/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm27.tools.ddrinteractive.gccheck;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm27.j9.gc.GCJNIWeakGlobalReferenceIterator;
import com.ibm.j9ddr.vm27.pointer.PointerPointer;
import com.ibm.j9ddr.vm27.pointer.VoidPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm27.tools.ddrinteractive.gccheck.Check;
import com.ibm.j9ddr.vm27.tools.ddrinteractive.gccheck.ScanFormatter;

class CheckJNIWeakGlobalReferences
extends Check {
    CheckJNIWeakGlobalReferences() {
    }

    public void check() {
        try {
            VoidPointer weakRefs = VoidPointer.cast(this.getJavaVM().jniWeakGlobalReferences());
            GCJNIWeakGlobalReferenceIterator jniWeakGlobalReferenceIterator = GCJNIWeakGlobalReferenceIterator.from();
            while (jniWeakGlobalReferenceIterator.hasNext()) {
                PointerPointer slot = PointerPointer.cast(jniWeakGlobalReferenceIterator.nextAddress());
                if (!slot.notNull() || this._engine.checkSlotPool(slot, weakRefs) == 0) continue;
                return;
            }
        }
        catch (CorruptDataException corruptDataException) {
            // empty catch block
        }
    }

    public String getCheckName() {
        return "JNI WEAK GLOBAL REFS";
    }

    public void print() {
        try {
            VoidPointer weakRefs = VoidPointer.cast(this.getJavaVM().jniWeakGlobalReferences());
            GCJNIWeakGlobalReferenceIterator jniWeakGlobalReferenceIterator = GCJNIWeakGlobalReferenceIterator.from();
            ScanFormatter formatter = new ScanFormatter(this, "jniWeakGlobalReferences", weakRefs);
            while (jniWeakGlobalReferenceIterator.hasNext()) {
                J9ObjectPointer slot = jniWeakGlobalReferenceIterator.next();
                if (!slot.notNull()) continue;
                formatter.entry(slot);
            }
            formatter.end("jniWeakGlobalReferences", weakRefs);
        }
        catch (CorruptDataException corruptDataException) {
            // empty catch block
        }
    }
}

