/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm27.tools.ddrinteractive.structureformat.base;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.BaseFieldFormatter;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.FormatWalkResult;
import com.ibm.j9ddr.tools.ddrinteractive.IStructureFormatter;
import com.ibm.j9ddr.vm27.pointer.Pointer;
import com.ibm.j9ddr.vm27.pointer.SelfRelativePointer;
import com.ibm.j9ddr.vm27.pointer.VoidPointer;
import com.ibm.j9ddr.vm27.pointer.WideSelfRelativePointer;
import java.io.PrintStream;

public class J9SRPFormatter
extends BaseFieldFormatter {
    private final int typeCode;
    private final String srpPrefix;
    private final boolean wide;

    public J9SRPFormatter(int typeCode, String srpPrefix, boolean wide) {
        this.typeCode = typeCode;
        this.srpPrefix = srpPrefix;
        this.wide = wide;
    }

    private String stripSRP(String type2) {
        type2 = type2.trim();
        return type2.substring(this.srpPrefix.length(), type2.length() - 1);
    }

    public FormatWalkResult format(String name, String type2, String declaredType, int thisTypeCode, long address, PrintStream out, Context context, IStructureFormatter structureFormatter) throws CorruptDataException {
        Pointer s;
        if (thisTypeCode != this.typeCode) {
            return FormatWalkResult.KEEP_WALKING;
        }
        VoidPointer targetAddress = VoidPointer.NULL;
        if (this.wide) {
            s = WideSelfRelativePointer.cast(address);
            targetAddress = ((WideSelfRelativePointer)s).get();
        } else {
            s = SelfRelativePointer.cast(address);
            targetAddress = ((SelfRelativePointer)s).get();
        }
        if (declaredType.contains("(")) {
            String srpType = this.stripSRP(declaredType);
            structureFormatter.formatField(name, srpType, srpType, targetAddress.getAddress(), out, context);
        } else {
            out.print("!j9x ");
            out.print(targetAddress.getHexAddress());
        }
        return FormatWalkResult.STOP_WALKING;
    }
}

