/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.InvalidityDateExtension;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.cert.CRLReason;
import java.security.cert.CertificateException;
import java.security.cert.Extension;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.x500.X500Principal;

public class CertificateRevokedException
extends CertificateException {
    private static final long serialVersionUID = 7839996631571608627L;
    private Date revocationDate;
    private final CRLReason reason;
    private final X500Principal authority;
    private transient Map<String, Extension> extensions;

    public CertificateRevokedException(Date revocationDate, CRLReason reason, X500Principal authority, Map<String, Extension> extensions) {
        if (revocationDate == null || reason == null || authority == null || extensions == null) {
            throw new NullPointerException();
        }
        this.revocationDate = new Date(revocationDate.getTime());
        this.reason = reason;
        this.authority = authority;
        this.extensions = Collections.checkedMap(new HashMap(), String.class, Extension.class);
        this.extensions.putAll(extensions);
    }

    public Date getRevocationDate() {
        return (Date)this.revocationDate.clone();
    }

    public CRLReason getRevocationReason() {
        return this.reason;
    }

    public X500Principal getAuthorityName() {
        return this.authority;
    }

    public Date getInvalidityDate() {
        Extension ext = this.getExtensions().get("2.5.29.24");
        if (ext == null) {
            return null;
        }
        try {
            Date invalidity = (Date)InvalidityDateExtension.toImpl((Extension)ext).get("DATE");
            return new Date(invalidity.getTime());
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public Map<String, Extension> getExtensions() {
        return Collections.unmodifiableMap(this.extensions);
    }

    @Override
    public String getMessage() {
        return "Certificate has been revoked, reason: " + (Object)((Object)this.reason) + ", revocation date: " + this.revocationDate + ", authority: " + this.authority + ", extension OIDs: " + this.extensions.keySet();
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        oos.writeInt(this.extensions.size());
        for (Map.Entry<String, Extension> entry : this.extensions.entrySet()) {
            Extension ext = entry.getValue();
            oos.writeObject(ext.getId());
            oos.writeBoolean(ext.isCritical());
            byte[] extVal = ext.getValue();
            oos.writeInt(extVal.length);
            oos.write(extVal);
        }
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.revocationDate = new Date(this.revocationDate.getTime());
        int size = ois.readInt();
        this.extensions = size == 0 ? Collections.emptyMap() : new HashMap<String, Extension>(size);
        for (int i = 0; i < size; ++i) {
            String oid = (String)ois.readObject();
            boolean critical = ois.readBoolean();
            int length = ois.readInt();
            byte[] extVal = new byte[length];
            ois.readFully(extVal);
            com.ibm.security.x509.Extension ext = com.ibm.security.x509.Extension.newExtension((ObjectIdentifier)new ObjectIdentifier(oid), (boolean)critical, (byte[])extVal);
            this.extensions.put(oid, (Extension)ext);
        }
    }
}

