/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.packed;

import com.ibm.jvm.packed.DefaultPackedSerialContext;
import com.ibm.jvm.packed.PackedSerialContext;
import java.io.ObjectInputStream;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.concurrent.ConcurrentHashMap;

final class InputStreamCache {
    private static final InputStreamCache instance = new InputStreamCache();
    private final ConcurrentHashMap<InputStreamKey, PackedSerialContext> cache = new ConcurrentHashMap();
    private final ReferenceQueue<ObjectInputStream> staleEntries = new ReferenceQueue();

    static InputStreamCache getInstance() {
        return instance;
    }

    private InputStreamCache() {
    }

    public PackedSerialContext get(ObjectInputStream objectInputStream) {
        this.clearStaleEntries();
        InputStreamKey inputStreamKey = new InputStreamKey(objectInputStream, this.staleEntries);
        PackedSerialContext packedSerialContext = this.cache.get(inputStreamKey);
        if (packedSerialContext == null) {
            packedSerialContext = new DefaultPackedSerialContext(true);
            if (this.cache.putIfAbsent(inputStreamKey, packedSerialContext) == null) {
                return packedSerialContext;
            }
            return this.cache.get(inputStreamKey);
        }
        return packedSerialContext;
    }

    public void clear(ObjectInputStream objectInputStream) {
        InputStreamKey inputStreamKey = new InputStreamKey(objectInputStream, this.staleEntries);
        PackedSerialContext packedSerialContext = this.cache.get(inputStreamKey);
        if (packedSerialContext != null) {
            packedSerialContext.clearReadEntries();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearStaleEntries() {
        InputStreamKey inputStreamKey = null;
        while (true) {
            ReferenceQueue<ObjectInputStream> referenceQueue = this.staleEntries;
            synchronized (referenceQueue) {
                inputStreamKey = (InputStreamKey)this.staleEntries.poll();
            }
            if (inputStreamKey == null) break;
            this.cache.remove(inputStreamKey);
        }
    }

    private static class InputStreamKey
    extends WeakReference<ObjectInputStream> {
        private final int hashcode;

        public InputStreamKey(ObjectInputStream objectInputStream, ReferenceQueue<ObjectInputStream> referenceQueue) {
            super(objectInputStream, referenceQueue);
            this.hashcode = objectInputStream.hashCode();
        }

        public final boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof InputStreamKey)) {
                return false;
            }
            ObjectInputStream objectInputStream = (ObjectInputStream)this.get();
            return objectInputStream != null && objectInputStream == ((InputStreamKey)object).get();
        }

        public final int hashCode() {
            return this.hashcode;
        }
    }
}

