/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.packed;

import com.ibm.jvm.packed.DefaultPackedSerialContext;
import com.ibm.jvm.packed.PackedSerialContext;
import java.io.ObjectOutputStream;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.concurrent.ConcurrentHashMap;

final class OutputStreamCache {
    private static final OutputStreamCache instance = new OutputStreamCache();
    private final ConcurrentHashMap<OStreamKey, PackedSerialContext> cache = new ConcurrentHashMap();
    private final ReferenceQueue<ObjectOutputStream> staleEntries = new ReferenceQueue();

    static OutputStreamCache getInstance() {
        return instance;
    }

    private OutputStreamCache() {
    }

    public PackedSerialContext get(ObjectOutputStream objectOutputStream) {
        this.clearStaleEntries();
        OStreamKey oStreamKey = new OStreamKey(objectOutputStream, this.staleEntries);
        PackedSerialContext packedSerialContext = this.cache.get(oStreamKey);
        if (packedSerialContext == null) {
            packedSerialContext = new DefaultPackedSerialContext(false);
            if (this.cache.putIfAbsent(oStreamKey, packedSerialContext) == null) {
                return packedSerialContext;
            }
            return this.cache.get(oStreamKey);
        }
        return packedSerialContext;
    }

    public void clear(ObjectOutputStream objectOutputStream) {
        OStreamKey oStreamKey = new OStreamKey(objectOutputStream, this.staleEntries);
        PackedSerialContext packedSerialContext = this.cache.get(oStreamKey);
        if (packedSerialContext != null) {
            packedSerialContext.clearWriteEntries();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearStaleEntries() {
        OStreamKey oStreamKey = null;
        while (true) {
            ReferenceQueue<ObjectOutputStream> referenceQueue = this.staleEntries;
            synchronized (referenceQueue) {
                oStreamKey = (OStreamKey)this.staleEntries.poll();
            }
            if (oStreamKey == null) break;
            this.cache.remove(oStreamKey);
        }
    }

    private static class OStreamKey
    extends WeakReference<ObjectOutputStream> {
        private final int hashcode;

        public OStreamKey(ObjectOutputStream objectOutputStream, ReferenceQueue<ObjectOutputStream> referenceQueue) {
            super(objectOutputStream, referenceQueue);
            this.hashcode = objectOutputStream.hashCode();
        }

        public final boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof OStreamKey)) {
                return false;
            }
            ObjectOutputStream objectOutputStream = (ObjectOutputStream)this.get();
            return objectOutputStream != null && objectOutputStream == ((OStreamKey)object).get();
        }

        public final int hashCode() {
            return this.hashcode;
        }
    }
}

