/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.cosnaming;

import com.sun.jndi.cosnaming.CNCtx;
import com.sun.jndi.cosnaming.CNNameParser;
import javax.naming.CannotProceedException;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.ContextNotEmptyException;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.NamingManager;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextPackage.AlreadyBound;
import org.omg.CosNaming.NamingContextPackage.CannotProceed;
import org.omg.CosNaming.NamingContextPackage.InvalidName;
import org.omg.CosNaming.NamingContextPackage.NotEmpty;
import org.omg.CosNaming.NamingContextPackage.NotFound;
import org.omg.CosNaming.NamingContextPackage.NotFoundReason;

public final class ExceptionMapper {
    private static final boolean debug = false;

    private ExceptionMapper() {
    }

    public static final NamingException mapException(Exception exception, CNCtx cNCtx, NameComponent[] nameComponentArray) throws NamingException {
        NamingException namingException;
        if (exception instanceof NamingException) {
            return (NamingException)exception;
        }
        if (exception instanceof RuntimeException) {
            throw (RuntimeException)exception;
        }
        if (exception instanceof NotFound) {
            if (cNCtx.federation) {
                return ExceptionMapper.tryFed((NotFound)((Object)exception), cNCtx, nameComponentArray);
            }
            namingException = new NameNotFoundException();
        } else if (exception instanceof CannotProceed) {
            namingException = new CannotProceedException();
            NamingContext namingContext = ((CannotProceed)exception).cxt;
            NameComponent[] nameComponentArray2 = ((CannotProceed)exception).rest_of_name;
            if (nameComponentArray != null && nameComponentArray.length > nameComponentArray2.length) {
                NameComponent[] nameComponentArray3 = new NameComponent[nameComponentArray.length - nameComponentArray2.length];
                System.arraycopy(nameComponentArray, 0, nameComponentArray3, 0, nameComponentArray3.length);
                namingException.setResolvedObj(new CNCtx(cNCtx._orb, cNCtx.orbTracker, namingContext, cNCtx._env, cNCtx.makeFullName(nameComponentArray3)));
            } else {
                namingException.setResolvedObj(cNCtx);
            }
            namingException.setRemainingName(CNNameParser.cosNameToName(nameComponentArray2));
        } else {
            namingException = exception instanceof InvalidName ? new InvalidNameException() : (exception instanceof AlreadyBound ? new NameAlreadyBoundException() : (exception instanceof NotEmpty ? new ContextNotEmptyException() : new NamingException("Unknown reasons")));
        }
        namingException.setRootCause(exception);
        return namingException;
    }

    private static final NamingException tryFed(NotFound notFound, CNCtx cNCtx, NameComponent[] nameComponentArray) throws NamingException {
        Object object;
        CNCtx cNCtx2;
        NameComponent[] nameComponentArray2;
        NameComponent[] nameComponentArray3;
        NameComponent[] nameComponentArray4 = notFound.rest_of_name;
        if (nameComponentArray4.length == 1 && nameComponentArray != null) {
            nameComponentArray3 = nameComponentArray[nameComponentArray.length - 1];
            if (!nameComponentArray4[0].id.equals(nameComponentArray3.id) || nameComponentArray4[0].kind == null || !nameComponentArray4[0].kind.equals(nameComponentArray3.kind)) {
                NameNotFoundException nameNotFoundException = new NameNotFoundException();
                nameNotFoundException.setRemainingName(CNNameParser.cosNameToName(nameComponentArray4));
                nameNotFoundException.setRootCause(notFound);
                throw nameNotFoundException;
            }
        }
        nameComponentArray3 = null;
        int n = 0;
        if (nameComponentArray != null && nameComponentArray.length >= nameComponentArray4.length) {
            if (notFound.why == NotFoundReason.not_context) {
                n = nameComponentArray.length - (nameComponentArray4.length - 1);
                if (nameComponentArray4.length == 1) {
                    nameComponentArray4 = null;
                } else {
                    nameComponentArray2 = new NameComponent[nameComponentArray4.length - 1];
                    System.arraycopy(nameComponentArray4, 1, nameComponentArray2, 0, nameComponentArray2.length);
                    nameComponentArray4 = nameComponentArray2;
                }
            } else {
                n = nameComponentArray.length - nameComponentArray4.length;
            }
            if (n > 0) {
                nameComponentArray3 = new NameComponent[n];
                System.arraycopy(nameComponentArray, 0, nameComponentArray3, 0, n);
            }
        }
        nameComponentArray2 = new CannotProceedException();
        nameComponentArray2.setRootCause(notFound);
        if (nameComponentArray4 != null && nameComponentArray4.length > 0) {
            nameComponentArray2.setRemainingName(CNNameParser.cosNameToName(nameComponentArray4));
        }
        nameComponentArray2.setEnvironment(cNCtx._env);
        CNCtx cNCtx3 = cNCtx2 = nameComponentArray3 != null ? cNCtx.callResolve(nameComponentArray3) : cNCtx;
        if (cNCtx2 instanceof Context) {
            RefAddr refAddr = new RefAddr("nns"){
                private static final long serialVersionUID = 669984699392133792L;

                @Override
                public Object getContent() {
                    return cNCtx2;
                }
            };
            Reference reference = new Reference("java.lang.Object", refAddr);
            CompositeName compositeName = new CompositeName();
            compositeName.add("");
            nameComponentArray2.setResolvedObj(reference);
            nameComponentArray2.setAltName(compositeName);
            nameComponentArray2.setAltNameCtx(cNCtx2);
            return nameComponentArray2;
        }
        Name name = CNNameParser.cosNameToName(nameComponentArray3);
        try {
            object = NamingManager.getObjectInstance(cNCtx2, name, cNCtx, cNCtx._env);
        }
        catch (NamingException namingException) {
            throw namingException;
        }
        catch (Exception exception) {
            NamingException namingException = new NamingException("problem generating object using object factory");
            namingException.setRootCause(exception);
            throw namingException;
        }
        if (object instanceof Context) {
            nameComponentArray2.setResolvedObj(object);
        } else {
            name.add("");
            nameComponentArray2.setAltName(name);
            final Object object2 = object;
            RefAddr refAddr = new RefAddr("nns"){
                private static final long serialVersionUID = -785132553978269772L;

                @Override
                public Object getContent() {
                    return object2;
                }
            };
            Reference reference = new Reference("java.lang.Object", refAddr);
            nameComponentArray2.setResolvedObj(reference);
            nameComponentArray2.setAltNameCtx(cNCtx);
        }
        return nameComponentArray2;
    }
}

