/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import com.ibm.jvm.MemorySafetyService;
import java.io.CanonicalPath;
import java.io.File;
import java.io.FilePermissionCollection;
import java.io.FileSystem;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.PrivilegedAction;

public final class FilePermission
extends Permission
implements Serializable {
    private static final int EXECUTE = 1;
    private static final int WRITE = 2;
    private static final int READ = 4;
    private static final int DELETE = 8;
    private static final int READLINK = 16;
    private static final int ALL = 31;
    private static final int NONE = 0;
    private transient int mask;
    private transient boolean directory;
    private transient boolean recursive;
    private String actions;
    private static final char RECURSIVE_CHAR = '-';
    private static final char WILD_CHAR = '*';
    private transient boolean dir_rec_set = false;
    private transient CanonicalPath cpath = null;
    private transient String path_string;
    private static final FileSystem fs = FileSystem.getFileSystem();
    private static final long serialVersionUID = 7930732926638008763L;

    private void init(int n) {
        if ((n & 0x1F) != n) {
            throw new IllegalArgumentException("invalid actions mask");
        }
        if (n == 0) {
            throw new IllegalArgumentException("invalid actions mask");
        }
        if (this.getName() == null) {
            throw new NullPointerException("name can't be null");
        }
        this.mask = n;
        this.cpath = null;
        this.dir_rec_set = false;
        this.path_string = null;
    }

    private void get_dir_rec() {
        int n;
        this.path_string = this.getName();
        if (this.path_string.equals("<<ALL FILES>>")) {
            this.directory = true;
            this.recursive = true;
            this.path_string = "";
            this.dir_rec_set = true;
            return;
        }
        this.path_string = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                try {
                    String string = FilePermission.this.path_string;
                    if (FilePermission.this.path_string.endsWith("*")) {
                        string = string.substring(0, string.length() - 1) + "-";
                        string = new File(string).getCanonicalPath();
                        return string.substring(0, string.length() - 1) + "*";
                    }
                    return new File(string).getCanonicalPath();
                }
                catch (IOException iOException) {
                    return FilePermission.this.path_string;
                }
            }
        });
        int n2 = this.path_string.length();
        int n3 = n = n2 > 0 ? (int)this.path_string.charAt(n2 - 1) : 0;
        if (n == 45 && (n2 == 1 || this.path_string.charAt(n2 - 2) == File.separatorChar)) {
            this.directory = true;
            this.recursive = true;
            this.path_string = this.path_string.substring(0, --n2);
        } else if (n == 42 && (n2 == 1 || this.path_string.charAt(n2 - 2) == File.separatorChar)) {
            this.directory = true;
            this.path_string = this.path_string.substring(0, --n2);
        }
        this.dir_rec_set = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init_cpath() {
        long l = -1L;
        try {
            l = MemorySafetyService.enterObjectsMemoryArea((Object)this);
            this.cpath = fs.getCanonicalPath(this.path_string, this.directory);
        }
        finally {
            MemorySafetyService.exitLastMemoryArea((long)l);
        }
    }

    public FilePermission(String string, String string2) {
        super(string);
        this.init(FilePermission.getMask(string2));
    }

    FilePermission(String string, int n) {
        super(string);
        this.init(n);
    }

    @Override
    public boolean implies(Permission permission) {
        if (!(permission instanceof FilePermission)) {
            return false;
        }
        FilePermission filePermission = (FilePermission)permission;
        return (this.mask & filePermission.mask) == filePermission.mask && this.impliesIgnoreMask(filePermission);
    }

    boolean impliesIgnoreMask(FilePermission filePermission) {
        if (this.getName().equals("<<ALL FILES>>")) {
            return true;
        }
        if (!this.dir_rec_set) {
            this.get_dir_rec();
        }
        if (!filePermission.dir_rec_set) {
            filePermission.get_dir_rec();
        }
        if (this.directory) {
            if (this.recursive) {
                if (filePermission.cpath == null) {
                    filePermission.init_cpath();
                }
                if (this.cpath == null) {
                    this.init_cpath();
                }
                if (filePermission.directory) {
                    return filePermission.cpath.startsWith(this.cpath);
                }
                return filePermission.cpath.startsWithAndLonger(this.cpath);
            }
            if (filePermission.directory) {
                if (filePermission.recursive) {
                    return false;
                }
                if (filePermission.cpath == null) {
                    filePermission.init_cpath();
                }
                if (this.cpath == null) {
                    this.init_cpath();
                }
                return this.cpath.equals(filePermission.cpath);
            }
            if (filePermission.cpath == null) {
                filePermission.init_cpath();
            }
            if (this.cpath == null) {
                this.init_cpath();
            }
            return filePermission.cpath.hasBaseDir(this.cpath);
        }
        if (filePermission.directory || filePermission.recursive) {
            return false;
        }
        if (filePermission.cpath == null) {
            filePermission.init_cpath();
        }
        if (this.cpath == null) {
            this.init_cpath();
        }
        return this.cpath.equals(filePermission.cpath);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof FilePermission)) {
            return false;
        }
        FilePermission filePermission = (FilePermission)object;
        if (!this.dir_rec_set) {
            this.get_dir_rec();
        }
        if (!filePermission.dir_rec_set) {
            filePermission.get_dir_rec();
        }
        if (this.mask == filePermission.mask && this.directory == filePermission.directory && this.recursive == filePermission.recursive) {
            if (filePermission.cpath == null) {
                filePermission.init_cpath();
            }
            if (this.cpath == null) {
                this.init_cpath();
            }
            return this.cpath.equals(filePermission.cpath);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 0;
    }

    private static int getMask(String string) {
        int n = 0;
        if (string == null) {
            return n;
        }
        if (string == "read") {
            return 4;
        }
        if (string == "write") {
            return 2;
        }
        if (string == "execute") {
            return 1;
        }
        if (string == "delete") {
            return 8;
        }
        if (string == "readlink") {
            return 16;
        }
        char[] cArray = string.toCharArray();
        int n2 = cArray.length - 1;
        if (n2 < 0) {
            return n;
        }
        while (n2 != -1) {
            int n3;
            char c;
            while (n2 != -1 && ((c = cArray[n2]) == ' ' || c == '\r' || c == '\n' || c == '\f' || c == '\t')) {
                --n2;
            }
            if (!(n2 < 3 || cArray[n2 - 3] != 'r' && cArray[n2 - 3] != 'R' || cArray[n2 - 2] != 'e' && cArray[n2 - 2] != 'E' || cArray[n2 - 1] != 'a' && cArray[n2 - 1] != 'A' || cArray[n2] != 'd' && cArray[n2] != 'D')) {
                n3 = 4;
                n |= 4;
            } else if (!(n2 < 4 || cArray[n2 - 4] != 'w' && cArray[n2 - 4] != 'W' || cArray[n2 - 3] != 'r' && cArray[n2 - 3] != 'R' || cArray[n2 - 2] != 'i' && cArray[n2 - 2] != 'I' || cArray[n2 - 1] != 't' && cArray[n2 - 1] != 'T' || cArray[n2] != 'e' && cArray[n2] != 'E')) {
                n3 = 5;
                n |= 2;
            } else if (!(n2 < 6 || cArray[n2 - 6] != 'e' && cArray[n2 - 6] != 'E' || cArray[n2 - 5] != 'x' && cArray[n2 - 5] != 'X' || cArray[n2 - 4] != 'e' && cArray[n2 - 4] != 'E' || cArray[n2 - 3] != 'c' && cArray[n2 - 3] != 'C' || cArray[n2 - 2] != 'u' && cArray[n2 - 2] != 'U' || cArray[n2 - 1] != 't' && cArray[n2 - 1] != 'T' || cArray[n2] != 'e' && cArray[n2] != 'E')) {
                n3 = 7;
                n |= 1;
            } else if (!(n2 < 5 || cArray[n2 - 5] != 'd' && cArray[n2 - 5] != 'D' || cArray[n2 - 4] != 'e' && cArray[n2 - 4] != 'E' || cArray[n2 - 3] != 'l' && cArray[n2 - 3] != 'L' || cArray[n2 - 2] != 'e' && cArray[n2 - 2] != 'E' || cArray[n2 - 1] != 't' && cArray[n2 - 1] != 'T' || cArray[n2] != 'e' && cArray[n2] != 'E')) {
                n3 = 6;
                n |= 8;
            } else if (!(n2 < 7 || cArray[n2 - 7] != 'r' && cArray[n2 - 7] != 'R' || cArray[n2 - 6] != 'e' && cArray[n2 - 6] != 'E' || cArray[n2 - 5] != 'a' && cArray[n2 - 5] != 'A' || cArray[n2 - 4] != 'd' && cArray[n2 - 4] != 'D' || cArray[n2 - 3] != 'l' && cArray[n2 - 3] != 'L' || cArray[n2 - 2] != 'i' && cArray[n2 - 2] != 'I' || cArray[n2 - 1] != 'n' && cArray[n2 - 1] != 'N' || cArray[n2] != 'k' && cArray[n2] != 'K')) {
                n3 = 8;
                n |= 0x10;
            } else {
                throw new IllegalArgumentException("invalid permission: " + string);
            }
            boolean bl = false;
            while (n2 >= n3 && !bl) {
                switch (cArray[n2 - n3]) {
                    case ',': {
                        bl = true;
                    }
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("invalid permission: " + string);
                    }
                }
                --n2;
            }
            n2 -= n3;
        }
        return n;
    }

    int getMask() {
        return this.mask;
    }

    private static String getActions(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        if ((n & 4) == 4) {
            bl = true;
            stringBuilder.append("read");
        }
        if ((n & 2) == 2) {
            if (bl) {
                stringBuilder.append(',');
            } else {
                bl = true;
            }
            stringBuilder.append("write");
        }
        if ((n & 1) == 1) {
            if (bl) {
                stringBuilder.append(',');
            } else {
                bl = true;
            }
            stringBuilder.append("execute");
        }
        if ((n & 8) == 8) {
            if (bl) {
                stringBuilder.append(',');
            } else {
                bl = true;
            }
            stringBuilder.append("delete");
        }
        if ((n & 0x10) == 16) {
            if (bl) {
                stringBuilder.append(',');
            } else {
                bl = true;
            }
            stringBuilder.append("readlink");
        }
        return stringBuilder.toString();
    }

    @Override
    public String getActions() {
        if (this.actions == null) {
            this.actions = FilePermission.getActions(this.mask);
        }
        return this.actions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PermissionCollection newPermissionCollection() {
        long l = -1L;
        try {
            l = MemorySafetyService.enterSafeMemoryArea();
            FilePermissionCollection filePermissionCollection = new FilePermissionCollection();
            return filePermissionCollection;
        }
        finally {
            MemorySafetyService.exitLastMemoryArea((long)l);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.actions == null) {
            this.getActions();
        }
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.init(FilePermission.getMask(this.actions));
    }
}

