/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import com.ibm.jvm.MemorySafetyService;
import com.ibm.jvm.util.GlobalMap;
import java.text.CollationKey;
import java.text.CollationRules;
import java.text.ParseException;
import java.text.RuleBasedCollator;
import java.text.spi.CollatorProvider;
import java.util.Comparator;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import sun.misc.SoftCache;
import sun.util.LocaleServiceProviderPool;
import sun.util.resources.LocaleData;

public abstract class Collator
implements Comparator<Object>,
Cloneable {
    public static final int PRIMARY = 0;
    public static final int SECONDARY = 1;
    public static final int TERTIARY = 2;
    public static final int IDENTICAL = 3;
    public static final int NO_DECOMPOSITION = 0;
    public static final int CANONICAL_DECOMPOSITION = 1;
    public static final int FULL_DECOMPOSITION = 2;
    private int strength = 2;
    private int decmp = 1;
    private static SoftCache cache = new SoftCache();
    private static GlobalMap<Locale, Collator> immortalCache = new GlobalMap();
    static final int LESS = -1;
    static final int EQUAL = 0;
    static final int GREATER = 1;

    public static synchronized Collator getInstance() {
        return Collator.getInstance(Locale.getDefault());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized Collator getInstance(Locale locale) {
        Object object;
        Collator collator = null;
        if (!MemorySafetyService.isSafeMode()) {
            collator = (Collator)cache.get(locale);
        } else {
            long l = -1L;
            try {
                l = MemorySafetyService.enterSafeMemoryArea();
                collator = immortalCache.getItem(locale);
            }
            finally {
                MemorySafetyService.exitLastMemoryArea((long)l);
            }
        }
        if (collator != null) {
            return (Collator)collator.clone();
        }
        LocaleServiceProviderPool localeServiceProviderPool = LocaleServiceProviderPool.getPool(CollatorProvider.class);
        if (localeServiceProviderPool.hasProviders() && (object = localeServiceProviderPool.getLocalizedObject(CollatorGetter.INSTANCE, locale, locale)) != null) {
            return object;
        }
        object = "";
        int n = 1;
        try {
            ResourceBundle resourceBundle = LocaleData.getCollationData(locale);
            object = resourceBundle.getString("Rule");
            n = (Integer)resourceBundle.getObject("CollationDecomp");
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        try {
            long l = -1L;
            try {
                l = MemorySafetyService.enterSafeMemoryArea();
                collator = new RuleBasedCollator(CollationRules.DEFAULTRULES + (String)object, n);
            }
            finally {
                MemorySafetyService.exitLastMemoryArea((long)l);
            }
        }
        catch (ParseException parseException) {
            try {
                collator = new RuleBasedCollator(CollationRules.DEFAULTRULES);
            }
            catch (ParseException parseException2) {
                // empty catch block
            }
        }
        collator.setDecomposition(0);
        if (!MemorySafetyService.isSafeMode()) {
            cache.put(locale, collator);
        } else {
            immortalCache.putItem(locale, collator);
        }
        return (Collator)collator.clone();
    }

    @Override
    public abstract int compare(String var1, String var2);

    @Override
    public int compare(Object object, Object object2) {
        return this.compare((String)object, (String)object2);
    }

    public abstract CollationKey getCollationKey(String var1);

    public boolean equals(String string, String string2) {
        return this.compare(string, string2) == 0;
    }

    public synchronized int getStrength() {
        return this.strength;
    }

    public synchronized void setStrength(int n) {
        if (n != 0 && n != 1 && n != 2 && n != 3) {
            throw new IllegalArgumentException("Incorrect comparison level.");
        }
        this.strength = n;
    }

    public synchronized int getDecomposition() {
        return this.decmp;
    }

    public synchronized void setDecomposition(int n) {
        if (n != 0 && n != 1 && n != 2) {
            throw new IllegalArgumentException("Wrong decomposition mode.");
        }
        this.decmp = n;
    }

    public static synchronized Locale[] getAvailableLocales() {
        LocaleServiceProviderPool localeServiceProviderPool = LocaleServiceProviderPool.getPool(CollatorProvider.class);
        return localeServiceProviderPool.getAvailableLocales();
    }

    public Object clone() {
        try {
            return (Collator)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Collator collator = (Collator)object;
        return this.strength == collator.strength && this.decmp == collator.decmp;
    }

    public abstract int hashCode();

    protected Collator() {
    }

    private static class CollatorGetter
    implements LocaleServiceProviderPool.LocalizedObjectGetter<CollatorProvider, Collator> {
        private static final CollatorGetter INSTANCE = new CollatorGetter();

        private CollatorGetter() {
        }

        @Override
        public Collator getObject(CollatorProvider collatorProvider, Locale locale, String string, Object ... objectArray) {
            assert (objectArray.length == 1);
            Collator collator = collatorProvider.getInstance(locale);
            if (collator != null) {
                cache.put((Locale)objectArray[0], collator);
                cache.put(locale, collator);
                return (Collator)collator.clone();
            }
            return null;
        }
    }
}

