/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import com.ibm.misc.SignalDispatcher;
import com.ibm.misc.SignalInfo;
import java.util.Hashtable;
import sun.misc.NativeSignalHandler;
import sun.misc.SignalHandler;

public final class Signal {
    private static Hashtable handlers = new Hashtable(4);
    private static Hashtable signals = new Hashtable(4);
    private int number;
    private String name;

    public int getNumber() {
        return this.number;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof Signal)) {
            return false;
        }
        Signal signal = (Signal)object;
        return this.name.equals(signal.name) && this.number == signal.number;
    }

    public int hashCode() {
        return this.number;
    }

    public String toString() {
        return "SIG" + this.name;
    }

    public Signal(String string) {
        if (string == null) {
            throw new NullPointerException("Signal name must not be null");
        }
        this.number = SignalInfo.getSignalNumber(string);
        this.name = string;
        if (this.number < 0) {
            throw new IllegalArgumentException("Unknown signal: " + string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized SignalHandler handle(Signal signal, SignalHandler signalHandler) throws IllegalArgumentException {
        long l;
        long l2 = signalHandler instanceof NativeSignalHandler ? ((NativeSignalHandler)signalHandler).getHandler() : 2L;
        try {
            l = SignalDispatcher.registerSignal(signal.number, l2, Signal.class.getDeclaredMethod("dispatch", Integer.TYPE));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
            throw new IllegalArgumentException("Signal handling not possible for: " + signal);
        }
        if (l == -1L) {
            throw new IllegalArgumentException("Signal already used by VM or OS: " + signal);
        }
        signals.put(new Integer(signal.number), signal);
        Hashtable hashtable = handlers;
        synchronized (hashtable) {
            SignalHandler signalHandler2 = (SignalHandler)handlers.get(signal);
            handlers.remove(signal);
            if (l2 == 2L) {
                handlers.put(signal, signalHandler);
            }
            if (l == 0L) {
                return SignalHandler.SIG_DFL;
            }
            if (l == 1L) {
                return SignalHandler.SIG_IGN;
            }
            if (l == 2L) {
                return signalHandler2;
            }
            return new NativeSignalHandler(l);
        }
    }

    public static void raise(Signal signal) throws IllegalArgumentException {
        if (handlers.get(signal) == null) {
            throw new IllegalArgumentException("Unhandled signal: " + signal);
        }
        SignalDispatcher.raiseSignal(signal.number);
    }

    private static void dispatch(int n) {
        final Signal signal = (Signal)signals.get(new Integer(n));
        final SignalHandler signalHandler = (SignalHandler)handlers.get(signal);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                signalHandler.handle(signal);
            }
        };
        if (signalHandler != null) {
            new Thread(runnable, signal + " handler").start();
        }
    }
}

