/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousServerSocketChannel;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.IllegalChannelGroupException;
import java.nio.channels.spi.AsynchronousChannelProvider;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import sun.nio.ch.AixEvent;
import sun.nio.ch.Port;
import sun.nio.ch.ThreadPool;
import sun.nio.ch.UnixAsynchronousServerSocketChannelImpl;
import sun.nio.ch.UnixAsynchronousSocketChannelImpl;
import sun.nio.ch.UnixEventPort;

public class AixAsynchronousChannelProvider
extends AsynchronousChannelProvider {
    private static volatile Port defaultPort;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Port defaultEventPort() throws IOException {
        if (defaultPort != null) return defaultPort;
        Class<AixAsynchronousChannelProvider> clazz = AixAsynchronousChannelProvider.class;
        synchronized (AixAsynchronousChannelProvider.class) {
            if (defaultPort != null) return defaultPort;
            defaultPort = new UnixEventPort(this, ThreadPool.getDefault(), new AixEvent()).start();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return defaultPort;
        }
    }

    @Override
    public AsynchronousChannelGroup openAsynchronousChannelGroup(int n, ThreadFactory threadFactory) throws IOException {
        return new UnixEventPort(this, ThreadPool.create(n, threadFactory), new AixEvent()).start();
    }

    @Override
    public AsynchronousChannelGroup openAsynchronousChannelGroup(ExecutorService executorService, int n) throws IOException {
        return new UnixEventPort(this, ThreadPool.wrap(executorService, n), new AixEvent()).start();
    }

    private Port toPort(AsynchronousChannelGroup asynchronousChannelGroup) throws IOException {
        if (asynchronousChannelGroup == null) {
            return this.defaultEventPort();
        }
        if (!(asynchronousChannelGroup instanceof UnixEventPort)) {
            throw new IllegalChannelGroupException();
        }
        return (Port)asynchronousChannelGroup;
    }

    @Override
    public AsynchronousServerSocketChannel openAsynchronousServerSocketChannel(AsynchronousChannelGroup asynchronousChannelGroup) throws IOException {
        return new UnixAsynchronousServerSocketChannelImpl(this.toPort(asynchronousChannelGroup));
    }

    @Override
    public AsynchronousSocketChannel openAsynchronousSocketChannel(AsynchronousChannelGroup asynchronousChannelGroup) throws IOException {
        return new UnixAsynchronousSocketChannelImpl(this.toPort(asynchronousChannelGroup));
    }
}

