/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.util.Enumeration;
import java.util.Formatter;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Scanner;
import sun.nio.ch.NetworkProvider;
import sun.nio.ch.SocketAction;
import sun.security.action.GetPropertyAction;

final class NetworkSelector {
    private static final boolean enabled;
    private static final String osName;
    private static final String osArch;
    private static InetAddress preferredAddress;
    private static LinkedList<Rule> bindRules;
    private static LinkedList<Rule> connectRules;
    private static LinkedList<Rule> acceptRules;
    private static HashMap<String, NetworkProvider> providerMap;

    private NetworkSelector() {
    }

    private static void addRule(Rule rule) {
        switch (rule.getAction()) {
            case BIND: {
                bindRules.addLast(rule);
                break;
            }
            case ACCEPT: {
                acceptRules.addLast(rule);
                bindRules.addLast(new HostPortRule(SocketAction.BIND, rule.getPrimaryHost(), rule.getPortRange(), rule.getSecondaryHost(), rule.getNetworkProvider()));
                break;
            }
            case CONNECT: {
                connectRules.addLast(rule);
                break;
            }
        }
    }

    private static void fail(String string, Object ... objectArray) {
        Formatter formatter = new Formatter();
        formatter.format(string, objectArray);
        throw new RuntimeException(formatter.out().toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private static void loadRulesFromFile(String var0) throws IOException {
        var1_1 = new Scanner(new File(var0));
lbl2:
        // 3 sources

        try {
            while (var1_1.hasNextLine()) {
                block16: {
                    var2_2 = var1_1.nextLine().trim();
                    if (var2_2.length() == 0 || var2_2.charAt(0) == '#') continue;
                    var3_3 = var2_2.split("\\s+");
                    if (var3_3.length < 4) {
                        NetworkSelector.fail("Malformed line '%s'", new Object[]{var2_2});
                        continue;
                    }
                    var4_4 = NetworkSelector.loadProvider(var3_3[0]);
                    if (var4_4 == null) {
                        NetworkSelector.fail("Network provider for '%s' could not be loaded", new Object[]{var3_3[0]});
                        continue;
                    }
                    var5_5 = SocketAction.parse(var3_3[1]);
                    if (var5_5 == null) {
                        NetworkSelector.fail("SocketAction '%s' not recognized", new Object[]{var3_3[1]});
                        continue;
                    }
                    if (var5_5 == SocketAction.ACCEPT && var3_3.length < 5) {
                        NetworkSelector.fail("Less than expected number of arguments '%s'", new Object[]{var2_2});
                        continue;
                    }
                    if ((var5_5 == SocketAction.BIND || var5_5 == SocketAction.CONNECT) && var3_3.length > 4) {
                        NetworkSelector.fail("Greater than expected number of arguments '%s'", new Object[]{var2_2});
                        continue;
                    }
                    var6_6 = Host.parse(var5_5, var3_3[2], false);
                    if (var6_6 == null) continue;
                    var7_7 = null;
                    try {
                        var7_7 = new PortRange(var3_3[3]);
                    }
                    catch (NumberFormatException var8_8) {
                        NetworkSelector.fail("Malformed port range '%s'", new Object[]{var3_3[3]});
                        continue;
                    }
                    if (var5_5 != SocketAction.ACCEPT) break block16;
                    for (var8_9 = 4; var8_9 < var3_3.length; ++var8_9) {
                        var9_10 = Host.parse(var5_5, var3_3[var8_9], true);
                        if (var9_10 == null) continue;
                        for (var10_11 = 0; var10_11 < var6_6.length; ++var10_11) {
                            for (var11_12 = 0; var11_12 < var9_10.length; ++var11_12) {
                                if (var9_10[var11_12].getIsLoopBackOrLocal()) continue;
                                NetworkSelector.addRule(new HostPortRule(var5_5, var6_6[var10_11], var7_7, var9_10[var11_12], var4_4));
                            }
                        }
                    }
                    ** GOTO lbl2
                }
                for (var8_9 = 0; var8_9 < var6_6.length; ++var8_9) {
                    if (var5_5 != SocketAction.BIND && var6_6[var8_9].getIsLoopBackOrLocal()) continue;
                    NetworkSelector.addRule(new HostPortRule(var5_5, var6_6[var8_9], var7_7, null, var4_4));
                }
                ** GOTO lbl2
            }
        }
        finally {
            var1_1.close();
        }
    }

    static boolean initializeRules() {
        boolean bl = false;
        String string = AccessController.doPrivileged(new GetPropertyAction("com.ibm.nio.rdma.conf"));
        if (string != null) {
            bindRules = new LinkedList();
            connectRules = new LinkedList();
            acceptRules = new LinkedList();
            providerMap = new HashMap();
            try {
                NetworkSelector.loadRulesFromFile(string);
                bl = true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (bl) {
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    @Override
                    public void run() {
                        for (NetworkProvider networkProvider : providerMap.values()) {
                            networkProvider.cleanup();
                        }
                    }
                });
            } else {
                bindRules = null;
                connectRules = null;
                acceptRules = null;
                providerMap = null;
            }
        }
        return bl;
    }

    private static Rule findFirstMatchingRule(List<Rule> list, SocketAction socketAction, InetAddress inetAddress, int n, InetAddress inetAddress2) {
        for (Rule rule : list) {
            if (!rule.match(socketAction, inetAddress, n, inetAddress2)) continue;
            return rule;
        }
        return null;
    }

    public static NetworkProvider getNetworkProvider(SocketAction socketAction, InetAddress inetAddress, int n, InetAddress inetAddress2) {
        Rule rule = null;
        if (!enabled) {
            return null;
        }
        switch (socketAction) {
            case BIND: {
                rule = NetworkSelector.findFirstMatchingRule(bindRules, socketAction, inetAddress, n, inetAddress2);
                break;
            }
            case ACCEPT: {
                if (inetAddress2 == null || Host.isLoopbackOrLocal(inetAddress2)) {
                    return null;
                }
                rule = NetworkSelector.findFirstMatchingRule(acceptRules, socketAction, inetAddress, n, inetAddress2);
                break;
            }
            case CONNECT: {
                if (inetAddress == null || Host.isLoopbackOrLocal(inetAddress)) {
                    return null;
                }
                rule = NetworkSelector.findFirstMatchingRule(connectRules, socketAction, inetAddress, n, inetAddress2);
                break;
            }
        }
        if (rule != null) {
            return rule.getNetworkProvider();
        }
        return null;
    }

    private static NetworkProvider loadProvider(String string) {
        NetworkProvider networkProvider = null;
        if (providerMap.containsKey(string)) {
            networkProvider = providerMap.get(string);
        } else if (string.equalsIgnoreCase("rdma")) {
            try {
                Class<?> clazz = Class.forName("sun.nio.ch.RDMANetworkProvider", true, null);
                networkProvider = (NetworkProvider)clazz.newInstance();
                Method method = clazz.getMethod("initialize", null);
                method.invoke(networkProvider, null);
                networkProvider.setPreferredAddress(Host.ibAddresses);
                preferredAddress = networkProvider.getPreferredAddress();
            }
            catch (Exception exception) {
                return null;
            }
            providerMap.put(string, networkProvider);
        }
        return networkProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String printRules() {
        String string = null;
        try (StringWriter stringWriter = new StringWriter();){
            try (PrintWriter printWriter = new PrintWriter(stringWriter);){
                printWriter.println("<Rules>");
                for (Rule rule : bindRules) {
                    printWriter.println(rule);
                }
                for (Rule rule : connectRules) {
                    printWriter.println(rule);
                }
                for (Rule rule : acceptRules) {
                    printWriter.println(rule);
                }
                printWriter.println();
                printWriter.println("<Host Addresses>");
                printWriter.println("InfiniBand: " + Host.ibAddresses);
                printWriter.println("Ethernet: " + Host.ethAddresses);
                printWriter.println("Other: " + Host.othAddresses);
                printWriter.println();
                printWriter.print("Preferred Address: ");
                if (preferredAddress != null) {
                    printWriter.println(preferredAddress);
                } else {
                    printWriter.println("null");
                }
            }
            finally {
                string = stringWriter.toString();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return string;
    }

    static {
        boolean bl = false;
        GetPropertyAction getPropertyAction = new GetPropertyAction("os.name");
        osName = AccessController.doPrivileged(getPropertyAction);
        getPropertyAction = new GetPropertyAction("os.arch");
        osArch = AccessController.doPrivileged(getPropertyAction);
        if (osName.equalsIgnoreCase("linux") && (osArch.equalsIgnoreCase("amd64") || osArch.equalsIgnoreCase("x86") || osArch.equalsIgnoreCase("ppc") || osArch.equalsIgnoreCase("ppc64"))) {
            bl = NetworkSelector.initializeRules();
        }
        enabled = bl;
    }

    private static class HostPortRule
    implements Rule {
        private SocketAction action;
        private PortRange range;
        private Host host;
        private Host remote;
        private NetworkProvider provider;

        HostPortRule(SocketAction socketAction, Host host, PortRange portRange, Host host2, NetworkProvider networkProvider) {
            this.action = socketAction;
            this.host = host;
            this.range = portRange;
            this.remote = host2;
            this.provider = networkProvider;
        }

        @Override
        public boolean match(SocketAction socketAction, InetAddress inetAddress, int n, InetAddress inetAddress2) {
            if (!this.host.match(socketAction, inetAddress, false) && (socketAction != SocketAction.ACCEPT && socketAction != SocketAction.BIND || preferredAddress == null || !inetAddress.equals(preferredAddress))) {
                return false;
            }
            if (!this.range.match(n)) {
                return false;
            }
            if (!(socketAction != SocketAction.BIND && socketAction != SocketAction.CONNECT || inetAddress2 != null && this.remote != null)) {
                return true;
            }
            return this.remote.match(socketAction, inetAddress2, true);
        }

        @Override
        public SocketAction getAction() {
            return this.action;
        }

        @Override
        public PortRange getPortRange() {
            return this.range;
        }

        @Override
        public Host getPrimaryHost() {
            return this.host;
        }

        @Override
        public Host getSecondaryHost() {
            return this.remote;
        }

        @Override
        public NetworkProvider getNetworkProvider() {
            return this.provider;
        }

        public String toString() {
            return new String("" + SocketAction.toString(this.action) + " " + this.host + " " + this.range + " " + this.remote);
        }
    }

    private static interface Rule {
        public boolean match(SocketAction var1, InetAddress var2, int var3, InetAddress var4);

        public SocketAction getAction();

        public PortRange getPortRange();

        public Host getPrimaryHost();

        public Host getSecondaryHost();

        public NetworkProvider getNetworkProvider();
    }

    private static class Host {
        private final boolean anyHost;
        private final byte[] addressAsBytes;
        private final int prefixByteCount;
        private final byte mask;
        private final boolean loopbackOrLocal;
        private final boolean ibLocal;
        private static List<String> ibAddresses = new LinkedList<String>();
        private static List<String> ethAddresses = new LinkedList<String>();
        private static List<String> othAddresses = new LinkedList<String>();
        static final Host[] allHosts = new Host[]{new Host(){

            @Override
            public boolean match(SocketAction socketAction, InetAddress inetAddress, boolean bl) {
                return true;
            }
        }};

        private Host() {
            this.anyHost = true;
            this.addressAsBytes = null;
            this.prefixByteCount = 0;
            this.mask = 0;
            this.loopbackOrLocal = false;
            this.ibLocal = false;
        }

        public static boolean isLoopbackOrLocal(InetAddress inetAddress) {
            if (inetAddress.isLoopbackAddress() || inetAddress.isAnyLocalAddress()) {
                return true;
            }
            for (String string : ibAddresses) {
                if (!string.equals(inetAddress.getHostAddress())) continue;
                return true;
            }
            for (String string : ethAddresses) {
                if (!string.equals(inetAddress.getHostAddress())) continue;
                return true;
            }
            for (String string : othAddresses) {
                if (!string.equals(inetAddress.getHostAddress())) continue;
                return true;
            }
            return false;
        }

        public static boolean isIBLocal(InetAddress inetAddress) {
            for (String string : ibAddresses) {
                if (!string.equals(inetAddress.getHostAddress())) continue;
                return true;
            }
            return false;
        }

        private Host(InetAddress inetAddress, int n) {
            this.anyHost = false;
            this.addressAsBytes = inetAddress.getAddress();
            this.prefixByteCount = n >> 3;
            this.mask = (byte)(255 << 8 - n % 8);
            this.loopbackOrLocal = Host.isLoopbackOrLocal(inetAddress);
            this.ibLocal = Host.isIBLocal(inetAddress);
        }

        boolean match(SocketAction socketAction, InetAddress inetAddress, boolean bl) {
            if (socketAction == SocketAction.ACCEPT && bl && this.anyHost) {
                return true;
            }
            byte[] byArray = inetAddress.getAddress();
            if (byArray.length != this.addressAsBytes.length) {
                return false;
            }
            for (int i = 0; i < this.prefixByteCount; ++i) {
                if (byArray[i] == this.addressAsBytes[i]) continue;
                return false;
            }
            return this.prefixByteCount >= this.addressAsBytes.length || (byArray[this.prefixByteCount] & this.mask) == (this.addressAsBytes[this.prefixByteCount] & this.mask);
        }

        static Host[] parse(SocketAction socketAction, String string, boolean bl) {
            LinkedList<Host> linkedList;
            block12: {
                if (socketAction == SocketAction.ACCEPT && bl && (string.equals("*") || string.equals("any") || string.equals("all"))) {
                    return allHosts;
                }
                linkedList = new LinkedList<Host>();
                int n = string.indexOf(47);
                try {
                    if (n < 0) {
                        InetAddress[] inetAddressArray;
                        for (InetAddress inetAddress : inetAddressArray = InetAddress.getAllByName(string)) {
                            int n2 = inetAddress instanceof Inet4Address ? 32 : 128;
                            linkedList.addLast(new Host(inetAddress, n2));
                        }
                        break block12;
                    }
                    InetAddress inetAddress = InetAddress.getByName(string.substring(0, n));
                    int n3 = -1;
                    try {
                        n3 = Integer.parseInt(string.substring(n + 1));
                        if (inetAddress instanceof Inet4Address) {
                            if (n3 < 0 || n3 > 32) {
                                n3 = -1;
                            }
                        } else if (n3 < 0 || n3 > 128) {
                            n3 = -1;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (n3 > 0) {
                        linkedList.addLast(new Host(inetAddress, n3));
                        break block12;
                    }
                    NetworkSelector.fail("Malformed prefix '%s'", new Object[]{string});
                    return null;
                }
                catch (UnknownHostException unknownHostException) {
                    NetworkSelector.fail("Unknown host or malformed IP address '%s'", new Object[]{string});
                    return null;
                }
            }
            return linkedList.toArray(new Host[linkedList.size()]);
        }

        public boolean getIsLoopBackOrLocal() {
            return this.loopbackOrLocal;
        }

        public boolean getIsIBLocal() {
            return this.ibLocal;
        }

        public String toString() {
            String string = null;
            try {
                string = this.anyHost ? new String("*") : new String("" + InetAddress.getByAddress(this.addressAsBytes).toString() + "/" + (this.prefixByteCount << 3));
            }
            catch (Exception exception) {
                // empty catch block
            }
            return string;
        }

        static {
            try {
                boolean bl = Boolean.parseBoolean(AccessController.doPrivileged(new GetPropertyAction("java.net.preferIPv4Stack")));
                boolean bl2 = Boolean.parseBoolean(AccessController.doPrivileged(new GetPropertyAction("java.net.preferIPv6Addresses")));
                Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
                if (enumeration != null) {
                    while (enumeration.hasMoreElements()) {
                        NetworkInterface networkInterface = enumeration.nextElement();
                        if (networkInterface == null || !networkInterface.isUp()) continue;
                        boolean bl3 = false;
                        boolean bl4 = false;
                        if (networkInterface.getName().startsWith("ib")) {
                            bl3 = true;
                        } else if (networkInterface.getName().startsWith("eth")) {
                            bl4 = true;
                        }
                        Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
                        while (enumeration2.hasMoreElements()) {
                            String string = enumeration2.nextElement().getHostAddress();
                            if (bl2 && !bl && string.indexOf(":") < 0 || !bl2 && string.indexOf(":") >= 0) continue;
                            if (bl3) {
                                ibAddresses.add(string);
                                continue;
                            }
                            if (bl4) {
                                ethAddresses.add(string);
                                continue;
                            }
                            othAddresses.add(string);
                        }
                    }
                }
            }
            catch (SocketException socketException) {
                // empty catch block
            }
        }
    }

    private static class PortRange {
        private final int portStart;
        private final int portEnd;
        private static final int MAX_PORT = 65535;

        public PortRange(String string) throws NumberFormatException {
            int n = string.indexOf(45);
            if (n < 0) {
                boolean bl = string.equals("*");
                this.portStart = bl ? 0 : Integer.parseInt(string);
                this.portEnd = bl ? 65535 : this.portStart;
            } else {
                String string2;
                String string3 = string.substring(0, n);
                if (string3.length() == 0) {
                    string3 = "*";
                }
                if ((string2 = string.substring(n + 1)).length() == 0) {
                    string2 = "*";
                }
                this.portStart = string3.equals("*") ? 0 : Integer.parseInt(string3);
                this.portEnd = string2.equals("*") ? 65535 : Integer.parseInt(string2);
            }
        }

        public boolean match(int n) {
            return n >= this.portStart && n <= this.portEnd;
        }

        public String toString() {
            if (this.portStart == this.portEnd) {
                return new String("" + this.portStart);
            }
            return new String("" + this.portStart + "-" + this.portEnd);
        }
    }
}

