/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs;

import com.ibm.jvm.io.LocalizedInputStream;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import java.security.AccessController;
import sun.nio.cs.HistoricallyNamedCharset;
import sun.security.action.GetPropertyAction;

public class StreamDecoder
extends Reader {
    private static final int MIN_BYTE_BUFFER_SIZE = 32;
    private static final int DEFAULT_BYTE_BUFFER_SIZE = 8192;
    private volatile boolean isOpen = true;
    private boolean haveLeftoverChar = false;
    private char leftoverChar;
    private static volatile boolean channelsAvailable = true;
    private Charset cs;
    private CharsetDecoder decoder;
    private ByteBuffer bb;
    private InputStream in;
    private ReadableByteChannel ch;

    private void ensureOpen() throws IOException {
        if (!this.isOpen) {
            throw new IOException("Stream closed");
        }
    }

    public static StreamDecoder forInputStreamReader(InputStream inputStream, Object object, String string) throws UnsupportedEncodingException {
        String string2 = string;
        if (string2 == null) {
            InputStream inputStream2;
            if (LocalizedInputStream.nonASCIIPlatform && (inputStream2 = LocalizedInputStream.localize(inputStream)) instanceof LocalizedInputStream) {
                return new LocalizedStreamDecoder(inputStream, object);
            }
            string2 = Charset.defaultCharset().name();
        }
        try {
            if (Charset.isSupported(string2)) {
                return new StreamDecoder(inputStream, object, Charset.forName(string2));
            }
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
            // empty catch block
        }
        throw new UnsupportedEncodingException(string2);
    }

    public static StreamDecoder forInputStreamReader(InputStream inputStream, Object object, Charset charset) {
        return new StreamDecoder(inputStream, object, charset);
    }

    public static StreamDecoder forInputStreamReader(InputStream inputStream, Object object, CharsetDecoder charsetDecoder) {
        return new StreamDecoder(inputStream, object, charsetDecoder);
    }

    public static StreamDecoder forDecoder(ReadableByteChannel readableByteChannel, CharsetDecoder charsetDecoder, int n) {
        return new StreamDecoder(readableByteChannel, charsetDecoder, n);
    }

    public String getEncoding() {
        if (this.isOpen()) {
            return this.encodingName();
        }
        return null;
    }

    @Override
    public int read() throws IOException {
        return this.read0();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int read0() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.haveLeftoverChar) {
                this.haveLeftoverChar = false;
                return this.leftoverChar;
            }
            char[] cArray = new char[2];
            int n = this.read(cArray, 0, 2);
            switch (n) {
                case -1: {
                    return -1;
                }
                case 2: {
                    this.leftoverChar = cArray[1];
                    this.haveLeftoverChar = true;
                }
                case 1: {
                    return cArray[0];
                }
            }
            assert (false) : n;
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(char[] cArray, int n, int n2) throws IOException {
        int n3 = n;
        int n4 = n2;
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            if (n3 < 0 || n3 > cArray.length || n4 < 0 || n3 + n4 > cArray.length || n3 + n4 < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (n4 == 0) {
                return 0;
            }
            int n5 = 0;
            if (this.haveLeftoverChar) {
                cArray[n3] = this.leftoverChar;
                ++n3;
                this.haveLeftoverChar = false;
                n5 = 1;
                if (--n4 == 0 || !this.implReady()) {
                    return n5;
                }
            }
            if (n4 == 1) {
                int n6 = this.read0();
                if (n6 == -1) {
                    return n5 == 0 ? -1 : n5;
                }
                cArray[n3] = (char)n6;
                return n5 + 1;
            }
            return n5 + this.implRead(cArray, n3, n3 + n4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean ready() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            return this.haveLeftoverChar || this.implReady();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isOpen) {
                return;
            }
            this.implClose();
            this.isOpen = false;
        }
    }

    private boolean isOpen() {
        return this.isOpen;
    }

    private static FileChannel getChannel(FileInputStream fileInputStream) {
        if (!channelsAvailable) {
            return null;
        }
        try {
            return fileInputStream.getChannel();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            channelsAvailable = false;
            return null;
        }
    }

    StreamDecoder(Object object) {
        super(object);
    }

    StreamDecoder(InputStream inputStream, Object object, Charset charset) {
        this(inputStream, object, charset.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE));
    }

    StreamDecoder(InputStream inputStream, Object object, CharsetDecoder charsetDecoder) {
        super(object);
        this.cs = charsetDecoder.charset();
        this.decoder = charsetDecoder;
        if (this.ch == null) {
            this.in = inputStream;
            this.ch = null;
            this.bb = ByteBuffer.allocate(8192);
        }
        this.bb.flip();
    }

    StreamDecoder(ReadableByteChannel readableByteChannel, CharsetDecoder charsetDecoder, int n) {
        this.in = null;
        this.ch = readableByteChannel;
        this.decoder = charsetDecoder;
        this.cs = charsetDecoder.charset();
        this.bb = ByteBuffer.allocate(n < 0 ? 8192 : (n < 32 ? 32 : n));
        this.bb.flip();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readBytes() throws IOException {
        int n;
        this.bb.compact();
        try {
            if (this.ch != null) {
                n = this.ch.read(this.bb);
                if (n < 0) {
                    int n2 = n;
                    return n2;
                }
            } else {
                int n3;
                n = this.bb.limit();
                int n4 = this.bb.position();
                assert (n4 <= n);
                int n5 = n3 = n4 <= n ? n - n4 : 0;
                assert (n3 > 0);
                int n6 = this.in.read(this.bb.array(), this.bb.arrayOffset() + n4, n3);
                if (n6 < 0) {
                    int n7 = n6;
                    return n7;
                }
                if (n6 == 0) {
                    throw new IOException("Underlying input stream returned zero bytes");
                }
                assert (n6 <= n3) : "n = " + n6 + ", rem = " + n3;
                this.bb.position(n4 + n6);
            }
        }
        finally {
            this.bb.flip();
        }
        n = this.bb.remaining();
        assert (n != 0) : n;
        return n;
    }

    int implRead(char[] cArray, int n, int n2) throws IOException {
        assert (n2 - n > 1);
        CharBuffer charBuffer = CharBuffer.wrap(cArray, n, n2 - n);
        if (charBuffer.position() != 0) {
            charBuffer = charBuffer.slice();
        }
        boolean bl = false;
        while (true) {
            CoderResult coderResult;
            if ((coderResult = this.decoder.decode(this.bb, charBuffer, bl)).isUnderflow()) {
                if (bl || !charBuffer.hasRemaining() || charBuffer.position() > 0 && !this.inReady()) break;
                int n3 = this.readBytes();
                if (n3 >= 0) continue;
                bl = true;
                if (charBuffer.position() == 0 && !this.bb.hasRemaining()) break;
                this.decoder.reset();
                continue;
            }
            if (coderResult.isOverflow()) {
                assert (charBuffer.position() > 0);
                break;
            }
            coderResult.throwException();
        }
        if (bl) {
            this.decoder.reset();
        }
        if (charBuffer.position() == 0) {
            if (bl) {
                return -1;
            }
            assert (false);
        }
        return charBuffer.position();
    }

    String encodingName() {
        return this.cs instanceof HistoricallyNamedCharset ? ((HistoricallyNamedCharset)((Object)this.cs)).historicalName() : this.cs.name();
    }

    private boolean inReady() {
        try {
            return this.in != null && this.in.available() > 0 || this.ch instanceof FileChannel;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    boolean implReady() {
        return this.bb.hasRemaining() || this.inReady();
    }

    void implClose() throws IOException {
        if (this.ch != null) {
            this.ch.close();
        } else {
            this.in.close();
        }
    }

    private static class LocalizedStreamDecoder
    extends StreamDecoder {
        private StreamDecoder sd;
        private BufferedInputStream bin;
        private Object lock;
        private InputStream in;
        static final String ASCIIEncoding;
        static final String EBCDICEncoding;

        LocalizedStreamDecoder(InputStream inputStream, Object object) throws UnsupportedEncodingException {
            super(object);
            this.in = inputStream;
            this.bin = new BufferedInputStream(inputStream);
            this.lock = object;
        }

        LocalizedStreamDecoder(ReadableByteChannel readableByteChannel, String string) throws UnsupportedEncodingException {
            this(Channels.newInputStream(readableByteChannel), null);
            this.lock = this;
        }

        @Override
        String encodingName() {
            if (this.sd == null) {
                try {
                    this.sdInit();
                }
                catch (IOException iOException) {
                    return null;
                }
            }
            return this.sd.encodingName();
        }

        @Override
        boolean implReady() {
            if (this.sd == null) {
                try {
                    this.sdInit();
                }
                catch (IOException iOException) {
                    return false;
                }
            }
            return this.sd.implReady();
        }

        @Override
        void implClose() throws IOException {
            if (this.sd == null) {
                this.bin.close();
            } else {
                this.sd.implClose();
            }
        }

        @Override
        int implRead(char[] cArray, int n, int n2) throws IOException {
            if (this.sd == null) {
                this.sdInit();
            }
            return this.sd.implRead(cArray, n, n2);
        }

        private void sdInit() throws IOException {
            boolean bl = false;
            boolean bl2 = false;
            this.bin.mark(1001);
            for (int i = 0; i < 1000; ++i) {
                int n;
                try {
                    if (i > 0 && this.bin.available() <= 0) break;
                    n = this.bin.read();
                }
                catch (IOException iOException) {
                    break;
                }
                if (n == -1) break;
                if (n == 35 || n == 61 || n == 10) {
                    bl = true;
                    break;
                }
                if (n != 21) continue;
                bl2 = true;
                break;
            }
            this.bin.reset();
            try {
                this.sd = bl2 ? StreamDecoder.forInputStreamReader((InputStream)this.bin, this.lock, Charset.forName(EBCDICEncoding)) : (bl ? StreamDecoder.forInputStreamReader((InputStream)this.bin, this.lock, Charset.forName(ASCIIEncoding)) : StreamDecoder.forInputStreamReader((InputStream)this.bin, this.lock, Charset.defaultCharset()));
            }
            catch (Exception exception) {
                throw (IOException)new IOException().initCause(exception);
            }
        }

        static {
            String string;
            String string2 = AccessController.doPrivileged(new GetPropertyAction("ibm.ascii.encoding"));
            if (string2 == null) {
                string2 = "8859_1";
            }
            if ((string = AccessController.doPrivileged(new GetPropertyAction("ibm.ebcdic.encoding"))) == null) {
                string = AccessController.doPrivileged(new GetPropertyAction("ibm.system.encoding"));
            }
            ASCIIEncoding = string2;
            EBCDICEncoding = string;
        }
    }
}

