/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cuda;

import com.ibm.cuda.CudaDevice;
import com.ibm.cuda.CudaException;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class Cuda {
    private static final int initializationStatus;
    private static final ThreadLocal<Boolean>[] threadInitialized;

    private static native long allocatePinnedBuffer(long var0) throws CudaException;

    public static ByteBuffer allocatePinnedHostBuffer(long capacity) throws CudaException {
        if (0L <= capacity && capacity <= Integer.MAX_VALUE) {
            long address = Cuda.allocatePinnedBuffer(capacity);
            ByteBuffer buffer = Cuda.wrapDirectBuffer(address, capacity);
            return Cleaner.instance.insert(buffer, address).order(ByteOrder.LITTLE_ENDIAN);
        }
        throw new IllegalArgumentException(String.valueOf(capacity));
    }

    static void checkInitialization(int deviceId) throws CudaException {
        if (initializationStatus != 0) {
            throw new CudaException(initializationStatus);
        }
        if (0 > deviceId || deviceId >= threadInitialized.length) {
            throw new CudaException(10);
        }
        ThreadLocal<Boolean> initialized = threadInitialized[deviceId];
        if (initialized.get() == null) {
            initialized.set(Boolean.TRUE);
            Cuda.initializeThreadContext(deviceId);
        }
    }

    public static native int getDeviceCount() throws CudaException;

    public static native int getDriverVersion() throws CudaException;

    static native String getErrorMessage(int var0);

    public static native int getRuntimeVersion() throws CudaException;

    private static native int initialize(Class<CudaDevice> var0, Class<CudaException> var1);

    private static native void initializeThreadContext(int var0) throws CudaException;

    private static native ByteBuffer wrapDirectBuffer(long var0, long var2);

    private Cuda() {
    }

    static {
        int deviceCount;
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                String Name = "com.ibm.oti.vm.library.version";
                String Default = "27";
                String VmLibVersion = System.getProperty(Name, Default);
                System.loadLibrary("cuda4j55_" + VmLibVersion);
                return null;
            }
        });
        initializationStatus = Cuda.initialize(CudaDevice.class, CudaException.class);
        if (initializationStatus != 0) {
            throw new RuntimeException(Cuda.getErrorMessage(initializationStatus));
        }
        try {
            deviceCount = Cuda.getDeviceCount();
            if (deviceCount < 0) {
                deviceCount = 0;
            }
        }
        catch (CudaException e) {
            deviceCount = 0;
        }
        ThreadLocal[] threadLocals = new ThreadLocal[deviceCount];
        for (int i = 0; i < deviceCount; ++i) {
            threadLocals[i] = new ThreadLocal();
        }
        threadInitialized = threadLocals;
    }

    private static final class Cleaner
    implements Runnable {
        static final Cleaner instance = new Cleaner();
        private static long releaseCount;
        private final Map<Object, Long> inuse = new ConcurrentHashMap<Object, Long>();
        private final ReferenceQueue<Object> queue = new ReferenceQueue();

        private static native void releasePinnedBuffer(long var0) throws CudaException;

        private Cleaner() {
        }

        ByteBuffer insert(ByteBuffer buffer, long address) {
            this.inuse.put(new WeakReference<Object>(buffer, this.queue), new Long(address));
            return buffer;
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Long address;
                        if ((address = this.inuse.remove(this.queue.remove())) == null) {
                            continue;
                        }
                        Cleaner.releasePinnedBuffer(address);
                        ++releaseCount;
                    }
                }
                catch (CudaException e) {
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }

        static {
            Thread daemon = new Thread((Runnable)instance, "CUDA pinned buffer cleaner");
            daemon.setDaemon(true);
            daemon.start();
        }
    }
}

