/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cuda;

import com.ibm.cuda.Cuda;
import com.ibm.cuda.CudaException;
import com.ibm.cuda.CudaPermission;
import java.util.Objects;

public final class CudaDevice {
    public static final int ATTRIBUTE_ASYNC_ENGINE_COUNT = 40;
    public static final int ATTRIBUTE_CAN_MAP_HOST_MEMORY = 19;
    public static final int ATTRIBUTE_CLOCK_RATE = 13;
    public static final int ATTRIBUTE_COMPUTE_CAPABILITY = -1;
    public static final int ATTRIBUTE_COMPUTE_CAPABILITY_MAJOR = 75;
    public static final int ATTRIBUTE_COMPUTE_CAPABILITY_MINOR = 76;
    public static final int ATTRIBUTE_COMPUTE_MODE = 20;
    public static final int ATTRIBUTE_CONCURRENT_KERNELS = 31;
    public static final int ATTRIBUTE_ECC_ENABLED = 32;
    public static final int ATTRIBUTE_GLOBAL_MEMORY_BUS_WIDTH = 37;
    public static final int ATTRIBUTE_INTEGRATED = 18;
    public static final int ATTRIBUTE_KERNEL_EXEC_TIMEOUT = 17;
    public static final int ATTRIBUTE_L2_CACHE_SIZE = 38;
    public static final int ATTRIBUTE_MAX_BLOCK_DIM_X = 2;
    public static final int ATTRIBUTE_MAX_BLOCK_DIM_Y = 3;
    public static final int ATTRIBUTE_MAX_BLOCK_DIM_Z = 4;
    public static final int ATTRIBUTE_MAX_GRID_DIM_X = 5;
    public static final int ATTRIBUTE_MAX_GRID_DIM_Y = 6;
    public static final int ATTRIBUTE_MAX_GRID_DIM_Z = 7;
    public static final int ATTRIBUTE_MAX_PITCH = 11;
    public static final int ATTRIBUTE_MAX_REGISTERS_PER_BLOCK = 12;
    public static final int ATTRIBUTE_MAX_SHARED_MEMORY_PER_BLOCK = 8;
    public static final int ATTRIBUTE_MAX_THREADS_PER_BLOCK = 1;
    public static final int ATTRIBUTE_MAX_THREADS_PER_MULTIPROCESSOR = 39;
    public static final int ATTRIBUTE_MAXIMUM_SURFACE1D_LAYERED_LAYERS = 62;
    public static final int ATTRIBUTE_MAXIMUM_SURFACE1D_LAYERED_WIDTH = 61;
    public static final int ATTRIBUTE_MAXIMUM_SURFACE1D_WIDTH = 55;
    public static final int ATTRIBUTE_MAXIMUM_SURFACE2D_HEIGHT = 57;
    public static final int ATTRIBUTE_MAXIMUM_SURFACE2D_LAYERED_HEIGHT = 64;
    public static final int ATTRIBUTE_MAXIMUM_SURFACE2D_LAYERED_LAYERS = 65;
    public static final int ATTRIBUTE_MAXIMUM_SURFACE2D_LAYERED_WIDTH = 63;
    public static final int ATTRIBUTE_MAXIMUM_SURFACE2D_WIDTH = 56;
    public static final int ATTRIBUTE_MAXIMUM_SURFACE3D_DEPTH = 60;
    public static final int ATTRIBUTE_MAXIMUM_SURFACE3D_HEIGHT = 59;
    public static final int ATTRIBUTE_MAXIMUM_SURFACE3D_WIDTH = 58;
    public static final int ATTRIBUTE_MAXIMUM_SURFACECUBEMAP_LAYERED_LAYERS = 68;
    public static final int ATTRIBUTE_MAXIMUM_SURFACECUBEMAP_LAYERED_WIDTH = 67;
    public static final int ATTRIBUTE_MAXIMUM_SURFACECUBEMAP_WIDTH = 66;
    public static final int ATTRIBUTE_MAXIMUM_TEXTURE1D_LAYERED_LAYERS = 43;
    public static final int ATTRIBUTE_MAXIMUM_TEXTURE1D_LAYERED_WIDTH = 42;
    public static final int ATTRIBUTE_MAXIMUM_TEXTURE1D_LINEAR_WIDTH = 69;
    public static final int ATTRIBUTE_MAXIMUM_TEXTURE1D_MIPMAPPED_WIDTH = 77;
    public static final int ATTRIBUTE_MAXIMUM_TEXTURE1D_WIDTH = 21;
    public static final int ATTRIBUTE_MAXIMUM_TEXTURE2D_GATHER_HEIGHT = 46;
    public static final int ATTRIBUTE_MAXIMUM_TEXTURE2D_GATHER_WIDTH = 45;
    public static final int ATTRIBUTE_MAXIMUM_TEXTURE2D_HEIGHT = 23;
    public static final int ATTRIBUTE_MAXIMUM_TEXTURE2D_LAYERED_HEIGHT = 28;
    public static final int ATTRIBUTE_MAXIMUM_TEXTURE2D_LAYERED_LAYERS = 29;
    public static final int ATTRIBUTE_MAXIMUM_TEXTURE2D_LAYERED_WIDTH = 27;
    public static final int ATTRIBUTE_MAXIMUM_TEXTURE2D_LINEAR_HEIGHT = 71;
    public static final int ATTRIBUTE_MAXIMUM_TEXTURE2D_LINEAR_PITCH = 72;
    public static final int ATTRIBUTE_MAXIMUM_TEXTURE2D_LINEAR_WIDTH = 70;
    public static final int ATTRIBUTE_MAXIMUM_TEXTURE2D_MIPMAPPED_HEIGHT = 74;
    public static final int ATTRIBUTE_MAXIMUM_TEXTURE2D_MIPMAPPED_WIDTH = 73;
    public static final int ATTRIBUTE_MAXIMUM_TEXTURE2D_WIDTH = 22;
    public static final int ATTRIBUTE_MAXIMUM_TEXTURE3D_DEPTH = 26;
    public static final int ATTRIBUTE_MAXIMUM_TEXTURE3D_DEPTH_ALTERNATE = 49;
    public static final int ATTRIBUTE_MAXIMUM_TEXTURE3D_HEIGHT = 25;
    public static final int ATTRIBUTE_MAXIMUM_TEXTURE3D_HEIGHT_ALTERNATE = 48;
    public static final int ATTRIBUTE_MAXIMUM_TEXTURE3D_WIDTH = 24;
    public static final int ATTRIBUTE_MAXIMUM_TEXTURE3D_WIDTH_ALTERNATE = 47;
    public static final int ATTRIBUTE_MAXIMUM_TEXTURECUBEMAP_LAYERED_LAYERS = 54;
    public static final int ATTRIBUTE_MAXIMUM_TEXTURECUBEMAP_LAYERED_WIDTH = 53;
    public static final int ATTRIBUTE_MAXIMUM_TEXTURECUBEMAP_WIDTH = 52;
    public static final int ATTRIBUTE_MEMORY_CLOCK_RATE = 36;
    public static final int ATTRIBUTE_MULTIPROCESSOR_COUNT = 16;
    public static final int ATTRIBUTE_PCI_BUS_ID = 33;
    public static final int ATTRIBUTE_PCI_DEVICE_ID = 34;
    public static final int ATTRIBUTE_PCI_DOMAIN_ID = 50;
    public static final int ATTRIBUTE_STREAM_PRIORITIES_SUPPORTED = 78;
    public static final int ATTRIBUTE_SURFACE_ALIGNMENT = 30;
    public static final int ATTRIBUTE_TCC_DRIVER = 35;
    public static final int ATTRIBUTE_TEXTURE_ALIGNMENT = 14;
    public static final int ATTRIBUTE_TEXTURE_PITCH_ALIGNMENT = 51;
    public static final int ATTRIBUTE_TOTAL_CONSTANT_MEMORY = 9;
    public static final int ATTRIBUTE_UNIFIED_ADDRESSING = 41;
    public static final int ATTRIBUTE_WARP_SIZE = 10;
    public static final int COMPUTE_MODE_DEFAULT = 0;
    public static final int COMPUTE_MODE_PROCESS_EXCLUSIVE = 3;
    public static final int COMPUTE_MODE_PROHIBITED = 2;
    public static final int COMPUTE_MODE_THREAD_EXCLUSIVE = 1;
    public static final int FLAG_LMEM_RESIZE_TO_MAX = 16;
    public static final int FLAG_MAP_HOST = 8;
    public static final int FLAG_SCHED_AUTO = 0;
    public static final int FLAG_SCHED_BLOCKING_SYNC = 4;
    public static final int FLAG_SCHED_SPIN = 1;
    public static final int FLAG_SCHED_YIELD = 2;
    public static final int MASK_SCHED = 7;
    private final int deviceId;

    static native void addCallback(int var0, long var1, Runnable var3) throws CudaException;

    private static native boolean canAccessPeer(int var0, int var1) throws CudaException;

    private static native void disablePeerAccess(int var0, int var1) throws CudaException;

    private static native void enablePeerAccess(int var0, int var1) throws CudaException;

    private static void fireCallback(Runnable callback) {
        try {
            callback.run();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    private static native int getAttribute(int var0, int var1) throws CudaException;

    private static native int getCacheConfig(int var0) throws CudaException;

    public static int getCount() throws CudaException {
        return Cuda.getDeviceCount();
    }

    @Deprecated
    public static int getDriverVersion() throws CudaException {
        return Cuda.getDriverVersion();
    }

    private static native long getFreeMemory(int var0) throws CudaException;

    private static native int getGreatestStreamPriority(int var0) throws CudaException;

    private static native int getLeastStreamPriority(int var0) throws CudaException;

    private static native long getLimit(int var0, int var1) throws CudaException;

    private static native String getName(int var0) throws CudaException;

    @Deprecated
    public static int getRuntimeVersion() throws CudaException {
        return Cuda.getRuntimeVersion();
    }

    private static native int getSharedMemConfig(int var0) throws CudaException;

    private static native long getTotalMemory(int var0) throws CudaException;

    private static native void setCacheConfig(int var0, int var1) throws CudaException;

    private static native void setLimit(int var0, int var1, long var2) throws CudaException;

    private static native void setSharedMemConfig(int var0, int var1) throws CudaException;

    private static native void synchronize(int var0) throws CudaException;

    public CudaDevice(int deviceId) {
        this.deviceId = deviceId;
    }

    public void addCallback(Runnable callback) throws CudaException {
        Objects.requireNonNull(callback);
        Cuda.checkInitialization(this.deviceId);
        CudaDevice.addCallback(this.deviceId, 0L, callback);
    }

    public boolean canAccessPeer(CudaDevice peerDevice) throws CudaException {
        Cuda.checkInitialization(this.deviceId);
        return CudaDevice.canAccessPeer(this.deviceId, peerDevice.deviceId);
    }

    public void disablePeerAccess(CudaDevice peerDevice) throws CudaException {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(CudaPermission.DisablePeerAccess);
        }
        Cuda.checkInitialization(this.deviceId);
        CudaDevice.disablePeerAccess(this.deviceId, peerDevice.deviceId);
    }

    public void enablePeerAccess(CudaDevice peerDevice) throws CudaException {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(CudaPermission.EnablePeerAccess);
        }
        Cuda.checkInitialization(this.deviceId);
        CudaDevice.enablePeerAccess(this.deviceId, peerDevice.deviceId);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof CudaDevice) {
            CudaDevice that = (CudaDevice)other;
            if (this.deviceId == that.deviceId) {
                return true;
            }
        }
        return false;
    }

    public int getAttribute(int attribute) throws CudaException {
        Cuda.checkInitialization(this.deviceId);
        return CudaDevice.getAttribute(this.deviceId, attribute);
    }

    public CacheConfig getCacheConfig() throws CudaException {
        Cuda.checkInitialization(this.deviceId);
        switch (CudaDevice.getCacheConfig(this.deviceId)) {
            default: {
                return CacheConfig.PREFER_NONE;
            }
            case 1: {
                return CacheConfig.PREFER_SHARED;
            }
            case 2: {
                return CacheConfig.PREFER_L1;
            }
            case 3: 
        }
        return CacheConfig.PREFER_EQUAL;
    }

    public int getDeviceId() {
        return this.deviceId;
    }

    public long getFreeMemory() throws CudaException {
        Cuda.checkInitialization(this.deviceId);
        return CudaDevice.getFreeMemory(this.deviceId);
    }

    public int getGreatestStreamPriority() throws CudaException {
        Cuda.checkInitialization(this.deviceId);
        return CudaDevice.getGreatestStreamPriority(this.deviceId);
    }

    public int getLeastStreamPriority() throws CudaException {
        Cuda.checkInitialization(this.deviceId);
        return CudaDevice.getLeastStreamPriority(this.deviceId);
    }

    public long getLimit(Limit limit) throws CudaException {
        Cuda.checkInitialization(this.deviceId);
        return CudaDevice.getLimit(this.deviceId, limit.nativeValue);
    }

    public String getName() throws CudaException {
        Cuda.checkInitialization(this.deviceId);
        return CudaDevice.getName(this.deviceId);
    }

    public SharedMemConfig getSharedMemConfig() throws CudaException {
        Cuda.checkInitialization(this.deviceId);
        switch (CudaDevice.getSharedMemConfig(this.deviceId)) {
            default: {
                return SharedMemConfig.DEFAULT_BANK_SIZE;
            }
            case 1: {
                return SharedMemConfig.FOUR_BYTE_BANK_SIZE;
            }
            case 2: 
        }
        return SharedMemConfig.EIGHT_BYTE_BANK_SIZE;
    }

    public long getTotalMemory() throws CudaException {
        Cuda.checkInitialization(this.deviceId);
        return CudaDevice.getTotalMemory(this.deviceId);
    }

    public int hashCode() {
        return this.deviceId;
    }

    public void setCacheConfig(CacheConfig config) throws CudaException {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(CudaPermission.SetCacheConfig);
        }
        Cuda.checkInitialization(this.deviceId);
        CudaDevice.setCacheConfig(this.deviceId, config.nativeValue);
    }

    public void setLimit(Limit limit, long value) throws CudaException {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(CudaPermission.SetLimit);
        }
        Cuda.checkInitialization(this.deviceId);
        CudaDevice.setLimit(this.deviceId, limit.nativeValue, value);
    }

    public void setSharedMemConfig(SharedMemConfig config) throws CudaException {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(CudaPermission.SetSharedMemConfig);
        }
        Cuda.checkInitialization(this.deviceId);
        CudaDevice.setSharedMemConfig(this.deviceId, config.nativeValue);
    }

    public void synchronize() throws CudaException {
        Cuda.checkInitialization(this.deviceId);
        CudaDevice.synchronize(this.deviceId);
    }

    public static enum SharedMemConfig {
        DEFAULT_BANK_SIZE(0),
        EIGHT_BYTE_BANK_SIZE(2),
        FOUR_BYTE_BANK_SIZE(1);

        final int nativeValue;

        private SharedMemConfig(int value) {
            this.nativeValue = value;
        }
    }

    public static enum Limit {
        DEV_RUNTIME_PENDING_LAUNCH_COUNT(4),
        DEV_RUNTIME_SYNC_DEPTH(3),
        MALLOC_HEAP_SIZE(2),
        PRINTF_FIFO_SIZE(1),
        STACK_SIZE(0);

        final int nativeValue;

        private Limit(int value) {
            this.nativeValue = value;
        }
    }

    public static enum CacheConfig {
        PREFER_EQUAL(3),
        PREFER_L1(2),
        PREFER_NONE(0),
        PREFER_SHARED(1);

        final int nativeValue;

        private CacheConfig(int value) {
            this.nativeValue = value;
        }
    }
}

