/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cuda;

import com.ibm.cuda.CudaException;
import com.ibm.cuda.CudaJitTarget;
import java.util.concurrent.atomic.AtomicLong;

public final class CudaJitOptions
implements Cloneable {
    private static final int NUM_OPT_CODES = 15;
    private static final int OPT_CACHE_MODE = 14;
    private static final int OPT_ERROR_LOG_BUFFER_SIZE_BYTES = 6;
    private static final int OPT_FALLBACK_STRATEGY = 10;
    private static final int OPT_GENERATE_DEBUG_INFO = 11;
    private static final int OPT_GENERATE_LINE_INFO = 13;
    private static final int OPT_INFO_LOG_BUFFER_SIZE_BYTES = 4;
    private static final int OPT_LOG_VERBOSE = 12;
    private static final int OPT_MAX_REGISTERS = 0;
    private static final int OPT_OPTIMIZATION_LEVEL = 7;
    private static final int OPT_TARGET = 9;
    private static final int OPT_TARGET_FROM_CUCONTEXT = 8;
    private static final int OPT_THREADS_PER_BLOCK = 1;
    private static final int OPT_WALL_TIME = 2;
    private String errorLogBuffer = "";
    private String infoLogBuffer = "";
    private final AtomicLong nativeHandle = new AtomicLong();
    private int optionMask = 0;
    private final int[] optionValue = new int[15];
    private int threadsPerBlock = 0;
    private float wallTime = 0.0f;

    private static native long create(int[] var0) throws CudaException;

    private static native void destroy(long var0);

    private static native String getErrorLogBuffer(long var0);

    private static native String getInfoLogBuffer(long var0);

    private static native int getThreadsPerBlock(long var0);

    private static native float getWallTime(long var0);

    protected CudaJitOptions clone() {
        CudaJitOptions clone = new CudaJitOptions();
        clone.optionMask = this.optionMask;
        System.arraycopy(this.optionValue, 0, clone.optionValue, 0, 15);
        return clone;
    }

    public String getErrorLogBuffer() {
        return this.errorLogBuffer;
    }

    long getHandle() throws CudaException {
        long handle;
        while ((handle = this.nativeHandle.get()) == 0L) {
            int mask;
            int[] keyValuePairs = new int[Integer.bitCount(mask) << 1];
            int index = 0;
            int code = 0;
            for (mask = this.optionMask; mask != 0; mask >>= 1) {
                if ((mask & 1) != 0) {
                    keyValuePairs[index++] = code;
                    keyValuePairs[index++] = this.optionValue[code];
                }
                ++code;
            }
            handle = CudaJitOptions.create(keyValuePairs);
            if (this.nativeHandle.compareAndSet(0L, handle)) break;
            CudaJitOptions.destroy(handle);
        }
        return handle;
    }

    public String getInfoLogBuffer() {
        return this.infoLogBuffer;
    }

    public int getThreadsPerBlock() {
        return this.threadsPerBlock;
    }

    public float getWallTime() {
        return this.wallTime;
    }

    public CudaJitOptions recordWallTime() {
        return this.setOption(2, true);
    }

    void releaseHandle(boolean update) {
        long handle = this.nativeHandle.getAndSet(0L);
        if (handle != 0L) {
            if (update) {
                this.update(handle);
            }
            CudaJitOptions.destroy(handle);
        }
    }

    public CudaJitOptions setCacheMode(CacheMode mode) {
        if (mode == null) {
            mode = CacheMode.DEFAULT;
        }
        return this.setOption(14, mode.nativeMode);
    }

    public CudaJitOptions setErrorLogBufferSize(int size) {
        return this.setOption(6, size);
    }

    public CudaJitOptions setGenerateDebugInfo(boolean enabled) {
        return this.setOption(11, enabled);
    }

    public CudaJitOptions setGenerateLineInfo(boolean enabled) {
        return this.setOption(13, enabled);
    }

    public CudaJitOptions setInfoLogBufferSize(int size) {
        return this.setOption(4, size);
    }

    public CudaJitOptions setJitFallbackStrategy(Fallback strategy) {
        if (strategy == null) {
            strategy = Fallback.PreferPtx;
        }
        return this.setOption(10, strategy.nativeStrategy);
    }

    public CudaJitOptions setLogVerbose(boolean verbose) {
        return this.setOption(12, verbose);
    }

    public CudaJitOptions setMaxRegisters(int limit) {
        return this.setOption(0, limit);
    }

    public CudaJitOptions setOptimizationLevel(int level) {
        return this.setOption(7, level);
    }

    private CudaJitOptions setOption(int key, boolean value) {
        return this.setOption(key, value ? 1 : 0);
    }

    private CudaJitOptions setOption(int key, int value) {
        this.releaseHandle(false);
        this.optionMask |= 1 << key;
        this.optionValue[key] = value;
        return this;
    }

    public CudaJitOptions setTarget(CudaJitTarget target) {
        return this.setOption(9, target.nativeValue);
    }

    public CudaJitOptions setTargetFromCuContext() {
        return this.setOption(8, true);
    }

    public CudaJitOptions setThreadsPerBlock(int limit) {
        return this.setOption(1, limit);
    }

    CudaJitOptions update() {
        long handle = this.nativeHandle.get();
        if (handle != 0L) {
            this.update(handle);
        }
        return this;
    }

    private void update(long handle) {
        this.errorLogBuffer = CudaJitOptions.getErrorLogBuffer(handle);
        this.infoLogBuffer = CudaJitOptions.getInfoLogBuffer(handle);
        this.threadsPerBlock = CudaJitOptions.getThreadsPerBlock(handle);
        this.wallTime = CudaJitOptions.getWallTime(handle);
    }

    public static enum Fallback {
        PreferBinary(1),
        PreferPtx(0);

        final int nativeStrategy;

        private Fallback(int nativeStrategy) {
            this.nativeStrategy = nativeStrategy;
        }
    }

    public static enum CacheMode {
        DEFAULT(0),
        L1_DISABLED(1),
        L1_ENABLED(2);

        final int nativeMode;

        private CacheMode(int nativeMode) {
            this.nativeMode = nativeMode;
        }
    }
}

