/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cuda;

import com.ibm.cuda.Cuda;
import com.ibm.cuda.CudaDevice;
import com.ibm.cuda.CudaException;
import com.ibm.cuda.CudaFunction;
import com.ibm.cuda.CudaGlobal;
import com.ibm.cuda.CudaJitOptions;
import com.ibm.cuda.CudaPermission;
import com.ibm.cuda.CudaSurface;
import com.ibm.cuda.CudaTexture;
import com.ibm.cuda.internal.CudaUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public final class CudaModule {
    final int deviceId;
    private final Map<String, CudaFunction> functions;
    private final Map<String, CudaGlobal> globals;
    private final AtomicLong nativeHandle;
    private final Map<String, CudaSurface> surfaces;
    private final Map<String, CudaTexture> textures;

    private static native long getFunction(int var0, long var1, String var3) throws CudaException;

    private static native long getGlobal(int var0, long var1, String var3) throws CudaException;

    private static native long getSurface(int var0, long var1, String var3) throws CudaException;

    private static native long getTexture(int var0, long var1, String var3) throws CudaException;

    private static native long load(int var0, byte[] var1, long var2) throws CudaException;

    private static native void unload(int var0, long var1) throws CudaException;

    public CudaModule(CudaDevice device, byte[] image) throws CudaException {
        this(device, image, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CudaModule(CudaDevice device, byte[] image, CudaJitOptions options) throws CudaException {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(CudaPermission.LoadModule);
        }
        if (image == null) {
            throw new NullPointerException();
        }
        this.deviceId = device.getDeviceId();
        Cuda.checkInitialization(this.deviceId);
        long optionsHandle = options == null ? 0L : options.getHandle();
        try {
            this.functions = new HashMap<String, CudaFunction>();
            this.globals = new HashMap<String, CudaGlobal>();
            this.nativeHandle = new AtomicLong(CudaModule.load(this.deviceId, image, optionsHandle));
            this.surfaces = new HashMap<String, CudaSurface>();
            this.textures = new HashMap<String, CudaTexture>();
        }
        finally {
            if (options != null) {
                options.releaseHandle(true);
            }
        }
    }

    public CudaModule(CudaDevice device, InputStream input) throws CudaException, IOException {
        this(device, input, null);
    }

    public CudaModule(CudaDevice device, InputStream input, CudaJitOptions options) throws CudaException, IOException {
        this(device, CudaUtil.read(input, true), options);
    }

    public CudaFunction getFunction(String name) throws CudaException {
        CudaFunction function = this.functions.get(name);
        if (function == null) {
            Cuda.checkInitialization(this.deviceId);
            long address = CudaModule.getFunction(this.deviceId, this.getHandle(), name);
            function = new CudaFunction(this.deviceId, address);
            this.functions.put(name, function);
        }
        return function;
    }

    public CudaGlobal getGlobal(String name) throws CudaException {
        CudaGlobal global = this.globals.get(name);
        if (global == null) {
            Cuda.checkInitialization(this.deviceId);
            long address = CudaModule.getGlobal(this.deviceId, this.getHandle(), name);
            global = new CudaGlobal(address);
            this.globals.put(name, global);
        }
        return global;
    }

    private long getHandle() {
        long handle = this.nativeHandle.get();
        if (handle == 0L) {
            throw new IllegalStateException();
        }
        return handle;
    }

    public CudaSurface getSurface(String name) throws CudaException {
        CudaSurface surface = this.surfaces.get(name);
        if (surface == null) {
            Cuda.checkInitialization(this.deviceId);
            long address = CudaModule.getSurface(this.deviceId, this.getHandle(), name);
            surface = new CudaSurface(address);
            this.surfaces.put(name, surface);
        }
        return surface;
    }

    public CudaTexture getTexture(String name) throws CudaException {
        CudaTexture texture = this.textures.get(name);
        if (texture == null) {
            Cuda.checkInitialization(this.deviceId);
            long address = CudaModule.getTexture(this.deviceId, this.getHandle(), name);
            texture = new CudaTexture(address);
            this.textures.put(name, texture);
        }
        return texture;
    }

    public void unload() throws CudaException {
        long handle = this.nativeHandle.getAndSet(0L);
        if (handle != 0L) {
            this.functions.clear();
            this.globals.clear();
            this.surfaces.clear();
            this.textures.clear();
            Cuda.checkInitialization(this.deviceId);
            CudaModule.unload(this.deviceId, handle);
        }
    }

    public static final class Cache {
        private final Map<Object, Map<CudaDevice, CudaModule>> store = new HashMap<Object, Map<CudaDevice, CudaModule>>(1);

        public CudaModule get(CudaDevice device, Object key) {
            Map<CudaDevice, CudaModule> map = this.store.get(key);
            return map == null ? null : map.get(device);
        }

        public CudaModule put(CudaDevice device, Object key, CudaModule module) {
            Map<CudaDevice, CudaModule> map = this.store.get(key);
            if (map == null) {
                map = new HashMap<CudaDevice, CudaModule>();
                this.store.put(key, map);
            }
            return map.put(device, module);
        }
    }
}

