/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.certrequest;

import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.keystore.CertSortComparator;
import com.ibm.gsk.ikeyman.keystore.EntryBagFactory;
import com.ibm.gsk.ikeyman.keystore.EntryInterfaceFactory;
import com.ibm.gsk.ikeyman.keystore.entry.CertificateRequestKeyItem;
import com.ibm.gsk.ikeyman.keystore.entry.Entry;
import com.ibm.gsk.ikeyman.keystore.ext.DatabaseDescriptorFactory;
import com.ibm.gsk.ikeyman.util.Debug;
import com.ibm.gsk.ikeyman.util.KeymanUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCertificateRequestStore<T extends DatabaseDescriptorFactory.DatabaseDescriptor>
implements EntryInterfaceFactory.EntryInterface<CertificateRequestKeyItem, T> {
    private static final List<Class<? extends Entry>> supportedTypes = new ArrayList<Class<? extends Entry>>();

    @Override
    public boolean contains(String label) {
        Debug.entering(label);
        boolean result = this.getAliases().contains(label);
        Debug.exiting(result);
        return result;
    }

    @Override
    public Collection<CertificateRequestKeyItem> getItems() throws KeyManagerException {
        Debug.entering();
        TreeSet<Entry> returnList = new TreeSet<Entry>(new CertSortComparator(this));
        for (String alias : this.getAliases()) {
            CertificateRequestKeyItem item = (CertificateRequestKeyItem)this.getItem(alias);
            if (item == null) continue;
            returnList.add(item);
        }
        Debug.exiting(returnList);
        return returnList;
    }

    @Override
    public void delete(Entry entry) throws KeyManagerException {
        try {
            this.delete(entry.getLabel());
        }
        catch (KeyManagerException e) {
            if (e.getReason() == KeyManagerException.ExceptionReason.NO_ENTRY_FOR_LABEL) {
                return;
            }
            throw e;
        }
    }

    @Override
    public int compare(Entry e1, Entry e2) {
        Debug.finest("Item 1 = {0}, Item 2 = {1}", e1, e2);
        return KeymanUtil.compareStrings(e1.getLabel(), e2.getLabel());
    }

    @Override
    public void close() throws KeyManagerException {
    }

    @Override
    public T getDescriptor() {
        return null;
    }

    @Override
    public EntryBagFactory.EntryBag<? extends Entry> getEntryBag(Class<? extends Entry> c) {
        if (this.getSupportedTypes().contains(c)) {
            return this;
        }
        return null;
    }

    @Override
    public List<Class<? extends Entry>> getSupportedTypes() {
        return supportedTypes;
    }

    public abstract List<String> getAliases();

    static {
        supportedTypes.add(CertificateRequestKeyItem.class);
    }
}

