/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.command;

import com.ibm.gsk.ikeyman.command.CommandFactory;
import com.ibm.gsk.ikeyman.command.CommandParameters;
import com.ibm.gsk.ikeyman.command.Constants;
import com.ibm.gsk.ikeyman.command.ControlObjectFactory;
import com.ibm.gsk.ikeyman.command.KeyStoreLoaderFactory;
import com.ibm.gsk.ikeyman.command.ParameterMap;
import com.ibm.gsk.ikeyman.command.ValidatorFactory;
import com.ibm.gsk.ikeyman.error.CancelledException;
import com.ibm.gsk.ikeyman.error.CommandValidationException;
import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.event.KeyManagerEvent;
import com.ibm.gsk.ikeyman.event.KeyManagerEventListener;
import com.ibm.gsk.ikeyman.event.ProviderEvent;
import com.ibm.gsk.ikeyman.keystore.ext.DatabaseDescriptorFactory;
import com.ibm.gsk.ikeyman.keystore.ext.Displayer;
import com.ibm.gsk.ikeyman.keystore.ext.KeyStoreInfo;
import com.ibm.gsk.ikeyman.keystore.ext.KeyStoreItem;
import com.ibm.gsk.ikeyman.messages.Messages;
import com.ibm.gsk.ikeyman.util.Debug;
import com.ibm.gsk.ikeyman.util.FilePermissions;
import com.ibm.gsk.ikeyman.util.KeymanSettings;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Command {
    protected static boolean controlObjectsEnabled = false;
    private final Constants.CommandType type;
    private final ValidatorFactory.Validator validator;
    private final ParameterMap map;
    private final Map<Constants.Parameter, Object> defaults;
    protected KeyStoreLoaderFactory.KeyStoreLoader loader;

    protected Command(ParameterMap map, ValidatorFactory.Validator validator, Map<Constants.Parameter, Object> defaults) {
        Debug.entering(map, validator, defaults);
        this.type = map.getCommandType();
        this.validator = validator;
        this.map = map;
        this.defaults = defaults;
        Debug.exiting();
    }

    public static void setControlObjectsEnabled(boolean value) {
        Debug.entering(value);
        controlObjectsEnabled = value;
        Debug.exiting();
    }

    protected KeyStoreItem<? extends DatabaseDescriptorFactory.DatabaseDescriptor> getKeystoreItem(DatabaseDescriptorFactory.DatabaseDescriptor descriptor) throws KeyManagerException, CancelledException {
        Debug.entering(descriptor);
        KeyStoreItem<? extends DatabaseDescriptorFactory.DatabaseDescriptor> item = this.loader.getKeyStoreItem(descriptor);
        Debug.exiting(item);
        return item;
    }

    protected KeyStoreItem<? extends DatabaseDescriptorFactory.DatabaseDescriptor> getValidKeystoreItem(DatabaseDescriptorFactory.DatabaseDescriptor descriptor) throws KeyManagerException, CancelledException {
        Debug.entering(descriptor);
        KeyStoreItem<? extends DatabaseDescriptorFactory.DatabaseDescriptor> item = this.loader.getValidKeyStoreItem(descriptor);
        Debug.exiting(item);
        return item;
    }

    protected void closeKeyStoreItem(DatabaseDescriptorFactory.DatabaseDescriptor descriptor) throws KeyManagerException {
        Debug.entering(descriptor);
        this.loader.closeKeyStoreItem(descriptor);
        Debug.exiting();
    }

    protected final void fireKeyManagerEventDatabaseOpened(KeyManagerEventListener listener, KeyStoreItem item) throws KeyManagerException {
        Debug.entering(listener, item);
        if (listener != null) {
            listener.databaseOpened(new KeyManagerEvent(this, item.getInfo()));
        }
        Debug.exiting();
    }

    protected final void fireKeyManagerEventDatabaseChanged(KeyManagerEventListener listener, KeyStoreItem item) throws KeyManagerException {
        Debug.entering(listener, item);
        if (listener != null) {
            listener.databaseChanged(new KeyManagerEvent(this, item.getInfo()));
        }
        Debug.exiting();
    }

    protected final void fireKeyManagerEventDatabaseClosed(KeyManagerEventListener listener, DatabaseDescriptorFactory.DatabaseDescriptor descriptor) throws KeyManagerException {
        Debug.entering(listener, descriptor);
        if (listener != null) {
            listener.databaseClosed(new KeyManagerEvent(this, new KeyStoreInfo(descriptor, null, null, null)));
        }
        Debug.exiting();
    }

    protected final void fireKeyManagerEventProviderAdded(KeyManagerEventListener listener, String provider) throws KeyManagerException {
        Debug.entering(listener, provider);
        if (listener != null) {
            listener.providerAdded(new ProviderEvent(this, provider));
        }
        Debug.exiting();
    }

    public final ControlObjectFactory.ControlObject invoke(KeyStoreLoaderFactory.KeyStoreLoader loader, KeyManagerEventListener listener, Displayer view) throws KeyManagerException, CancelledException {
        Debug.entering(loader, listener, view);
        try {
            this.validator.validate(this.map.getParameters());
        }
        catch (CommandValidationException e) {
            Debug.throwing(e);
            e.addDetail(this.getUsageString());
            throw e;
        }
        if (this.defaults != null) {
            for (Constants.Parameter param : this.defaults.keySet()) {
                Object value;
                if (this.map.containsKey(param)) continue;
                if (param.name().equalsIgnoreCase("size") && this.map.containsKey(Constants.Parameter.SigAlg) && this.map.get(Constants.Parameter.SigAlg).toString().toUpperCase().contains("ECDSA")) {
                    this.defaults.put(Constants.Parameter.Size, KeymanSettings.Setting.DefaultECKeySize.getInteger() + "");
                }
                if ((value = this.defaults.get(param)) == null) continue;
                Debug.log("Adding default value {0} for parameter {1}", value, param);
                this.map.put(param, value);
            }
        }
        if (this.map.containsKey(Constants.Parameter.Stashed)) {
            this.map.remove(Constants.Parameter.Stashed);
            this.map.put(Constants.Parameter.Password, this.getPasswordFromStash(CommandFactory.getStashFileName((String)this.map.get(Constants.Parameter.DatabaseName))));
        }
        this.loader = loader;
        ControlObjectFactory.ControlObject returnObject = null;
        try {
            returnObject = this.run(this.map.getCommandParameters(), listener, view);
        }
        catch (KeyManagerException e) {
            if (e.getMessage() != null && e.getMessage().contains("TrustedCertEntry not supported")) {
                throw new KeyManagerException(KeyManagerException.ExceptionReason.NOT_SUPPORTED_ACTION);
            }
            throw e;
        }
        finally {
            FilePermissions.setLogFilePermissions();
        }
        Debug.exiting(returnObject);
        return returnObject;
    }

    public String getUsageString() {
        Debug.entering();
        String usageString = this.validator.toString();
        usageString = usageString + "\n\n" + this.getDefaultsString();
        Debug.exiting(usageString);
        return usageString;
    }

    private String getDefaultsString() {
        Debug.entering();
        StringBuffer returnString = new StringBuffer();
        if (this.defaults != null) {
            returnString.append(Messages.getString("Message.Defaults") + " ");
            Iterator<Constants.Parameter> iter = this.defaults.keySet().iterator();
            while (iter.hasNext()) {
                Constants.Parameter param = iter.next();
                returnString.append(param + " = " + this.defaults.get(param));
                if (!iter.hasNext()) continue;
                returnString.append(", ");
            }
        }
        Debug.exiting(returnString.toString());
        return returnString.toString();
    }

    private String getPasswordFromStash(String stashFile) throws KeyManagerException {
        ByteBuffer bytebuf;
        Charset utf8Set;
        CharBuffer charbuf;
        byte[] buffer = new byte[129];
        try {
            FileInputStream in = new FileInputStream(stashFile);
            if (((InputStream)in).read(buffer) != 129) {
                throw new KeyManagerException(KeyManagerException.ExceptionReason.INVALID_OBJECT, stashFile);
            }
            ((InputStream)in).close();
        }
        catch (FileNotFoundException e) {
            throw new KeyManagerException(KeyManagerException.ExceptionReason.INPUT_FILE_NOT_FOUND, stashFile);
        }
        catch (IOException e) {
            throw new KeyManagerException(KeyManagerException.ExceptionReason.IO_ERROR_MSG, e.getMessage());
        }
        int endOfPwdIndex = 0;
        for (int i = 0; i < 129; ++i) {
            buffer[i] = (byte)(buffer[i] ^ 0xF5);
            if (buffer[i] != 0 || endOfPwdIndex != 0) continue;
            endOfPwdIndex = i;
            break;
        }
        if (!(charbuf = (utf8Set = Charset.forName("UTF-8")).decode(bytebuf = ByteBuffer.wrap(buffer, 0, endOfPwdIndex))).hasArray()) {
            throw new KeyManagerException(KeyManagerException.ExceptionReason.INVALID_OBJECT, stashFile);
        }
        char[] password = new char[endOfPwdIndex];
        System.arraycopy(charbuf.array(), 0, password, 0, endOfPwdIndex);
        Command.wipeArray(buffer);
        Command.wipeArray(charbuf.array());
        return new String(password);
    }

    private static void wipeArray(byte[] array) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = 0;
        }
    }

    private static void wipeArray(char[] array) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = '\u0000';
        }
    }

    protected abstract ControlObjectFactory.ControlObject run(CommandParameters var1, KeyManagerEventListener var2, Displayer var3) throws KeyManagerException, CancelledException;
}

