/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.command;

import com.ibm.gsk.ikeyman.util.Debug;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Security;

public class SupportCheckerFactory {
    public static SupportChecker newKeyStoreSupportChecker(String keyStoreName) {
        return new KeyStoreSupportChecker(keyStoreName);
    }

    public static SupportChecker newProviderChecker(String provider) {
        return new ProviderChecker(provider);
    }

    public static SupportChecker newConstantChecker(boolean value) {
        return new ConstantChecker(value);
    }

    private static class ConstantChecker
    implements SupportChecker {
        private boolean value;

        public ConstantChecker(boolean value) {
            Debug.entering(value);
            this.value = value;
            Debug.exiting();
        }

        public boolean isSupported() {
            Debug.entering();
            Debug.exiting(this.value);
            return this.value;
        }
    }

    private static class KeyStoreSupportChecker
    implements SupportChecker {
        private String keyStoreName;
        private boolean supported = false;

        public KeyStoreSupportChecker(String keyStoreName) {
            Debug.entering(keyStoreName);
            this.keyStoreName = keyStoreName;
            Debug.exiting();
        }

        public boolean isSupported() {
            Debug.entering();
            if (!this.supported) {
                try {
                    KeyStore.getInstance(this.keyStoreName);
                    Debug.exiting(true);
                    this.supported = true;
                    return true;
                }
                catch (RuntimeException e) {
                    Debug.exiting(false);
                    return false;
                }
                catch (KeyStoreException e) {
                    Debug.exiting(false);
                    return false;
                }
            }
            Debug.exiting(this.supported);
            return this.supported;
        }
    }

    private static class ProviderChecker
    implements SupportChecker {
        private String providerClass;

        public ProviderChecker(String providerClass) {
            Debug.entering(providerClass);
            this.providerClass = providerClass;
            Debug.exiting();
        }

        public boolean isSupported() {
            Debug.entering();
            boolean returnValue = Security.getProvider(this.providerClass) != null;
            Debug.exiting(returnValue);
            return returnValue;
        }
    }

    public static interface SupportChecker {
        public boolean isSupported();
    }
}

