/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.command;

import com.ibm.gsk.ikeyman.error.CommandValidationException;
import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.messages.Messages;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Formatter;
import java.util.List;

public class ValidatorFactory {
    public static Validator newValidator(Validation ... validations) {
        return new ParameterValidator(validations);
    }

    public static Validation required(ValidationItem item, ValidationCondition condition) {
        return new RequiredValidation(item, condition);
    }

    public static Validation required(Validatable item, ValidationCondition condition) {
        return new RequiredValidation(new SingleItem(item), condition);
    }

    public static Validation optional(ValidationItem item, ValidationCondition condition) {
        return new OptionalValidation(item, condition);
    }

    public static Validation optional(Validatable item, ValidationCondition condition) {
        return new OptionalValidation(new SingleItem(item), condition);
    }

    public static ValidationItem choice(Validatable ... validatables) {
        return new ChoiceItem(validatables);
    }

    public static ValidationItem singleItem(Validatable validatable) {
        return new SingleItem(validatable);
    }

    public static ValidationCondition itemPresent(Validatable validatable) {
        return new ItemPresentCondition(validatable);
    }

    public static ValidationCondition and(ValidationCondition ... conditions) {
        return new AndCondition(conditions);
    }

    public static ValidationCondition or(ValidationCondition ... conditions) {
        return new OrCondition(conditions);
    }

    public static ValidationCondition not(ValidationCondition condition) {
        return new NotCondition(condition);
    }

    public static ValidationCondition always() {
        return new ConstantCondition(true);
    }

    public static ValidationCondition never() {
        return new ConstantCondition(false);
    }

    static abstract class AbstractValidation
    implements Validation {
        private static final String FORMAT_STRING = "%-35s %s";
        protected ValidationItem item;
        protected ValidationCondition condition;

        public AbstractValidation(ValidationItem item, ValidationCondition condition) {
            this.item = item;
            this.condition = condition;
        }

        protected static String formatArguments(Object ... args) {
            return new Formatter().format(FORMAT_STRING, args).toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class AndCondition
    implements ValidationCondition {
        private ValidationCondition[] conditions;

        public AndCondition(ValidationCondition[] conditions) {
            this.conditions = conditions;
        }

        @Override
        public boolean isSatisfied(Collection<? extends Validatable> validatables) {
            boolean returnValue = true;
            for (ValidationCondition condition : this.conditions) {
                returnValue &= condition.isSatisfied(validatables);
            }
            return returnValue;
        }

        public String toString() {
            String returnString = "";
            for (int i = 0; i < this.conditions.length; ++i) {
                returnString = returnString + "(" + this.conditions[i].toString() + ")";
                if (i >= this.conditions.length - 1) continue;
                returnString = returnString + " " + Messages.getString("Message.And") + " ";
            }
            return returnString;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ChoiceItem
    implements ValidationItem {
        private Validatable[] validatables;

        public ChoiceItem(Validatable[] validatables) {
            this.validatables = validatables;
        }

        @Override
        public boolean isPresent(Collection<? extends Validatable> validatables) throws CommandValidationException {
            int selectedCount = this.getSelectedCount(validatables);
            if (selectedCount == 0) {
                return false;
            }
            if (selectedCount == 1) {
                return true;
            }
            throw new CommandValidationException(KeyManagerException.ExceptionReason.TOO_MANY_CHOICES_SELECTED, this.toString());
        }

        private int getSelectedCount(Collection<? extends Validatable> validatables) {
            int count = 0;
            for (Validatable validatable : this.validatables) {
                if (!validatables.contains(validatable)) continue;
                ++count;
            }
            return count;
        }

        public String toString() {
            String returnString = "";
            for (int i = 0; i < this.validatables.length; ++i) {
                returnString = returnString + this.validatables[i].toString();
                if (i == this.validatables.length - 2) {
                    returnString = returnString + " " + Messages.getString("Message.Or") + " ";
                    continue;
                }
                if (i >= this.validatables.length - 1) continue;
                returnString = returnString + ", ";
            }
            return returnString.trim();
        }

        @Override
        public Collection<? extends Validatable> getAllValidatables() {
            return Arrays.asList(this.validatables);
        }

        @Override
        public String getValidValues() {
            return "";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ConstantCondition
    implements ValidationCondition {
        private boolean value;

        public ConstantCondition(boolean value) {
            this.value = value;
        }

        @Override
        public boolean isSatisfied(Collection<? extends Validatable> validatables) {
            return this.value;
        }

        public String toString() {
            return this.value ? "" : Messages.getString("Message.Never");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ItemPresentCondition
    implements ValidationCondition {
        private Validatable item;

        public ItemPresentCondition(Validatable item) {
            this.item = item;
        }

        @Override
        public boolean isSatisfied(Collection<? extends Validatable> validatables) {
            return validatables.contains(this.item);
        }

        public String toString() {
            return MessageFormat.format(Messages.getString("Message.IfPresent"), this.item.toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class NotCondition
    implements ValidationCondition {
        private ValidationCondition condition;

        public NotCondition(ValidationCondition condition) {
            this.condition = condition;
        }

        @Override
        public boolean isSatisfied(Collection<? extends Validatable> validatables) {
            return !this.condition.isSatisfied(validatables);
        }

        public String toString() {
            return Messages.getString("Message.Not") + " (" + this.condition.toString() + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class OptionalValidation
    extends AbstractValidation {
        public OptionalValidation(ValidationItem item, ValidationCondition condition) {
            super(item, condition);
        }

        @Override
        public void validate(Collection<? extends Validatable> validatables) throws CommandValidationException {
            if (this.item.isPresent(validatables) && !this.condition.isSatisfied(validatables)) {
                throw new CommandValidationException(KeyManagerException.ExceptionReason.INVALID_OPTIONAL_PARAMETER, this.toString());
            }
        }

        public String toString() {
            if (this.item.getValidValues().trim().equals("")) {
                return OptionalValidation.formatArguments(this.item.toString(), Messages.getString("Message.Optional") + " " + this.condition.toString());
            }
            return OptionalValidation.formatArguments(this.item.toString(), Messages.getString("Message.Optional") + " " + this.condition.toString() + " " + this.item.getValidValues());
        }

        @Override
        public Collection<? extends Validatable> getAllValidatables() {
            return this.item.getAllValidatables();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class OrCondition
    implements ValidationCondition {
        private ValidationCondition[] conditions;

        public OrCondition(ValidationCondition[] conditions) {
            this.conditions = conditions;
        }

        @Override
        public boolean isSatisfied(Collection<? extends Validatable> validatables) {
            boolean returnValue = false;
            for (ValidationCondition condition : this.conditions) {
                returnValue |= condition.isSatisfied(validatables);
            }
            return returnValue;
        }

        public String toString() {
            String returnString = "";
            for (int i = 0; i < this.conditions.length; ++i) {
                returnString = returnString + "(" + this.conditions[i].toString() + ")";
                if (i >= this.conditions.length - 2) continue;
                returnString = returnString + " " + Messages.getString("Message.Or") + " ";
            }
            return returnString;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ParameterValidator
    implements Validator {
        private List<Validation> validations;

        public ParameterValidator(Validation[] validations) {
            this.validations = Arrays.asList(validations);
        }

        @Override
        public void validate(Collection<? extends Validatable> values) throws CommandValidationException {
            for (Validation validation : this.validations) {
                validation.validate(values);
            }
            List<Validatable> allValidatables = this.getAllValidatables();
            for (Validatable validatable : values) {
                if (allValidatables.contains(validatable)) continue;
                throw new CommandValidationException(KeyManagerException.ExceptionReason.INVALID_PARAMETER_FOR_COMMAND, validatable.toString());
            }
        }

        public String toString() {
            return this.makeUsageString();
        }

        private String makeUsageString() {
            String usageString = "";
            for (Validation validation : this.validations) {
                usageString = usageString + validation.toString() + "\n";
            }
            return usageString.trim();
        }

        private List<Validatable> getAllValidatables() {
            ArrayList<Validatable> allValidatables = new ArrayList<Validatable>();
            for (Validation validation : this.validations) {
                allValidatables.addAll(validation.getAllValidatables());
            }
            return allValidatables;
        }

        public <K extends Validatable> Collection<K> getAllValidatables(Class<K> type) {
            List<Validatable> tempList = this.getAllValidatables();
            ArrayList<Validatable> returnList = new ArrayList<Validatable>();
            for (Validatable validatable : tempList) {
                returnList.add(validatable);
            }
            return returnList;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class RequiredValidation
    extends AbstractValidation {
        public RequiredValidation(ValidationItem item, ValidationCondition condition) {
            super(item, condition);
        }

        @Override
        public void validate(Collection<? extends Validatable> validatables) throws CommandValidationException {
            if (this.condition.isSatisfied(validatables) && !this.item.isPresent(validatables)) {
                throw new CommandValidationException(KeyManagerException.ExceptionReason.REQUIRED_VALUE_NOT_SPECIFIED, this.toString());
            }
        }

        public String toString() {
            if (this.item.getValidValues().trim().equals("")) {
                return RequiredValidation.formatArguments(this.item.toString(), Messages.getString("Message.Required") + " " + this.condition.toString());
            }
            return RequiredValidation.formatArguments(this.item.toString(), Messages.getString("Message.Required") + " " + this.condition.toString() + " " + this.item.getValidValues());
        }

        @Override
        public Collection<? extends Validatable> getAllValidatables() {
            return this.item.getAllValidatables();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SingleItem
    implements ValidationItem {
        private Validatable validatable;

        public SingleItem(Validatable validatable) {
            this.validatable = validatable;
        }

        @Override
        public boolean isPresent(Collection<? extends Validatable> validatables) throws CommandValidationException {
            return validatables.contains(this.validatable);
        }

        public String toString() {
            return this.validatable.toString();
        }

        @Override
        public String getValidValues() {
            return this.validatable.getValidValues();
        }

        @Override
        public Collection<? extends Validatable> getAllValidatables() {
            return Arrays.asList(this.validatable);
        }
    }

    public static interface Validatable {
        public String getValidValues();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Validation {
        public void validate(Collection<? extends Validatable> var1) throws CommandValidationException;

        public Collection<? extends Validatable> getAllValidatables();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ValidationCondition {
        public boolean isSatisfied(Collection<? extends Validatable> var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ValidationItem {
        public boolean isPresent(Collection<? extends Validatable> var1) throws CommandValidationException;

        public String getValidValues();

        public Collection<? extends Validatable> getAllValidatables();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Validator {
        public void validate(Collection<? extends Validatable> var1) throws CommandValidationException;
    }
}

