/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.gui;

import com.ibm.gsk.ikeyman.gui.GUIConstants;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JDialog;
import javax.swing.JMenu;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CenteredDialog
extends JDialog
implements ActionListener,
ContainerListener {
    private GUIConstants.DialogResult result = GUIConstants.DialogResult.Cancel;
    private KeyListener keyListener = new KeyAdapter(){

        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 27) {
                CenteredDialog.this.cancelHandler();
            }
        }
    };

    public CenteredDialog(Frame owner) {
        super(owner);
        this.getContentPane().addContainerListener(this);
    }

    public CenteredDialog(Frame owner, String string) {
        super(owner, string);
        this.getContentPane().addContainerListener(this);
    }

    protected void setDialogResult(GUIConstants.DialogResult result) {
        this.result = result;
    }

    protected GUIConstants.DialogResult getDialogResult() {
        return this.result;
    }

    protected void centerToParent() {
        Dimension diagSize = this.getSize();
        Dimension parentSize = this.getParent().getSize();
        Point parentLocation = this.getParent().getLocation();
        int x = Math.max(0, parentLocation.x + (parentSize.width - diagSize.width) / 2);
        int y = Math.max(0, parentLocation.y + (parentSize.height - diagSize.height) / 2);
        this.setLocation(x, y);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals(GUIConstants.Actions.OK.toString())) {
            this.okHandler();
        } else if (e.getActionCommand().equals(GUIConstants.Actions.Cancel.toString())) {
            this.cancelHandler();
        } else if (e.getActionCommand().equals(GUIConstants.Actions.Reset.toString())) {
            this.resetHandler();
        }
    }

    private void cancelHandler() {
        this.result = GUIConstants.DialogResult.Cancel;
        this.setVisible(false);
    }

    protected abstract void okHandler();

    protected abstract void resetHandler();

    @Override
    public void componentAdded(ContainerEvent e) {
        e.getComponent().addKeyListener(this.keyListener);
    }

    @Override
    public void componentRemoved(ContainerEvent e) {
        e.getComponent().removeKeyListener(this.keyListener);
    }

    @Override
    public void setContentPane(Container contentPane) {
        this.getContentPane().removeContainerListener(this);
        contentPane.addContainerListener(this);
        ArrayList<Component> comps = new ArrayList<Component>();
        CenteredDialog.getAllComponents(contentPane, comps);
        for (Component comp : comps) {
            comp.addKeyListener(this.keyListener);
        }
        super.setContentPane(contentPane);
    }

    private static void getAllComponents(Component component, Collection<Component> comps) {
        block3: {
            block2: {
                comps.add(component);
                if (!(component instanceof JMenu)) break block2;
                for (Component comp : ((JMenu)component).getMenuComponents()) {
                    CenteredDialog.getAllComponents(comp, comps);
                }
                break block3;
            }
            if (!(component instanceof Container)) break block3;
            for (Component comp : ((Container)component).getComponents()) {
                CenteredDialog.getAllComponents(comp, comps);
            }
        }
    }
}

