/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.gui;

import com.ibm.gsk.ikeyman.command.Constants;
import com.ibm.gsk.ikeyman.command.ParameterMap;
import com.ibm.gsk.ikeyman.error.CancelledException;
import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.gui.CenteredDialog;
import com.ibm.gsk.ikeyman.gui.GUIConstants;
import com.ibm.gsk.ikeyman.gui.panels.CheckBoxTree;
import com.ibm.gsk.ikeyman.gui.panels.OKResetCancelButtonPanel;
import com.ibm.gsk.ikeyman.keystore.ext.CACertificates;
import com.ibm.gsk.ikeyman.keystore.ext.KeymanTree;
import com.ibm.gsk.ikeyman.messages.ControlNames;
import com.ibm.gsk.ikeyman.messages.Messages;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Collection;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SignerSelectDialog
extends CenteredDialog {
    private static final String COLLECTION_DELIMITER = ",";
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JScrollPane scrollPane = null;
    private CheckBoxTree checkBoxTree = null;
    private JLabel jLabel = null;
    private OKResetCancelButtonPanel oKResetCancelButtonPanel = null;
    private KeymanTree<String, Boolean> tree;

    public SignerSelectDialog(Frame owner) {
        super(owner);
        this.initialize();
    }

    public SignerSelectDialog(Frame owner, KeymanTree<String, Boolean> tree) {
        super(owner);
        this.tree = tree;
        this.initialize();
    }

    private void initialize() {
        this.setSize(450, 550);
        this.centerToParent();
        this.setModal(true);
        this.setTitle(Messages.getString("GUI.Title.SelectSigners"));
        this.setContentPane(this.getJContentPane());
        this.setName(ControlNames.SignerSelectDialog.toString());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridy = 2;
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.insets = new Insets(0, 0, 5, 0);
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridy = 0;
            gridBagConstraints1.anchor = 17;
            gridBagConstraints1.insets = new Insets(5, 5, 0, 5);
            gridBagConstraints1.gridx = 0;
            this.jLabel = new JLabel();
            this.jLabel.setText(Messages.getString("Label.SignerCertificatesSelect"));
            this.jLabel.setName(ControlNames.SignerSelectDialogSelectSignerLabel.toString());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints.gridy = 1;
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.getScrollPane(), gridBagConstraints);
            this.jContentPane.add((Component)this.jLabel, gridBagConstraints1);
            this.jContentPane.add((Component)this.getButtonPanel(), gridBagConstraints2);
        }
        return this.jContentPane;
    }

    private CheckBoxTree getCheckBoxTree() {
        if (this.checkBoxTree == null) {
            this.checkBoxTree = new CheckBoxTree(this.tree);
            this.checkBoxTree.getAccessibleContext().setAccessibleDescription(Messages.getString("Label.SignerCertificatesSelect"));
        }
        return this.checkBoxTree;
    }

    private JScrollPane getScrollPane() {
        if (this.scrollPane == null) {
            this.scrollPane = new JScrollPane(this.getCheckBoxTree());
        }
        return this.scrollPane;
    }

    private OKResetCancelButtonPanel getButtonPanel() {
        if (this.oKResetCancelButtonPanel == null) {
            this.oKResetCancelButtonPanel = new OKResetCancelButtonPanel(GUIConstants.Actions.OK, GUIConstants.Actions.Cancel, GUIConstants.Actions.Reset);
            this.oKResetCancelButtonPanel.addActionListener(this);
        }
        return this.oKResetCancelButtonPanel;
    }

    @Override
    protected void okHandler() {
        this.setDialogResult(GUIConstants.DialogResult.OK);
        this.setVisible(false);
    }

    @Override
    protected void resetHandler() {
        this.resetFields();
    }

    private void resetFields() {
        this.checkBoxTree.resetFields();
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
        KeymanTree<String, Boolean> tree = new KeymanTree<String, Boolean>(KeymanTree.newNode("Root"));
        KeymanTree.KeymanTreeNode rootNode = (KeymanTree.KeymanTreeNode)tree.getRoot();
        KeymanTree.KeymanTreeNode[] children = new KeymanTree.KeymanTreeNode[5];
        for (int i = 0; i < children.length; ++i) {
            KeymanTree.KeymanTreeNode child = rootNode.addChild(KeymanTree.newNode("child " + i, false));
            for (int j = 0; j < 5; ++j) {
                KeymanTree.KeymanTreeNode childsChild = child.addChild(KeymanTree.newNode("child " + i + "'s child " + j, false));
                childsChild.addChild(KeymanTree.newNode("child " + i + "'s child " + j + "'s child 1", false));
                childsChild.addChild(KeymanTree.newNode("child " + i + "'s child " + j + "'s child 2", false));
                childsChild.addChild(KeymanTree.newNode("child " + i + "'s child " + j + "'s child 3", false));
            }
        }
        SignerSelectDialog dialog = new SignerSelectDialog((Frame)frame, tree);
        dialog.setVisible(true);
        Collection<String> selected = dialog.checkBoxTree.getSelectedLeaves();
        for (String leaf : selected) {
            System.out.println(leaf);
        }
    }

    private ParameterMap getParameters() throws KeyManagerException {
        Collection<String> selected = this.checkBoxTree.getSelectedLeaves();
        if (selected.size() == 0) {
            throw new CancelledException();
        }
        ParameterMap map = new ParameterMap();
        map.put(Constants.Parameter.Label, SignerSelectDialog.collectionToString(selected));
        return map;
    }

    public static String collectionToString(Collection<String> col) {
        if (col.size() == 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        for (String obj : col) {
            buf.append(obj).append(COLLECTION_DELIMITER);
        }
        return buf.toString().substring(0, buf.length() - COLLECTION_DELIMITER.length());
    }

    public static ParameterMap getData(Frame parent) throws KeyManagerException {
        SignerSelectDialog dialog = new SignerSelectDialog(parent, CACertificates.getCertificateTree());
        try {
            dialog.setVisible(true);
            if (dialog.getDialogResult() == GUIConstants.DialogResult.OK) {
                ParameterMap parameterMap = dialog.getParameters();
                return parameterMap;
            }
            throw new CancelledException();
        }
        finally {
            dialog.dispose();
        }
    }
}

