/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.io;

import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.security.pkcs12.PFX;
import com.ibm.security.pkcsutil.PKCSException;
import com.ibm.security.x509.X500Name;
import com.ibm.security.x509.X509CRLImpl;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.cert.CRL;
import java.util.Calendar;
import java.util.Date;

public class BlankPKCS12File {
    private static final String ENCRYPTION_ALGORITHM = "3KeyTripleDES";
    private PFX pfx;

    public BlankPKCS12File() throws KeyManagerException {
        try {
            this.pfx = new PFX();
            long keyId = new Date().getTime();
            X509CRLImpl crl = new X509CRLImpl(new X500Name("cn=dummyCRL"), Calendar.getInstance().getTime(), Calendar.getInstance().getTime());
            KeyPairGenerator generator = KeyPairGenerator.getInstance("RSA");
            generator.initialize(1024);
            KeyPair pair = generator.generateKeyPair();
            PrivateKey privateKey = pair.getPrivate();
            crl.sign(privateKey, "RSA");
            crl.getEncoded();
            this.pfx.addCRL((CRL)crl, "test", String.valueOf(keyId).getBytes());
        }
        catch (Exception e) {
            throw new KeyManagerException(KeyManagerException.ExceptionReason.BLANK_PKCS12_CREATION_ERROR, (Throwable)e, e.getMessage() != null ? e.getMessage() : e.toString());
        }
    }

    public void store(char[] password, String file) throws KeyManagerException {
        try {
            this.pfx.protect(ENCRYPTION_ALGORITHM, password);
            FileOutputStream stream = new FileOutputStream(file);
            this.pfx.encode((OutputStream)stream);
            ((OutputStream)stream).close();
        }
        catch (PKCSException e) {
            if (e.getMessage() != null && e.getMessage().toLowerCase().contains("illegal key size")) {
                throw new KeyManagerException(KeyManagerException.ExceptionReason.RESTRICTED_POLICY_FILES, (Throwable)e);
            }
        }
        catch (Exception e) {
            throw new KeyManagerException(KeyManagerException.ExceptionReason.BLANK_PKCS12_STORE_ERROR, (Throwable)e, e.getMessage() != null ? e.getMessage() : e.toString());
        }
    }
}

