/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.io;

import com.ibm.security.util.DerInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.NoSuchPaddingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecretKeyReader {
    private InputStream is;

    public SecretKeyReader(InputStream is) {
        this.is = is;
    }

    public List<SecretKeyInfo> readKeys() throws IOException, InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException {
        ArrayList<SecretKeyInfo> returnList = new ArrayList<SecretKeyInfo>();
        while (this.is.available() > 0) {
            byte[] lengthBytes = new byte[4];
            this.is.read(lengthBytes);
            byte tag = (byte)this.is.read();
            int length = SecretKeyReader.toIntFromByte4(lengthBytes);
            byte[] data = new byte[length - 1];
            this.is.read(data);
            DerInputStream derData = new DerInputStream(data);
            String alias = derData.getGeneralString();
            String algorithm = derData.getGeneralString();
            byte[] encryptedKey = derData.getOctetString();
            returnList.add(new SecretKeyInfo(alias, algorithm, encryptedKey));
        }
        return returnList;
    }

    private static int toIntFromByte4(byte[] bytes) {
        return bytes[0] << 24 | bytes[1] << 16 | bytes[2] << 8 | bytes[3] & 0xFF;
    }

    public static class SecretKeyInfo {
        public final String alias;
        public final String algorithm;
        public final byte[] encryptedKey;

        public SecretKeyInfo(String alias, String algorithm, byte[] encryptedKey) {
            this.alias = alias;
            this.algorithm = algorithm;
            this.encryptedKey = encryptedKey;
        }
    }
}

