/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.keystore;

import com.ibm.gsk.ikeyman.command.CommandParameters;
import com.ibm.gsk.ikeyman.command.Constants;
import com.ibm.gsk.ikeyman.error.InternalKeyManagerException;
import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.keystore.EntryContainerFactory;
import com.ibm.gsk.ikeyman.keystore.EntryFilterFactory;
import com.ibm.gsk.ikeyman.keystore.EntryMakerFactory;
import com.ibm.gsk.ikeyman.keystore.KeyStoreProxyCreatorFactory;
import com.ibm.gsk.ikeyman.keystore.ProtectionParameterCreatorFactory;
import com.ibm.gsk.ikeyman.keystore.SelectorFactory;
import com.ibm.gsk.ikeyman.keystore.entry.AbstractUnloadableEntry;
import com.ibm.gsk.ikeyman.keystore.entry.CMSCertificateItem;
import com.ibm.gsk.ikeyman.keystore.entry.CMSKeyItem;
import com.ibm.gsk.ikeyman.keystore.entry.CertificateItem;
import com.ibm.gsk.ikeyman.keystore.entry.CertificateKeyItem;
import com.ibm.gsk.ikeyman.keystore.entry.CertificateRequestKeyItem;
import com.ibm.gsk.ikeyman.keystore.entry.Entry;
import com.ibm.gsk.ikeyman.keystore.entry.EntryFactory;
import com.ibm.gsk.ikeyman.keystore.entry.SecretKeyItem;
import com.ibm.gsk.ikeyman.util.ComparatorFactory;
import com.ibm.gsk.ikeyman.util.Debug;
import com.ibm.gsk.ikeyman.util.KeymanUtil;
import com.ibm.gsk.ikeyman.util.TypeDisplayerFactory;
import com.ibm.pkcs11.PKCS11Exception;
import com.ibm.security.x509.Extension;
import com.ibm.security.x509.SubjectKeyIdentifierExtension;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableEntryException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntryBagFactory {
    public static EntryBag<CertificateItem> newKeyStoreCertificateBag(KeyStoreProxyCreatorFactory.KeyStoreProxy keyStore, ProtectionParameterCreatorFactory.ProtectionParameterCreator protectionCreater, String password) throws KeyManagerException {
        return new BasicKeyStoreBag<CertificateItem>(keyStore, EntryFilterFactory.newKeyStoreCertEntryFilter(), protectionCreater, password, EntryMakerFactory.getCertMaker());
    }

    public static EntryBag<CertificateKeyItem> newKeyStoreKeyBag(KeyStoreProxyCreatorFactory.KeyStoreProxy keyStore, ProtectionParameterCreatorFactory.ProtectionParameterCreator protectionCreater, String password) throws KeyManagerException {
        return new KeyStoreKeyBag<CertificateKeyItem>(keyStore, EntryFilterFactory.newKeyStoreKeyEntryFilter(), protectionCreater, password, EntryMakerFactory.getPrivateKeyMaker());
    }

    public static EntryBag<SecretKeyItem> newKeyStoreSecretKeyBag(KeyStoreProxyCreatorFactory.KeyStoreProxy keyStore, ProtectionParameterCreatorFactory.ProtectionParameterCreator protectionCreater, String password) throws KeyManagerException {
        return new KeyStoreKeyBag<SecretKeyItem>(keyStore, EntryFilterFactory.newKeyStoreSecretKeyEntryFilter(), protectionCreater, password, EntryMakerFactory.getSecretKeyMaker());
    }

    public static EntryBag<CMSCertificateItem> newCMSKeyStoreCertificateBag(KeyStoreProxyCreatorFactory.KeyStoreProxy keyStore, ProtectionParameterCreatorFactory.ProtectionParameterCreator protectionCreater, String password) throws KeyManagerException {
        return new BasicKeyStoreBag<CMSCertificateItem>(keyStore, EntryFilterFactory.newKeyStoreCertEntryFilter(), protectionCreater, password, EntryMakerFactory.getCMSCertMaker());
    }

    public static EntryBag<CMSKeyItem> newCMSKeyStoreKeyBag(KeyStoreProxyCreatorFactory.KeyStoreProxy keyStore, ProtectionParameterCreatorFactory.ProtectionParameterCreator protectionCreater, String password) throws KeyManagerException {
        return new BasicKeyStoreBag<CMSKeyItem>(keyStore, EntryFilterFactory.newKeyStoreKeyEntryFilter(), protectionCreater, password, EntryMakerFactory.getCMSKeyMaker());
    }

    public static EntryBag<CertificateItem> newPKCS11CertificateBag(KeyStoreProxyCreatorFactory.KeyStoreProxy p11KeyStore, ProtectionParameterCreatorFactory.ProtectionParameterCreator protectionCreater, TypeDisplayerFactory.TypeDisplayer<Entry> typeDisplayer, String password) throws KeyManagerException {
        return new PKCS11ImplKeyStoreBag<CertificateItem>(p11KeyStore, EntryFilterFactory.newKeyStoreCertEntryFilter(), protectionCreater, typeDisplayer, password, EntryMakerFactory.getExtendedCertMaker());
    }

    public static EntryBag<CertificateKeyItem> newPKCS11KeyBag(KeyStoreProxyCreatorFactory.KeyStoreProxy p11KeyStore, ProtectionParameterCreatorFactory.ProtectionParameterCreator protectionCreater, TypeDisplayerFactory.TypeDisplayer<Entry> typeDisplayer, String password) throws KeyManagerException {
        return new PKCS11ImplKeyStoreBag<CertificateKeyItem>(p11KeyStore, EntryFilterFactory.newPKCS11KeyEntryFilter(), protectionCreater, typeDisplayer, password, EntryMakerFactory.getExtendedPrivateKeyMaker());
    }

    public static EntryBag<SecretKeyItem> newPKCS11SecretKeyBag(KeyStoreProxyCreatorFactory.KeyStoreProxy p11KeyStore, ProtectionParameterCreatorFactory.ProtectionParameterCreator protectionCreater, TypeDisplayerFactory.TypeDisplayer<Entry> typeDisplayer, String password) throws KeyManagerException {
        return new PKCS11ImplKeyStoreBag<SecretKeyItem>(p11KeyStore, EntryFilterFactory.newKeyStoreSecretKeyEntryFilter(), protectionCreater, typeDisplayer, password, EntryMakerFactory.getExtendedSecretKeyMaker());
    }

    public static EntryBag<CertificateRequestKeyItem> newPKCS11CertRequestBag(KeyStoreProxyCreatorFactory.KeyStoreProxy p11KeyStore, String provider, ProtectionParameterCreatorFactory.ProtectionParameterCreator protectionCreater, TypeDisplayerFactory.TypeDisplayer<Entry> typeDisplayer, String password) throws KeyManagerException {
        return new CertRequestAsKeyEntryBag(new PKCS11ImplKeyStoreBag<CertificateKeyItem>(p11KeyStore, EntryFilterFactory.newCertificateRequestEntryFilter(), protectionCreater, typeDisplayer, password, EntryMakerFactory.getExtendedPrivateKeyMaker()), provider);
    }

    public static EntryBag<Entry> newBagCollection(EntryBag<? extends Entry> ... entryBags) {
        return new CompoundEntryBag(SelectorFactory.getEntryBagCollectionSelector(entryBags));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class AbstractEntryContainerBag<T extends Entry>
    implements EntryBag<T> {
        private final EntryContainerFactory.EntryContainer<T> entryContainer;

        public AbstractEntryContainerBag(EntryContainerFactory.EntryContainer<T> entryFile) {
            this.entryContainer = entryFile;
        }

        @Override
        public boolean contains(String label) {
            boolean returnValue = this.entryContainer.contains(label);
            return returnValue;
        }

        @Override
        public Collection<String> getAliases() {
            Collection<String> returnValue = this.entryContainer.getAliases();
            return returnValue;
        }

        @Override
        public T getItem(String label) throws KeyManagerException {
            T returnValue = this.entryContainer.getItem(label);
            return returnValue;
        }

        @Override
        public Collection<T> getItems() throws KeyManagerException {
            Collection<T> returnValue = this.entryContainer.getItems();
            return returnValue;
        }

        @Override
        public boolean needsRefresh() {
            boolean returnValue = this.entryContainer.needsRefresh();
            return returnValue;
        }

        @Override
        public int compare(Entry e1, Entry e2) {
            return this.entryContainer.compare(e1, e2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class AbstractKeyStoreBag<T extends Entry>
    implements EntryBag<T> {
        protected KeyStoreProxyCreatorFactory.KeyStoreProxy keyStore;
        protected EntryFilterFactory.EntryFilter<KeyStore> entryFilter;
        protected Collection<String> aliases;
        protected ProtectionParameterCreatorFactory.ProtectionParameterCreator protectionCreater;
        protected String password;

        public AbstractKeyStoreBag(KeyStoreProxyCreatorFactory.KeyStoreProxy keyStore, EntryFilterFactory.EntryFilter<KeyStore> entryFilter, ProtectionParameterCreatorFactory.ProtectionParameterCreator protectionCreater, String password) throws KeyManagerException {
            this.keyStore = keyStore;
            this.entryFilter = entryFilter;
            this.protectionCreater = protectionCreater;
            this.password = password;
            this.refreshAliases();
        }

        @Override
        public void add(T item) throws KeyManagerException {
            this.setKeyStoreEntry(item.getLabel(), item.toKeyStoreEntry(), this.protectionCreater.getParameter(this.password));
        }

        private void setKeyStoreEntry(String label, KeyStore.Entry entry, KeyStore.ProtectionParameter protParam) throws KeyManagerException {
            try {
                this.keyStore.getKeyStore().setEntry(label, entry, protParam);
                this.keyStore.setHasChanged(true);
                this.refreshAliases();
            }
            catch (KeyStoreException e) {
                String stackTraceString = KeymanUtil.getStackTraceString(e);
                if (stackTraceString.contains("Illegal key size")) {
                    throw new KeyManagerException(KeyManagerException.ExceptionReason.RESTRICTED_POLICY_FILES, (Throwable)e);
                }
                throw new KeyManagerException(KeyManagerException.ExceptionReason.KEY_STORE_ENTRY_SET_ERROR, (Throwable)e, label);
            }
        }

        protected void refreshAliases() throws KeyManagerException {
            try {
                Enumeration<String> allAliases = this.keyStore.getKeyStore().aliases();
                this.aliases = new TreeSet<String>(ComparatorFactory.newCollatedStringComparator());
                while (allAliases.hasMoreElements()) {
                    String alias = allAliases.nextElement();
                    if (!this.entryFilter.isEntry(this.keyStore.getKeyStore(), alias, this.password)) continue;
                    this.aliases.add(alias);
                }
            }
            catch (KeyStoreException e) {
                throw new InternalKeyManagerException(KeyManagerException.ExceptionReason.UNINITIALISED_KEY_STORE, (Throwable)e);
            }
        }

        @Override
        public void delete(String label) throws KeyManagerException {
            try {
                if (!this.contains(label)) {
                    throw new KeyManagerException(KeyManagerException.ExceptionReason.NO_ENTRY_FOR_LABEL, label);
                }
                this.keyStore.getKeyStore().deleteEntry(label);
                this.keyStore.setHasChanged(true);
                this.refreshAliases();
            }
            catch (KeyStoreException e) {
                if (e.getMessage().contains("Uninitialized")) {
                    throw new InternalKeyManagerException(KeyManagerException.ExceptionReason.UNINITIALISED_KEY_STORE, (Throwable)e);
                }
                throw new KeyManagerException(KeyManagerException.ExceptionReason.DELETION_FAILED, (Throwable)e, label);
            }
            catch (PKCS11Exception e) {
                throw new KeyManagerException(KeyManagerException.ExceptionReason.PKCS11_ERROR, (Throwable)e, label, e.getMessage());
            }
        }

        @Override
        public void delete(Entry entry) throws KeyManagerException {
            try {
                this.delete(entry.getLabel());
            }
            catch (KeyManagerException e) {
                if (e.getReason() == KeyManagerException.ExceptionReason.NO_ENTRY_FOR_LABEL) {
                    return;
                }
                throw e;
            }
        }

        @Override
        public boolean contains(String label) {
            boolean returnValue = this.aliases.contains(label);
            return returnValue;
        }

        @Override
        public T getItem(String label) throws KeyManagerException {
            if (this.getAliases().contains(label)) {
                T returnValue = this.makeEntry(label);
                return returnValue;
            }
            throw new KeyManagerException(KeyManagerException.ExceptionReason.NO_ENTRY_FOR_LABEL, label);
        }

        @Override
        public Collection<T> getItems() throws KeyManagerException {
            ArrayList<T> returnVal = new ArrayList<T>();
            for (String alias : this.aliases) {
                returnVal.add(this.getItem(alias));
            }
            return returnVal;
        }

        @Override
        public void refresh() throws KeyManagerException {
            this.refreshAliases();
        }

        @Override
        public Collection<String> getAliases() {
            return this.aliases;
        }

        @Override
        public void changePassword(CommandParameters params) throws KeyManagerException {
            if (params.isParameterPresent(Constants.Parameter.NewPassword)) {
                this.password = params.getNewPassword();
                this.keyStore.setHasChanged(true);
            }
        }

        @Override
        public boolean needsRefresh() {
            boolean returnValue = this.keyStore.needsRefresh();
            return returnValue;
        }

        @Override
        public int compare(Entry e1, Entry e2) {
            return e1.compareTo(e2);
        }

        @Override
        public EntryBag<? extends Entry> getEntryBag(Class<? extends Entry> c) {
            if (this.getSupportedTypes().contains(c)) {
                return this;
            }
            return null;
        }

        protected abstract T makeEntry(String var1) throws KeyManagerException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BasicKeyStoreBag<T extends Entry>
    extends AbstractKeyStoreBag<T> {
        private final EntryMakerFactory.EntryMaker<T> entryMaker;

        public BasicKeyStoreBag(KeyStoreProxyCreatorFactory.KeyStoreProxy keyStore, EntryFilterFactory.EntryFilter<KeyStore> entryFilter, ProtectionParameterCreatorFactory.ProtectionParameterCreator protectionCreater, String password, EntryMakerFactory.EntryMaker<T> entryMaker) throws KeyManagerException {
            super(keyStore, entryFilter, protectionCreater, password);
            this.entryMaker = entryMaker;
        }

        @Override
        protected T makeEntry(String alias) throws KeyManagerException {
            T returnValue = null;
            KeyStore.Entry nullEntry = null;
            try {
                KeyStore.Entry entry = this.keyStore.getKeyStore().getEntry(alias, this.protectionCreater.getParameter(this.password));
                returnValue = this.entryMaker.makeEntry(this.getExactAlias(alias), entry);
                return returnValue;
            }
            catch (KeyStoreException e) {
                Debug.log(e.getMessage(), alias);
                try {
                    returnValue = this.entryMaker.makeEntry(this.getExactAlias(alias), nullEntry);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                String stackTraceString = KeymanUtil.getStackTraceString(e);
                if (stackTraceString.contains("Illegal key size")) {
                    if (returnValue != null && returnValue instanceof AbstractUnloadableEntry) {
                        ((AbstractUnloadableEntry)returnValue).setErr(KeyManagerException.ExceptionReason.RESTRICTED_POLICY_FILES, e, alias);
                    }
                    throw new KeyManagerException(KeyManagerException.ExceptionReason.RESTRICTED_POLICY_FILES, (Throwable)e);
                }
                if (e.getMessage().contains("Couldn't find the record with alias:")) {
                    if (returnValue != null && returnValue instanceof AbstractUnloadableEntry) {
                        ((AbstractUnloadableEntry)returnValue).setErr(KeyManagerException.ExceptionReason.INVALID_ALIAS, e, alias);
                    }
                    throw new KeyManagerException(KeyManagerException.ExceptionReason.INVALID_ALIAS, (Throwable)e);
                }
                if (returnValue != null && returnValue instanceof AbstractUnloadableEntry) {
                    ((AbstractUnloadableEntry)returnValue).setErr(KeyManagerException.ExceptionReason.ENTRY_LOAD_ERROR, e, alias);
                }
                throw new KeyManagerException(KeyManagerException.ExceptionReason.ENTRY_LOAD_ERROR, (Throwable)e, alias);
            }
            catch (UnrecoverableEntryException e) {
                Debug.log(e.getMessage(), alias);
                Certificate cert = null;
                try {
                    cert = this.keyStore.getKeyStore().getCertificate(alias);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    returnValue = this.entryMaker.makeEntry(this.getExactAlias(alias), cert);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                if (returnValue != null && returnValue instanceof AbstractUnloadableEntry) {
                    ((AbstractUnloadableEntry)returnValue).setErr(KeyManagerException.ExceptionReason.UNRECOVERABLE_KEY, e, alias);
                }
                throw new KeyManagerException(KeyManagerException.ExceptionReason.UNRECOVERABLE_KEY, (Throwable)e, alias);
            }
            catch (NoSuchAlgorithmException e) {
                Debug.log(e.getMessage(), alias);
                try {
                    returnValue = this.entryMaker.makeEntry(this.getExactAlias(alias), nullEntry);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                if (returnValue != null && returnValue instanceof AbstractUnloadableEntry) {
                    ((AbstractUnloadableEntry)returnValue).setErr(KeyManagerException.ExceptionReason.NO_SUCH_ALGORITHM, e, e.getMessage());
                }
                throw new KeyManagerException(KeyManagerException.ExceptionReason.NO_SUCH_ALGORITHM, (Throwable)e, e.getMessage());
            }
            catch (Exception e) {
                Debug.log(e.getMessage(), alias);
                try {
                    returnValue = this.entryMaker.makeEntry(this.getExactAlias(alias), nullEntry);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                if (returnValue != null && returnValue instanceof AbstractUnloadableEntry) {
                    ((AbstractUnloadableEntry)returnValue).setErr(KeyManagerException.ExceptionReason.UNRECOVERABLE_KEY, e, alias);
                }
                throw new KeyManagerException(KeyManagerException.ExceptionReason.UNRECOVERABLE_KEY, (Throwable)e, alias);
            }
            return returnValue;
        }

        protected String getExactAlias(String alias) {
            if (this.getAliases() != null) {
                for (String current : this.getAliases()) {
                    if (!alias.equalsIgnoreCase(current)) continue;
                    return current;
                }
            }
            return alias;
        }

        @Override
        public List<Class<? extends Entry>> getSupportedTypes() {
            return this.entryMaker.getSupportedTypes();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CertRequestAsKeyEntryBag
    implements EntryBag<CertificateRequestKeyItem> {
        private static final List<Class<? extends Entry>> supportedTypes = new ArrayList<Class<? extends Entry>>();
        private final EntryBag<CertificateKeyItem> keyBag;
        private final String provider;

        public CertRequestAsKeyEntryBag(EntryBag<CertificateKeyItem> keyBag, String provider) {
            this.keyBag = keyBag;
            this.provider = provider;
        }

        @Override
        public void add(CertificateRequestKeyItem item) throws KeyManagerException {
            X509Certificate cert;
            try {
                byte[] keyidentifier;
                try {
                    keyidentifier = "IkeymanCertificateRequest".getBytes("8859_1");
                }
                catch (UnsupportedEncodingException use) {
                    keyidentifier = "IkeymanCertificateRequest".getBytes();
                }
                SubjectKeyIdentifierExtension ski = new SubjectKeyIdentifierExtension(keyidentifier);
                cert = item.toCertificate((Extension)ski, this.provider);
            }
            catch (IOException e) {
                throw new KeyManagerException(KeyManagerException.ExceptionReason.IO_ERROR, (Throwable)e);
            }
            Certificate[] certchain = new Certificate[]{cert};
            CertificateKeyItem certificateKeyItem = EntryFactory.newKeyItem(item.getLabel(), cert, item.getPrivateKey());
            this.keyBag.add(certificateKeyItem);
        }

        @Override
        public boolean contains(String label) {
            return this.keyBag.contains(label);
        }

        @Override
        public void delete(String label) throws KeyManagerException {
            this.keyBag.delete(label);
        }

        @Override
        public void delete(Entry entry) throws KeyManagerException {
            try {
                this.keyBag.delete(entry.getLabel());
            }
            catch (KeyManagerException e) {
                if (e.getReason() == KeyManagerException.ExceptionReason.NO_ENTRY_FOR_LABEL) {
                    return;
                }
                throw e;
            }
        }

        @Override
        public Collection<String> getAliases() {
            return this.keyBag.getAliases();
        }

        @Override
        public CertificateRequestKeyItem getItem(String label) throws KeyManagerException {
            return ((CertificateKeyItem)this.keyBag.getItem(label)).toCertRequest(null, this.provider);
        }

        @Override
        public Collection<CertificateRequestKeyItem> getItems() throws KeyManagerException {
            ArrayList<CertificateRequestKeyItem> returnVal = new ArrayList<CertificateRequestKeyItem>();
            for (String alias : this.getAliases()) {
                returnVal.add(this.getItem(alias));
            }
            return returnVal;
        }

        @Override
        public List<Class<? extends Entry>> getSupportedTypes() {
            return supportedTypes;
        }

        @Override
        public int compare(Entry e1, Entry e2) {
            return e1.compareTo(e2);
        }

        @Override
        public void refresh() throws KeyManagerException {
            this.keyBag.refresh();
        }

        @Override
        public EntryBag<? extends Entry> getEntryBag(Class<? extends Entry> c) {
            if (supportedTypes.contains(c)) {
                return this;
            }
            return null;
        }

        @Override
        public void changePassword(CommandParameters params) throws KeyManagerException {
            this.keyBag.changePassword(params);
        }

        @Override
        public boolean needsRefresh() {
            return this.keyBag.needsRefresh();
        }

        static {
            supportedTypes.add(CertificateRequestKeyItem.class);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CompoundEntryBag
    implements EntryBag<Entry> {
        private final SelectorFactory.Selector<EntryBag<? extends Entry>> selector;

        public CompoundEntryBag(SelectorFactory.Selector<EntryBag<? extends Entry>> selector) {
            this.selector = selector;
        }

        @Override
        public void add(Entry item) throws KeyManagerException {
            EntryBag<? extends Entry> bag = this.selector.select(item);
            if (bag == null) {
                throw new KeyManagerException(KeyManagerException.ExceptionReason.INVALID_ENTRY_TYPE, item.getClass().toString());
            }
            bag.add(item);
        }

        @Override
        public boolean contains(String label) {
            for (EntryBag<? extends Entry> bag : this.selector.getAll()) {
                if (!bag.contains(label)) continue;
                return true;
            }
            return false;
        }

        @Override
        public void delete(String label) throws KeyManagerException {
            for (EntryBag<? extends Entry> bag : this.selector.getAll()) {
                if (!bag.contains(label)) continue;
                bag.delete(label);
                return;
            }
            throw new KeyManagerException(KeyManagerException.ExceptionReason.NO_ENTRY_FOR_LABEL, label);
        }

        @Override
        public void delete(Entry entry) throws KeyManagerException {
            EntryBag<? extends Entry> bag = this.selector.select(entry);
            if (bag != null) {
                bag.delete(entry);
            }
        }

        @Override
        public Collection<String> getAliases() {
            ArrayList<String> returnList = new ArrayList<String>();
            for (EntryBag<? extends Entry> bag : this.selector.getAll()) {
                returnList.addAll(bag.getAliases());
            }
            return returnList;
        }

        @Override
        public Entry getItem(String label) throws KeyManagerException {
            for (EntryBag<? extends Entry> bag : this.selector.getAll()) {
                if (!bag.contains(label)) continue;
                Object returnValue = bag.getItem(label);
                return returnValue;
            }
            throw new KeyManagerException(KeyManagerException.ExceptionReason.NO_ENTRY_FOR_LABEL, label);
        }

        @Override
        public Collection<Entry> getItems() throws KeyManagerException {
            ArrayList<Entry> returnList = new ArrayList<Entry>();
            for (String alias : this.getAliases()) {
                returnList.add(this.getItem(alias));
            }
            return returnList;
        }

        @Override
        public int compare(Entry e1, Entry e2) {
            int returnValue = this.selector.compare((EntryBag<? extends Entry>)((Object)e1), (EntryBag<? extends Entry>)((Object)e2));
            return returnValue;
        }

        @Override
        public List<Class<? extends Entry>> getSupportedTypes() {
            ArrayList<Class<? extends Entry>> returnList = new ArrayList<Class<? extends Entry>>();
            for (EntryBag<? extends Entry> bag : this.selector.getAll()) {
                returnList.addAll(bag.getSupportedTypes());
            }
            return returnList;
        }

        @Override
        public void refresh() throws KeyManagerException {
            for (EntryBag<? extends Entry> bag : this.selector.getAll()) {
                bag.refresh();
            }
        }

        @Override
        public EntryBag<? extends Entry> getEntryBag(Class<? extends Entry> c) {
            for (EntryBag<? extends Entry> bag : this.selector.getAll()) {
                if (bag.getEntryBag(c) == null) continue;
                return bag;
            }
            return null;
        }

        @Override
        public void changePassword(CommandParameters params) throws KeyManagerException {
            for (EntryBag<? extends Entry> bag : this.selector.getAll()) {
                bag.changePassword(params);
            }
        }

        @Override
        public boolean needsRefresh() {
            for (EntryBag<? extends Entry> bag : this.selector.getAll()) {
                if (!bag.needsRefresh()) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface EntryBag<T extends Entry>
    extends EntryContainerFactory.EntryContainer<T> {
        public void add(T var1) throws KeyManagerException;

        public void delete(String var1) throws KeyManagerException;

        public void delete(Entry var1) throws KeyManagerException;

        public List<Class<? extends Entry>> getSupportedTypes();

        public void refresh() throws KeyManagerException;

        public EntryBag<? extends Entry> getEntryBag(Class<? extends Entry> var1);

        public void changePassword(CommandParameters var1) throws KeyManagerException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class KeyStoreKeyBag<T extends Entry>
    extends BasicKeyStoreBag<T> {
        public KeyStoreKeyBag(KeyStoreProxyCreatorFactory.KeyStoreProxy keyStore, EntryFilterFactory.EntryFilter<KeyStore> entryFilter, ProtectionParameterCreatorFactory.ProtectionParameterCreator protectionCreater, String password, EntryMakerFactory.EntryMaker<T> entryMaker) throws KeyManagerException {
            super(keyStore, entryFilter, protectionCreater, password, entryMaker);
        }

        @Override
        public void changePassword(CommandParameters params) throws KeyManagerException {
            String newPassword = params.getNewPassword();
            String oldPassword = params.getPassword();
            String alias2 = null;
            try {
                Collection<String> aliases = this.getAliases();
                for (String alias2 : aliases) {
                    Certificate[] certChain = this.keyStore.getKeyStore().getCertificateChain(alias2);
                    Key key = this.keyStore.getKeyStore().getKey(alias2, oldPassword.toCharArray());
                    this.keyStore.getKeyStore().setKeyEntry(alias2, key, newPassword.toCharArray(), certChain);
                }
            }
            catch (KeyStoreException e) {
                throw new KeyManagerException(KeyManagerException.ExceptionReason.KEY_STORE_ENTRY_SET_ERROR, (Throwable)e, alias2);
            }
            catch (NoSuchAlgorithmException e) {
                throw new KeyManagerException(KeyManagerException.ExceptionReason.NO_SUCH_ALGORITHM, (Throwable)e, e.getMessage());
            }
            catch (UnrecoverableKeyException e) {
                throw new KeyManagerException(KeyManagerException.ExceptionReason.UNRECOVERABLE_KEY, (Throwable)e, alias2);
            }
            super.changePassword(params);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PKCS11ImplKeyStoreBag<T extends Entry>
    extends AbstractKeyStoreBag<T> {
        private final TypeDisplayerFactory.TypeDisplayer<Entry> typeDisplayer;
        private final EntryMakerFactory.ExtendedEntryMaker<T> entryMaker;

        public PKCS11ImplKeyStoreBag(KeyStoreProxyCreatorFactory.KeyStoreProxy keyStore, EntryFilterFactory.EntryFilter<KeyStore> entryFilter, ProtectionParameterCreatorFactory.ProtectionParameterCreator protectionCreater, TypeDisplayerFactory.TypeDisplayer<Entry> typeDisplayer, String password, EntryMakerFactory.ExtendedEntryMaker<T> entryMaker) throws KeyManagerException {
            super(keyStore, entryFilter, protectionCreater, password);
            this.typeDisplayer = typeDisplayer;
            this.entryMaker = entryMaker;
        }

        @Override
        protected T makeEntry(String alias) throws KeyManagerException {
            KeyStore.Entry entry;
            try {
                entry = this.loadEntry(alias);
            }
            catch (NullPointerException e) {
                try {
                    if (!this.keyStore.getKeyStore().isKeyEntry(alias)) {
                        throw e;
                    }
                    Key key = this.keyStore.getKeyStore().getKey(alias, null);
                    entry = new KeyEntry((PrivateKey)key);
                }
                catch (KeyStoreException e1) {
                    String stackTraceString = KeymanUtil.getStackTraceString(e1);
                    if (stackTraceString.contains("Illegal key size")) {
                        throw new KeyManagerException(KeyManagerException.ExceptionReason.RESTRICTED_POLICY_FILES, (Throwable)e1);
                    }
                    throw new KeyManagerException(KeyManagerException.ExceptionReason.ENTRY_LOAD_ERROR, (Throwable)e1, alias);
                }
                catch (NoSuchAlgorithmException e1) {
                    throw new KeyManagerException(KeyManagerException.ExceptionReason.NO_SUCH_ALGORITHM, (Throwable)e1, e1.getMessage());
                }
                catch (UnrecoverableKeyException e1) {
                    throw new KeyManagerException(KeyManagerException.ExceptionReason.UNRECOVERABLE_KEY, (Throwable)e1, alias);
                }
            }
            T tempEntry = this.makeEntry(alias, entry);
            if (tempEntry == null) {
                return null;
            }
            tempEntry.setDisplayer(this.typeDisplayer);
            return tempEntry;
        }

        private T makeEntry(String alias, KeyStore.Entry entry) throws KeyManagerException {
            String certAlias = this.getCertForAlias(alias);
            KeyStore.Entry certEntry = null;
            if (certAlias != null) {
                certEntry = this.loadEntry(certAlias);
            }
            return this.entryMaker.makeEntry(alias, entry, certEntry);
        }

        private KeyStore.Entry loadEntry(String alias) throws KeyManagerException {
            try {
                return this.keyStore.getKeyStore().getEntry(alias, this.protectionCreater.getParameter(this.password));
            }
            catch (KeyStoreException e) {
                String stackTraceString = KeymanUtil.getStackTraceString(e);
                if (stackTraceString.contains("Illegal key size")) {
                    throw new KeyManagerException(KeyManagerException.ExceptionReason.RESTRICTED_POLICY_FILES, (Throwable)e);
                }
                throw new KeyManagerException(KeyManagerException.ExceptionReason.ENTRY_LOAD_ERROR, (Throwable)e, alias);
            }
            catch (NoSuchAlgorithmException e) {
                throw new KeyManagerException(KeyManagerException.ExceptionReason.NO_SUCH_ALGORITHM, (Throwable)e, e.getMessage());
            }
            catch (UnrecoverableEntryException e) {
                throw new KeyManagerException(KeyManagerException.ExceptionReason.UNRECOVERABLE_ENTRY, (Throwable)e, alias);
            }
        }

        private String getCertForAlias(String alias) throws KeyManagerException {
            ArrayList<String> aliases;
            try {
                aliases = Collections.list(this.keyStore.getKeyStore().aliases());
            }
            catch (KeyStoreException e) {
                return null;
            }
            for (String a : aliases) {
                if (!a.matches(alias + "cert[\\d]+")) continue;
                return a;
            }
            return null;
        }

        @Override
        protected void refreshAliases() throws KeyManagerException {
            try {
                ArrayList<String> allAliases = Collections.list(this.keyStore.getKeyStore().aliases());
                this.aliases = new TreeSet<String>(ComparatorFactory.newCollatedStringComparator());
                for (String alias : allAliases) {
                    String label;
                    if (alias.matches(".+?cert[\\d]+") && allAliases.contains(label = alias.substring(0, alias.lastIndexOf("cert"))) || !this.entryFilter.isEntry(this.keyStore.getKeyStore(), alias, this.password)) continue;
                    this.aliases.add(alias);
                }
            }
            catch (KeyStoreException e) {
                throw new InternalKeyManagerException(KeyManagerException.ExceptionReason.UNINITIALISED_KEY_STORE, (Throwable)e);
            }
        }

        @Override
        public List<Class<? extends Entry>> getSupportedTypes() {
            return this.entryMaker.getSupportedTypes();
        }

        public class KeyEntry
        implements KeyStore.Entry {
            private final PrivateKey key;

            public KeyEntry(PrivateKey key) {
                this.key = key;
            }

            public PrivateKey getPrivateKey() {
                return this.key;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ReadonlyEntryContainerBag<T extends Entry>
    extends AbstractEntryContainerBag<T> {
        private final List<Class<? extends Entry>> supportedTypes = new ArrayList<Class<? extends Entry>>();

        public ReadonlyEntryContainerBag(EntryContainerFactory.EntryContainer<T> entryFile, Class<T> c) {
            super(entryFile);
            this.supportedTypes.add(c);
        }

        @Override
        public void add(T item) throws KeyManagerException {
            throw new UnsupportedOperationException("ReadonlyEntryContainerBag.add");
        }

        @Override
        public void changePassword(CommandParameters params) throws KeyManagerException {
            throw new UnsupportedOperationException("ReadonlyEntryContainerBag.changePassword");
        }

        @Override
        public void delete(String label) throws KeyManagerException {
            throw new UnsupportedOperationException("ReadonlyEntryContainerBag.delete");
        }

        @Override
        public void delete(Entry entry) throws KeyManagerException {
            throw new UnsupportedOperationException("ReadonlyEntryContainerBag.delete");
        }

        @Override
        public List<Class<? extends Entry>> getSupportedTypes() {
            return this.supportedTypes;
        }

        @Override
        public void refresh() throws KeyManagerException {
        }

        @Override
        public EntryBag<? extends Entry> getEntryBag(Class<? extends Entry> c) {
            if (this.getSupportedTypes().contains(c)) {
                return this;
            }
            return null;
        }
    }
}

