/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.fips.provider;

import com.ibm.crypto.fips.provider.AlgorithmStatus;
import com.ibm.crypto.fips.provider.FIPSRuntimeException;
import com.ibm.crypto.fips.provider.RSAPrivateCrtKey;
import com.ibm.crypto.fips.provider.RSAPrivateKey;
import com.ibm.crypto.fips.provider.RSAPublicKey;
import com.ibm.crypto.fips.provider.SelfTest;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import sun.security.action.GetPropertyAction;

public final class RSAKeyFactory
extends KeyFactorySpi
implements AlgorithmStatus {
    public static final int MIN_MODLEN = 512;
    public static final int MAX_MODLEN = 16384;
    public static final int MAX_MODLEN_RESTRICT_EXP = 3072;
    public static final int MAX_RESTRICTED_EXPLEN = 64;
    private static final boolean a;
    private static final String[] z;

    public static void checkKeyLengths(int n2, BigInteger bigInteger, int n3, int n4) throws InvalidKeyException {
        if (n3 > 0 && n2 < n3) {
            throw new InvalidKeyException(z[4] + n3 + z[2]);
        }
        int n5 = Math.min(n4, 16384);
        if (n2 > n5) {
            throw new InvalidKeyException(z[5] + n5 + z[3]);
        }
        if (a && bigInteger != null && n2 > 3072 && bigInteger.bitLength() > 64) {
            throw new InvalidKeyException(z[6]);
        }
    }

    static void a(int n2, BigInteger bigInteger) throws InvalidKeyException {
        RSAKeyFactory.checkKeyLengths(n2 + 7 & 0xFFFFFFF8, bigInteger, 512, Integer.MAX_VALUE);
    }

    @Override
    public boolean isFipsApproved() {
        return true;
    }

    @Override
    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        if (SelfTest.isFipsRunnable()) {
            return this.a(keySpec);
        }
        throw new FIPSRuntimeException();
    }

    protected PublicKey a(KeySpec keySpec) throws InvalidKeySpecException {
        try {
            if (keySpec instanceof RSAPublicKeySpec) {
                RSAPublicKeySpec rSAPublicKeySpec = (RSAPublicKeySpec)keySpec;
                return new RSAPublicKey(rSAPublicKeySpec.getModulus(), rSAPublicKeySpec.getPublicExponent());
            }
            if (keySpec instanceof X509EncodedKeySpec) {
                return new RSAPublicKey(((X509EncodedKeySpec)keySpec).getEncoded());
            }
            throw new InvalidKeySpecException(z[1]);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InvalidKeySpecException(z[0] + invalidKeyException.getMessage());
        }
    }

    @Override
    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        if (SelfTest.isFipsRunnable()) {
            return this.b(keySpec);
        }
        throw new FIPSRuntimeException();
    }

    protected PrivateKey b(KeySpec keySpec) throws InvalidKeySpecException {
        try {
            if (keySpec instanceof PKCS8EncodedKeySpec) {
                try {
                    return new RSAPrivateCrtKey(((PKCS8EncodedKeySpec)keySpec).getEncoded());
                }
                catch (InvalidKeyException invalidKeyException) {
                    return new RSAPrivateKey(((PKCS8EncodedKeySpec)keySpec).getEncoded());
                }
            }
            if (keySpec instanceof RSAPrivateCrtKeySpec) {
                RSAPrivateCrtKeySpec rSAPrivateCrtKeySpec = (RSAPrivateCrtKeySpec)keySpec;
                return new RSAPrivateCrtKey(rSAPrivateCrtKeySpec.getModulus(), rSAPrivateCrtKeySpec.getPrivateExponent(), rSAPrivateCrtKeySpec.getPublicExponent(), rSAPrivateCrtKeySpec.getPrimeP(), rSAPrivateCrtKeySpec.getPrimeQ(), rSAPrivateCrtKeySpec.getPrimeExponentP(), rSAPrivateCrtKeySpec.getPrimeExponentQ(), rSAPrivateCrtKeySpec.getCrtCoefficient());
            }
            if (keySpec instanceof RSAPrivateKeySpec) {
                RSAPrivateKeySpec rSAPrivateKeySpec = (RSAPrivateKeySpec)keySpec;
                return new RSAPrivateKey(rSAPrivateKeySpec.getModulus(), rSAPrivateKeySpec.getPrivateExponent());
            }
            throw new InvalidKeySpecException(z[1]);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InvalidKeySpecException(z[0] + invalidKeyException.getMessage());
        }
    }

    protected KeySpec engineGetKeySpec(Key key, Class clazz) throws InvalidKeySpecException {
        if (SelfTest.isFipsRunnable()) {
            return this.a(key, clazz);
        }
        throw new FIPSRuntimeException();
    }

    protected KeySpec a(Key key, Class clazz) throws InvalidKeySpecException {
        try {
            if (key instanceof java.security.interfaces.RSAPublicKey) {
                Class<?> clazz2 = Class.forName(z[9]);
                Class<?> clazz3 = Class.forName(z[14]);
                if (clazz2.isAssignableFrom(clazz)) {
                    java.security.interfaces.RSAPublicKey rSAPublicKey = (java.security.interfaces.RSAPublicKey)key;
                    return new RSAPublicKeySpec(rSAPublicKey.getModulus(), rSAPublicKey.getPublicExponent());
                }
                if (clazz3.isAssignableFrom(clazz)) {
                    return new X509EncodedKeySpec(key.getEncoded());
                }
                throw new InvalidKeySpecException(z[1]);
            }
            if (key instanceof java.security.interfaces.RSAPrivateCrtKey) {
                Class<?> clazz4 = Class.forName(z[10]);
                Class<?> clazz5 = Class.forName(z[13]);
                if (clazz4.isAssignableFrom(clazz)) {
                    java.security.interfaces.RSAPrivateCrtKey rSAPrivateCrtKey = (java.security.interfaces.RSAPrivateCrtKey)key;
                    return new RSAPrivateCrtKeySpec(rSAPrivateCrtKey.getModulus(), rSAPrivateCrtKey.getPublicExponent(), rSAPrivateCrtKey.getPrivateExponent(), rSAPrivateCrtKey.getPrimeP(), rSAPrivateCrtKey.getPrimeQ(), rSAPrivateCrtKey.getPrimeExponentP(), rSAPrivateCrtKey.getPrimeExponentQ(), rSAPrivateCrtKey.getCrtCoefficient());
                }
                if (clazz5.isAssignableFrom(clazz)) {
                    return new PKCS8EncodedKeySpec(key.getEncoded());
                }
                throw new InvalidKeySpecException(z[1]);
            }
            if (key instanceof java.security.interfaces.RSAPrivateKey) {
                Class<?> clazz6 = Class.forName(z[8]);
                Class<?> clazz7 = Class.forName(z[13]);
                if (clazz6.isAssignableFrom(clazz)) {
                    java.security.interfaces.RSAPrivateKey rSAPrivateKey = (java.security.interfaces.RSAPrivateKey)key;
                    return new RSAPrivateKeySpec(rSAPrivateKey.getModulus(), rSAPrivateKey.getPrivateExponent());
                }
                if (clazz7.isAssignableFrom(clazz)) {
                    return new PKCS8EncodedKeySpec(key.getEncoded());
                }
                throw new InvalidKeySpecException(z[1]);
            }
            throw new InvalidKeySpecException(z[12]);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new InvalidKeySpecException(z[11] + classNotFoundException.getMessage());
        }
    }

    @Override
    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        if (key == null) {
            throw new InvalidKeyException(z[7]);
        }
        if (key instanceof java.security.interfaces.RSAPublicKey || key instanceof java.security.interfaces.RSAPrivateCrtKey || key instanceof java.security.interfaces.RSAPrivateKey) {
            return key;
        }
        throw new InvalidKeyException(z[7]);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[17];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "\u0000'hJg;&yH~(=l\u001a|,0)Ig,*`\\~*(}Sx's)";
        int n3 = -1;
        block24: while (true) {
            char[] cArray;
            block29: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block28: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block28;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block29;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 73;
                                break;
                            }
                            case 1: {
                                n9 = 73;
                                break;
                            }
                            case 2: {
                                n9 = 9;
                                break;
                            }
                            case 3: {
                                n9 = 58;
                                break;
                            }
                            default: {
                                n9 = 23;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "\u0000'hJg;&yH~(=l\u001a|,0)Ig,*`\\~*(}Sx'";
                    n3 = 0;
                    continue block24;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "i+`Ndi%fTp";
                    n3 = 1;
                    continue block24;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "i+`Nd";
                    n3 = 2;
                    continue block24;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "\u001b\u001aH\u001a|,0z\u001az<:}\u001au,ihN7%,hIci";
                    n3 = 3;
                    continue block24;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "\u001b\u001aH\u001a|,0z\u001az<:}\u001au,igU7%&g]r;i}Rv'i";
                    n3 = 4;
                    continue block24;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "\u001b\u001aH\u001ar19fTr'=z\u001at(')Xri'f\u001a{&'n_ei=a[yi\u007f=\u001au =z\u001a7 /)Wx-<eOdi z\u001ap;,hNr;i}Rv'i:\n {ikSc:";
                    n3 = 5;
                    continue block24;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "\u0002,p\u001a`(:)Tb%%";
                    n3 = 6;
                    continue block24;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "#(\u007f[9:,jOe =p\u0014d9,j\u0014E\u001a\bYH~?(}_\\,0ZJr*";
                    n3 = 7;
                    continue block24;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = "#(\u007f[9:,jOe =p\u0014d9,j\u0014E\u001a\bYOu% jqr0\u001ay_t";
                    n3 = 8;
                    continue block24;
                }
                case 8: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 10;
                    string2 = "#(\u007f[9:,jOe =p\u0014d9,j\u0014E\u001a\bYH~?(}_T;=B_n\u001a9lY";
                    n3 = 9;
                    continue block24;
                }
                case 9: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 11;
                    string2 = "\u001c'zOg9&{Nr-ib_ni:y_t /`Yv= fT-i";
                    n3 = 10;
                    continue block24;
                }
                case 10: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 12;
                    string2 = "\u0000'hJg;&yH~(=l\u001a|,0)Nn9,";
                    n3 = 11;
                    continue block24;
                }
                case 11: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 13;
                    string2 = "#(\u007f[9:,jOe =p\u0014d9,j\u0014G\u0002\nZ\u0002R'*f^r-\u0002lCD9,j";
                    n3 = 12;
                    continue block24;
                }
                case 12: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 14;
                    string2 = "#(\u007f[9:,jOe =p\u0014d9,j\u0014O|y0\u007fy*&m_s\u0002,pig,*";
                    n3 = 13;
                    continue block24;
                }
                case 13: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 15;
                    string2 = "=;|_";
                    n3 = 14;
                    continue block24;
                }
                case 14: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 16;
                    string2 = "*&d\u0014~+$'Ye09}U99;fL~-,{\u0014e,:}H~*=[iV\f1yUy,'}";
                    n3 = 15;
                    continue block24;
                }
                case 15: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
        a = z[15].equalsIgnoreCase(AccessController.doPrivileged(new GetPropertyAction(z[16], z[15])));
    }
}

