/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.fips.provider;

import com.ibm.crypto.fips.provider.RSAKeyFactory;
import com.ibm.security.pkcs8.PrivateKeyInfo;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgIdRSA;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidKeyException;

public final class RSAPrivateCrtKey
extends PrivateKeyInfo
implements java.security.interfaces.RSAPrivateCrtKey,
Serializable {
    static final long serialVersionUID = 4979297236007557055L;
    private BigInteger version = BigInteger.ZERO;
    private BigInteger modulus;
    private BigInteger publicExponent;
    private BigInteger privateExponent;
    private BigInteger primeP;
    private BigInteger primeQ;
    private BigInteger primeExponentP;
    private BigInteger primeExponentQ;
    private BigInteger crtCoefficient;
    private static final String[] z;

    public RSAPrivateCrtKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5, BigInteger bigInteger6, BigInteger bigInteger7, BigInteger bigInteger8) throws InvalidKeyException {
        this.algid = new AlgIdRSA();
        byte[] byArray = bigInteger.compareTo(BigInteger.ZERO) == 0 ? null : bigInteger.toByteArray();
        byte[] byArray2 = bigInteger2.compareTo(BigInteger.ZERO) == 0 ? null : bigInteger2.toByteArray();
        byte[] byArray3 = bigInteger3.compareTo(BigInteger.ZERO) == 0 ? null : bigInteger3.toByteArray();
        byte[] byArray4 = bigInteger4.compareTo(BigInteger.ZERO) == 0 ? null : bigInteger4.toByteArray();
        byte[] byArray5 = bigInteger5.compareTo(BigInteger.ZERO) == 0 ? null : bigInteger5.toByteArray();
        byte[] byArray6 = bigInteger6.compareTo(BigInteger.ZERO) == 0 ? null : bigInteger6.toByteArray();
        byte[] byArray7 = bigInteger7.compareTo(BigInteger.ZERO) == 0 ? null : bigInteger7.toByteArray();
        byte[] byArray8 = bigInteger8.compareTo(BigInteger.ZERO) == 0 ? null : bigInteger8.toByteArray();
        byte[][] byArrayArray = new byte[][]{byArray, byArray2, byArray3, byArray4, byArray5, byArray6, byArray7, byArray8};
        try {
            RSAPrivateCrtKey.a(byArrayArray);
        }
        catch (Exception exception) {
            throw new InvalidKeyException(z[1] + exception.getMessage());
        }
        this.modulus = new BigInteger(byArrayArray[0]);
        this.privateExponent = new BigInteger(byArrayArray[1]);
        this.publicExponent = new BigInteger(byArrayArray[2]);
        this.primeP = new BigInteger(byArrayArray[3]);
        this.primeQ = new BigInteger(byArrayArray[4]);
        this.primeExponentP = new BigInteger(byArrayArray[5]);
        this.primeExponentQ = new BigInteger(byArrayArray[6]);
        this.crtCoefficient = new BigInteger(byArrayArray[7]);
        RSAKeyFactory.a(this.modulus.bitLength(), this.publicExponent);
        try {
            DerValue[] derValueArray = new DerValue[]{new DerValue(2, this.version.toByteArray()), new DerValue(2, this.modulus.toByteArray()), new DerValue(2, this.publicExponent.toByteArray()), new DerValue(2, this.privateExponent.toByteArray()), new DerValue(2, this.primeP.toByteArray()), new DerValue(2, this.primeQ.toByteArray()), new DerValue(2, this.primeExponentP.toByteArray()), new DerValue(2, this.primeExponentQ.toByteArray()), new DerValue(2, this.crtCoefficient.toByteArray())};
            DerOutputStream derOutputStream = new DerOutputStream();
            derOutputStream.putSequence(derValueArray);
            this.key = derOutputStream.toByteArray();
            this.encode();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(z[0] + iOException.getMessage());
        }
    }

    public RSAPrivateCrtKey(byte[] byArray) throws InvalidKeyException {
        try {
            this.decode(byArray);
            RSAKeyFactory.a(this.modulus.bitLength(), this.publicExponent);
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(iOException.getMessage());
        }
    }

    @Override
    public BigInteger getModulus() {
        return this.modulus;
    }

    @Override
    public BigInteger getPrivateExponent() {
        return this.privateExponent;
    }

    @Override
    public BigInteger getPublicExponent() {
        return this.publicExponent;
    }

    @Override
    public BigInteger getPrimeP() {
        return this.primeP;
    }

    @Override
    public BigInteger getPrimeQ() {
        return this.primeQ;
    }

    @Override
    public BigInteger getPrimeExponentP() {
        return this.primeExponentP;
    }

    @Override
    public BigInteger getPrimeExponentQ() {
        return this.primeExponentQ;
    }

    @Override
    public BigInteger getCrtCoefficient() {
        return this.crtCoefficient;
    }

    public String toString() {
        return z[11] + this.modulus.toString() + "\n" + z[5] + this.publicExponent.toString() + "\n" + z[4] + this.privateExponent.toString() + "\n" + z[6] + this.primeP.toString() + "\n" + z[9] + this.primeQ.toString() + "\n" + z[8] + this.primeExponentP.toString() + "\n" + z[10] + this.primeExponentQ.toString() + "\n" + z[7] + this.crtCoefficient.toString() + "\n";
    }

    protected void parseKeyBits() throws IOException {
        try {
            DerValue derValue = new DerValue(this.key);
            this.version = derValue.getData().getInteger();
            this.modulus = derValue.getData().getInteger();
            this.publicExponent = derValue.getData().getInteger();
            this.privateExponent = derValue.getData().getInteger();
            this.primeP = derValue.getData().getInteger();
            this.primeQ = derValue.getData().getInteger();
            this.primeExponentP = derValue.getData().getInteger();
            this.primeExponentQ = derValue.getData().getInteger();
            this.crtCoefficient = derValue.getData().getInteger();
            if (derValue.getData().available() != 0) {
                throw new IOException(z[3]);
            }
        }
        catch (Exception exception) {
            throw new IOException(z[2] + exception.getMessage());
        }
    }

    private static void a(byte[][] byArray) {
        int n2;
        BigInteger[] bigIntegerArray = new BigInteger[8];
        for (n2 = 0; n2 < 8; ++n2) {
            if (byArray[n2] == null) continue;
            bigIntegerArray[n2] = new BigInteger(1, byArray[n2]);
        }
        if (bigIntegerArray[3].compareTo(bigIntegerArray[4]) < 0) {
            BigInteger bigInteger = bigIntegerArray[3];
            bigIntegerArray[3] = bigIntegerArray[4];
            bigIntegerArray[4] = bigInteger;
            bigInteger = bigIntegerArray[5];
            bigIntegerArray[5] = bigIntegerArray[6];
            bigIntegerArray[6] = bigInteger;
            bigIntegerArray[7] = null;
        }
        if (bigIntegerArray[7] == null) {
            bigIntegerArray[7] = bigIntegerArray[4].modInverse(bigIntegerArray[3]);
        }
        if (bigIntegerArray[0] == null) {
            bigIntegerArray[0] = bigIntegerArray[3].multiply(bigIntegerArray[4]);
        }
        if (bigIntegerArray[1] == null) {
            bigIntegerArray[1] = bigIntegerArray[2].modInverse(bigIntegerArray[3].subtract(BigInteger.ONE).multiply(bigIntegerArray[4].subtract(BigInteger.ONE)));
        }
        if (bigIntegerArray[5] == null) {
            bigIntegerArray[5] = bigIntegerArray[1].mod(bigIntegerArray[3].subtract(BigInteger.ONE));
        }
        if (bigIntegerArray[6] == null) {
            bigIntegerArray[6] = bigIntegerArray[1].mod(bigIntegerArray[4].subtract(BigInteger.ONE));
        }
        for (n2 = 0; n2 < 8; ++n2) {
            byArray[n2] = bigIntegerArray[n2].toByteArray();
        }
    }

    public void zeroize() {
        this.modulus = BigInteger.ZERO;
        this.publicExponent = BigInteger.ZERO;
        this.privateExponent = BigInteger.ZERO;
        this.primeP = BigInteger.ZERO;
        this.primeQ = BigInteger.ZERO;
        this.primeExponentP = BigInteger.ZERO;
        this.primeExponentQ = BigInteger.ZERO;
        this.crtCoefficient = BigInteger.ZERO;
    }

    protected void finalize() {
        this.zeroize();
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[12];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "\u000b\fc\u001f\u0018H\ry\u0007\\,&DS\u0019\u0006\u0000y\u0017\u0019RC";
        int n3 = -1;
        block19: while (true) {
            char[] cArray;
            block24: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block23: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block23;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block24;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 104;
                                break;
                            }
                            case 1: {
                                n9 = 99;
                                break;
                            }
                            case 2: {
                                n9 = 22;
                                break;
                            }
                            case 3: {
                                n9 = 115;
                                break;
                            }
                            default: {
                                n9 = 124;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "+\fc\u001f\u0018H\ry\u0007\\\u001b\u0006bS.;\"6\u0018\u0019\u0011Y6";
                    n3 = 0;
                    continue block19;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "!\r`\u0012\u0010\u0001\u00076\u0018\u0019\u0011C`\u0012\u0010\u001d\u00066y";
                    n3 = 1;
                    continue block19;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "!\r`\u0012\u0010\u0001\u00076!/)3d\u001a\n\t\u0017s0\u000e\u001c(s\n\\\r\ru\u001c\u0018\u0001\rq_\\\f\u0002b\u0012\\\u0007\u0015s\u0001\u000e\u001d\r";
                    n3 = 2;
                    continue block19;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "\u0018\u0011\u007f\u0005\u001d\u001c\u00066\u0016\u0004\u0018\fx\u0016\u0012\u001cY\u001c";
                    n3 = 3;
                    continue block19;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "\u0018\u0016t\u001f\u0015\u000bCs\u000b\f\u0007\rs\u001d\bRi";
                    n3 = 4;
                    continue block19;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "\u0018\u0011\u007f\u001e\u0019H3\u001c";
                    n3 = 5;
                    continue block19;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "\u000b\u0011bS\u001f\u0007\u0006p\u0015\u0015\u000b\ns\u001d\bb";
                    n3 = 6;
                    continue block19;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "\u0018\u0011\u007f\u001e\u0019H\u0006n\u0003\u0013\u0006\u0006x\u0007\\8i";
                    n3 = 7;
                    continue block19;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = "\u0018\u0011\u007f\u001e\u0019H2\u001c";
                    n3 = 8;
                    continue block19;
                }
                case 8: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 10;
                    string2 = "\u0018\u0011\u007f\u001e\u0019H\u0006n\u0003\u0013\u0006\u0006x\u0007\\9i";
                    n3 = 9;
                    continue block19;
                }
                case 9: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 11;
                    string2 = "!![9?-%_#/H1E2\\8\u0011\u007f\u0005\u001d\u001c\u000660\u000e\u001cC]\u0016\u0005Ri{\u001c\u0018\u001d\u000fc\u0000Fb";
                    n3 = 10;
                    continue block19;
                }
                case 10: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

