/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import com.ibm.oti.util.Msg;
import com.ibm.oti.util.Util;
import com.ibm.oti.vm.ZipStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.zip.ZipConstants;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;

public class ZipFile
implements ZipConstants,
Closeable {
    String fileName;
    Charset charset;
    private boolean useCharset;
    long descriptor = -1L;
    private int size = -1;
    private int mode;
    private Object lock = new ZipFileLock();
    private static final int LEBIT_MASK = 2048;
    public static final int OPEN_READ = 1;
    public static final int OPEN_DELETE = 4;

    public ZipFile(File file) throws ZipException, IOException {
        this(file.getPath());
    }

    public ZipFile(File file, Charset charset) throws ZipException, IOException {
        this(file.getPath(), charset);
    }

    public ZipFile(File file, int mode) throws IOException {
        if (mode == 1 || mode == 5) {
            this.fileName = file.getPath();
            SecurityManager security = System.getSecurityManager();
            if (security != null) {
                security.checkRead(this.fileName);
                if ((mode & 4) != 0) {
                    security.checkDelete(this.fileName);
                }
            }
        } else {
            throw new IllegalArgumentException();
        }
        this.mode = mode;
        this.openZip();
    }

    public ZipFile(File file, int mode, Charset charset) throws IOException {
        if (mode == 1 || mode == 5) {
            this.fileName = file.getPath();
            SecurityManager security = System.getSecurityManager();
            if (security != null) {
                security.checkRead(this.fileName);
                if ((mode & 4) != 0) {
                    security.checkDelete(this.fileName);
                }
            }
            this.mode = mode;
            this.charset = charset;
            if (!charset.name().equals("UTF-8")) {
                this.useCharset = true;
            }
        } else {
            throw new IllegalArgumentException();
        }
        this.openZip();
    }

    public ZipFile(String filename) throws IOException {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkRead(filename);
        }
        this.fileName = filename;
        this.openZip();
    }

    public ZipFile(String filename, Charset charset) throws ZipException, IOException {
        SecurityManager security;
        this.charset = charset;
        if (!charset.name().equals("UTF-8")) {
            this.useCharset = true;
        }
        if ((security = System.getSecurityManager()) != null) {
            security.checkRead(filename);
        }
        this.fileName = filename;
        this.openZip();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openZip() throws IOException {
        int result;
        Object object = this.lock;
        synchronized (object) {
            result = this.openZipImpl(Util.getBytes((String)this.fileName));
        }
        if (result != 0) {
            switch (result) {
                case 1: {
                    throw new ZipException(Msg.getString((String)"K01c3", (Object)this.fileName));
                }
                case 2: {
                    throw new ZipException(Msg.getString((String)"K01c4", (Object)this.fileName));
                }
            }
            throw new OutOfMemoryError();
        }
    }

    protected void finalize() throws IOException {
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.fileName != null) {
            Object object = this.lock;
            synchronized (object) {
                this.closeZipImpl();
            }
            if ((this.mode & 4) != 0) {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        new File(ZipFile.this.fileName).delete();
                        return null;
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration<? extends ZipEntry> entries() {
        Object object = this.lock;
        synchronized (object) {
            return new ZFEnum();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZipEntry getEntry(String entryName) {
        if (entryName != null) {
            ZipEntry entry;
            byte[] encodedEntryName = null;
            if (this.useCharset) {
                encodedEntryName = entryName.getBytes(this.charset);
            }
            Object object = this.lock;
            synchronized (object) {
                entry = this.useCharset ? this.getEntryImpl3(this.descriptor, entryName, encodedEntryName, this.charset) : this.getEntryImpl3(this.descriptor, entryName, null, null);
            }
            return entry;
        }
        throw new NullPointerException();
    }

    public InputStream getInputStream(ZipEntry entry) throws IOException {
        InputStream is = null;
        byte[] encodedEntryName = null;
        if ((entry.flag & 0x800) == 0 && this.charset != null) {
            encodedEntryName = entry.getName().getBytes(this.charset);
        }
        is = ZipStream.getZipStream(this, entry.getName(), encodedEntryName);
        return is;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getComment() throws IllegalStateException {
        String commentString;
        byte[] comments;
        CharBuffer cb = null;
        ByteBuffer bb = null;
        Charset lCharset = this.charset;
        Object object = this.lock;
        synchronized (object) {
            if (this.descriptor == -1L) {
                throw new IllegalStateException(Msg.getString((String)"K00b7"));
            }
            comments = this.getCommentImpl(this.descriptor);
        }
        if (null == comments) {
            return null;
        }
        if (this.charset == null) {
            lCharset = Charset.forName("UTF-8");
        }
        try {
            bb = ByteBuffer.wrap(comments);
            cb = lCharset.newDecoder().decode(bb);
            commentString = cb.toString();
        }
        catch (CharacterCodingException e) {
            throw new IllegalArgumentException(e.toString(), e);
        }
        return commentString;
    }

    public String getName() {
        return this.fileName;
    }

    private native int openZipImpl(byte[] var1);

    private native void closeZipImpl() throws IOException;

    private native byte[] getCommentImpl(long var1);

    private native ZipEntry getEntryImpl3(long var1, String var3, byte[] var4, Charset var5);

    public int size() {
        if (this.size != -1) {
            return this.size;
        }
        this.size = 0;
        Enumeration<? extends ZipEntry> e = this.entries();
        while (e.hasMoreElements()) {
            ++this.size;
            e.nextElement();
        }
        return this.size;
    }

    static native void ntvinit();

    static {
        ZipFile.ntvinit();
    }

    class ZFEnum
    implements Enumeration {
        private long nextEntryPointer;
        private ZipEntry current;

        ZFEnum() {
            this.nextEntryPointer = this.resetZip(ZipFile.this.descriptor);
            this.current = ZipFile.this.useCharset ? this.getNextEntry2(ZipFile.this.descriptor, this.nextEntryPointer, ZipFile.this.charset) : this.getNextEntry2(ZipFile.this.descriptor, this.nextEntryPointer, null);
        }

        private native long resetZip(long var1);

        private native ZipEntry getNextEntry2(long var1, long var3, Charset var5);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasMoreElements() {
            Object object = ZipFile.this.lock;
            synchronized (object) {
                if (ZipFile.this.descriptor == -1L) {
                    throw new IllegalStateException(Msg.getString((String)"K00b7"));
                }
            }
            return this.current != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object nextElement() {
            if (this.current == null) {
                throw new NoSuchElementException();
            }
            ZipEntry ze = this.current;
            Object object = ZipFile.this.lock;
            synchronized (object) {
                if (ZipFile.this.descriptor == -1L) {
                    throw new IllegalStateException(Msg.getString((String)"K00b7"));
                }
                this.current = ZipFile.this.useCharset ? this.getNextEntry2(ZipFile.this.descriptor, this.nextEntryPointer, ZipFile.this.charset) : this.getNextEntry2(ZipFile.this.descriptor, this.nextEntryPointer, null);
            }
            return ze;
        }
    }

    private static class ZipFileLock {
        private ZipFileLock() {
        }
    }
}

