/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.crypto.dsig;

import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.xml.crypto.spi.SignatureEngine;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.ECPublicKey;
import java.security.spec.AlgorithmParameterSpec;

public class SignatureEngineECDSA
implements SignatureEngine {
    private Signature signature;
    private String uri;
    private PublicKey temppk;
    private static boolean allowNegs = true;

    public SignatureEngineECDSA(String u, Provider provider) throws NoSuchAlgorithmException {
        String alg = "SHA2withECDSA";
        if (u.endsWith("sha1")) {
            alg = "SHA1withECDSA";
        } else if (u.endsWith("256")) {
            alg = "SHA2withECDSA";
        } else if (u.endsWith("384")) {
            alg = "SHA384withECDSA";
        } else if (u.endsWith("512")) {
            alg = "SHA512withECDSA";
        } else {
            throw new NoSuchAlgorithmException(u);
        }
        this.signature = provider == null ? Signature.getInstance(alg) : Signature.getInstance(alg, provider);
        this.uri = u;
    }

    public void setParameter(AlgorithmParameterSpec spec) throws InvalidAlgorithmParameterException {
        if (spec != null) {
            throw new InvalidAlgorithmParameterException("This algorithm supports no AlgorithmParameterSpec.");
        }
    }

    public String getURI() {
        return this.uri;
    }

    public void initSign(Key key) throws InvalidKeyException {
        this.signature.initSign((PrivateKey)key);
    }

    public void initVerify(Key key) throws InvalidKeyException {
        this.temppk = (PublicKey)key;
        this.signature.initVerify((PublicKey)key);
    }

    public void update(byte[] data) throws SignatureException {
        this.signature.update(data);
    }

    public void update(byte[] data, int off, int len) throws SignatureException {
        this.signature.update(data, off, len);
    }

    public byte[] sign() throws SignatureException {
        byte[] asn1Wrapped = this.signature.sign();
        try {
            DerInputStream dis = new DerInputStream(asn1Wrapped);
            DerValue[] integers = dis.getSequence(2);
            BigInteger r = integers[0].getInteger();
            BigInteger s = integers[1].getInteger();
            byte[] rB = r.toByteArray();
            byte[] sB = s.toByteArray();
            int rbLen = rB.length;
            int rbStart = 0;
            int sbLen = sB.length;
            int sbStart = 0;
            if (rB[0] == 0) {
                --rbLen;
                ++rbStart;
            }
            if (sB[0] == 0) {
                --sbLen;
                ++sbStart;
            }
            if (Math.abs(rbLen - sbLen) != 0) {
                if (rbLen < sbLen) {
                    byte[] rBnew = new byte[rbLen + Math.abs(rbLen - sbLen)];
                    System.arraycopy(rB, rbStart, rBnew, Math.abs(rbLen - sbLen), rbLen);
                    rB = rBnew;
                    rbStart = 0;
                    rbLen = rBnew.length;
                } else {
                    byte[] sBnew = new byte[sbLen + Math.abs(rbLen - sbLen)];
                    System.arraycopy(sB, sbStart, sBnew, Math.abs(rbLen - sbLen), sbLen);
                    sB = sBnew;
                    sbStart = 0;
                    sbLen = sBnew.length;
                }
            }
            if (rbLen != sbLen) {
                throw new SignatureException("unequal array lengths...rbLen = " + rbLen + ", sbLen = " + sbLen);
            }
            int arrayLen = rbLen + sbLen;
            byte[] ans = new byte[arrayLen];
            System.arraycopy(rB, rbStart, ans, 0, rbLen);
            System.arraycopy(sB, sbStart, ans, rbLen, sbLen);
            return ans;
        }
        catch (Exception e) {
            throw new SignatureException(e);
        }
    }

    public boolean verify(byte[] signature) throws SignatureException {
        try {
            BigInteger s;
            boolean flipOrder = false;
            int len = signature.length >> 1;
            if (len << 1 != signature.length) {
                SignatureException e = new SignatureException("odd length...how to split?");
                throw e;
            }
            byte[] rB = new byte[len];
            byte[] sB = new byte[len];
            System.arraycopy(signature, 0, rB, 0, len);
            System.arraycopy(signature, len, sB, 0, len);
            BigInteger r = allowNegs ? new BigInteger(1, rB) : new BigInteger(rB);
            BigInteger bigInteger = s = allowNegs ? new BigInteger(1, sB) : new BigInteger(sB);
            if (new BigInteger(rB).compareTo(BigInteger.ZERO) <= 0) {
                System.out.println("Negative BigInteger R");
            }
            if (new BigInteger(sB).compareTo(BigInteger.ZERO) <= 0) {
                System.out.println("Negative BigInteger S");
            }
            if (r.compareTo(((ECPublicKey)this.temppk).getParams().getOrder()) >= 0) {
                return false;
            }
            if (s.compareTo(((ECPublicKey)this.temppk).getParams().getOrder()) >= 0) {
                return false;
            }
            DerOutputStream dos = new DerOutputStream(256);
            dos.putInteger(r);
            dos.putInteger(s);
            DerValue result = new DerValue(48, dos.toByteArray());
            return this.signature.verify(result.toByteArray());
        }
        catch (Exception e) {
            throw new SignatureException(e);
        }
    }

    private String hexToPrintable(byte[] bytes, boolean toUpper) {
        String LOWERCHARS = "0123456789abcdef";
        String tempChars = "0123456789abcdef";
        if (toUpper) {
            tempChars = tempChars.toUpperCase();
        }
        char[] hexchars = tempChars.toCharArray();
        StringBuffer sb = new StringBuffer(256);
        int now = -1;
        int end = -1;
        if (bytes != null) {
            now = 0;
            end = bytes.length;
        }
        while (now < end) {
            byte val = bytes[now];
            int temp1 = val >>> 4 & 0xF;
            int temp2 = val & 0xF;
            sb.append(hexchars[temp1]);
            sb.append(hexchars[temp2]);
            ++now;
        }
        return sb.toString();
    }

    private String decimalToString(byte[] bytes, boolean toUpper) {
        String LOWERCHARS = "0123456789";
        String tempChars = "0123456789";
        if (toUpper) {
            tempChars = tempChars.toUpperCase();
        }
        char[] hexchars = tempChars.toCharArray();
        StringBuffer sb = new StringBuffer(256);
        int now = -1;
        int end = -1;
        if (bytes != null) {
            now = 0;
            end = bytes.length;
        }
        while (now < end) {
            byte val = bytes[now];
            int temp1 = val >>> 4 & 0xF;
            int temp2 = val & 0xF;
            sb.append(hexchars[temp1]);
            sb.append(hexchars[temp2]);
            ++now;
        }
        return sb.toString();
    }

    static {
        try {
            String allowNegsS = System.getProperty("MicrosoftAndOracleAreDunderheads");
            if ("false".equalsIgnoreCase(allowNegsS)) {
                allowNegs = false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

