/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.crypto.dsig.dom;

import com.ibm.xml.crypto.dsig.dom.AlgorithmFactory;
import com.ibm.xml.crypto.dsig.dom.Marshalling;
import com.ibm.xml.crypto.dsig.dom.RetrievalMethodImpl;
import com.ibm.xml.crypto.dsig.dom.XMLStructureImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import org.w3c.dom.Node;

class KeyInfoImpl
extends XMLStructureImpl
implements KeyInfo {
    List content;
    private String id;

    KeyInfoImpl(AlgorithmFactory f, List content, String id) {
        super(f);
        if (content == null) {
            throw new NullPointerException("A null List is specified.");
        }
        if (content.size() == 0) {
            throw new IllegalArgumentException("No content");
        }
        this.content = new ArrayList(content.size());
        for (XMLStructure obj : content) {
            this.content.add(obj);
        }
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public List getContent() {
        return Collections.unmodifiableList(this.content);
    }

    public void marshal(XMLStructure parent, XMLCryptoContext context) throws MarshalException {
        DOMStructure domparent = (DOMStructure)parent;
        Node node = domparent.getNode();
        node.appendChild(Marshalling.marshalKeyInfo(this, node, (DOMCryptoContext)context, this.afactory));
    }

    void setSignatureNode(Node n) {
        for (int i = 0; i < this.content.size(); ++i) {
            Object o = this.content.get(i);
            if (!(o instanceof RetrievalMethodImpl)) continue;
            ((RetrievalMethodImpl)o).setSignatureNode(n);
        }
    }
}

