/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.crypto.dsig.dom;

import com.ibm.xml.crypto.dsig.dom.AlgorithmFactory;
import com.ibm.xml.crypto.dsig.dom.DOMUtil;
import com.ibm.xml.crypto.dsig.dom.Marshalling;
import com.ibm.xml.crypto.dsig.dom.NodeSetDataImpl;
import com.ibm.xml.crypto.dsig.dom.TransformContext;
import com.ibm.xml.crypto.dsig.dom.URIDereferencerImpl;
import com.ibm.xml.crypto.dsig.dom.URIReferenceImpl;
import com.ibm.xml.crypto.dsig.dom.transform.BinaryData;
import com.ibm.xml.crypto.dsig.dom.transform.TransformBase;
import com.ibm.xml.crypto.dsig.dom.transform.TransformUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.xml.crypto.Data;
import javax.xml.crypto.NodeSetData;
import javax.xml.crypto.OctetStreamData;
import javax.xml.crypto.URIDereferencer;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.TransformService;
import javax.xml.crypto.dsig.XMLSignContext;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLValidateContext;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import org.w3c.dom.Node;

class ReferenceImpl
extends URIReferenceImpl
implements Reference {
    static String PROP_CACHEREFERENCE = "javax.xml.crypto.dsig.cacheReference";
    private static final int FETCH_BUFFER_SIZE = 1024;
    private DigestMethod digestMethod;
    List transforms;
    private int applied;
    private Data appliedData;
    private String id;
    private byte[] digest;
    private byte[] calculated;
    private boolean cachedResult;
    private Node digestValueNode;
    private Object dereferencedData;
    private byte[] digestInput;

    ReferenceImpl(AlgorithmFactory f, String uri, DigestMethod dm, List applied, Data result, List transforms, String type, String id, byte[] digestValue) {
        super(f, uri, type, true);
        if (dm == null) {
            throw new NullPointerException("DigestMethod is null.");
        }
        this.digestMethod = dm;
        if (!(applied != null && applied.size() != 0 || transforms != null && transforms.size() != 0)) {
            this.transforms = Collections.EMPTY_LIST;
            this.applied = 0;
        } else if (applied != null && applied.size() > 0) {
            if (transforms != null) {
                this.transforms = new ArrayList(applied.size() + transforms.size());
                for (Transform obj : applied) {
                    this.transforms.add(obj);
                }
                for (Transform obj : transforms) {
                    this.transforms.add(obj);
                }
            } else {
                this.transforms = new ArrayList(applied.size());
                for (Transform obj : applied) {
                    this.transforms.add(obj);
                }
            }
            this.applied = applied.size();
        } else {
            this.transforms = new ArrayList(transforms.size());
            for (Transform obj : transforms) {
                this.transforms.add(obj);
            }
            this.applied = 0;
        }
        this.appliedData = null;
        if (result != null) {
            this.appliedData = result;
        }
        if (digestValue != null) {
            this.calculated = new byte[digestValue.length];
            System.arraycopy(digestValue, 0, this.calculated, 0, digestValue.length);
        }
        this.id = id;
        this.digest = null;
        this.digestValueNode = null;
        this.dereferencedData = null;
        this.digestInput = null;
    }

    public DigestMethod getDigestMethod() {
        return this.digestMethod;
    }

    public String getId() {
        return this.id;
    }

    public List getTransforms() {
        return Collections.unmodifiableList(this.transforms);
    }

    void setDigestValue(byte[] value) {
        this.digest = value;
    }

    public boolean isDigested() {
        return this.digest != null;
    }

    void setDigestValueNode(Node node) {
        this.digestValueNode = node;
    }

    public byte[] getDigestValue() {
        if (this.digest == null) {
            return null;
        }
        byte[] ret = new byte[this.digest.length];
        System.arraycopy(this.digest, 0, ret, 0, ret.length);
        return ret;
    }

    public byte[] getCalculatedDigestValue() {
        if (this.calculated == null) {
            return null;
        }
        byte[] ret = new byte[this.calculated.length];
        System.arraycopy(this.calculated, 0, ret, 0, ret.length);
        return ret;
    }

    public Data getDereferencedData() {
        if (this.dereferencedData == null) {
            return null;
        }
        if (this.dereferencedData instanceof byte[]) {
            ByteArrayInputStream is = new ByteArrayInputStream((byte[])this.dereferencedData);
            return new OctetStreamData(is);
        }
        return new NodeSetDataImpl(((List)this.dereferencedData).iterator());
    }

    public InputStream getDigestInputStream() {
        if (this.digestInput == null) {
            return null;
        }
        return new ByteArrayInputStream(this.digestInput);
    }

    void sign(XMLSignContext scontext) throws XMLSignatureException {
        if (scontext == null) {
            throw new NullPointerException("Null context");
        }
        if (this.digestValueNode == null) {
            throw new XMLSignatureException("Internal Error: <ds:DigestValue> node is not registered.");
        }
        if (this.digestValueNode == null) {
            throw new XMLSignatureException("Internal Error: <ds:DigestValue> element is not registered.");
        }
        DOMUtil.removeAllChildren(this.digestValueNode);
        this.digest = this.calculated != null ? this.calculated : this.calculateDigestValue(scontext);
        Marshalling.insertBase64Binary(this.digestValueNode, this.digest);
    }

    public boolean validate(XMLValidateContext vcontext) throws XMLSignatureException {
        if (vcontext == null) {
            throw new NullPointerException("Null context");
        }
        DOMValidateContext dvcontext = (DOMValidateContext)vcontext;
        if (this.digest == null) {
            throw new XMLSignatureException("This Reference has no DigestValue.");
        }
        if (this.calculated != null) {
            return this.cachedResult;
        }
        this.calculated = this.calculateDigestValue(vcontext);
        this.cachedResult = MessageDigest.isEqual(this.calculated, this.digest);
        return this.cachedResult;
    }

    private byte[] calculateDigestValue(XMLCryptoContext context) throws XMLSignatureException {
        byte[] digest;
        Data data;
        URIDereferencer ud;
        boolean cacheReference = false;
        boolean checkEmptyReference = false;
        Boolean property = (Boolean)context.getProperty(PROP_CACHEREFERENCE);
        if (property != null && property.booleanValue()) {
            cacheReference = true;
        }
        if ((property = (Boolean)context.getProperty("com.ibm.xml.crypto.dsig.checkEmptyReference")) != null && property.booleanValue()) {
            checkEmptyReference = true;
        }
        if ((ud = context.getURIDereferencer()) == null) {
            ud = URIDereferencerImpl.getInstance();
        }
        TransformContext tcontext = new TransformContext(this.afactory, this.transforms);
        context.put(TransformContext.class, tcontext);
        try {
            if (this.appliedData != null) {
                data = this.appliedData;
            } else {
                data = ud.dereference(this, context);
                if (cacheReference) {
                    if (data instanceof OctetStreamData) {
                        InputStream is = ((OctetStreamData)data).getOctetStream();
                        this.dereferencedData = ReferenceImpl.fetchStream(is);
                        is.close();
                        data = new BinaryData((byte[])this.dereferencedData);
                    } else {
                        NodeSetData nodeset = (NodeSetData)data;
                        Iterator iter = nodeset.iterator();
                        ArrayList nodelist = new ArrayList();
                        while (iter.hasNext()) {
                            nodelist.add(iter.next());
                        }
                        data = new NodeSetDataImpl(new TransformUtil.ListIterator(nodelist));
                        this.dereferencedData = Collections.unmodifiableList(nodelist);
                    }
                }
            }
            for (int i = this.applied; i < this.transforms.size(); ++i) {
                TransformBase tr = (TransformBase)this.transforms.get(i);
                data = tr.transform(data, context);
            }
            if (!(data instanceof OctetStreamData)) {
                TransformService tr = TransformService.getInstance("http://www.w3.org/TR/2001/REC-xml-c14n-20010315", "DOM");
                tr.init(null);
                data = tr.transform(data, context);
            }
        }
        catch (Exception e) {
            throw new XMLSignatureException(e);
        }
        finally {
            tcontext.mightCleanTree();
            context.put(TransformContext.class, null);
        }
        MessageDigest digester = null;
        InputStream is = null;
        int total = 0;
        try {
            digester = this.afactory.getMessageDigest(this.digestMethod.getAlgorithm(), this.digestMethod.getParameterSpec());
            digester.reset();
            this.digestInput = null;
            if (data instanceof BinaryData) {
                this.digestInput = ((BinaryData)data).getData();
                total = this.digestInput.length;
                digest = digester.digest(this.digestInput);
            } else if (cacheReference) {
                is = ((OctetStreamData)data).getOctetStream();
                this.digestInput = ReferenceImpl.fetchStream(is);
                total = this.digestInput.length;
                digest = digester.digest(this.digestInput);
            } else {
                int readLength;
                is = ((OctetStreamData)data).getOctetStream();
                byte[] buffer = new byte[1024];
                while ((readLength = is.read(buffer)) != -1) {
                    digester.update(buffer, 0, readLength);
                    total += readLength;
                }
                digest = digester.digest();
            }
        }
        catch (GeneralSecurityException gse) {
            throw new XMLSignatureException(gse);
        }
        catch (IOException ioe) {
            throw new XMLSignatureException(ioe);
        }
        finally {
            if (digester != null) {
                this.afactory.releaseMessageDigest(this.digestMethod.getAlgorithm(), digester);
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ioe) {}
            }
        }
        if (checkEmptyReference && total <= 0) {
            throw new XMLSignatureException("Transformed data is empty.");
        }
        return digest;
    }

    private static byte[] fetchStream(InputStream is) throws IOException {
        int readLength;
        byte[] buffer = new byte[1024];
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        while ((readLength = is.read(buffer)) != -1) {
            baos.write(buffer, 0, readLength);
        }
        baos.close();
        return baos.toByteArray();
    }
}

