/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.crypto.dsig.dom;

import com.ibm.xml.crypto.dsig.dom.AlgorithmFactory;
import com.ibm.xml.crypto.dsig.dom.TransformContext;
import com.ibm.xml.crypto.dsig.dom.URIDereferencerImpl;
import com.ibm.xml.crypto.dsig.dom.URIReferenceImpl;
import com.ibm.xml.crypto.dsig.dom.transform.TransformBase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.xml.crypto.Data;
import javax.xml.crypto.OctetStreamData;
import javax.xml.crypto.URIDereferencer;
import javax.xml.crypto.URIReferenceException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.TransformService;
import javax.xml.crypto.dsig.keyinfo.RetrievalMethod;

class RetrievalMethodImpl
extends URIReferenceImpl
implements RetrievalMethod {
    List transforms;

    RetrievalMethodImpl(AlgorithmFactory f, String uri, String type, List transforms) {
        super(f, uri, type);
        if (transforms == null || transforms.size() == 0) {
            this.transforms = null;
        } else {
            Iterator iter = transforms.iterator();
            this.transforms = new ArrayList(transforms.size());
            while (iter.hasNext()) {
                Transform obj = (Transform)iter.next();
                this.transforms.add(obj);
            }
        }
    }

    public List getTransforms() {
        return this.transforms == null ? Collections.EMPTY_LIST : Collections.unmodifiableList(this.transforms);
    }

    public Data dereference(XMLCryptoContext context) throws URIReferenceException {
        URIDereferencer ud = context.getURIDereferencer();
        if (ud == null) {
            ud = URIDereferencerImpl.getInstance();
        }
        TransformContext tcontext = new TransformContext(this.afactory, this.transforms);
        context.put(TransformContext.class, tcontext);
        Data data = ud.dereference(this, context);
        try {
            if (this.transforms != null && this.transforms.size() > 0) {
                for (int i = 0; i < this.transforms.size(); ++i) {
                    TransformBase tr = (TransformBase)this.transforms.get(i);
                    data = tr.transform(data, context);
                }
            }
            if (!(data instanceof OctetStreamData)) {
                TransformService tr = TransformService.getInstance("http://www.w3.org/TR/2001/REC-xml-c14n-20010315", "DOM");
                tr.init(null);
                data = tr.transform(data, context);
            }
        }
        catch (Exception e) {
            throw new URIReferenceException(e);
        }
        finally {
            tcontext.mightCleanTree();
            context.put(TransformContext.class, null);
        }
        return data;
    }
}

