/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.crypto.dsig.dom.transform;

import com.ibm.xml.crypto.dsig.Constants;
import com.ibm.xml.crypto.dsig.dom.DOMUtil;
import com.ibm.xml.crypto.dsig.dom.Marshalling;
import com.ibm.xml.crypto.dsig.dom.NodeSetDataImpl;
import com.ibm.xml.crypto.dsig.dom.Unmarshalling;
import com.ibm.xml.crypto.dsig.dom.transform.TransformBase;
import com.ibm.xml.crypto.dsig.dom.transform.TransformUtil;
import com.ibm.xml.crypto.dsig.dom.transform.XPathUtil;
import java.lang.reflect.Method;
import java.security.InvalidAlgorithmParameterException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.crypto.Data;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.NodeSetData;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.TransformException;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.crypto.dsig.spec.XPathFilter2ParameterSpec;
import javax.xml.crypto.dsig.spec.XPathType;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xml.utils.PrefixResolverDefault;
import org.apache.xpath.Expression;
import org.apache.xpath.XPath;
import org.apache.xpath.XPathContext;
import org.apache.xpath.compiler.FunctionTable;
import org.apache.xpath.objects.XObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;

public class XPath2Transformer
extends TransformBase
implements Constants {
    private static FunctionTable m_functionTable = null;

    public void init(TransformParameterSpec spec) throws InvalidAlgorithmParameterException {
        if (spec == null || !(spec instanceof XPathFilter2ParameterSpec)) {
            throw new InvalidAlgorithmParameterException("Need an XPathFilter2ParameterSpec instance");
        }
        this.spec = spec;
        XPathFilter2ParameterSpec xspec = (XPathFilter2ParameterSpec)this.spec;
        if (xspec.getXPathList().size() <= 0) {
            throw new InvalidAlgorithmParameterException("XPathFilter2ParameterSpec must have one or more XPath.");
        }
    }

    public void marshalParams(XMLStructure parent, XMLCryptoContext xcontext) throws MarshalException {
        if (parent == null) {
            throw new NullPointerException("XMLStructure must not be null.");
        }
        Element el = (Element)((DOMStructure)parent).getNode();
        if (this.spec == null) {
            throw new MarshalException("Invalid state: no param");
        }
        XPathFilter2ParameterSpec xspec = (XPathFilter2ParameterSpec)this.spec;
        Iterator<XPathType> iter = xspec.getXPathList().iterator();
        while (iter.hasNext()) {
            Node xpathElement = this.marshalXPath2((DOMCryptoContext)xcontext, el.getOwnerDocument(), iter.next());
            el.appendChild(xpathElement);
        }
    }

    private Node marshalXPath2(DOMCryptoContext dcontext, Document factory, XPathType xpath) throws MarshalException {
        String strFilter;
        Element el;
        Map<String, String> map = xpath.getNamespaceMap();
        if (map == null) {
            el = Marshalling.createElement(dcontext, factory, "http://www.w3.org/2002/06/xmldsig-filter2", "XPath", true);
        } else {
            String prefix2 = TransformUtil.getAvailablePrefix(dcontext, "http://www.w3.org/2002/06/xmldsig-filter2", "xf", map);
            String qname = prefix2.length() == 0 ? "XPath" : prefix2 + ":" + "XPath";
            el = factory.createElementNS("http://www.w3.org/2002/06/xmldsig-filter2", qname);
            qname = prefix2.length() == 0 ? "xmlns" : "xmlns:" + prefix2;
            el.setAttributeNS("http://www.w3.org/2000/xmlns/", qname, "http://www.w3.org/2002/06/xmldsig-filter2");
            for (String prefix2 : map.keySet()) {
                qname = prefix2.length() == 0 ? "xmlns" : "xmlns:" + prefix2;
                el.setAttributeNS("http://www.w3.org/2000/xmlns/", qname, map.get(prefix2));
            }
        }
        XPathType.Filter filter = xpath.getFilter();
        if (XPathType.Filter.INTERSECT.equals(filter)) {
            strFilter = "intersect";
        } else if (XPathType.Filter.SUBTRACT.equals(filter)) {
            strFilter = "subtract";
        } else if (XPathType.Filter.UNION.equals(filter)) {
            strFilter = "union";
        } else {
            throw new MarshalException("Internal Error: Unknown filter type: " + filter);
        }
        el.setAttributeNS(null, "Filter", strFilter);
        el.appendChild(factory.createTextNode(xpath.getExpression()));
        return el;
    }

    public void init(XMLStructure parent, XMLCryptoContext xcontext) throws InvalidAlgorithmParameterException {
        if (parent == null) {
            throw new NullPointerException("XMLStructure must not be null.");
        }
        LinkedList<XPathType> xpathList = null;
        LinkedList<Node> xpathElements = null;
        Element node = (Element)((DOMStructure)parent).getNode();
        try {
            if (Unmarshalling.confirmEmpty(node)) {
                throw new InvalidAlgorithmParameterException("XPath2 Transform must have one  or more <xf:XPath> elements.");
            }
            Node child = DOMUtil.getFirstChild2(node);
            while (child != null) {
                if (!Unmarshalling.isIgnorableNode(child)) {
                    XPathType.Filter filter;
                    if (child.getNodeType() != 1 || !"http://www.w3.org/2002/06/xmldsig-filter2".equals(child.getNamespaceURI()) || !"XPath".equals(child.getLocalName())) {
                        throw new InvalidAlgorithmParameterException("XPath2 transform does not support specified node: " + child.getNodeName());
                    }
                    String strFilter = ((Element)child).getAttribute("Filter");
                    if ("intersect".equals(strFilter)) {
                        filter = XPathType.Filter.INTERSECT;
                    } else if ("subtract".equals(strFilter)) {
                        filter = XPathType.Filter.SUBTRACT;
                    } else if ("union".equals(strFilter)) {
                        filter = XPathType.Filter.UNION;
                    } else {
                        throw new InvalidAlgorithmParameterException("XPath2 transform does not support the specified filter type: " + strFilter);
                    }
                    XPathType xpath = new XPathType(Unmarshalling.getStringValue(child), filter, TransformUtil.makePrefixMap(child));
                    if (xpathList == null) {
                        xpathList = new LinkedList<XPathType>();
                    }
                    xpathList.add(xpath);
                    if (xpathElements == null) {
                        xpathElements = new LinkedList<Node>();
                    }
                    xpathElements.add(child);
                }
                child = DOMUtil.getNextSibling2(child);
            }
        }
        catch (MarshalException me) {
            throw new InvalidAlgorithmParameterException(me.getMessage());
        }
        XPathFilter2ParameterSpec spec = new XPathFilter2ParameterSpec(xpathList);
        this.init(spec);
    }

    public Data transform(Data in, XMLCryptoContext xcontext) throws TransformException {
        NodeSetData nodeSet;
        if (in == null) {
            throw new NullPointerException("The Data parameter is null.");
        }
        try {
            nodeSet = this.toNodeSet(in, xcontext);
        }
        catch (Exception ex) {
            throw new TransformException(ex);
        }
        Iterator iter = nodeSet.iterator();
        if (!iter.hasNext()) {
            return new NodeSetDataImpl(iter);
        }
        Node input = (Node)iter.next();
        Document doc = input instanceof Document ? (Document)input : input.getOwnerDocument();
        XPathFilter2ParameterSpec xp2spec = (XPathFilter2ParameterSpec)this.spec;
        List<XPathType> xpaths = xp2spec.getXPathList();
        int xpathSize = xpaths.size();
        List[] iterators = new List[xpathSize + 1];
        XPathType.Filter[] filters = new XPathType.Filter[xpathSize + 1];
        iterators[0] = Collections.singletonList(doc);
        filters[0] = XPathType.Filter.UNION;
        Iterator<XPathType> xiter = xpaths.iterator();
        int i = 1;
        Element hereNode = DOMUtil.getFirstChildElement(this.node);
        while (xiter.hasNext()) {
            XPathType x = xiter.next();
            iterators[i] = XPath2Transformer.eval(x, hereNode, doc, xcontext);
            filters[i] = x.getFilter();
            ++i;
            hereNode = DOMUtil.getNextElement(hereNode);
        }
        LinkedList<Node> output = new LinkedList<Node>();
        while (true) {
            for (int j = 0; j < filters.length; ++j) {
                if (filters[j] != XPathType.Filter.UNION || !XPath2Transformer.contain(iterators[j], input)) continue;
                boolean z = true;
                for (int k = j + 1; k < filters.length; ++k) {
                    if (filters[k].equals(XPathType.Filter.UNION)) continue;
                    if (filters[k].equals(XPathType.Filter.INTERSECT)) {
                        if (XPath2Transformer.contain(iterators[k], input)) continue;
                        z = false;
                        break;
                    }
                    if (!filters[k].equals(XPathType.Filter.SUBTRACT) || !XPath2Transformer.contain(iterators[k], input)) continue;
                    z = false;
                    break;
                }
                if (!z) continue;
                output.add(input);
                break;
            }
            if (!iter.hasNext()) break;
            input = (Node)iter.next();
        }
        return new NodeSetDataImpl(new TransformUtil.ListIterator(output));
    }

    private static boolean contain(List list, Node n) {
        for (Node m : list) {
            if (m != n && !TransformUtil.isAncestorOrSelf(n, m)) continue;
            return true;
        }
        return false;
    }

    private static List eval(XPathType xp2, Node xpathNode, Document start, XMLCryptoContext xccontext) throws TransformException {
        Node n;
        NodeIterator iter;
        XPathContext xcontext = XPathUtil.createContext(xpathNode, (DOMCryptoContext)xccontext);
        Map<String, String> nscontext = xp2.getNamespaceMap();
        XPathUtil.MapPrefixResolver presolver = nscontext.size() > 0 ? new XPathUtil.MapPrefixResolver(nscontext) : new PrefixResolverDefault(xpathNode);
        try {
            XPath xpath = new XPath(xp2.getExpression(), null, (PrefixResolver)presolver, 0, null, m_functionTable);
            XObject xobj = xpath.execute(xcontext, (Node)start, (PrefixResolver)presolver);
            if (xobj.getType() != 4) {
                throw new XMLSignatureException("The result of xpath evaluation for '" + xp2.getExpression() + "' is not a nodeset: " + xobj.getTypeString());
            }
            iter = xobj.nodeset();
        }
        catch (Exception e) {
            throw new TransformException(e);
        }
        ArrayList<Node> result = new ArrayList<Node>();
        while ((n = iter.nextNode()) != null) {
            result.add(n);
        }
        return result;
    }

    private static void fixupFunctionTable() {
        Method installFunction;
        Class[] args;
        boolean installed = false;
        try {
            args = new Class[]{String.class, Expression.class};
            installFunction = FunctionTable.class.getMethod("installFunction", args);
            int modifier = installFunction.getModifiers();
            if ((modifier & 8) != 0) {
                Object[] params = new Object[]{"here", new XPathUtil.FuncHere()};
                installFunction.invoke(null, params);
                installed = true;
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (!installed) {
            try {
                m_functionTable = new FunctionTable();
                args = new Class[]{String.class, Class.class};
                installFunction = FunctionTable.class.getMethod("installFunction", args);
                Object[] params = new Object[]{"here", XPathUtil.FuncHere.class};
                installFunction.invoke((Object)m_functionTable, params);
                installed = true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    static {
        XPath2Transformer.fixupFunctionTable();
    }
}

