/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xslt.translator;

import com.ibm.xtq.Constants;
import com.ibm.xtq.ast.nodes.ApplyTemplates;
import com.ibm.xtq.ast.nodes.CallTemplate;
import com.ibm.xtq.ast.nodes.Choose;
import com.ibm.xtq.ast.nodes.CompAttrConstructor;
import com.ibm.xtq.ast.nodes.CompElemConstructor;
import com.ibm.xtq.ast.nodes.Copy;
import com.ibm.xtq.ast.nodes.CopyOf;
import com.ibm.xtq.ast.nodes.DirAttributeConstructor;
import com.ibm.xtq.ast.nodes.DirCommentConstructor;
import com.ibm.xtq.ast.nodes.DirElemConstructor;
import com.ibm.xtq.ast.nodes.DirPIConstructor;
import com.ibm.xtq.ast.nodes.Expr;
import com.ibm.xtq.ast.nodes.ForEach;
import com.ibm.xtq.ast.nodes.If;
import com.ibm.xtq.ast.nodes.Node;
import com.ibm.xtq.ast.nodes.Number;
import com.ibm.xtq.ast.nodes.OperatorExpr;
import com.ibm.xtq.ast.nodes.Otherwise;
import com.ibm.xtq.ast.nodes.Param;
import com.ibm.xtq.ast.nodes.Template;
import com.ibm.xtq.ast.nodes.Text;
import com.ibm.xtq.ast.nodes.UseAttributeSets;
import com.ibm.xtq.ast.nodes.ValueOf;
import com.ibm.xtq.ast.nodes.VariableBase;
import com.ibm.xtq.ast.nodes.VariableRef;
import com.ibm.xtq.ast.nodes.When;
import com.ibm.xtq.ast.nodes.WithParam;
import com.ibm.xtq.ast.nodes.XTQProgram;
import com.ibm.xtq.xslt.res.ErrorMsg;
import com.ibm.xtq.xslt.translator.ASTDecorator;
import com.ibm.xtq.xslt.translator.ASTDecorator1;
import com.ibm.xtq.xslt.translator.XSLTCHelper;
import com.ibm.xtq.xslt.typechecker.v1.types.Type;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.List;
import org.apache.xml.serializer.ElemDesc;
import org.apache.xml.serializer.ToHTMLStream;
import org.apache.xml.serializer.ToXHTMLStream;

public class TranslatorHelper
implements Constants {
    public static ElemDesc getElemDesc(DirElemConstructor dirElemConstructor) {
        ElemDesc elemDesc = null;
        int n = dirElemConstructor.getXTQProgram().getOutputMethod();
        switch (n) {
            case 2: {
                elemDesc = ToHTMLStream.getElemDesc(dirElemConstructor.getQName());
                break;
            }
            case 4: {
                elemDesc = ToXHTMLStream.getElemDesc(dirElemConstructor.getQName());
            }
        }
        return elemDesc;
    }

    public static boolean isTopLevelRTFNode(Expr expr) {
        Expr expr2 = (Expr)expr.jjtGetParent();
        if (expr2 == null) {
            return false;
        }
        int n = expr2.getId();
        return n == 217 || n == 34 || n == 29;
    }

    private static boolean isSimpleRTF(Expr expr) {
        int n = expr.jjtGetNumChildren();
        for (int i = 0; i < n; ++i) {
            Expr expr2 = (Expr)expr.jjtGetChild(i);
            if (TranslatorHelper.isTextElement(expr2, false)) continue;
            return false;
        }
        return true;
    }

    private static boolean isAdaptiveRTF(Expr expr) {
        int n = expr.jjtGetNumChildren();
        for (int i = 0; i < n; ++i) {
            Expr expr2 = (Expr)expr.jjtGetChild(i);
            if (TranslatorHelper.isTextElement(expr2, true)) continue;
            return false;
        }
        return true;
    }

    private static boolean isTextElement(Expr expr, boolean bl) {
        if (expr instanceof ValueOf || expr instanceof Number || expr instanceof Text) {
            return true;
        }
        if (expr instanceof If) {
            return bl ? TranslatorHelper.isAdaptiveRTF(expr) : TranslatorHelper.isSimpleRTF(expr);
        }
        if (expr instanceof Choose) {
            int n = expr.jjtGetNumChildren();
            for (int i = 0; i < n; ++i) {
                Expr expr2 = (Expr)expr.jjtGetChild(i);
                if (expr2 instanceof Text || (expr2 instanceof When || expr2 instanceof Otherwise) && (bl && TranslatorHelper.isAdaptiveRTF(expr2) || !bl && TranslatorHelper.isSimpleRTF(expr2))) continue;
                return false;
            }
            return true;
        }
        return bl && (expr instanceof CallTemplate || expr instanceof ApplyTemplates);
    }

    public static String getSignature(Class clazz) {
        if (clazz.isArray()) {
            StringBuffer stringBuffer = new StringBuffer();
            Class<?> clazz2 = clazz;
            while (clazz2.isArray()) {
                stringBuffer.append("[");
                clazz2 = clazz2.getComponentType();
            }
            stringBuffer.append(TranslatorHelper.getSignature(clazz2));
            return stringBuffer.toString();
        }
        if (clazz.isPrimitive()) {
            if (clazz == Integer.TYPE) {
                return "I";
            }
            if (clazz == Byte.TYPE) {
                return "B";
            }
            if (clazz == Long.TYPE) {
                return "J";
            }
            if (clazz == Float.TYPE) {
                return "F";
            }
            if (clazz == Double.TYPE) {
                return "D";
            }
            if (clazz == Short.TYPE) {
                return "S";
            }
            if (clazz == Character.TYPE) {
                return "C";
            }
            if (clazz == Boolean.TYPE) {
                return "Z";
            }
            if (clazz == Void.TYPE) {
                return "V";
            }
            String string = clazz.toString();
            ErrorMsg errorMsg = new ErrorMsg("UNKNOWN_SIG_TYPE_ERR", string);
            throw new Error(errorMsg.toString());
        }
        return "L" + clazz.getName().replace('.', '/') + ';';
    }

    public static String getSignature(Method method) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        Class<?>[] classArray = method.getParameterTypes();
        for (int i = 0; i < classArray.length; ++i) {
            stringBuffer.append(TranslatorHelper.getSignature(classArray[i]));
        }
        return stringBuffer.append(')').append(TranslatorHelper.getSignature(method.getReturnType())).toString();
    }

    public static String getSignature(Constructor constructor) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        Class<?>[] classArray = constructor.getParameterTypes();
        for (int i = 0; i < classArray.length; ++i) {
            stringBuffer.append(TranslatorHelper.getSignature(classArray[i]));
        }
        return stringBuffer.append(")V").toString();
    }

    public static boolean canLoadAsArrayOffsetLength(Text text) {
        return text.getText().length() <= 21845;
    }

    public static Template getCalleeTemplate(CallTemplate callTemplate) {
        XTQProgram xTQProgram = callTemplate.getXTQProgram();
        xTQProgram = xTQProgram.getTopLevelXTQProgram();
        List list = xTQProgram.getAllValidTemplates();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Template template = (Template)list.get(i);
            if (template.getQName() != callTemplate.getQName() || !template.isSimpleNamedTemplate()) continue;
            return template;
        }
        return null;
    }

    protected static boolean buildParameterList(CallTemplate callTemplate, Object[] objectArray) {
        Object object;
        Expr expr;
        int n;
        int n2 = callTemplate.jjtGetNumChildren();
        int n3 = objectArray.length;
        block0: for (n = 0; n < n2; n += 1) {
            Node node = callTemplate.jjtGetChild(n);
            if (!(node instanceof WithParam) || ((WithParam)(expr = (WithParam)node)).isTunnel()) continue;
            object = ((WithParam)expr).getQName();
            for (int i = 0; i < n3; ++i) {
                Object object2 = objectArray[i];
                if (object2 instanceof Param && ((Param)object2).getQName() == object) {
                    objectArray[i] = expr;
                    continue block0;
                }
                if (!(object2 instanceof WithParam) || ((WithParam)object2).getQName() != object) continue;
                objectArray[i] = expr;
                continue block0;
            }
        }
        n = 0;
        for (int i = 0; i < n3; ++i) {
            if (!(objectArray[i] instanceof Param)) continue;
            expr = (Param)objectArray[i];
            object = ((VariableBase)expr).getExpression();
            if (expr.jjtGetNumChildren() <= 0 && (object == null || !XSLTCHelper.hasVariableReferences((Expr)object))) continue;
            n = 1;
            break;
        }
        return n != 0;
    }

    protected static boolean checkAttributesUnique(DirElemConstructor dirElemConstructor) {
        boolean bl = TranslatorHelper.canProduceAttributeNodes(dirElemConstructor, true);
        if (bl) {
            return false;
        }
        List list = dirElemConstructor.getAttributeElements();
        if (list != null) {
            int n = list.size();
            Hashtable<Object, com.ibm.xtq.ast.nodes.Constructor> hashtable = null;
            for (int i = 0; i < n; ++i) {
                CompAttrConstructor compAttrConstructor;
                com.ibm.xtq.ast.nodes.Constructor constructor;
                Expr expr;
                Expr expr2 = (Expr)list.get(i);
                if (expr2 instanceof UseAttributeSets) {
                    return false;
                }
                if (!(expr2 instanceof CompAttrConstructor)) continue;
                if (hashtable == null) {
                    hashtable = new Hashtable<Object, com.ibm.xtq.ast.nodes.Constructor>();
                    for (int j = 0; j < i; ++j) {
                        expr = (Expr)list.get(j);
                        if (!(expr instanceof DirAttributeConstructor)) continue;
                        constructor = (DirAttributeConstructor)expr;
                        hashtable.put(((DirAttributeConstructor)constructor).getQName(), constructor);
                    }
                }
                if ((expr = (compAttrConstructor = (CompAttrConstructor)expr2).getNameExpr()) instanceof Text) {
                    constructor = (Text)expr;
                    String string = constructor.toString();
                    if (string != null && hashtable.get(string) != null) {
                        return false;
                    }
                    if (string == null) continue;
                    hashtable.put(string, compAttrConstructor);
                    continue;
                }
                return false;
            }
        }
        return true;
    }

    private static boolean canProduceAttributeNodes(Expr expr, boolean bl) {
        int n = expr.jjtGetNumChildren();
        for (int i = 0; i < n; ++i) {
            Expr expr2 = (Expr)expr.jjtGetChild(i);
            if (expr2 instanceof Text) {
                Text text = (Text)expr2;
                if (text.isIgnore()) continue;
                return false;
            }
            if (expr2 instanceof DirElemConstructor || expr2 instanceof ValueOf || expr2 instanceof CompElemConstructor || expr2 instanceof DirCommentConstructor || expr2 instanceof Number || expr2 instanceof DirPIConstructor) {
                return false;
            }
            if (expr2 instanceof CompAttrConstructor) {
                if (bl) continue;
                return true;
            }
            if (expr2 instanceof CallTemplate || expr2 instanceof ApplyTemplates || expr2 instanceof Copy || expr2 instanceof CopyOf) {
                return true;
            }
            if ((expr2 instanceof If || expr2 instanceof ForEach) && TranslatorHelper.canProduceAttributeNodes(expr2, false)) {
                return true;
            }
            if (!(expr2 instanceof Choose)) continue;
            int n2 = expr2.jjtGetNumChildren();
            for (int j = 0; j < n2; ++j) {
                Expr expr3 = (Expr)expr2.jjtGetChild(j);
                if (!(expr3 instanceof When) && !(expr3 instanceof Otherwise) || !TranslatorHelper.canProduceAttributeNodes(expr3, false)) continue;
                return true;
            }
        }
        return false;
    }

    protected static int getMinPrecedence(Expr expr, int n) {
        XTQProgram xTQProgram = expr.getXTQProgram();
        while (xTQProgram._includedFrom != null) {
            xTQProgram = xTQProgram._includedFrom;
        }
        return xTQProgram.getMinimumDescendantPrecedence();
    }

    public static boolean hasBadChars(String string) {
        for (char c : string.toCharArray()) {
            if (c >= ' ' && '~' >= c && c != '<' && c != '>' && c != '&' && c != '\"') continue;
            return true;
        }
        return false;
    }

    public static Type getRealType(Expr expr) {
        Type type = ASTDecorator1.getExpressionCastType(expr);
        if (type != null) {
            return type;
        }
        return ASTDecorator1.getType(expr);
    }

    public static boolean isNodeValueTest(Expr expr) {
        if (!ASTDecorator.getCanOptimize(expr)) {
            return false;
        }
        return XSLTCHelper.getStepForPredicate(expr) != null && TranslatorHelper.getCompareValue(expr) != null;
    }

    public static Expr getCompareValue(Expr expr) {
        Expr expr2 = ASTDecorator.getCompareValue(expr);
        if (expr2 != null) {
            return expr2;
        }
        if (expr == null) {
            return null;
        }
        if (expr.getId() == 59) {
            OperatorExpr operatorExpr = (OperatorExpr)expr;
            if (operatorExpr.getOperatorType() != 13 && operatorExpr.getOperatorType() != 14) {
                return null;
            }
            Expr expr3 = operatorExpr.getOperand(0);
            Expr expr4 = operatorExpr.getOperand(1);
            Type type = TranslatorHelper.getRealType(expr3);
            Type type2 = TranslatorHelper.getRealType(expr4);
            if (type == Type.String && !XSLTCHelper.isSimpleStep(expr3)) {
                expr2 = expr3;
            } else if (expr3 instanceof VariableRef) {
                expr2 = expr3;
            }
            if (expr2 != null) {
                ASTDecorator.setCompareValue(expr, expr2);
                return expr2;
            }
            if (type2 == Type.String && !XSLTCHelper.isSimpleStep(expr4)) {
                expr2 = expr4;
            } else if (expr4 instanceof VariableRef) {
                expr2 = expr4;
            }
            if (expr2 != null) {
                ASTDecorator.setCompareValue(expr, expr2);
                return expr2;
            }
        }
        return null;
    }
}

