/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.xpath;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import javax.xml.xpath.SecuritySupport;
import javax.xml.xpath.XPathFactory;

final class XPathFactoryFinder {
    private static boolean debug;
    private static Properties jaxpProperties;
    private static long lastModified;
    private static final int DEFAULT_LINE_LENGTH = 80;
    static /* synthetic */ Class class$javax$xml$xpath$XPathFactoryFinder;

    private XPathFactoryFinder() {
    }

    /*
     * Unable to fully structure code
     */
    static Object find(String var0, String var1_1, String var2_2) throws ConfigurationError {
        var3_3 = SecuritySupport.getContextClassLoader();
        if (var3_3 == null) {
            var3_3 = (XPathFactoryFinder.class$javax$xml$xpath$XPathFactoryFinder == null ? (XPathFactoryFinder.class$javax$xml$xpath$XPathFactoryFinder = XPathFactoryFinder.class$("javax.xml.xpath.XPathFactoryFinder")) : XPathFactoryFinder.class$javax$xml$xpath$XPathFactoryFinder).getClassLoader();
        }
        var4_4 = var0 + ":" + var1_1;
        if (XPathFactoryFinder.debug) {
            XPathFactoryFinder.dPrint("find factoryId=" + var4_4);
        }
        try {
            var5_5 = SecuritySupport.getSystemProperty(var4_4);
            if (var5_5 != null) {
                if (XPathFactoryFinder.debug) {
                    XPathFactoryFinder.dPrint("found system property, value=" + var5_5);
                }
                return XPathFactoryFinder.newInstance(var5_5, var3_3, true);
            }
        }
        catch (SecurityException var5_6) {
            // empty catch block
        }
        var5_7 = false;
        var6_8 = null;
        try {
            var7_9 = SecuritySupport.getSystemProperty("java.home");
            var8_11 = (String)var7_9 + File.separator + "lib" + File.separator + "jaxp.properties";
            var6_8 = new File(var8_11);
            var5_7 = SecuritySupport.getFileExists(var6_8);
        }
        catch (SecurityException var7_10) {
            XPathFactoryFinder.lastModified = -1L;
            XPathFactoryFinder.jaxpProperties = null;
        }
        var7_9 = XPathFactoryFinder.class$javax$xml$xpath$XPathFactoryFinder == null ? (XPathFactoryFinder.class$javax$xml$xpath$XPathFactoryFinder = XPathFactoryFinder.class$("javax.xml.xpath.XPathFactoryFinder")) : XPathFactoryFinder.class$javax$xml$xpath$XPathFactoryFinder;
        synchronized (var7_9) {
            block34: {
                var8_12 = false;
                var9_15 = null;
                try {
                    block33: {
                        if (XPathFactoryFinder.lastModified >= 0L) {
                            if (var5_7 && XPathFactoryFinder.lastModified < (XPathFactoryFinder.lastModified = SecuritySupport.getLastModified(var6_8))) {
                                var8_12 = true;
                            } else if (!var5_7) {
                                XPathFactoryFinder.lastModified = -1L;
                                XPathFactoryFinder.jaxpProperties = null;
                            }
                        } else if (var5_7) {
                            var8_12 = true;
                            XPathFactoryFinder.lastModified = SecuritySupport.getLastModified(var6_8);
                        }
                        if (!var8_12) break block33;
                        XPathFactoryFinder.jaxpProperties = new Properties();
                        var9_15 = SecuritySupport.getFileInputStream(var6_8);
                        XPathFactoryFinder.jaxpProperties.load(var9_15);
                    }
                    var12_16 = null;
                    ** if (var9_15 == null) goto lbl-1000
                }
                catch (Throwable var11_23) {
                    var12_18 = null;
                    if (var9_15 != null) {
                        try {
                            var9_15.close();
                        }
                        catch (IOException var13_21) {
                            // empty catch block
                        }
                    }
                    throw var11_23;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        var9_15.close();
                    }
                    catch (IOException var13_19) {}
                }
lbl-1000:
                // 2 sources

                {
                    break block34;
                    catch (Exception var10_22) {
                        XPathFactoryFinder.lastModified = -1L;
                        XPathFactoryFinder.jaxpProperties = null;
                        var12_17 = null;
                        if (var9_15 != null) {
                            try {
                                var9_15.close();
                            }
                            catch (IOException var13_20) {}
                        }
                    }
                }
            }
        }
        if (XPathFactoryFinder.jaxpProperties != null && (var8_13 = XPathFactoryFinder.jaxpProperties.getProperty(var4_4)) != null) {
            if (XPathFactoryFinder.debug) {
                XPathFactoryFinder.dPrint("found in jaxp.properties, value=" + var8_13);
            }
            return XPathFactoryFinder.newInstance(var8_13, var3_3, true);
        }
        var8_14 = XPathFactoryFinder.findJarServiceProvider(var0, var1_1);
        if (var8_14 != null) {
            return var8_14;
        }
        if (var2_2 != null && var1_1.equals("http://java.sun.com/jaxp/xpath/dom")) {
            if (XPathFactoryFinder.debug) {
                XPathFactoryFinder.dPrint("using fallback, value=" + var2_2);
            }
            return XPathFactoryFinder.newInstance(var2_2, var3_3, true);
        }
        throw new ConfigurationError("Provider for " + var4_4 + " cannot be found", null);
    }

    private static void dPrint(String string) {
        if (debug) {
            System.err.println("JAXP: " + string);
        }
    }

    static Object newInstance(String string, ClassLoader classLoader, boolean bl) throws ConfigurationError {
        try {
            Class<?> clazz;
            Object object;
            int n;
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null && (n = string.lastIndexOf(46)) != -1) {
                object = string.substring(0, n);
                securityManager.checkPackageAccess((String)object);
            }
            if (classLoader == null) {
                clazz = Class.forName(string);
            } else {
                try {
                    clazz = classLoader.loadClass(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (bl) {
                        classLoader = (class$javax$xml$xpath$XPathFactoryFinder == null ? (class$javax$xml$xpath$XPathFactoryFinder = XPathFactoryFinder.class$("javax.xml.xpath.XPathFactoryFinder")) : class$javax$xml$xpath$XPathFactoryFinder).getClassLoader();
                        clazz = classLoader != null ? classLoader.loadClass(string) : Class.forName(string);
                    }
                    throw classNotFoundException;
                }
            }
            object = clazz.newInstance();
            if (debug) {
                XPathFactoryFinder.dPrint("created new instance of " + clazz + " using ClassLoader: " + classLoader);
            }
            return object;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ConfigurationError("Provider " + string + " not found", classNotFoundException);
        }
        catch (Exception exception) {
            throw new ConfigurationError("Provider " + string + " could not be instantiated: " + exception, exception);
        }
    }

    private static Object findJarServiceProvider(String string, String string2) throws ConfigurationError {
        String string3 = "META-INF/services/" + string;
        Enumeration enumeration = null;
        ClassLoader classLoader = SecuritySupport.getContextClassLoader();
        if (classLoader != null) {
            enumeration = SecuritySupport.getResources(classLoader, string3);
            if (!enumeration.hasMoreElements()) {
                classLoader = (class$javax$xml$xpath$XPathFactoryFinder == null ? (class$javax$xml$xpath$XPathFactoryFinder = XPathFactoryFinder.class$("javax.xml.xpath.XPathFactoryFinder")) : class$javax$xml$xpath$XPathFactoryFinder).getClassLoader();
                enumeration = SecuritySupport.getResources(classLoader, string3);
            }
        } else {
            classLoader = (class$javax$xml$xpath$XPathFactoryFinder == null ? (class$javax$xml$xpath$XPathFactoryFinder = XPathFactoryFinder.class$("javax.xml.xpath.XPathFactoryFinder")) : class$javax$xml$xpath$XPathFactoryFinder).getClassLoader();
            enumeration = SecuritySupport.getResources(classLoader, string3);
        }
        while (enumeration.hasMoreElements()) {
            URL uRL = (URL)enumeration.nextElement();
            try {
                BufferedReader bufferedReader;
                InputStream inputStream = uRL.openStream();
                try {
                    bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"), 80);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    bufferedReader = new BufferedReader(new InputStreamReader(inputStream), 80);
                }
                String string4 = null;
                XPathFactory xPathFactory = null;
                while (true) {
                    try {
                        string4 = bufferedReader.readLine();
                    }
                    catch (IOException iOException) {
                        break;
                    }
                    if (string4 == null) break;
                    int n = string4.indexOf(35);
                    if (n != -1) {
                        string4 = string4.substring(0, n);
                    }
                    if ((string4 = string4.trim()).length() == 0) continue;
                    try {
                        XPathFactory xPathFactory2 = (XPathFactory)XPathFactoryFinder.newInstance(string4, classLoader, false);
                        if (!xPathFactory2.isObjectModelSupported(string2)) continue;
                        xPathFactory = xPathFactory2;
                    }
                    catch (Throwable throwable) {
                        continue;
                    }
                    break;
                }
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (xPathFactory == null) continue;
                if (debug) {
                    XPathFactoryFinder.dPrint("found jar resource=" + string3 + " using ClassLoader: " + classLoader);
                }
                return xPathFactory;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        jaxpProperties = null;
        lastModified = -1L;
        try {
            String string = SecuritySupport.getSystemProperty("jaxp.debug");
            debug = string != null && !"false".equals(string);
        }
        catch (SecurityException securityException) {
            debug = false;
        }
    }

    static class ConfigurationError
    extends Error {
        private Exception exception;

        ConfigurationError(String string, Exception exception) {
            super(string);
            this.exception = exception;
        }

        Exception getException() {
            return this.exception;
        }
    }
}

