/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.processor;

import com.ibm.xml.jaxp.util.ExternalResourceHelper;
import com.ibm.xtq.xml.utils.StopParseException;
import com.ibm.xtq.xml.utils.StylesheetPIHandler;
import com.ibm.xtq.xslt.jaxp.DummyProtocolErrorHandler;
import com.ibm.xtq.xslt.jaxp.STAXEvent2SAX;
import com.ibm.xtq.xslt.jaxp.STAXStream2SAX;
import java.io.IOException;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TemplatesHandler;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stax.StAXSource;
import org.apache.xalan.processor.StylesheetHandler;
import org.apache.xalan.res.XSLMessages;
import org.apache.xalan.templates.StylesheetRootProxy;
import org.apache.xalan.transformer.TrAXFilter;
import org.apache.xalan.transformer.TransformerIdentityImpl;
import org.apache.xalan.transformer.TransformerImpl;
import org.apache.xml.serializer.utils.SystemIDResolver;
import org.apache.xml.utils.DOM2Helper;
import org.apache.xml.utils.DefaultErrorHandler;
import org.apache.xml.utils.TreeWalker;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLFilter;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class TransformerFactoryImpl
extends SAXTransformerFactory {
    private boolean m_serializable = false;
    public static final String XSLT_PROPERTIES = "org/apache/xalan/res/XSLTInfo.properties";
    private ExternalResourceHelper.ProtocolValidator m_dtd_protocol_validator = null;
    private ExternalResourceHelper.ProtocolValidator m_stylesheet_protocol_validator = null;
    private ExternalResourceHelper.ProtocolValidatorErrorHandler m_pv_error_handler;
    public static final String FEATURE_INCREMENTAL = "http://xml.apache.org/xalan/features/incremental";
    public static final String FEATURE_OPTIMIZE = "http://xml.apache.org/xalan/features/optimize";
    public static final String FEATURE_SOURCE_LOCATION = "http://xml.apache.org/xalan/properties/source-location";
    public static final String FEATURE_SERIALIZABLE = "http://www.ibm.com/xmlns/prod/xslt4j/serializable-templates";
    private String m_DOMsystemID = null;
    private boolean m_isSecureProcessing = false;
    private boolean m_optimize = true;
    private boolean m_source_location = false;
    private boolean m_incremental = false;
    URIResolver m_uriResolver;
    private ErrorListener m_errorListener = new DefaultErrorHandler(false);

    public TransformerFactoryImpl() {
        if (ExternalResourceHelper.isSupportAvailable()) {
            this.m_pv_error_handler = new DummyProtocolErrorHandler();
            this.m_stylesheet_protocol_validator = ExternalResourceHelper.getStylesheetProtocolValidator(this.m_pv_error_handler);
            this.m_dtd_protocol_validator = ExternalResourceHelper.getDTDProtocolValidator(this.m_pv_error_handler);
        }
    }

    public Templates processFromNode(Node node) throws TransformerConfigurationException {
        try {
            TemplatesHandler templatesHandler = this.newTemplatesHandler();
            if (this.m_serializable) {
                TreeWalker treeWalker = new TreeWalker(templatesHandler, new DOM2Helper(), templatesHandler.getSystemId());
                treeWalker.traverse(node);
                return templatesHandler.getTemplates();
            }
            return new StylesheetRootProxy(templatesHandler, node, this.m_isSecureProcessing, this.m_stylesheet_protocol_validator, this.getAllowedDTDProtocols());
        }
        catch (SAXException sAXException) {
            if (this.m_errorListener != null) {
                try {
                    this.m_errorListener.fatalError(new TransformerException(sAXException));
                }
                catch (TransformerConfigurationException transformerConfigurationException) {
                    throw transformerConfigurationException;
                }
                catch (TransformerException transformerException) {
                    throw new TransformerConfigurationException(transformerException);
                }
                return null;
            }
            throw new TransformerConfigurationException(XSLMessages.createMessage("ER_PROCESSFROMNODE_FAILED", null), sAXException);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw transformerConfigurationException;
        }
        catch (Exception exception) {
            if (this.m_errorListener != null) {
                try {
                    this.m_errorListener.fatalError(new TransformerException(exception));
                }
                catch (TransformerConfigurationException transformerConfigurationException) {
                    throw transformerConfigurationException;
                }
                catch (TransformerException transformerException) {
                    throw new TransformerConfigurationException(transformerException);
                }
                return null;
            }
            throw new TransformerConfigurationException(XSLMessages.createMessage("ER_PROCESSFROMNODE_FAILED", null), exception);
        }
    }

    String getDOMsystemID() {
        return this.m_DOMsystemID;
    }

    Templates processFromNode(Node node, String string) throws TransformerConfigurationException {
        this.m_DOMsystemID = string;
        return this.processFromNode(node);
    }

    @Override
    public Source getAssociatedStylesheet(Source source, String string, String string2, String string3) throws TransformerConfigurationException {
        Object object;
        block25: {
            String string4;
            InputSource inputSource = null;
            Node node = null;
            XMLReader xMLReader = null;
            if (source instanceof DOMSource) {
                object = (DOMSource)source;
                node = ((DOMSource)object).getNode();
                string4 = ((DOMSource)object).getSystemId();
            } else if (source instanceof StAXSource) {
                object = (StAXSource)source;
                string4 = ((StAXSource)object).getSystemId();
            } else {
                inputSource = SAXSource.sourceToInputSource(source);
                string4 = inputSource.getSystemId();
            }
            object = new StylesheetPIHandler(string4, string, string2, string3);
            if (this.m_uriResolver != null) {
                ((StylesheetPIHandler)object).setURIResolver(this.m_uriResolver);
            }
            ((StylesheetPIHandler)object).setStylesheetProtocolValidator(this.m_stylesheet_protocol_validator);
            try {
                if (null != node) {
                    TreeWalker treeWalker = new TreeWalker((ContentHandler)object, new DOM2Helper(), string4);
                    treeWalker.traverse(node);
                    break block25;
                }
                if (source instanceof StAXSource) {
                    XMLInputFactory xMLInputFactory = XMLInputFactory.newInstance();
                    if (this.m_dtd_protocol_validator != null) {
                        xMLInputFactory.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", this.m_dtd_protocol_validator.getAllowedProtocols());
                    }
                    XMLStreamReader xMLStreamReader = xMLInputFactory.createXMLStreamReader(source);
                    while (true) {
                        int n;
                        if ((n = xMLStreamReader.next()) == 8) {
                            xMLStreamReader.close();
                            break block25;
                        }
                        if (n != 3) continue;
                        ((StylesheetPIHandler)object).processingInstruction(xMLStreamReader.getPITarget(), xMLStreamReader.getPIData());
                    }
                }
                try {
                    SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
                    sAXParserFactory.setNamespaceAware(true);
                    if (this.m_isSecureProcessing) {
                        try {
                            sAXParserFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                        }
                        catch (SAXException sAXException) {
                            // empty catch block
                        }
                    }
                    SAXParser sAXParser = sAXParserFactory.newSAXParser();
                    if (this.m_dtd_protocol_validator != null) {
                        sAXParser.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", this.m_dtd_protocol_validator.getAllowedProtocols());
                    }
                    xMLReader = sAXParser.getXMLReader();
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    throw new SAXException(parserConfigurationException);
                }
                catch (FactoryConfigurationError factoryConfigurationError) {
                    throw new SAXException(factoryConfigurationError.toString());
                }
                catch (NoSuchMethodError noSuchMethodError) {
                }
                catch (AbstractMethodError abstractMethodError) {
                    // empty catch block
                }
                if (null == xMLReader) {
                    xMLReader = XMLReaderFactory.createXMLReader();
                }
                xMLReader.setContentHandler((ContentHandler)object);
                xMLReader.parse(inputSource);
            }
            catch (StopParseException stopParseException) {
            }
            catch (SAXException sAXException) {
                throw new TransformerConfigurationException("getAssociatedStylesheets failed", sAXException);
            }
            catch (IOException iOException) {
                throw new TransformerConfigurationException("getAssociatedStylesheets failed", iOException);
            }
            catch (XMLStreamException xMLStreamException) {
                throw new TransformerConfigurationException("getAssociatedStylesheets failed", xMLStreamException);
            }
        }
        return ((StylesheetPIHandler)object).getAssociatedStylesheet();
    }

    @Override
    public TemplatesHandler newTemplatesHandler() throws TransformerConfigurationException {
        return new StylesheetHandler(this);
    }

    @Override
    public boolean getFeature(String string) {
        if (string == null) {
            throw new NullPointerException(XSLMessages.createMessage("ER_GET_FEATURE_NULL_NAME", null));
        }
        if ("http://javax.xml.transform.dom.DOMResult/feature" == string || "http://javax.xml.transform.dom.DOMSource/feature" == string || "http://javax.xml.transform.sax.SAXResult/feature" == string || "http://javax.xml.transform.sax.SAXSource/feature" == string || "http://javax.xml.transform.stream.StreamResult/feature" == string || "http://javax.xml.transform.stream.StreamSource/feature" == string || "http://javax.xml.transform.stax.StAXSource/feature" == string || "http://javax.xml.transform.stax.StAXResult/feature" == string || "http://javax.xml.transform.sax.SAXTransformerFactory/feature" == string || "http://javax.xml.transform.sax.SAXTransformerFactory/feature/xmlfilter" == string) {
            return true;
        }
        if ("http://javax.xml.transform.dom.DOMResult/feature".equals(string) || "http://javax.xml.transform.dom.DOMSource/feature".equals(string) || "http://javax.xml.transform.sax.SAXResult/feature".equals(string) || "http://javax.xml.transform.sax.SAXSource/feature".equals(string) || "http://javax.xml.transform.stream.StreamResult/feature".equals(string) || "http://javax.xml.transform.stream.StreamSource/feature".equals(string) || "http://javax.xml.transform.stax.StAXSource/feature".equals(string) || "http://javax.xml.transform.stax.StAXResult/feature".equals(string) || "http://javax.xml.transform.sax.SAXTransformerFactory/feature".equals(string) || "http://javax.xml.transform.sax.SAXTransformerFactory/feature/xmlfilter".equals(string)) {
            return true;
        }
        try {
            if (string.equals("http://javax.xml.XMLConstants/feature/secure-processing")) {
                return this.m_isSecureProcessing;
            }
            return false;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            return false;
        }
    }

    @Override
    public void setFeature(String string, boolean bl) throws TransformerConfigurationException {
        if (string == null) {
            throw new NullPointerException(XSLMessages.createMessage("ER_SET_FEATURE_NULL_NAME", null));
        }
        if (!string.equals("http://javax.xml.XMLConstants/feature/secure-processing")) {
            throw new TransformerConfigurationException(XSLMessages.createMessage("ER_UNSUPPORTED_FEATURE", new Object[]{string}));
        }
        this.m_isSecureProcessing = bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setAttribute(String string, Object object) throws IllegalArgumentException {
        if (string.equals(FEATURE_INCREMENTAL)) {
            if (object instanceof Boolean) {
                this.m_incremental = (Boolean)object;
                return;
            } else {
                if (!(object instanceof String)) throw new IllegalArgumentException(XSLMessages.createMessage("ER_BAD_VALUE", new Object[]{string, object}));
                this.m_incremental = new Boolean((String)object);
            }
            return;
        } else if (string.equals(FEATURE_OPTIMIZE)) {
            if (object instanceof Boolean) {
                this.m_optimize = (Boolean)object;
                return;
            } else {
                if (!(object instanceof String)) throw new IllegalArgumentException(XSLMessages.createMessage("ER_BAD_VALUE", new Object[]{string, object}));
                this.m_optimize = new Boolean((String)object);
            }
            return;
        } else if (string.equals(FEATURE_SOURCE_LOCATION)) {
            if (object instanceof Boolean) {
                this.m_source_location = (Boolean)object;
                return;
            } else {
                if (!(object instanceof String)) throw new IllegalArgumentException(XSLMessages.createMessage("ER_BAD_VALUE", new Object[]{string, object}));
                this.m_source_location = new Boolean((String)object);
            }
            return;
        } else if (string.equals(FEATURE_SERIALIZABLE)) {
            if (object instanceof Boolean) {
                this.m_serializable = (Boolean)object;
                return;
            } else {
                if (!(object instanceof String)) throw new IllegalArgumentException(XSLMessages.createMessage("ER_BAD_VALUE", new Object[]{string, object}));
                this.m_serializable = new Boolean((String)object);
            }
            return;
        } else if (string.equals("http://javax.xml.XMLConstants/property/accessExternalDTD") && ExternalResourceHelper.isSupportAvailable()) {
            if (!(object instanceof String)) throw new IllegalArgumentException(XSLMessages.createMessage("ER_BAD_VALUE", new Object[]{string, object}));
            this.m_dtd_protocol_validator.setAllowedProtocols((String)object);
            return;
        } else {
            if (!string.equals("http://javax.xml.XMLConstants/property/accessExternalStylesheet") || !ExternalResourceHelper.isSupportAvailable()) throw new IllegalArgumentException(XSLMessages.createMessage("ER_NOT_SUPPORTED", new Object[]{string}));
            if (!(object instanceof String)) throw new IllegalArgumentException(XSLMessages.createMessage("ER_BAD_VALUE", new Object[]{string, object}));
            this.m_stylesheet_protocol_validator.setAllowedProtocols((String)object);
        }
    }

    @Override
    public Object getAttribute(String string) throws IllegalArgumentException {
        if (string.equals(FEATURE_INCREMENTAL)) {
            return new Boolean(this.m_incremental);
        }
        if (string.equals(FEATURE_OPTIMIZE)) {
            return new Boolean(this.m_optimize);
        }
        if (string.equals(FEATURE_SOURCE_LOCATION)) {
            return new Boolean(this.m_source_location);
        }
        if (string.equals(FEATURE_SERIALIZABLE)) {
            return new Boolean(this.m_serializable);
        }
        throw new IllegalArgumentException(XSLMessages.createMessage("ER_ATTRIB_VALUE_NOT_RECOGNIZED", new Object[]{string}));
    }

    @Override
    public XMLFilter newXMLFilter(Source source) throws TransformerConfigurationException {
        Templates templates = this.newTemplates(source);
        if (templates == null) {
            return null;
        }
        return this.newXMLFilter(templates);
    }

    @Override
    public XMLFilter newXMLFilter(Templates templates) throws TransformerConfigurationException {
        try {
            return new TrAXFilter(templates);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            if (this.m_errorListener != null) {
                try {
                    this.m_errorListener.fatalError(transformerConfigurationException);
                    return null;
                }
                catch (TransformerConfigurationException transformerConfigurationException2) {
                    throw transformerConfigurationException2;
                }
                catch (TransformerException transformerException) {
                    throw new TransformerConfigurationException(transformerException);
                }
            }
            throw transformerConfigurationException;
        }
    }

    @Override
    public TransformerHandler newTransformerHandler(Source source) throws TransformerConfigurationException {
        Templates templates = this.newTemplates(source);
        if (templates == null) {
            return null;
        }
        return this.newTransformerHandler(templates);
    }

    @Override
    public TransformerHandler newTransformerHandler(Templates templates) throws TransformerConfigurationException {
        try {
            TransformerImpl transformerImpl = (TransformerImpl)templates.newTransformer();
            transformerImpl.setURIResolver(this.m_uriResolver);
            TransformerHandler transformerHandler = (TransformerHandler)transformerImpl.getInputContentHandler(true);
            return transformerHandler;
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            if (this.m_errorListener != null) {
                try {
                    this.m_errorListener.fatalError(transformerConfigurationException);
                    return null;
                }
                catch (TransformerConfigurationException transformerConfigurationException2) {
                    throw transformerConfigurationException2;
                }
                catch (TransformerException transformerException) {
                    throw new TransformerConfigurationException(transformerException);
                }
            }
            throw transformerConfigurationException;
        }
    }

    @Override
    public TransformerHandler newTransformerHandler() throws TransformerConfigurationException {
        if (this.m_dtd_protocol_validator != null) {
            return new TransformerIdentityImpl(this.m_isSecureProcessing, this.m_dtd_protocol_validator.getAllowedProtocols());
        }
        return new TransformerIdentityImpl(this.m_isSecureProcessing);
    }

    @Override
    public Transformer newTransformer(Source source) throws TransformerConfigurationException {
        try {
            Templates templates = this.newTemplates(source);
            if (templates == null) {
                return null;
            }
            Transformer transformer = templates.newTransformer();
            transformer.setURIResolver(this.m_uriResolver);
            return transformer;
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            if (this.m_errorListener != null) {
                try {
                    this.m_errorListener.fatalError(transformerConfigurationException);
                }
                catch (TransformerConfigurationException transformerConfigurationException2) {
                    throw transformerConfigurationException2;
                }
                catch (TransformerException transformerException) {
                    throw new TransformerConfigurationException(transformerException);
                }
            }
            throw transformerConfigurationException;
        }
    }

    @Override
    public Transformer newTransformer() throws TransformerConfigurationException {
        if (this.m_dtd_protocol_validator != null) {
            return new TransformerIdentityImpl(this.m_isSecureProcessing, this.m_dtd_protocol_validator.getAllowedProtocols());
        }
        return new TransformerIdentityImpl(this.m_isSecureProcessing);
    }

    @Override
    public Templates newTemplates(Source source) throws TransformerConfigurationException {
        TransformerConfigurationException transformerConfigurationException = null;
        String string = source.getSystemId();
        if (null != string) {
            string = SystemIDResolver.getAbsoluteURI(string);
        }
        if (source instanceof DOMSource) {
            DOMSource dOMSource = (DOMSource)source;
            Node node = dOMSource.getNode();
            if (null != node) {
                return this.processFromNode(node, string);
            }
            String string2 = XSLMessages.createMessage("ER_ILLEGAL_DOMSOURCE_INPUT", null);
            throw new IllegalArgumentException(string2);
        }
        TemplatesHandler templatesHandler = this.newTemplatesHandler();
        templatesHandler.setSystemId(string);
        try {
            Object object;
            Object object2;
            XMLReader xMLReader = null;
            InputSource inputSource = SAXSource.sourceToInputSource(source);
            if (source instanceof StAXSource) {
                object2 = (StAXSource)source;
                object = ((StAXSource)object2).getXMLStreamReader();
                if (object != null) {
                    xMLReader = new STAXStream2SAX((XMLStreamReader)object);
                } else {
                    XMLEventReader xMLEventReader = ((StAXSource)object2).getXMLEventReader();
                    if (xMLEventReader != null) {
                        xMLReader = new STAXEvent2SAX(xMLEventReader);
                    }
                }
                inputSource = new InputSource(((StAXSource)object2).getSystemId());
            }
            inputSource.setSystemId(string);
            if (source instanceof SAXSource) {
                xMLReader = ((SAXSource)source).getXMLReader();
            }
            if (null == xMLReader) {
                try {
                    object2 = SAXParserFactory.newInstance();
                    ((SAXParserFactory)object2).setNamespaceAware(true);
                    if (this.m_isSecureProcessing) {
                        try {
                            ((SAXParserFactory)object2).setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                        }
                        catch (SAXException sAXException) {
                            // empty catch block
                        }
                    }
                    object = ((SAXParserFactory)object2).newSAXParser();
                    if (this.m_dtd_protocol_validator != null) {
                        ((SAXParser)object).setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", this.m_dtd_protocol_validator.getAllowedProtocols());
                    }
                    xMLReader = ((SAXParser)object).getXMLReader();
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    throw new SAXException(parserConfigurationException);
                }
                catch (FactoryConfigurationError factoryConfigurationError) {
                    throw new SAXException(factoryConfigurationError.toString());
                }
                catch (NoSuchMethodError noSuchMethodError) {
                }
                catch (AbstractMethodError abstractMethodError) {
                    // empty catch block
                }
            }
            if (null == xMLReader) {
                xMLReader = XMLReaderFactory.createXMLReader();
            }
            xMLReader.setContentHandler(templatesHandler);
            if (this.m_serializable) {
                xMLReader.parse(inputSource);
                return templatesHandler.getTemplates();
            }
            return new StylesheetRootProxy(xMLReader, inputSource, this.m_isSecureProcessing, this.m_stylesheet_protocol_validator, this.getAllowedDTDProtocols());
        }
        catch (SAXException sAXException) {
            if (this.m_errorListener != null) {
                try {
                    transformerConfigurationException = new TransformerConfigurationException(sAXException);
                    this.m_errorListener.fatalError(transformerConfigurationException);
                }
                catch (TransformerConfigurationException transformerConfigurationException2) {
                    throw transformerConfigurationException2;
                }
                catch (TransformerException transformerException) {
                    throw new TransformerConfigurationException(transformerException);
                }
            }
            throw new TransformerConfigurationException(sAXException.getMessage(), sAXException);
        }
        catch (Exception exception) {
            if (this.m_errorListener != null) {
                try {
                    transformerConfigurationException = new TransformerConfigurationException(exception);
                    this.m_errorListener.fatalError(transformerConfigurationException);
                }
                catch (TransformerConfigurationException transformerConfigurationException3) {
                    throw transformerConfigurationException3;
                }
                catch (TransformerException transformerException) {
                    throw new TransformerConfigurationException(transformerException);
                }
            }
            throw new TransformerConfigurationException(exception.getMessage(), exception);
        }
        throw transformerConfigurationException;
    }

    @Override
    public void setURIResolver(URIResolver uRIResolver) {
        this.m_uriResolver = uRIResolver;
    }

    @Override
    public URIResolver getURIResolver() {
        return this.m_uriResolver;
    }

    @Override
    public ErrorListener getErrorListener() {
        return this.m_errorListener;
    }

    @Override
    public void setErrorListener(ErrorListener errorListener) throws IllegalArgumentException {
        if (null == errorListener) {
            throw new IllegalArgumentException(XSLMessages.createMessage("ER_ERRORLISTENER", null));
        }
        this.m_errorListener = errorListener;
    }

    public boolean isSecureProcessing() {
        return this.m_isSecureProcessing;
    }

    String getAllowedDTDProtocols() {
        if (this.m_dtd_protocol_validator != null) {
            return this.m_dtd_protocol_validator.getAllowedProtocols();
        }
        return null;
    }

    ExternalResourceHelper.ProtocolValidator getStylesheetProtocolValidator() {
        return this.m_stylesheet_protocol_validator;
    }

    boolean isStylesheetProtocolAllowed(String string) {
        if (this.m_stylesheet_protocol_validator != null) {
            return this.m_stylesheet_protocol_validator.validate(string);
        }
        return true;
    }
}

