/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.templates;

import com.ibm.xml.jaxp.util.ExternalResourceHelper;
import java.io.Serializable;
import java.text.DecimalFormatSymbols;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.xalan.extensions.ExtensionNamespacesManager;
import org.apache.xalan.processor.XSLTSchema;
import org.apache.xalan.res.XSLMessages;
import org.apache.xalan.templates.DecimalFormatProperties;
import org.apache.xalan.templates.ElemApplyTemplates;
import org.apache.xalan.templates.ElemAttributeSet;
import org.apache.xalan.templates.ElemTemplate;
import org.apache.xalan.templates.ElemTemplateElement;
import org.apache.xalan.templates.ElemValueOf;
import org.apache.xalan.templates.ElemVariable;
import org.apache.xalan.templates.KeyDeclaration;
import org.apache.xalan.templates.NamespaceAlias;
import org.apache.xalan.templates.OutputProperties;
import org.apache.xalan.templates.Stylesheet;
import org.apache.xalan.templates.StylesheetComposed;
import org.apache.xalan.templates.TemplateList;
import org.apache.xalan.templates.WhiteSpaceInfo;
import org.apache.xalan.transformer.TransformerImpl;
import org.apache.xml.dtm.DTM;
import org.apache.xml.dtm.ref.ExpandedNameTable;
import org.apache.xml.utils.DefaultErrorHandler;
import org.apache.xml.utils.IntStack;
import org.apache.xml.utils.QName;
import org.apache.xpath.XPath;
import org.apache.xpath.XPathContext;

public class StylesheetRoot
extends StylesheetComposed
implements Serializable,
Templates {
    static final long serialVersionUID = 3875353123529147855L;
    private boolean m_optimizer = true;
    private boolean m_incremental = false;
    private boolean m_source_location = false;
    private boolean m_isSecureProcessing = false;
    private ErrorListener m_errorListener = null;
    private String m_allowedDTDProtocols = null;
    private ExternalResourceHelper.ProtocolValidator m_stylesheet_protocol_validator = null;
    private Hashtable m_availElems;
    private transient ExtensionNamespacesManager m_extNsMgr = null;
    private StylesheetComposed[] m_globalImportList;
    private OutputProperties m_outputProperties;
    private boolean m_outputMethodSet = false;
    private Hashtable m_attrSets;
    private Hashtable m_decimalFormatSymbols;
    private Vector m_keyDecls;
    private Hashtable m_namespaceAliasComposed;
    private TemplateList m_templateList;
    private Vector m_variables;
    private TemplateList m_whiteSpaceInfoList;
    private ElemTemplate m_defaultTextRule;
    private ElemTemplate m_defaultRule;
    private ElemTemplate m_defaultRootRule;
    private ElemTemplate m_startRule;
    XPath m_selectDefault;
    private transient ComposeState m_composeState;
    private String m_extensionHandlerClass = "org.apache.xalan.extensions.ExtensionHandlerExsltFunction";

    public StylesheetRoot(ErrorListener errorListener) throws TransformerConfigurationException {
        super(null);
        if (null == errorListener) {
            errorListener = new DefaultErrorHandler();
        }
        this.m_errorListener = errorListener;
        this.setStylesheetRoot(this);
        try {
            this.m_selectDefault = new XPath("node()", this, this, 0, errorListener);
            this.initDefaultRule(errorListener);
        }
        catch (TransformerException transformerException) {
            throw new TransformerConfigurationException(XSLMessages.createMessage("ER_CANNOT_INIT_DEFAULT_TEMPLATES", null), transformerException);
        }
    }

    public StylesheetRoot(XSLTSchema xSLTSchema, ErrorListener errorListener) throws TransformerConfigurationException {
        this(errorListener);
        this.m_availElems = xSLTSchema.getElemsAvailable();
    }

    @Override
    public boolean isRoot() {
        return true;
    }

    public void setSecureProcessing(boolean bl) {
        this.m_isSecureProcessing = bl;
    }

    public boolean isSecureProcessing() {
        return this.m_isSecureProcessing;
    }

    public Hashtable getAvailableElements() {
        return this.m_availElems;
    }

    public ExtensionNamespacesManager getExtensionNamespacesManager() {
        if (this.m_extNsMgr == null) {
            this.m_extNsMgr = new ExtensionNamespacesManager();
        }
        return this.m_extNsMgr;
    }

    public Vector getExtensions() {
        return this.m_extNsMgr != null ? this.m_extNsMgr.getExtensions() : null;
    }

    @Override
    public Transformer newTransformer() {
        return new TransformerImpl(this);
    }

    public Properties getDefaultOutputProps() {
        return this.m_outputProperties.getProperties();
    }

    @Override
    public Properties getOutputProperties() {
        return (Properties)this.getDefaultOutputProps().clone();
    }

    public void recompose() throws TransformerException {
        int n;
        Vector vector = new Vector();
        if (null == this.m_globalImportList) {
            Vector vector2 = new Vector();
            this.addImports(this, true, vector2);
            this.m_globalImportList = new StylesheetComposed[vector2.size()];
            int n2 = vector2.size() - 1;
            for (n = 0; n < vector2.size(); ++n) {
                this.m_globalImportList[n2] = (StylesheetComposed)vector2.elementAt(n);
                this.m_globalImportList[n2].recomposeIncludes(this.m_globalImportList[n2]);
                this.m_globalImportList[n2--].recomposeImports();
            }
        }
        int n3 = this.getGlobalImportCount();
        for (n = 0; n < n3; ++n) {
            StylesheetComposed stylesheetComposed = this.getGlobalImport(n);
            stylesheetComposed.recompose(vector);
        }
        this.QuickSort2(vector, 0, vector.size() - 1);
        this.m_outputProperties = new OutputProperties("");
        this.m_attrSets = new Hashtable();
        this.m_decimalFormatSymbols = new Hashtable();
        this.m_keyDecls = new Vector();
        this.m_namespaceAliasComposed = new Hashtable();
        this.m_templateList = new TemplateList();
        this.m_variables = new Vector();
        for (n = vector.size() - 1; n >= 0; --n) {
            ((ElemTemplateElement)vector.elementAt(n)).recompose(this);
        }
        this.initComposeState();
        this.m_templateList.compose(this);
        this.m_outputProperties.compose(this);
        this.m_outputProperties.endCompose(this);
        n3 = this.getGlobalImportCount();
        for (n = 0; n < n3; ++n) {
            StylesheetComposed stylesheetComposed = this.getGlobalImport(n);
            int n4 = stylesheetComposed.getIncludeCountComposed();
            for (int i = -1; i < n4; ++i) {
                Stylesheet stylesheet = stylesheetComposed.getIncludeComposed(i);
                this.composeTemplates(stylesheet);
            }
        }
        if (this.m_extNsMgr != null) {
            this.m_extNsMgr.registerUnregisteredNamespaces();
        }
        this.clearComposeState();
    }

    void composeTemplates(ElemTemplateElement elemTemplateElement) throws TransformerException {
        elemTemplateElement.compose(this);
        for (ElemTemplateElement elemTemplateElement2 = elemTemplateElement.getFirstChildElem(); elemTemplateElement2 != null; elemTemplateElement2 = elemTemplateElement2.getNextSiblingElem()) {
            this.composeTemplates(elemTemplateElement2);
        }
        elemTemplateElement.endCompose(this);
    }

    protected void addImports(Stylesheet stylesheet, boolean bl, Vector vector) {
        Stylesheet stylesheet2;
        int n;
        int n2 = stylesheet.getImportCount();
        if (n2 > 0) {
            for (n = 0; n < n2; ++n) {
                stylesheet2 = stylesheet.getImport(n);
                this.addImports(stylesheet2, true, vector);
            }
        }
        if ((n2 = stylesheet.getIncludeCount()) > 0) {
            for (n = 0; n < n2; ++n) {
                stylesheet2 = stylesheet.getInclude(n);
                this.addImports(stylesheet2, false, vector);
            }
        }
        if (bl) {
            vector.addElement(stylesheet);
        }
    }

    public StylesheetComposed getGlobalImport(int n) {
        return this.m_globalImportList[n];
    }

    public int getGlobalImportCount() {
        return this.m_globalImportList != null ? this.m_globalImportList.length : 1;
    }

    public int getImportNumber(StylesheetComposed stylesheetComposed) {
        if (this == stylesheetComposed) {
            return 0;
        }
        int n = this.getGlobalImportCount();
        for (int i = 0; i < n; ++i) {
            if (stylesheetComposed != this.getGlobalImport(i)) continue;
            return i;
        }
        return -1;
    }

    void recomposeOutput(OutputProperties outputProperties) throws TransformerException {
        this.m_outputProperties.copyFrom(outputProperties);
    }

    public OutputProperties getOutputComposed() {
        return this.m_outputProperties;
    }

    public boolean isOutputMethodSet() {
        return this.m_outputMethodSet;
    }

    void recomposeAttributeSets(ElemAttributeSet elemAttributeSet) {
        Vector<ElemAttributeSet> vector = (Vector<ElemAttributeSet>)this.m_attrSets.get(elemAttributeSet.getName());
        if (null == vector) {
            vector = new Vector<ElemAttributeSet>();
            this.m_attrSets.put(elemAttributeSet.getName(), vector);
        }
        vector.addElement(elemAttributeSet);
    }

    public Vector getAttributeSetComposed(QName qName) throws ArrayIndexOutOfBoundsException {
        return (Vector)this.m_attrSets.get(qName);
    }

    void recomposeDecimalFormats(DecimalFormatProperties decimalFormatProperties) {
        DecimalFormatSymbols decimalFormatSymbols = (DecimalFormatSymbols)this.m_decimalFormatSymbols.get(decimalFormatProperties.getName());
        if (null == decimalFormatSymbols) {
            this.m_decimalFormatSymbols.put(decimalFormatProperties.getName(), decimalFormatProperties.getDecimalFormatSymbols());
        } else if (!decimalFormatProperties.getDecimalFormatSymbols().equals(decimalFormatSymbols)) {
            String string = decimalFormatProperties.getName().equals(new QName("")) ? XSLMessages.createWarning("WG_ONE_DEFAULT_XSLDECIMALFORMAT_ALLOWED", new Object[0]) : XSLMessages.createWarning("WG_XSLDECIMALFORMAT_NAMES_MUST_BE_UNIQUE", new Object[]{decimalFormatProperties.getName()});
            this.error(string);
        }
    }

    public DecimalFormatSymbols getDecimalFormatComposed(QName qName) {
        return (DecimalFormatSymbols)this.m_decimalFormatSymbols.get(qName);
    }

    void recomposeKeys(KeyDeclaration keyDeclaration) {
        this.m_keyDecls.addElement(keyDeclaration);
    }

    public Vector getKeysComposed() {
        return this.m_keyDecls;
    }

    void recomposeNamespaceAliases(NamespaceAlias namespaceAlias) {
        this.m_namespaceAliasComposed.put(namespaceAlias.getStylesheetNamespace(), namespaceAlias);
    }

    public NamespaceAlias getNamespaceAliasComposed(String string) {
        return null == this.m_namespaceAliasComposed ? null : this.m_namespaceAliasComposed.get(string);
    }

    void recomposeTemplates(ElemTemplate elemTemplate) {
        this.m_templateList.setTemplate(elemTemplate);
    }

    public final TemplateList getTemplateListComposed() {
        return this.m_templateList;
    }

    public final void setTemplateListComposed(TemplateList templateList) {
        this.m_templateList = templateList;
    }

    public ElemTemplate getTemplateComposed(XPathContext xPathContext, int n, QName qName, boolean bl, DTM dTM) throws TransformerException {
        return this.m_templateList.getTemplate(xPathContext, n, qName, bl, dTM);
    }

    public ElemTemplate getTemplateComposed(XPathContext xPathContext, int n, QName qName, int n2, int n3, boolean bl, DTM dTM) throws TransformerException {
        return this.m_templateList.getTemplate(xPathContext, n, qName, n2, n3, bl, dTM);
    }

    public ElemTemplate getTemplateComposed(QName qName) {
        return this.m_templateList.getTemplate(qName);
    }

    void recomposeVariables(ElemVariable elemVariable) {
        ElemVariable elemVariable2 = this.getVariableOrParamComposed(elemVariable.getName());
        if (elemVariable2 == null) {
            elemVariable.setIsTopLevel(true);
            elemVariable.setIndex(this.m_variables.size());
            this.m_variables.addElement(elemVariable);
        } else {
            int n = elemVariable2.getStylesheetComposed().getImportCountComposed();
            int n2 = elemVariable.getStylesheetComposed().getImportCountComposed();
            if (n2 == n) {
                try {
                    elemVariable.warn(this.m_errorListener, "ER_DUPLICATE_GLOBAL_VAR", new Object[]{elemVariable.getName()}, null);
                }
                catch (TransformerException transformerException) {
                    throw new RuntimeException(transformerException.getMessage());
                }
            }
        }
    }

    public ElemVariable getVariableOrParamComposed(QName qName) {
        if (null != this.m_variables) {
            int n = this.m_variables.size();
            for (int i = 0; i < n; ++i) {
                ElemVariable elemVariable = (ElemVariable)this.m_variables.elementAt(i);
                if (!elemVariable.getName().equals(qName)) continue;
                return elemVariable;
            }
        }
        return null;
    }

    public Vector getVariablesAndParamsComposed() {
        return this.m_variables;
    }

    void recomposeWhiteSpaceInfo(WhiteSpaceInfo whiteSpaceInfo) {
        if (null == this.m_whiteSpaceInfoList) {
            this.m_whiteSpaceInfoList = new TemplateList();
        }
        this.m_whiteSpaceInfoList.setTemplate(whiteSpaceInfo);
    }

    public boolean shouldCheckWhitespace() {
        return null != this.m_whiteSpaceInfoList;
    }

    public WhiteSpaceInfo getWhiteSpaceInfo(XPathContext xPathContext, int n, DTM dTM) throws TransformerException {
        if (null != this.m_whiteSpaceInfoList) {
            return (WhiteSpaceInfo)this.m_whiteSpaceInfoList.getTemplate(xPathContext, n, null, false, dTM);
        }
        return null;
    }

    public boolean shouldStripWhiteSpace(XPathContext xPathContext, int n) throws TransformerException {
        if (null != this.m_whiteSpaceInfoList) {
            while (-1 != n) {
                DTM dTM = xPathContext.getDTM(n);
                WhiteSpaceInfo whiteSpaceInfo = (WhiteSpaceInfo)this.m_whiteSpaceInfoList.getTemplate(xPathContext, n, null, false, dTM);
                if (null != whiteSpaceInfo) {
                    return whiteSpaceInfo.getShouldStripSpace();
                }
                int n2 = dTM.getParent(n);
                if (-1 != n2 && 1 == dTM.getNodeType(n2)) {
                    n = n2;
                    continue;
                }
                n = -1;
            }
        }
        return false;
    }

    @Override
    public boolean canStripWhiteSpace() {
        return null != this.m_whiteSpaceInfoList;
    }

    public final ElemTemplate getDefaultTextRule() {
        return this.m_defaultTextRule;
    }

    public final ElemTemplate getDefaultRule() {
        return this.m_defaultRule;
    }

    public final ElemTemplate getDefaultRootRule() {
        return this.m_defaultRootRule;
    }

    public final ElemTemplate getStartRule() {
        return this.m_startRule;
    }

    private void initDefaultRule(ErrorListener errorListener) throws TransformerException {
        this.m_defaultRule = new ElemTemplate();
        this.m_defaultRule.setStylesheet(this);
        XPath xPath = new XPath("*", this, this, 1, errorListener);
        this.m_defaultRule.setMatch(xPath);
        ElemApplyTemplates elemApplyTemplates = new ElemApplyTemplates();
        elemApplyTemplates.setIsDefaultTemplate(true);
        elemApplyTemplates.setSelect(this.m_selectDefault);
        this.m_defaultRule.appendChild(elemApplyTemplates);
        this.m_startRule = this.m_defaultRule;
        this.m_defaultTextRule = new ElemTemplate();
        this.m_defaultTextRule.setStylesheet(this);
        xPath = new XPath("text() | @*", this, this, 1, errorListener);
        this.m_defaultTextRule.setMatch(xPath);
        ElemValueOf elemValueOf = new ElemValueOf();
        this.m_defaultTextRule.appendChild(elemValueOf);
        XPath xPath2 = new XPath(".", this, this, 0, errorListener);
        elemValueOf.setSelect(xPath2);
        this.m_defaultRootRule = new ElemTemplate();
        this.m_defaultRootRule.setStylesheet(this);
        xPath = new XPath("/", this, this, 1, errorListener);
        this.m_defaultRootRule.setMatch(xPath);
        elemApplyTemplates = new ElemApplyTemplates();
        elemApplyTemplates.setIsDefaultTemplate(true);
        this.m_defaultRootRule.appendChild(elemApplyTemplates);
        elemApplyTemplates.setSelect(this.m_selectDefault);
    }

    private void QuickSort2(Vector vector, int n, int n2) {
        int n3 = n;
        int n4 = n2;
        if (n2 > n) {
            ElemTemplateElement elemTemplateElement = (ElemTemplateElement)vector.elementAt((n + n2) / 2);
            while (n3 <= n4) {
                while (n3 < n2 && ((ElemTemplateElement)vector.elementAt(n3)).compareTo(elemTemplateElement) < 0) {
                    ++n3;
                }
                while (n4 > n && ((ElemTemplateElement)vector.elementAt(n4)).compareTo(elemTemplateElement) > 0) {
                    --n4;
                }
                if (n3 > n4) continue;
                ElemTemplateElement elemTemplateElement2 = (ElemTemplateElement)vector.elementAt(n3);
                vector.setElementAt(vector.elementAt(n4), n3);
                vector.setElementAt(elemTemplateElement2, n4);
                ++n3;
                --n4;
            }
            if (n < n4) {
                this.QuickSort2(vector, n, n4);
            }
            if (n3 < n2) {
                this.QuickSort2(vector, n3, n2);
            }
        }
    }

    void initComposeState() {
        this.m_composeState = new ComposeState();
    }

    ComposeState getComposeState() {
        return this.m_composeState;
    }

    private void clearComposeState() {
        this.m_composeState = null;
    }

    public String setExtensionHandlerClass(String string) {
        String string2 = this.m_extensionHandlerClass;
        this.m_extensionHandlerClass = string;
        return string2;
    }

    public String getExtensionHandlerClass() {
        return this.m_extensionHandlerClass;
    }

    public boolean getOptimizer() {
        return this.m_optimizer;
    }

    public void setOptimizer(boolean bl) {
        this.m_optimizer = bl;
    }

    public boolean getIncremental() {
        return this.m_incremental;
    }

    public boolean getSource_location() {
        return this.m_source_location;
    }

    public void setIncremental(boolean bl) {
        this.m_incremental = bl;
    }

    public void setSource_location(boolean bl) {
        this.m_source_location = bl;
    }

    public ExternalResourceHelper.ProtocolValidator getStylesheetProtocolValidator() {
        return this.m_stylesheet_protocol_validator;
    }

    public void setStylesheetProtocolValidator(ExternalResourceHelper.ProtocolValidator protocolValidator) {
        this.m_stylesheet_protocol_validator = protocolValidator;
    }

    public String getAllowedDTDProtocols() {
        return this.m_allowedDTDProtocols;
    }

    public void setAllowedDTDProtocols(String string) {
        this.m_allowedDTDProtocols = string;
    }

    class ComposeState {
        private ExpandedNameTable m_ent = new ExpandedNameTable();
        private Vector m_variableNames = new Vector();
        IntStack m_marks = new IntStack();
        private int m_maxStackFrameSize;

        ComposeState() {
            int n = StylesheetRoot.this.m_variables.size();
            for (int i = 0; i < n; ++i) {
                ElemVariable elemVariable = (ElemVariable)StylesheetRoot.this.m_variables.elementAt(i);
                this.m_variableNames.addElement(elemVariable.getName());
            }
        }

        public int getQNameID(QName qName) {
            return this.m_ent.getExpandedTypeID(qName.getNamespace(), qName.getLocalName(), 1);
        }

        int addLocalVariable(ElemVariable elemVariable) {
            int n;
            QName qName = elemVariable.getName();
            boolean bl = false;
            for (n = this.getGlobalsSize(); n < this.m_variableNames.size(); ++n) {
                if (!this.m_variableNames.get(n).equals(qName)) continue;
                bl = true;
                break;
            }
            if (bl) {
                try {
                    elemVariable.warn(StylesheetRoot.this.m_errorListener, "ER_DUPLICATE_VAR", new Object[]{elemVariable.getName()}, null);
                }
                catch (TransformerException transformerException) {
                    throw new RuntimeException(transformerException.getMessage());
                }
            }
            n = this.m_variableNames.size();
            this.m_variableNames.addElement(qName);
            int n2 = this.m_variableNames.size() - this.getGlobalsSize();
            if (n2 > this.m_maxStackFrameSize) {
                ++this.m_maxStackFrameSize;
            }
            return n;
        }

        void resetStackFrameSize() {
            this.m_maxStackFrameSize = 0;
        }

        int getFrameSize() {
            return this.m_maxStackFrameSize;
        }

        int getCurrentStackFrameSize() {
            return this.m_variableNames.size();
        }

        void setCurrentStackFrameSize(int n) {
            this.m_variableNames.setSize(n);
        }

        int getGlobalsSize() {
            return StylesheetRoot.this.m_variables.size();
        }

        void pushStackMark() {
            this.m_marks.push(this.getCurrentStackFrameSize());
        }

        void popStackMark() {
            int n = this.m_marks.pop();
            this.setCurrentStackFrameSize(n);
        }

        Vector getVariableNames() {
            return this.m_variableNames;
        }
    }
}

