/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.provider;

import java.math.BigInteger;
import java.security.spec.ECField;
import java.security.spec.ECFieldF2m;
import java.security.spec.ECFieldFp;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;

public class ECUtils {
    public static final int EC_SIZE_192 = 192;
    public static final int EC_SIZE_224 = 224;
    public static final int EC_SIZE_256 = 256;
    public static final int EC_SIZE_384 = 384;
    public static final int EC_SIZE_521 = 521;
    private static final String[] z;

    protected static ECPoint a(ECPoint eCPoint, EllipticCurve ellipticCurve) {
        ECFieldFp eCFieldFp = (ECFieldFp)ellipticCurve.getField();
        BigInteger bigInteger = eCFieldFp.getP();
        return new ECPoint(eCPoint.getAffineX(), eCPoint.getAffineY().negate().mod(bigInteger));
    }

    protected static ECPoint a(ECPoint eCPoint, ECPoint eCPoint2, EllipticCurve ellipticCurve) {
        ECPoint eCPoint3 = ECUtils.a(eCPoint2, ellipticCurve);
        eCPoint3 = ECUtils.b(eCPoint, eCPoint3, ellipticCurve);
        return eCPoint3;
    }

    protected static ECPoint b(ECPoint eCPoint, ECPoint eCPoint2, EllipticCurve ellipticCurve) {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        ECFieldFp eCFieldFp = (ECFieldFp)ellipticCurve.getField();
        BigInteger bigInteger3 = eCFieldFp.getP();
        BigInteger bigInteger4 = new BigInteger("0");
        if (eCPoint2 == null) {
            return eCPoint;
        }
        if (eCPoint == null) {
            return eCPoint2;
        }
        ECPoint eCPoint3 = ECUtils.a(eCPoint2, ellipticCurve);
        if (eCPoint.equals(eCPoint3)) {
            return null;
        }
        if (!eCPoint.equals(eCPoint2)) {
            bigInteger2 = eCPoint2.getAffineY().subtract(eCPoint.getAffineY());
            bigInteger = eCPoint2.getAffineX().subtract(eCPoint.getAffineX()).modInverse(bigInteger3);
            bigInteger4 = bigInteger2.multiply(bigInteger).mod(bigInteger3);
        } else if (eCPoint.equals(eCPoint2) && eCPoint.getAffineY().compareTo(BigInteger.ZERO) != 0) {
            bigInteger2 = eCPoint.getAffineX().modPow(new BigInteger("2"), bigInteger3).multiply(new BigInteger("3")).add(ellipticCurve.getA());
            bigInteger = eCPoint.getAffineY().multiply(new BigInteger("2")).modInverse(bigInteger3);
            bigInteger4 = bigInteger2.multiply(bigInteger).mod(bigInteger3);
        } else {
            return null;
        }
        bigInteger2 = bigInteger4.modPow(new BigInteger("2"), bigInteger3).subtract(eCPoint.getAffineX()).subtract(eCPoint2.getAffineX()).mod(bigInteger3);
        bigInteger = bigInteger4.multiply(eCPoint.getAffineX().subtract(bigInteger2)).subtract(eCPoint.getAffineY()).mod(bigInteger3);
        return new ECPoint(bigInteger2, bigInteger);
    }

    protected static ECPoint a(BigInteger bigInteger, ECPoint eCPoint, EllipticCurve ellipticCurve) {
        ECPoint eCPoint2 = new ECPoint(eCPoint.getAffineX(), eCPoint.getAffineY());
        ECPoint eCPoint3 = new ECPoint(eCPoint.getAffineX(), eCPoint.getAffineY());
        BigInteger bigInteger2 = bigInteger.subtract(BigInteger.ONE);
        BigInteger bigInteger3 = BigInteger.ZERO;
        while (bigInteger3.compareTo(bigInteger2) < 0) {
            eCPoint3 = ECUtils.b(eCPoint2, eCPoint3, ellipticCurve);
            bigInteger3 = bigInteger3.add(BigInteger.ONE);
        }
        return eCPoint3;
    }

    protected static ECPoint b(BigInteger bigInteger, ECPoint eCPoint, EllipticCurve ellipticCurve) {
        BigInteger bigInteger2 = new BigInteger("2");
        ECPoint eCPoint2 = eCPoint;
        ECPoint eCPoint3 = eCPoint;
        ECPoint eCPoint4 = eCPoint;
        if (bigInteger.compareTo(bigInteger2) != 1) {
            return ECUtils.a(bigInteger, eCPoint, ellipticCurve);
        }
        String string = bigInteger.toString(2);
        char[] cArray = string.toCharArray();
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (i2 == 0) continue;
            eCPoint4 = cArray[i2] == '0' ? ECUtils.b(eCPoint4, eCPoint4, ellipticCurve) : ECUtils.b(eCPoint, ECUtils.b(eCPoint4, eCPoint4, ellipticCurve), ellipticCurve);
        }
        eCPoint2 = eCPoint4;
        return eCPoint2;
    }

    protected static String a(ECPoint eCPoint) {
        StringBuffer stringBuffer = new StringBuffer("[");
        stringBuffer.append(eCPoint.getAffineX().toString());
        stringBuffer.append(",");
        stringBuffer.append(eCPoint.getAffineY().toString());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    protected static String a(EllipticCurve ellipticCurve) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(z[2]);
        stringBuffer.append(ECUtils.a(ellipticCurve.getField()));
        stringBuffer.append(z[1] + ellipticCurve.getA());
        stringBuffer.append(z[0] + ellipticCurve.getB());
        stringBuffer.append("#");
        return stringBuffer.toString();
    }

    protected static String a(ECField eCField) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(z[4] + eCField.getFieldSize());
        if (eCField instanceof ECFieldFp) {
            ECFieldFp eCFieldFp = (ECFieldFp)eCField;
            stringBuffer.append(z[3] + eCFieldFp.getP());
        } else if (eCField instanceof ECFieldF2m) {
            ECFieldF2m eCFieldF2m = (ECFieldF2m)eCField;
            stringBuffer.append(z[5] + eCFieldF2m.getM());
            stringBuffer.append(z[6] + eCFieldF2m.getReductionPolynomial());
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[7];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "\f0p\u0015";
        int n3 = -1;
        block14: while (true) {
            char[] cArray;
            block18: {
                int n4;
                int n5;
                block17: {
                    char[] cArray2 = string2.toCharArray();
                    cArray = cArray2;
                    n5 = cArray2.length;
                    n4 = 0;
                    if (!true) break block17;
                    n5 = n5;
                    if (n5 <= n4) break block18;
                }
                do {
                    int n6;
                    cArray = cArray;
                    int n7 = n4;
                    char c2 = cArray[n7];
                    switch (n4 % 5) {
                        case 0: {
                            n6 = 5;
                            break;
                        }
                        case 1: {
                            n6 = 82;
                            break;
                        }
                        case 2: {
                            n6 = 74;
                            break;
                        }
                        case 3: {
                            n6 = 53;
                            break;
                        }
                        default: {
                            n6 = 40;
                        }
                    }
                    cArray[n7] = (char)(c2 ^ n6);
                    ++n4;
                    n5 = n5;
                } while (n5 > n4);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "\f3p\u0015";
                    n3 = 0;
                    continue block14;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "&\u0017&YAu&#Vkp <P\b";
                    n3 = 1;
                    continue block14;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "\f\"p\u0015";
                    n3 = 2;
                    continue block14;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "~\u0017\tsA`>.\u0015!v;0P\u0012%";
                    n3 = 3;
                    continue block14;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "\f?p\u0015";
                    n3 = 4;
                    continue block14;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "\f /Q]f&#ZF%\"%YQk='\\Iihj";
                    n3 = 5;
                    continue block14;
                }
                case 5: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

