/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.provider;

import com.ibm.crypto.provider.ByteAdder;
import com.ibm.crypto.provider.IHashDrbg;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.security.SecureRandomSpi;

public class HASHDRBG
extends SecureRandomSpi
implements IHashDrbg {
    private static final long serialVersionUID = 2596920209735836086L;
    public static final int MIN_STRENGTH = 112;
    public static final int MAX_STRENGTH = 256;
    public static final int SHA1_MAX_STRENGTH = 128;
    public static final int SHA224_MAX_STRENGTH = 192;
    public static final int MIN_SEED_LENGTH = 440;
    public static final int MAX_SEED_LENGTH = 888;
    public static final String DEFAULT_DIGEST_ALG;
    public static final int DEFAULT_STRENGTH = 256;
    private static final int MIN_SEED_BYTES = 55;
    private static final int MAX_SEED_BYTES = 111;
    private static final long MAX_UNTIL_RESEED = 0x1000000000000L;
    protected String hashAlgName;
    protected int security_strength = 0;
    protected int ss_bytes = 0;
    protected int seed_byte_count;
    protected ByteBuffer entropy;
    protected MessageDigest hash;
    private int seedlen;
    private int outlenbits;
    protected byte[] V;
    protected byte[] C;
    protected long reseed_counter = 0L;
    protected SecureRandom sr;
    protected boolean resistant;
    protected boolean initDone;
    private static final String[] z;

    public HASHDRBG() {
    }

    protected HASHDRBG(String string, int n2) {
        this.security_strength = n2;
        if (n2 < 112) {
            throw new IllegalArgumentException(z[8]);
        }
        if (n2 > 256) {
            throw new IllegalArgumentException(z[9]);
        }
        this.hashAlgName = string;
        try {
            this.hash = MessageDigest.getInstance(string, z[7]);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(exception);
        }
    }

    @Override
    protected byte[] engineGenerateSeed(int n2) {
        byte[] byArray = new byte[n2];
        this.engineNextBytes(byArray);
        return byArray;
    }

    @Override
    protected void engineNextBytes(byte[] byArray) {
        byte[] byArray2;
        if (!this.initDone) {
            if (this.hashAlgName == null) {
                this.hashAlgName = DEFAULT_DIGEST_ALG;
            }
            if (this.security_strength >= 0) {
                this.security_strength = 256;
            }
            this.engineSetSeed(null);
        }
        if ((byArray2 = this.generate(byArray.length, false, null)).length != byArray.length) {
            throw new IllegalStateException(z[10]);
        }
        System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
    }

    @Override
    protected void engineSetSeed(byte[] byArray) {
        if (byArray == null) {
            byArray = this.b(this.ss_bytes);
        }
        if (!this.initDone) {
            if (this.hashAlgName == null) {
                this.init(DEFAULT_DIGEST_ALG, 256, ByteBuffer.wrap(byArray), false);
            } else {
                this.init(this.hashAlgName, this.security_strength, ByteBuffer.wrap(byArray), false);
            }
            if (byArray.length < this.ss_bytes) {
                throw new IllegalArgumentException(z[14] + this.ss_bytes + z[13]);
            }
        } else {
            this.entropy = ByteBuffer.wrap(byArray, 0, this.ss_bytes);
        }
        if (this.reseed_counter < 1L) {
            byte[] byArray2 = new byte[]{};
            if (byArray.length > this.ss_bytes) {
                byArray2 = new byte[byArray.length - this.ss_bytes];
                System.arraycopy(byArray, this.ss_bytes, byArray2, 0, byArray.length - this.ss_bytes);
            }
            this.instantiate(byArray2, null);
        } else {
            this.reseed(null);
        }
    }

    @Override
    public int init(String string, int n2, ByteBuffer byteBuffer, boolean bl) throws IllegalArgumentException {
        if (string == null || !string.startsWith(z[2])) {
            throw new IllegalArgumentException(z[5]);
        }
        if (this.hashAlgName != null && !this.hashAlgName.equalsIgnoreCase(string)) {
            throw new IllegalStateException(z[4]);
        }
        try {
            this.hash = MessageDigest.getInstance(string, z[7]);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(exception);
        }
        byte[] byArray = this.hash.digest();
        this.seed_byte_count = 55;
        this.seedlen = 440;
        if (byArray == null || byArray.length < 20) {
            throw new IllegalArgumentException(z[3]);
        }
        this.outlenbits = byArray.length << 3;
        this.ss_bytes = n2 >> 3;
        if (this.ss_bytes << 3 != n2) {
            throw new IllegalArgumentException(z[6]);
        }
        if (n2 <= 112) {
            n2 = 112;
        } else if (byArray.length == 20) {
            if (n2 > 128) {
                throw new IllegalArgumentException(z[3]);
            }
            this.security_strength = 128;
        } else if (byArray.length == 28) {
            if (n2 > 192) {
                throw new IllegalArgumentException(z[3]);
            }
            if (n2 > 112 && n2 <= 128) {
                this.security_strength = 128;
            } else if (n2 > 128 && n2 <= 192) {
                this.security_strength = 192;
            }
        } else {
            if (byArray.length > 32) {
                this.seed_byte_count = 111;
                this.seedlen = 888;
            }
            if (n2 > 256) {
                throw new IllegalArgumentException(z[3]);
            }
            if (n2 > 112 && n2 <= 128) {
                this.security_strength = 128;
            } else if (n2 > 128 && n2 <= 192) {
                this.security_strength = 192;
            } else if (n2 > 192 && n2 <= 256) {
                this.security_strength = 256;
            }
        }
        this.entropy = byteBuffer;
        this.resistant = bl;
        this.initDone = true;
        return this.security_strength;
    }

    @Override
    public void instantiate(byte[] byArray, byte[] byArray2) {
        int n2 = 0;
        int n3 = 0;
        if (byArray2 != null) {
            n2 = byArray2.length;
        }
        if (byArray != null) {
            n3 = byArray.length;
        }
        byte[] byArray3 = null;
        if (this.entropy == null || this.entropy.remaining() == 0) {
            byArray3 = this.b(0);
        } else {
            byArray3 = new byte[this.ss_bytes];
            try {
                this.entropy.get(byArray3);
            }
            catch (Exception exception) {
                throw new IllegalStateException(z[0], exception);
            }
        }
        byte[] byArray4 = new byte[byArray3.length + n3 + n2];
        System.arraycopy(byArray3, 0, byArray4, 0, byArray3.length);
        if (n3 > 0) {
            System.arraycopy(byArray, 0, byArray4, byArray3.length, byArray.length);
        }
        if (n2 != 0) {
            System.arraycopy(byArray2, 0, byArray4, byArray3.length + n3, n2);
        }
        this.V = this.a(this.hash, this.outlenbits, byArray4, this.seedlen);
        byte[] byArray5 = new byte[this.V.length + 1];
        byArray5[0] = 0;
        System.arraycopy(this.V, 0, byArray5, 1, this.V.length);
        this.C = this.a(this.hash, this.outlenbits, byArray5, this.seedlen);
        this.reseed_counter = 1L;
    }

    @Override
    public byte[] generate(int n2, boolean bl, byte[] byArray) {
        int n3 = n2 << 3;
        if (bl && !this.resistant) {
            throw new IllegalArgumentException(z[11]);
        }
        if (this.reseed_counter >= 0x1000000000000L || bl) {
            this.reseed(byArray);
            byArray = null;
        }
        byte[] byArray2 = null;
        if (byArray != null) {
            byte[] byArray3 = null;
            this.hash.update((byte)2);
            this.hash.update(this.V);
            byArray3 = this.hash.digest(byArray);
            this.V = ByteAdder.add(this.seed_byte_count, this.V, byArray3);
        }
        int n4 = this.a(n3, this.outlenbits);
        byte[] byArray4 = (byte[])this.V.clone();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (int i2 = 1; i2 <= n4; ++i2) {
            try {
                byteArrayOutputStream.write(this.hash.digest(byArray4));
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
            byArray4 = ByteAdder.add(this.seed_byte_count, byArray4, HASHDRBG.a(1));
        }
        byArray2 = byteArrayOutputStream.toByteArray();
        if (byArray2.length > n2) {
            byte[] byArray5 = new byte[n2];
            System.arraycopy(byArray2, 0, byArray5, 0, n2);
            byArray2 = byArray5;
        }
        byte[] byArray6 = null;
        this.hash.update((byte)3);
        byArray6 = this.hash.digest(this.V);
        this.V = ByteAdder.add(this.seed_byte_count, this.V, byArray6, this.C, HASHDRBG.a((int)this.reseed_counter));
        ++this.reseed_counter;
        return byArray2;
    }

    @Override
    public void reseed(byte[] byArray) {
        int n2 = 0;
        if (byArray != null) {
            n2 = byArray.length;
        }
        byte[] byArray2 = new byte[this.ss_bytes];
        try {
            this.entropy.get(byArray2);
        }
        catch (Exception exception) {
            throw new IllegalStateException(z[0], exception);
        }
        byte[] byArray3 = new byte[1 + this.V.length + byArray2.length + n2];
        byArray3[0] = 1;
        int n3 = 1;
        System.arraycopy(this.V, 0, byArray3, n3, this.V.length);
        System.arraycopy(byArray2, 0, byArray3, n3 += this.V.length, byArray2.length);
        n3 += byArray2.length;
        if (n2 != 0) {
            System.arraycopy(byArray, 0, byArray3, n3, n2);
        }
        this.V = this.a(this.hash, this.outlenbits, byArray3, this.seedlen);
        byte[] byArray4 = new byte[this.V.length + 1];
        byArray4[0] = 0;
        System.arraycopy(this.V, 0, byArray4, 1, this.V.length);
        this.C = this.a(this.hash, this.outlenbits, byArray4, this.seedlen);
        this.reseed_counter = 1L;
    }

    private byte[] a(MessageDigest messageDigest, int n2, byte[] byArray, int n3) {
        byte[] byArray2 = null;
        int n4 = this.a(n3, n2);
        int n5 = n3 + 7 >> 3;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n5);
        for (int i2 = 1; i2 <= n4; ++i2) {
            messageDigest.update((byte)i2);
            messageDigest.update(HASHDRBG.a(n3));
            try {
                byteArrayOutputStream.write(messageDigest.digest(byArray));
                continue;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        byArray2 = byteArrayOutputStream.toByteArray();
        if (byArray2.length > n5) {
            byte[] byArray3 = byArray2;
            byArray2 = new byte[n5];
            System.arraycopy(byArray3, 0, byArray2, 0, byArray2.length);
        }
        return byArray2;
    }

    private static final void a(int n2, byte[] byArray, int n3) {
        byArray[n3] = (byte)(n2 >>> 24);
        byArray[n3 + 1] = (byte)(n2 >>> 16);
        byArray[n3 + 2] = (byte)(n2 >>> 8);
        byArray[n3 + 3] = (byte)n2;
    }

    private static final byte[] a(int n2) {
        byte[] byArray = new byte[4];
        HASHDRBG.a(n2, byArray, 0);
        return byArray;
    }

    private int a(int n2, int n3) {
        int n4;
        if (n3 <= 0) {
            throw new IllegalArgumentException(z[1]);
        }
        if (n2 < 0) {
            n2 = -n2;
        }
        if ((n4 = n2 / n3) * n3 != n2) {
            ++n4;
        }
        return n4;
    }

    private byte[] b(int n2) {
        if (n2 <= 0) {
            n2 = 256;
        }
        if (this.sr == null) {
            try {
                this.sr = SecureRandom.getInstance(z[12], z[7]);
            }
            catch (Exception exception) {
                throw new IllegalStateException(exception);
            }
        }
        return this.sr.generateSeed(n2);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[15];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "\";\b#fDE";
        int n3 = 14;
        block23: while (true) {
            char[] cArray;
            block27: {
                int n4;
                int n5;
                block26: {
                    char[] cArray2 = string2.toCharArray();
                    cArray = cArray2;
                    n5 = cArray2.length;
                    n4 = 0;
                    if (!true) break block26;
                    n5 = n5;
                    if (n5 <= n4) break block27;
                }
                do {
                    int n6;
                    cArray = cArray;
                    int n7 = n4;
                    char c2 = cArray[n7];
                    switch (n4 % 5) {
                        case 0: {
                            n6 = 113;
                            break;
                        }
                        case 1: {
                            n6 = 115;
                            break;
                        }
                        case 2: {
                            n6 = 73;
                            break;
                        }
                        case 3: {
                            n6 = 14;
                            break;
                        }
                        default: {
                            n6 = 84;
                        }
                    }
                    cArray[n7] = (char)(c2 ^ n6);
                    ++n4;
                    n5 = n5;
                } while (n5 > n4);
            }
            string = new String(cArray);
            switch (n3) {
                case 14: {
                    DEFAULT_DIGEST_ALG = string.intern();
                    string2 = "\u001f\u001c=.1\u001f\u001c<i<Q\u0016'z&\u001e\u00030";
                    n3 = -1;
                    continue block23;
                }
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "\u0002\u0007;g0\u0014S }tMNit1\u0003\u001c";
                    n3 = 0;
                    continue block23;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "\";\b";
                    n3 = 1;
                    continue block23;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "\u0010\u001f.a&\u0018\u0007!ct\u001f\u001c=.'\u0005\u0001&`3Q\u0016'a!\u0016\u001b";
                    n3 = 2;
                    continue block23;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "\u0012\u0012'`;\u0005S `=\u0005S>g \u0019S-g2\u0017\u0016;k:\u0005S!o'\u0019S(b3\u001e\u0001 z<\u001c";
                    n3 = 3;
                    continue block23;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "\u001e\u001d%wt\u0002\u00069~;\u0003\u0007iz<\u0014S\u001aF\u0015Q\u0015(c=\u001d\n";
                    n3 = 4;
                    continue block23;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "\u001f\u0016,jt\u0013\n=kt\u001c\u0006%z=\u0001\u001f,.2\u001e\u0001il=\u0005 =|1\u001f\u0014=f\u0006\u0014\u0002<k'\u0005\u0016-";
                    n3 = 5;
                    continue block23;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "81\u0004D\u00174";
                    n3 = 6;
                    continue block23;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "\u0005\u001c&.#\u0014\u0012\"";
                    n3 = 7;
                    continue block23;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = "\u0005\u001c&.'\u0005\u0001&`3";
                    n3 = 8;
                    continue block23;
                }
                case 8: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 10;
                    string2 = "8\u001d=k&\u001f\u0012%.1\u0003\u0001&|xQ\u0004;a:\u0016S%k:\u0016\u0007!.;\u0004\u00079{ Q\u0014,`1\u0003\u0012=k0";
                    n3 = 9;
                    continue block23;
                }
                case 9: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 11;
                    string2 = "\u0001\u0001,j=\u0012\u0007 a:Q\u0001,}=\u0002\u0007(`7\u0014S*o$\u0010\u0011 b=\u0005\ni`;\u0005S `'\u0005\u0012'z=\u0010\u0007,j";
                    n3 = 10;
                    continue block23;
                }
                case 10: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 12;
                    string2 = "\";\b?\u0004#=\u000e";
                    n3 = 11;
                    continue block23;
                }
                case 11: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 13;
                    string2 = "Q\u00110z1\u0002S&ht\u0014\u001d=|;\u0001\n";
                    n3 = 12;
                    continue block23;
                }
                case 12: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 14;
                    string2 = "\u001f\u0016,jt\u0010\u0007ib1\u0010\u0000=.";
                    n3 = 13;
                    continue block23;
                }
                case 13: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

