/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.provider;

import com.ibm.crypto.provider.RSAKeyFactory;
import com.ibm.crypto.provider.RSAPrivateCrtKey;
import com.ibm.crypto.provider.RSAPublicKey;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.RSAKeyGenParameterSpec;

public final class RSAKeyPairGenerator
extends KeyPairGeneratorSpi {
    private BigInteger a;
    private int b = 2048;
    SecureRandom c = null;
    private static final String[] z;

    @Override
    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (!(algorithmParameterSpec instanceof RSAKeyGenParameterSpec)) {
            throw new InvalidAlgorithmParameterException(z[3]);
        }
        RSAKeyGenParameterSpec rSAKeyGenParameterSpec = (RSAKeyGenParameterSpec)algorithmParameterSpec;
        int n2 = rSAKeyGenParameterSpec.getKeysize();
        this.a = rSAKeyGenParameterSpec.getPublicExponent();
        this.c = secureRandom;
        if (n2 % 8 != 0) {
            throw new InvalidAlgorithmParameterException(z[2]);
        }
        try {
            RSAKeyFactory.checkKeyLengths(n2, this.a, 512, 65536);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InvalidAlgorithmParameterException(z[0], invalidKeyException);
        }
        this.b = n2;
        if (this.a == null) {
            this.a = RSAKeyGenParameterSpec.F4;
        } else {
            if (this.a.compareTo(RSAKeyGenParameterSpec.F0) < 0) {
                throw new InvalidAlgorithmParameterException(z[4]);
            }
            if (this.a.bitLength() > n2) {
                throw new InvalidAlgorithmParameterException(z[5]);
            }
        }
    }

    @Override
    public void initialize(int n2, SecureRandom secureRandom) {
        if (n2 % 8 != 0) {
            throw new InvalidParameterException(z[2]);
        }
        try {
            RSAKeyFactory.checkKeyLengths(n2, RSAKeyGenParameterSpec.F4, 512, 65536);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InvalidParameterException(invalidKeyException.getMessage());
        }
        this.b = n2;
        this.c = secureRandom;
        this.a = RSAKeyGenParameterSpec.F4;
    }

    public void initialize(int n2) {
        if (n2 % 8 != 0) {
            throw new InvalidParameterException(z[2]);
        }
        this.b = n2;
        try {
            this.c = SecureRandom.getInstance(z[1]);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            this.c = new SecureRandom();
        }
        this.a = RSAKeyGenParameterSpec.F4;
        try {
            RSAKeyFactory.checkKeyLengths(this.b, this.a, 512, 65536);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InvalidParameterException(z[0]);
        }
    }

    @Override
    public KeyPair generateKeyPair() {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        BigInteger bigInteger3;
        BigInteger bigInteger4;
        BigInteger bigInteger5;
        BigInteger bigInteger6;
        int n2;
        if (this.c == null) {
            this.c = null;
            try {
                this.c = SecureRandom.getInstance(z[1]);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                this.c = new SecureRandom();
            }
        }
        BigInteger bigInteger7 = this.a != null ? this.a : RSAKeyGenParameterSpec.F4;
        while ((n2 = (bigInteger6 = (bigInteger5 = new BigInteger(this.b / 2, 10, this.c)).multiply(bigInteger4 = new BigInteger(this.b / 2, 10, this.c))).bitLength()) != this.b || !bigInteger7.gcd(bigInteger3 = (bigInteger2 = bigInteger5.subtract(BigInteger.ONE)).multiply(bigInteger = bigInteger4.subtract(BigInteger.ONE))).equals(BigInteger.ONE)) {
        }
        BigInteger bigInteger8 = bigInteger7.modInverse(bigInteger3);
        BigInteger bigInteger9 = bigInteger8.mod(bigInteger2);
        BigInteger bigInteger10 = bigInteger8.mod(bigInteger);
        BigInteger bigInteger11 = bigInteger4.modInverse(bigInteger5);
        try {
            RSAPublicKey rSAPublicKey = new RSAPublicKey(bigInteger6, bigInteger7);
            RSAPrivateCrtKey rSAPrivateCrtKey = new RSAPrivateCrtKey(bigInteger6, bigInteger8, bigInteger7, bigInteger5, bigInteger4, bigInteger9, bigInteger10, bigInteger11);
            return new KeyPair(rSAPublicKey, rSAPrivateCrtKey);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new ProviderException(invalidKeyException.getMessage());
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[6];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "\"J\r\u001aL\u0002@[\u0010E\u0012\u0004\b\u0012Z\u000eW";
        int n3 = -1;
        block13: while (true) {
            char[] cArray;
            block17: {
                int n4;
                int n5;
                block16: {
                    char[] cArray2 = string2.toCharArray();
                    cArray = cArray2;
                    n5 = cArray2.length;
                    n4 = 0;
                    if (!true) break block16;
                    n5 = n5;
                    if (n5 <= n4) break block17;
                }
                do {
                    int n6;
                    cArray = cArray;
                    int n7 = n4;
                    char c2 = cArray[n7];
                    switch (n4 % 5) {
                        case 0: {
                            n6 = 107;
                            break;
                        }
                        case 1: {
                            n6 = 36;
                            break;
                        }
                        case 2: {
                            n6 = 123;
                            break;
                        }
                        case 3: {
                            n6 = 123;
                            break;
                        }
                        default: {
                            n6 = 32;
                        }
                    }
                    cArray[n7] = (char)(c2 ^ n6);
                    ++n4;
                    n5 = n5;
                } while (n5 > n4);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "\"f6(E\bQ\t\u001er\nJ\u001f\u0014M";
                    n3 = 0;
                    continue block13;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "&K\u001f\u000eL\u001eW[\bI\u0011A[\u0016U\u0018P[\u0019EKI\u000e\u0017T\u0002T\u0017\u001e\u0000\u0004B[C";
                    n3 = 1;
                    continue block13;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = ";E\t\u001aM\u0018\u0004\u0016\u000eS\u001f\u0004\u0019\u001e\u0000\u0002J\b\u000fA\u0005G\u001e[O\r\u0004)(a A\u0002<E\u0005t\u001a\tA\u0006A\u000f\u001eR8T\u001e\u0018";
                    n3 = 2;
                    continue block13;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = ";Q\u0019\u0017I\b\u0004\u001e\u0003P\u0004J\u001e\u0015TKI\u000e\bTKF\u001e[\u0013KK\t[L\nV\u001c\u001eR";
                    n3 = 3;
                    continue block13;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = ";Q\u0019\u0017I\b\u0004\u001e\u0003P\u0004J\u001e\u0015TKI\u000e\bTKF\u001e[S\u0006E\u0017\u0017E\u0019\u0004\u000f\u0013A\u0005\u0004\u0010\u001eYKW\u0012\u0001E";
                    n3 = 4;
                    continue block13;
                }
                case 4: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

