/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.provider;

import com.ibm.crypto.provider.JCAUtil;
import com.ibm.crypto.provider.RSACore;
import com.ibm.crypto.provider.RSAKeyFactory;
import com.ibm.crypto.provider.RSAPadding;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.AlgorithmParameters;
import java.security.DigestException;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.interfaces.RSAKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PSSParameterSpec;
import java.util.Arrays;
import javax.crypto.BadPaddingException;

public class RSAPSSSignature
extends SignatureSpi {
    protected SecureRandom a;
    double b = 0.0;
    private int c;
    private double d;
    private final MessageDigest e;
    private MessageDigest f;
    private boolean g;
    private RSAPadding h;
    private RSAPrivateKey i;
    private RSAPublicKey j;
    PSSParameterSpec k = PSSParameterSpec.DEFAULT;
    private static final String[] z;

    RSAPSSSignature(PSSParameterSpec pSSParameterSpec) {
        this.k = pSSParameterSpec;
        try {
            this.e = MessageDigest.getInstance(pSSParameterSpec.getDigestAlgorithm());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new ProviderException(noSuchAlgorithmException);
        }
        this.g = true;
    }

    public RSAPSSSignature() {
        this(new PSSParameterSpec(z[15], z[14], MGF1ParameterSpec.SHA1, 20, 1));
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        RSAPublicKey rSAPublicKey = (RSAPublicKey)RSAKeyFactory.toRSAKey(publicKey);
        this.i = null;
        this.j = rSAPublicKey;
        this.a = JCAUtil.getSecureRandom();
        this.b = rSAPublicKey.getModulus().bitLength();
        this.d = this.b - 1.0;
        this.c = (int)Math.ceil(this.d / 8.0);
        this.a(rSAPublicKey, this.a);
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        this.a = JCAUtil.getSecureRandom();
        this.engineInitSign(privateKey, this.a);
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey, SecureRandom secureRandom) throws InvalidKeyException {
        RSAPrivateKey rSAPrivateKey = (RSAPrivateKey)RSAKeyFactory.toRSAKey(privateKey);
        this.b = rSAPrivateKey.getModulus().bitLength();
        this.d = this.b - 1.0;
        this.c = (int)Math.ceil(this.d / 8.0);
        this.i = rSAPrivateKey;
        this.j = null;
        this.a(rSAPrivateKey, secureRandom);
    }

    private void a(RSAKey rSAKey, SecureRandom secureRandom) throws InvalidKeyException {
        int n2 = RSACore.getByteLength(rSAKey);
        try {
            this.h = RSAPadding.getInstance(5, n2, secureRandom);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InvalidKeyException(invalidAlgorithmParameterException.getMessage());
        }
        this.a();
    }

    private void a() {
        this.e.reset();
        this.g = true;
    }

    private byte[] b() {
        this.g = true;
        return this.e.digest();
    }

    @Override
    protected void engineUpdate(byte by) throws SignatureException {
        this.e.update(by);
        this.g = false;
    }

    @Override
    protected void engineUpdate(byte[] byArray, int n2, int n3) throws SignatureException {
        this.e.update(byArray, n2, n3);
        this.g = false;
    }

    @Override
    protected void engineUpdate(ByteBuffer byteBuffer) {
        this.e.update(byteBuffer);
        this.g = false;
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        byte[] byArray = this.b();
        try {
            byte[] byArray2 = this.encodeSignature(byArray);
            byte[] byArray3 = RSACore.rsa(byArray2, this.i);
            int n2 = ((int)this.b + 7) / 8;
            return byArray3;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new SignatureException(z[4], generalSecurityException);
        }
    }

    @Override
    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        if (byArray.length != RSACore.getByteLength(this.j)) {
            throw new SignatureException(z[1] + byArray.length + z[2] + RSACore.getByteLength(this.j));
        }
        int n2 = ((int)this.b + 7) / 8;
        if (byArray.length != n2) {
            throw new SignatureException(z[1] + byArray.length + z[2] + RSACore.getByteLength(this.j));
        }
        byte[] byArray2 = this.b();
        try {
            byte[] byArray3 = RSACore.rsa(byArray, this.j);
            byte[] byArray4 = this.h.unpad(byArray3);
            if (byArray4.length > this.c) {
                return false;
            }
            if (byArray4.length < this.c) {
                byte[] byArray5 = new byte[this.c];
                System.arraycopy(byArray4, 0, byArray5, this.c - byArray4.length, byArray4.length);
                byArray4 = byArray5;
            }
            boolean bl = this.decodeSignature(byArray4, byArray2);
            return bl;
        }
        catch (BadPaddingException badPaddingException) {
            return false;
        }
        catch (InvalidKeyException invalidKeyException) {
            return false;
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            return false;
        }
        catch (IOException iOException) {
            throw new SignatureException(z[0], iOException);
        }
    }

    public byte[] encodeSignature(byte[] byArray) throws InvalidKeyException, InvalidAlgorithmParameterException, BadPaddingException {
        int n2;
        if (this.c < byArray.length + this.k.getSaltLength() + 2) {
            throw new SecurityException(z[3]);
        }
        byte[] byArray2 = new byte[this.k.getSaltLength()];
        this.a.nextBytes(byArray2);
        byte[] byArray3 = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
        byte[] byArray4 = new byte[8 + byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray4, byArray3.length, byArray.length);
        System.arraycopy(byArray2, 0, byArray4, byArray3.length + byArray.length, byArray2.length);
        this.e.reset();
        this.e.update(byArray4);
        byte[] byArray5 = this.e.digest();
        int n3 = this.c - byArray5.length - byArray2.length - 2;
        byte[] byArray6 = new byte[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            byArray6[n2] = 0;
        }
        byte[] byArray7 = new byte[this.c - byArray5.length - 1];
        if (n3 > 0) {
            System.arraycopy(byArray6, 0, byArray7, 0, byArray6.length);
        }
        byArray7[n2++] = 1;
        System.arraycopy(byArray2, 0, byArray7, n2, byArray2.length);
        byte[] byArray8 = new byte[n3 + 1 + byArray2.length];
        byArray8 = this.a(byArray5, byArray8.length);
        byte[] byArray9 = new byte[n3 + 1 + byArray2.length];
        int n4 = 0;
        for (byte by : byArray8) {
            byArray9[n4] = (byte)(by ^ byArray7[n4++]);
        }
        int n5 = 8 * this.c - (int)this.d;
        if (n5 > 0) {
            int n6 = (byte)(255 >>> n5);
            byArray9[0] = (byte)(byArray9[0] & n6);
        }
        byte[] byArray10 = new byte[this.c];
        System.arraycopy(byArray9, 0, byArray10, 0, byArray9.length);
        System.arraycopy(byArray5, 0, byArray10, byArray9.length, byArray5.length);
        byArray10[byArray9.length + byArray5.length] = -68;
        return byArray10;
    }

    public boolean decodeSignature(byte[] byArray, byte[] byArray2) throws IOException, SignatureException, InvalidKeyException, InvalidAlgorithmParameterException, BadPaddingException {
        int n2;
        byte by;
        if (this.c < byArray2.length + 2 + this.k.getSaltLength()) {
            throw new SecurityException(z[5]);
        }
        byte by2 = byArray[this.c - 1];
        if ((by2 ^ 0xBC) == 0) {
            throw new SecurityException(z[5]);
        }
        byte[] byArray3 = Arrays.copyOfRange(byArray, 0, this.c - byArray2.length - 1);
        byte[] byArray4 = Arrays.copyOfRange(byArray, byArray3.length, this.c - 1);
        int n3 = 8 * this.c - (int)this.d;
        int n4 = 8 - n3;
        if (n4 > 0 && (byArray3[0] & (by = (byte)(255 << n4))) != 0) {
            throw new SignatureException(z[6]);
        }
        byte[] byArray5 = new byte[this.c - byArray4.length - 1];
        byArray5 = this.a(byArray4, byArray5.length);
        byte[] byArray6 = new byte[byArray5.length];
        int n5 = 0;
        byte[] byArray7 = byArray5;
        int n6 = byArray7.length;
        for (int i2 = 0; i2 < n6; ++i2) {
            byte by3 = byArray7[i2];
            byArray6[n5] = (byte)(by3 ^ byArray3[n5]);
            ++n5;
        }
        n3 = 8 * this.c - (int)this.d;
        if (n3 > 0) {
            byte by4 = (byte)(255 >>> n3);
            byArray6[0] = (byte)(byArray6[0] & by4);
        }
        if ((n2 = this.c - byArray4.length - this.k.getSaltLength() - 2) > 0) {
            for (n6 = 0; n6 < n2; ++n6) {
                if (byArray6[n6] == 0) continue;
                throw new SecurityException(z[6]);
            }
        }
        if (byArray6[n2] != 1) {
            throw new SecurityException(z[6]);
        }
        byte[] byArray8 = Arrays.copyOfRange(byArray6, n2 + 1, byArray6.length);
        byte[] byArray9 = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
        byte[] byArray10 = new byte[8 + byArray2.length + byArray8.length];
        System.arraycopy(byArray9, 0, byArray10, 0, byArray9.length);
        System.arraycopy(byArray2, 0, byArray10, byArray9.length, byArray2.length);
        System.arraycopy(byArray8, 0, byArray10, byArray9.length + byArray2.length, byArray8.length);
        this.e.reset();
        this.e.update(byArray10);
        byte[] byArray11 = this.e.digest();
        return Arrays.equals(byArray4, byArray11);
    }

    @Override
    @Deprecated
    protected void engineSetParameter(String string, Object object) throws InvalidParameterException {
        throw new UnsupportedOperationException(z[16]);
    }

    @Override
    @Deprecated
    protected Object engineGetParameter(String string) throws InvalidParameterException {
        throw new UnsupportedOperationException(z[13]);
    }

    @Override
    protected void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        if (!(algorithmParameterSpec instanceof PSSParameterSpec)) {
            throw new InvalidAlgorithmParameterException();
        }
        this.k = (PSSParameterSpec)algorithmParameterSpec;
    }

    private byte[] a(byte[] byArray, int n2) throws InvalidAlgorithmParameterException, InvalidKeyException, BadPaddingException {
        String string = this.k.getDigestAlgorithm();
        String string2 = this.k.getMGFAlgorithm();
        if (!string2.equalsIgnoreCase(z[14])) {
            throw new InvalidAlgorithmParameterException(z[18] + string2);
        }
        String string3 = null;
        string3 = this.k.getMGFParameters() == null ? string : ((MGF1ParameterSpec)this.k.getMGFParameters()).getDigestAlgorithm();
        try {
            this.f = MessageDigest.getInstance(string3);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InvalidKeyException(z[17] + string + z[19], noSuchAlgorithmException);
        }
        byte[] byArray2 = new byte[n2];
        int n3 = this.f.getDigestLength();
        int n4 = n2 / n3;
        if (n2 % n3 > 0) {
            ++n4;
        }
        byte[] byArray3 = new byte[4];
        byte[] byArray4 = new byte[n3];
        for (int i2 = 0; i2 < n4; ++i2) {
            byArray3[0] = (byte)(i2 >>> 24);
            byArray3[1] = (byte)(i2 >>> 16);
            byArray3[2] = (byte)(i2 >>> 8);
            byArray3[3] = (byte)i2;
            this.f.update(byArray, 0, byArray.length);
            this.f.update(byArray3);
            try {
                this.f.digest(byArray4, 0, byArray4.length);
            }
            catch (DigestException digestException) {
                throw new BadPaddingException(digestException.toString());
            }
            for (int i3 = 0; i3 < byArray4.length && i2 * n3 + i3 < n2; ++i3) {
                byArray2[i2 * n3 + i3] = byArray4[i3];
            }
        }
        return byArray2;
    }

    @Override
    protected AlgorithmParameters engineGetParameters() throws InvalidParameterException {
        AlgorithmParameters algorithmParameters = null;
        if (this.k == null) {
            return null;
        }
        try {
            algorithmParameters = AlgorithmParameters.getInstance(z[11], z[9]);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
            throw new RuntimeException(z[10] + noSuchAlgorithmException.getMessage());
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new RuntimeException(z[8]);
        }
        try {
            algorithmParameters.init(this.k);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            invalidParameterSpecException.printStackTrace();
            throw new RuntimeException(z[7] + invalidParameterSpecException.getMessage());
        }
        return algorithmParameters;
    }

    String a(byte[] byArray) {
        String string = z[12];
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            int n2 = byArray[i2] & 0xFF;
            stringBuffer.append(string.charAt(n2 >> 4));
            stringBuffer.append(string.charAt(n2 & 0xF));
        }
        return stringBuffer.toString();
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[20];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "+6(*\u0006\f*=!G\u001d1,+\u0003\u00111(d\u0002\n- 6";
        int n3 = -1;
        block27: while (true) {
            char[] cArray;
            block31: {
                int n4;
                int n5;
                block30: {
                    char[] cArray2 = string2.toCharArray();
                    cArray = cArray2;
                    n5 = cArray2.length;
                    n4 = 0;
                    if (!true) break block30;
                    n5 = n5;
                    if (n5 <= n4) break block31;
                }
                do {
                    int n6;
                    cArray = cArray;
                    int n7 = n4;
                    char c2 = cArray[n7];
                    switch (n4 % 5) {
                        case 0: {
                            n6 = 120;
                            break;
                        }
                        case 1: {
                            n6 = 95;
                            break;
                        }
                        case 2: {
                            n6 = 79;
                            break;
                        }
                        case 3: {
                            n6 = 68;
                            break;
                        }
                        default: {
                            n6 = 103;
                        }
                    }
                    cArray[n7] = (char)(c2 ^ n6);
                    ++n4;
                    n5 = n5;
                } while (n5 > n4);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "X\f&#\t\u0019+:6\u0002X3**\u0000\f7o*\b\f\u007f,+\u0015\n:,0]X8 0G";
                    n3 = 0;
                    continue block27;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "X=:0G\u000f><d\u0002\u0000/*'\u0013\u00111(d";
                    n3 = 1;
                    continue block27;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "\u001d1,+\u0003\u00111(d\u0002\n- 6";
                    n3 = 2;
                    continue block27;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = ";0:(\u0003X1 0G\u000b6(*G\u001c>;%";
                    n3 = 3;
                    continue block27;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "\u00111,+\t\u000b6<0\u0002\u0016+o7\u000e\u001f1.0\u0012\n:";
                    n3 = 4;
                    continue block27;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "<:,+\u0003\u00111(d\u0002\n- 6";
                    n3 = 5;
                    continue block27;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "(\f\u001c\u0014\u0006\n>\"!\u0013\u001d-\u001c4\u0002\u001b\u007f!+\u0013X,:4\u0017\u0017-;!\u0003X";
                    n3 = 6;
                    continue block27;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "1\u001d\u0002\u000e$=\u007f,%\u000b\u0014:+hG\u001a*;d\t\u0017+o'\b\u00169&#\u0012\n:+";
                    n3 = 7;
                    continue block27;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = "1\u001d\u0002\u000e$=";
                    n3 = 8;
                    continue block27;
                }
                case 8: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 10;
                    string2 = "60o7\u0012\u001b7o%\u000b\u001f0=-\u0013\u00102o";
                    n3 = 9;
                    continue block27;
                }
                case 9: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 11;
                    string2 = "*\f\u000e\u00144+";
                    n3 = 10;
                    continue block27;
                }
                case 10: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 12;
                    string2 = "Hn}wSMix|^\u0019=, \u0002\u001e";
                    n3 = 11;
                    continue block27;
                }
                case 11: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 13;
                    string2 = "\u001f:;\u0014\u0006\n>\"!\u0013\u001d-gmG\u00160;d\u0014\r/?+\u0015\f:+";
                    n3 = 12;
                    continue block27;
                }
                case 12: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 14;
                    string2 = "5\u0018\tu";
                    n3 = 13;
                    continue block27;
                }
                case 13: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 15;
                    string2 = "+\u0017\u000eiV";
                    n3 = 14;
                    continue block27;
                }
                case 14: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 16;
                    string2 = "\u000b:;\u0014\u0006\n>\"!\u0013\u001d-gmG\u00160;d\u0014\r/?+\u0015\f:+";
                    n3 = 15;
                    continue block27;
                }
                case 15: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 17;
                    string2 = "<6(!\u0014\f\u007f";
                    n3 = 16;
                    continue block27;
                }
                case 16: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 18;
                    string2 = "-1<1\u0017\b0=0\u0002\u001c\u007f\u0002\u0003!X>##\bB\u007f";
                    n3 = 17;
                    continue block27;
                }
                case 17: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 19;
                    string2 = "X1 0G\u0019).-\u000b\u0019=#!";
                    n3 = 18;
                    continue block27;
                }
                case 18: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

