/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.provider;

import com.ibm.crypto.provider.JCAUtil;
import com.ibm.crypto.provider.RSACore;
import java.security.DigestException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.MGF1ParameterSpec;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;

public final class RSAPadding {
    public static final int PAD_BLOCKTYPE_1 = 1;
    public static final int PAD_BLOCKTYPE_2 = 2;
    public static final int PAD_NONE = 3;
    public static final int PAD_OAEP_MGF1 = 4;
    public static final int PAD_ZERO = 5;
    private final int a;
    private final int b;
    private SecureRandom c;
    private final int d;
    private MessageDigest e;
    private MessageDigest f;
    private byte[] g;
    private static final Map<String, byte[]> h;
    private static final String[] z;

    public static RSAPadding getInstance(int n2, int n3) throws InvalidKeyException, InvalidAlgorithmParameterException {
        return new RSAPadding(n2, n3, null, null);
    }

    public static RSAPadding getInstance(int n2, int n3, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        return new RSAPadding(n2, n3, secureRandom, null);
    }

    public static RSAPadding getInstance(int n2, int n3, SecureRandom secureRandom, OAEPParameterSpec oAEPParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        return new RSAPadding(n2, n3, secureRandom, oAEPParameterSpec);
    }

    private RSAPadding(int n2, int n3, SecureRandom secureRandom, OAEPParameterSpec oAEPParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.a = n2;
        this.b = n3;
        this.c = secureRandom;
        if (n3 < 64) {
            throw new InvalidKeyException(z[10]);
        }
        switch (n2) {
            case 1: 
            case 2: {
                this.d = n3 - 11;
                break;
            }
            case 3: 
            case 5: {
                this.d = n3;
                break;
            }
            case 4: {
                String string = z[4];
                String string2 = z[4];
                byte[] byArray = null;
                try {
                    if (oAEPParameterSpec != null) {
                        string = oAEPParameterSpec.getDigestAlgorithm();
                        String string3 = oAEPParameterSpec.getMGFAlgorithm();
                        if (!string3.equalsIgnoreCase(z[12])) {
                            throw new InvalidAlgorithmParameterException(z[7] + string3);
                        }
                        string2 = ((MGF1ParameterSpec)oAEPParameterSpec.getMGFParameters()).getDigestAlgorithm();
                        PSource pSource = oAEPParameterSpec.getPSource();
                        String string4 = pSource.getAlgorithm();
                        if (!string4.equalsIgnoreCase(z[9])) {
                            throw new InvalidAlgorithmParameterException(z[11] + string4);
                        }
                        byArray = ((PSource.PSpecified)pSource).getValue();
                    }
                    this.e = MessageDigest.getInstance(string);
                    this.f = MessageDigest.getInstance(string2);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    throw new InvalidKeyException(z[6] + string + z[8], noSuchAlgorithmException);
                }
                this.g = RSAPadding.a(this.e, byArray);
                int n4 = this.g.length;
                this.d = n3 - 2 - 2 * n4;
                if (this.d > 0) break;
                throw new InvalidKeyException(z[5] + string + z[3] + string2);
            }
            default: {
                throw new InvalidKeyException(z[13] + n2);
            }
        }
    }

    private static byte[] a(MessageDigest messageDigest, byte[] byArray) {
        byte[] byArray2;
        if (byArray == null || byArray.length == 0) {
            String string = messageDigest.getAlgorithm();
            byArray2 = h.get(string);
            if (byArray2 == null) {
                byArray2 = messageDigest.digest();
                h.put(string, byArray2);
            }
        } else {
            byArray2 = messageDigest.digest(byArray);
        }
        return byArray2;
    }

    public int getMaxDataSize() {
        return this.d;
    }

    public byte[] pad(byte[] byArray, int n2, int n3) throws BadPaddingException {
        return this.pad(RSACore.convert(byArray, n2, n3));
    }

    public byte[] pad(byte[] byArray) throws BadPaddingException {
        if (byArray.length > this.d) {
            throw new BadPaddingException(z[1] + (this.d + 1) + z[2]);
        }
        switch (this.a) {
            case 3: {
                return byArray;
            }
            case 1: 
            case 2: {
                return this.a(byArray);
            }
            case 4: {
                return this.e(byArray);
            }
            case 5: {
                return this.b(byArray);
            }
        }
        throw new AssertionError();
    }

    public byte[] unpad(byte[] byArray, int n2, int n3) throws BadPaddingException {
        return this.unpad(RSACore.convert(byArray, n2, n3));
    }

    public byte[] unpad(byte[] byArray) throws BadPaddingException {
        if (byArray.length != this.b) {
            throw new BadPaddingException(z[0]);
        }
        switch (this.a) {
            case 3: {
                return byArray;
            }
            case 1: 
            case 2: {
                return this.c(byArray);
            }
            case 4: {
                return this.f(byArray);
            }
            case 5: {
                return this.d(byArray);
            }
        }
        throw new AssertionError();
    }

    private byte[] a(byte[] byArray) throws BadPaddingException {
        byte[] byArray2 = new byte[this.b];
        System.arraycopy(byArray, 0, byArray2, this.b - byArray.length, byArray.length);
        int n2 = this.b - 3 - byArray.length;
        int n3 = 0;
        byArray2[n3++] = 0;
        byArray2[n3++] = (byte)this.a;
        if (this.a == 1) {
            while (n2-- > 0) {
                byArray2[n3++] = -1;
            }
        } else {
            if (this.c == null) {
                this.c = JCAUtil.getSecureRandom();
            }
            byte[] byArray3 = new byte[64];
            int n4 = -1;
            while (n2-- > 0) {
                int n5;
                do {
                    if (n4 >= 0) continue;
                    this.c.nextBytes(byArray3);
                    n4 = byArray3.length - 1;
                } while ((n5 = byArray3[n4--] & 0xFF) == 0);
                byArray2[n3++] = (byte)n5;
            }
        }
        return byArray2;
    }

    private byte[] b(byte[] byArray) throws BadPaddingException {
        byte[] byArray2 = new byte[this.b];
        byte[] byArray3 = new byte[this.b - byArray.length];
        System.arraycopy(byArray2, 0, byArray3, 0, byArray3.length);
        System.arraycopy(byArray, 0, byArray2, this.b - byArray.length, byArray.length);
        return byArray2;
    }

    private byte[] c(byte[] byArray) throws BadPaddingException {
        int n2;
        int n3 = 0;
        boolean bl = false;
        if (byArray[n3++] != 0) {
            bl = true;
        }
        if (byArray[n3++] != this.a) {
            bl = true;
        }
        int n4 = 0;
        while (n3 < byArray.length) {
            if ((n2 = byArray[n3++] & 0xFF) == 0 && n4 == 0) {
                n4 = n3;
            }
            if (n3 == byArray.length && n4 == 0) {
                bl = true;
            }
            if (this.a != 1 || n2 == 255 || n4 != 0) continue;
            bl = true;
        }
        n2 = byArray.length - n4;
        if (n2 > this.d) {
            bl = true;
        }
        byte[] byArray2 = new byte[n4];
        System.arraycopy(byArray, 0, byArray2, 0, n4);
        byte[] byArray3 = new byte[n2];
        System.arraycopy(byArray, n4, byArray3, 0, n2);
        BadPaddingException badPaddingException = new BadPaddingException(z[0]);
        if (bl) {
            throw badPaddingException;
        }
        return byArray3;
    }

    private byte[] d(byte[] byArray) throws BadPaddingException {
        int n2;
        int n3 = -1;
        for (n2 = 0; n2 < byArray.length; ++n2) {
            int n4 = byArray[n2] & 0xFF;
            if (n4 == 0 || n3 != -1) continue;
            n3 = n2;
        }
        if (n3 == -1) {
            n3 = byArray.length > 0 ? byArray.length - 1 : 0;
        }
        n2 = byArray.length - n3;
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, 0, byArray2, 0, n3);
        byte[] byArray3 = new byte[n2];
        System.arraycopy(byArray, n3, byArray3, 0, n2);
        return byArray3;
    }

    private byte[] e(byte[] byArray) throws BadPaddingException {
        if (this.c == null) {
            this.c = JCAUtil.getSecureRandom();
        }
        int n2 = this.g.length;
        byte[] byArray2 = new byte[n2];
        this.c.nextBytes(byArray2);
        byte[] byArray3 = new byte[this.b];
        int n3 = 1;
        int n4 = n2;
        System.arraycopy(byArray2, 0, byArray3, n3, n4);
        int n5 = n2 + 1;
        int n6 = byArray3.length - n5;
        int n7 = this.b - byArray.length;
        System.arraycopy(this.g, 0, byArray3, n5, n2);
        byArray3[n7 - 1] = 1;
        System.arraycopy(byArray, 0, byArray3, n7, byArray.length);
        this.a(byArray3, n3, n4, byArray3, n5, n6);
        this.a(byArray3, n5, n6, byArray3, n3, n4);
        return byArray3;
    }

    private byte[] f(byte[] byArray) throws BadPaddingException {
        int n2;
        int n3;
        byte[] byArray2 = byArray;
        boolean bl = false;
        int n4 = this.g.length;
        if (byArray2[0] != 0) {
            bl = true;
        }
        int n5 = 1;
        int n6 = n4;
        int n7 = n4 + 1;
        int n8 = byArray2.length - n7;
        this.a(byArray2, n7, n8, byArray2, n5, n6);
        this.a(byArray2, n5, n6, byArray2, n7, n8);
        for (n3 = 0; n3 < n4; ++n3) {
            if (this.g[n3] == byArray2[n7 + n3]) continue;
            bl = true;
        }
        n3 = n7 + n4;
        int n9 = -1;
        for (n2 = n3; n2 < byArray2.length; ++n2) {
            byte by = byArray2[n2];
            if (n9 != -1 || by == 0) continue;
            if (by == 1) {
                n9 = n2;
                continue;
            }
            bl = true;
        }
        if (n9 == -1) {
            bl = true;
            n9 = byArray2.length - 1;
        }
        n2 = n9 + 1;
        byte[] byArray3 = new byte[n2 - n3];
        System.arraycopy(byArray2, n3, byArray3, 0, byArray3.length);
        byte[] byArray4 = new byte[byArray2.length - n2];
        System.arraycopy(byArray2, n2, byArray4, 0, byArray4.length);
        BadPaddingException badPaddingException = new BadPaddingException(z[0]);
        if (bl) {
            throw badPaddingException;
        }
        return byArray4;
    }

    private void a(byte[] byArray, int n2, int n3, byte[] byArray2, int n4, int n5) throws BadPaddingException {
        byte[] byArray3 = new byte[4];
        byte[] byArray4 = new byte[this.f.getDigestLength()];
        block2: while (n5 > 0) {
            this.f.update(byArray, n2, n3);
            this.f.update(byArray3);
            try {
                this.f.digest(byArray4, 0, byArray4.length);
            }
            catch (DigestException digestException) {
                throw new BadPaddingException(digestException.toString());
            }
            int n6 = 0;
            while (n6 < byArray4.length && n5 > 0) {
                int n7 = n4++;
                byArray2[n7] = (byte)(byArray2[n7] ^ byArray4[n6++]);
                --n5;
            }
            if (n5 <= 0) continue;
            n6 = byArray3.length - 1;
            while (true) {
                int n8 = --n6;
                byArray3[n8] = (byte)(byArray3[n8] + 1);
                if (byArray3[n8] != 0 || n6 <= 0) continue block2;
            }
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[14];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "s\u001d$8\u001dG\f.%\n\u0017\u001d58\u000bE";
        int n3 = -1;
        block21: while (true) {
            char[] cArray;
            block25: {
                int n4;
                int n5;
                block24: {
                    char[] cArray2 = string2.toCharArray();
                    cArray = cArray2;
                    n5 = cArray2.length;
                    n4 = 0;
                    if (!true) break block24;
                    n5 = n5;
                    if (n5 <= n4) break block25;
                }
                do {
                    int n6;
                    cArray = cArray;
                    int n7 = n4;
                    char c2 = cArray[n7];
                    switch (n4 % 5) {
                        case 0: {
                            n6 = 55;
                            break;
                        }
                        case 1: {
                            n6 = 120;
                            break;
                        }
                        case 2: {
                            n6 = 71;
                            break;
                        }
                        case 3: {
                            n6 = 74;
                            break;
                        }
                        default: {
                            n6 = 100;
                        }
                    }
                    cArray[n7] = (char)(c2 ^ n6);
                    ++n4;
                    n5 = n5;
                } while (n5 > n4);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "s\u00193+DZ\r4>DU\u001dg9\fX\n3/\u0016\u0017\f/+\n\u0017";
                    n3 = 0;
                    continue block21;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "\u0017\u001a>>\u0001D";
                    n3 = 1;
                    continue block21;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "\u0017\u0019).Dz?\u0001{";
                    n3 = 2;
                    continue block21;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "d0\u0006gU";
                    n3 = 3;
                    continue block21;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "|\u001d>j\rDX3%\u000b\u0017\u000b/%\u0016CX!%\u0016\u0017\u001d))\u0016N\b3#\u000bYX29\rY\u001fg\u0005%r(\u0017+\u0000S\u0011)-D@\u00113\"D";
                    n3 = 4;
                    continue block21;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "s\u0011 /\u0017CX";
                    n3 = 5;
                    continue block21;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "b\u00164?\u0014G\u00175>\u0001SX\n\r\"\u0017\u0019+-\u000b\rX";
                    n3 = 6;
                    continue block21;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "\u0017\u0016(>DV\u000e&#\bV\u001a+/";
                    n3 = 7;
                    continue block21;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = "g+7/\u0007^\u001e./\u0000";
                    n3 = 8;
                    continue block21;
                }
                case 8: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 10;
                    string2 = "g\u0019#.\u0001SX4#\u001eRX*?\u0017CX%/DV\fg&\u0001V\u000b3jR\u0003";
                    n3 = 9;
                    continue block21;
                }
                case 9: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 11;
                    string2 = "b\u00164?\u0014G\u00175>\u0001SX7\u0019\u000bB\n$/DV\u0014 %^\u0017";
                    n3 = 10;
                    continue block21;
                }
                case 10: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 12;
                    string2 = "z?\u0001{";
                    n3 = 11;
                    continue block21;
                }
                case 11: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 13;
                    string2 = "~\u00161+\b^\u001cg:\u0005S\u001c.$\u0003\rX";
                    n3 = 12;
                    continue block21;
                }
                case 12: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
        h = Collections.synchronizedMap(new HashMap());
    }
}

