********************************************************************/
*                                                                  */
* Program name: AMQSCOS0                                           */
*                                                                  */
* Description: Sample MQSC source defining MQM sample queues       */
*              Can be processed, with changes as needed, after     */
*              starting the MQM                                    */
* <copyright                                                       */
* notice="lm-source-program"                                       */
* pids="5639-B43,"                                                 */
* years="1994,2001"                                                */
* crc="3261619391" >                                               */
* Licensed Materials - Property of IBM                             */
*                                                                  */
* 5639-B43,                                                        */
*                                                                  */
* (C) Copyright IBM Corp. 1994, 2001 All Rights Reserved.          */
*                                                                  */
* US Government Users Restricted Rights - Use, duplication or      */
* disclosure restricted by GSA ADP Schedule Contract with          */
* IBM Corp.                                                        */
* </copyright>                                                     */
*                                                                  */
********************************************************************/
*                                                                  */
* Function:                                                        */
*                                                                  */
*                                                                  */
*   AMQSCOS0 is a sample MQSC file to create or reset sample       */
*   MQI resources of the Message Queue Manager (MQM).              */
*   It includes the following.                                     */
*                                                                  */
*      -- definition of objects used by the sample programs        */
*                                                                  */
*   This file, or a similar one, can be processed when the MQM     */
*   is started - it creates the objects if missing, or resets      */
*   their attributes to the prescribed values.                     */
*                                                                  */
********************************************************************/
*                                                                  */
*   AMQSCOS0 is sample data for the MQSC utility                   */
*                                                                  */
********************************************************************/


********************************************************************/
*       EXAMPLES OF DIFFERENT QUEUE TYPES                          */
*                                                                  */
*   Create local, alias and remote queues                          */
*                                                                  */
*   Uses system defaults for most attributes                       */
*                                                                  */
********************************************************************/
**   Create a local queue
    DEFINE QLOCAL('SYSTEM.SAMPLE.LOCAL') REPLACE +

           DESCR('Sample local queue') +
*   Persistent messages OK
           DEFPSIST(YES)  +
*   Shareable
           SHARE

**   Create an alias queue
    DEFINE QALIAS('SYSTEM.SAMPLE.ALIAS') REPLACE  +

           DESCR('Sample alias queue') +
*   Persistent messages OK
           DEFPSIST(YES)               +
           TARGQ('SYSTEM.SAMPLE.LOCAL')

**   Create a remote queue - in this case, an indirect reference
**      is made to the sample local queue on OTHER queue manager
    DEFINE QREMOTE('SYSTEM.SAMPLE.REMOTE') REPLACE  +

           DESCR('Sample remote queue') +
*   Persistent messages OK
           DEFPSIST(YES)                +
           RNAME('SYSTEM.SAMPLE.LOCAL') +
*   Queue is on queue manager called OTHER
           RQMNAME('OTHER')

**   Create a transmission queue for messages to queues at OTHER
**   By default, use remote node name
    DEFINE QLOCAL('OTHER') REPLACE +

           DESCR('transmision queue to OTHER')  +
           USAGE(XMITQ)

********************************************************************/
*       SAMPLE MODEL QUEUE USED BY SAMPLE PROGRAMS                 */
*                                                                  */
*   Create model queue opened by sample programs to create         */
*   a dynamic queue for replies                                    */
*                                                                  */
********************************************************************/
*   General reply queue                                            */
    DEFINE QMODEL('SYSTEM.SAMPLE.REPLY') REPLACE +
           DESCR('General reply queue')

********************************************************************/
*       SPECIFIC QUEUES AND PROCESS USED BY SAMPLE PROGRAMS        */
*                                                                  */
*   Create local queues used by sample programs                    */
*   Create MQI process associated with sample initiation queue     */
*                                                                  */
********************************************************************/

*   Queue used by AMQSECHA
    DEFINE QLOCAL('SYSTEM.SAMPLE.ECHO') REPLACE +
           DESCR('queue for AMQSECHA')         +
*   Shareable
           SHARE                  +
*   Trigger control on
           TRIGGER                +
*   Trigger on first message
           TRIGTYPE (FIRST)       +
           PROCESS('SYSTEM.SAMPLE.ECHOPROCESS') +
           INITQ('SYSTEM.SAMPLE.TRIGGER')


*   Queue used by AMQSINQA
    DEFINE QLOCAL('SYSTEM.SAMPLE.INQ') REPLACE +
           DESCR('queue for AMQSINQA')         +
*   Shareable
           SHARE                  +
*   Trigger control on
           TRIGGER                +
*   Trigger on first message
           TRIGTYPE (FIRST)       +
           PROCESS('SYSTEM.SAMPLE.INQPROCESS') +
           INITQ('SYSTEM.SAMPLE.TRIGGER')


*   Queue used by AMQSSETA
    DEFINE QLOCAL('SYSTEM.SAMPLE.SET') REPLACE +
           DESCR('queue for AMQSSETA')         +
*   Shareable
           SHARE                  +
*   Trigger control on
           TRIGGER                +
*   Trigger on first message
           TRIGTYPE (FIRST)       +
           PROCESS('SYSTEM.SAMPLE.SETPROCESS')  +
           INITQ('SYSTEM.SAMPLE.TRIGGER')

**   Initiation Queue used by AMQSTRGx, sample trigger process
    DEFINE QLOCAL('SYSTEM.SAMPLE.TRIGGER') REPLACE +
           DESCR('trigger queue for sample programs')

**   MQI Processes associated with triggered sample programs

    DEFINE PROCESS('SYSTEM.SAMPLE.ECHOPROCESS')  REPLACE +
           DESCR('trigger process for AMQSECHA')        +
** Note -
**    select name of application to trigger, this could be the C or
**    COBOL sample application name. The default is the C name.
           APPLICID('amqsech')

    DEFINE PROCESS('SYSTEM.SAMPLE.INQPROCESS')  REPLACE +
           DESCR('trigger process for AMQSINQA')        +
** Note -
**    select name of application to trigger, this could be the C or
**    COBOL sample application name. The default is the C name.
           APPLICID('amqsinq')

    DEFINE PROCESS('SYSTEM.SAMPLE.SETPROCESS')  REPLACE +
           DESCR('trigger process for AMQSSETA')        +
** Note -
**    select name of application to trigger, this could be the C or
**    COBOL sample application name. The default is the C name.
           APPLICID('amqsset')

********************************************************************/
*                                                                  */
* END OF AMQSCOS0                                                  */
*                                                                  */
********************************************************************/

