/* @(#) MQMBID sn=p800-003-150615.2 su=_O7DtFhOPEeWRp7-5NNeHyQ pn=samples/c/amqsvfc0.c */
 /********************************************************************/
 /*                                                                  */
 /* Program name: AMQSVFC0                                           */
 /*                                                                  */
 /* Description: Sample C skeleton of a Data Conversion exit         */
 /*              routine                                             */
 /*                                                                  */
 /*   <copyright                                                     */
 /*   notice="lm-source-program"                                     */
 /*   pids="5724-H72,"                                               */
 /*   years="1994,2012"                                              */
 /*   crc="1406417264" >                                             */
 /*   Licensed Materials - Property of IBM                           */
 /*                                                                  */
 /*   5724-H72,                                                      */
 /*                                                                  */
 /*   (C) Copyright IBM Corp. 1994, 2012 All Rights Reserved.        */
 /*                                                                  */
 /*   US Government Users Restricted Rights - Use, duplication or    */
 /*   disclosure restricted by GSA ADP Schedule Contract with        */
 /*   IBM Corp.                                                      */
 /*   </copyright>                                                   */
 /*                                                                  */
 /*                                                                  */
 /********************************************************************/
 /*                                                                  */
 /* Function:                                                        */
 /*                                                                  */
 /*   AMQSVFC0 is a sample C skeleton of a Data Conversion exit      */
 /*   routine.                                                       */
 /*   Each Data Conversion exit routine converts a single named      */
 /*   Format.  This skeleton is intended as a wrapper for code       */
 /*   fragments generated by the Data Conversion Exit-generation     */
 /*   utility program - crtmqcvx.                                    */
 /*                                                                  */
 /*   The utility produces one code fragment for each data           */
 /*   structure; a format may be defined in terms of several         */
 /*   such structures so that several code fragments will need       */
 /*   to be added to this skeleton to produce a routine to do        */
 /*   data conversion of the entire Format.                          */
 /*                                                                  */
 /*   For Windows systems:                                           */
 /*     Once complete, the code should be compiled into a DLL with   */
 /*     the name of the DLL being the name of the format to be       */
 /*     converted.                                                   */
 /*                                                                  */
 /*   For Unix systems:                                              */
 /*     Once complete the code should be compiled into a loadable    */
 /*     object. The name of the object should be the name of the     */
 /*     format to be converted.                                      */
 /*                                                                  */
 /*   See the WebSphere MQ Application Programming Guide for         */
 /*   further information.                                           */
 /*                                                                  */
 /********************************************************************/
 /*                                                                  */
 /*  AMQSVFC0 takes the parameters defined for a Data Conversion     */
 /*  exit routine in the CMQXC.H header file.                        */
 /*                                                                  */
 /********************************************************************/
 #include <cmqc.h>              /* For MQI datatypes                 */
 #include <cmqxc.h>             /* For MQI exit-related definitions  */
 #include <cmqec.h>             /* For interface function pointers   */
 #include <amqsvmha.h>          /* For sample macro definitions      */

 /********************************************************************/
 /* Insert the function prototypes for the functions produced by     */
 /* the data conversion utility program.                             */
 /********************************************************************/

 MQDATACONVEXIT MQStart;

 /********************************************************************/
 /* On some Unix systems, the name of this function is not important */
 /* as it is not actually used to call the conversion exit but it    */
 /* must be an exported symbol or the entrypoint to the module.  On  */
 /* other systems (typically SVR4-based implementations) the name    */
 /* must be set to MQStart. On Windows the function must exported in */
 /* the .DEF file.                                                   */
 /* More information can be found in the WebSphere MQ Application    */
 /* Programming Guide.                                               */
 /********************************************************************/
 void MQENTRY MQStart(
   PMQDXP   pDataConvExitParms, /* Data-conversion exit parameter    */
                                /* block                             */
   PMQMD    pMsgDesc,           /* Message descriptor                */
   MQLONG   InBufferLength,     /* Length in bytes of InBuffer       */
   PMQVOID  pInBuffer,          /* Buffer containing the unconverted */
                                /* message                           */
   MQLONG   OutBufferLength,    /* Length in bytes of OutBuffer      */
   PMQVOID  pOutBuffer)         /* Buffer containing the converted   */
                                /* message                           */
 {
   MQLONG   ReturnCode   = MQRC_NONE;
   MQHCONN  hConn        = pDataConvExitParms->Hconn;
   MQLONG   opts         = pDataConvExitParms->AppOptions;
   PMQBYTE  in_cursor    = (PMQBYTE)pInBuffer;
   PMQBYTE  out_cursor   = (PMQBYTE)pOutBuffer;
   PMQBYTE  in_lastbyte  = (PMQBYTE)pInBuffer + InBufferLength - 1;
   PMQBYTE  out_lastbyte = (PMQBYTE)pOutBuffer + OutBufferLength - 1;
   MQLONG   MsgEncoding  = pMsgDesc->Encoding;
   MQLONG   ReqEncoding  = pDataConvExitParms->Encoding;
   MQLONG   MsgCCSID     = pMsgDesc->CodedCharSetId;
   MQLONG   ReqCCSID     = pDataConvExitParms->CodedCharSetId;
   MQLONG   CompCode     = pDataConvExitParms->CompCode;
   MQLONG   Reason       = pDataConvExitParms->Reason;

   /******************************************************************/
   /* Insert calls to the code fragments to convert the format's     */
   /* structure(s) here.                                             */
   /* ReturnCode = ConverttagSTRUCT(                                 */
   /*                         pDataConvExitParms,                    */
   /*                         &in_cursor,                            */
   /*                         &out_cursor,                           */
   /*                         in_lastbyte,                           */
   /*                         out_lastbyte,                          */
   /*                         hConn,                                 */
   /*                         opts,                                  */
   /*                         MsgEncoding,                           */
   /*                         ReqEncoding,                           */
   /*                         MsgCCSID,                              */
   /*                         ReqCCSID,                              */
   /*                         CompCode,                              */
   /*                         Reason);                               */
   /******************************************************************/


   /******************************************************************/
   /* Check whether the conversion succeeded                         */
   /******************************************************************/
   if ((ReturnCode == MQRC_NONE) ||
       (ReturnCode == MQRC_TRUNCATED_MSG_ACCEPTED))
   {
     pDataConvExitParms->ExitResponse = MQXDR_OK;
     /****************************************************************/
     /* Always return new length. Queue manager code decides         */
     /* if the new length is to be reported.                         */
     /* Warning - this assumes that out_cursor has been set up to    */
     /* point to the end of the message. Routines produced by the    */
     /* data conversion exit utility will do this BUT if you are     */
     /* writing your own routines ensure it is updated or the        */
     /* message could end up with a zero length and appear not to    */
     /* get converted!                                               */
     /****************************************************************/
     pDataConvExitParms->DataLength = (MQLONG)(out_cursor
                                         - (PMQBYTE)pOutBuffer);
   }
   /******************************************************************/
   /* Otherwise indicate that conversion of the message data failed. */
   /******************************************************************/
   else
   {
     pDataConvExitParms->ExitResponse = MQXDR_CONVERSION_FAILED;
   }
   /******************************************************************/
   /* It the message is not already truncated update comp code, and  */
   /* reason.                                                        */
   /******************************************************************/
   if (Reason != MQRC_TRUNCATED_MSG_ACCEPTED)
   {
      pDataConvExitParms->Reason = ReturnCode;

     if (ReturnCode == MQRC_NONE)
     {
       pDataConvExitParms->CompCode   = MQCC_OK;
     }
     else
     {
       pDataConvExitParms->CompCode = MQCC_WARNING;
     }
   }

   return;
 }

 /********************************************************************/
 /* Insert the functions produced by the data conversion exit        */
 /* utility program.                                                 */
 /********************************************************************/

 /********************************************************************/
 /*                                                                  */
 /* END OF AMQSVFC0                                                  */
 /*                                                                  */
 /********************************************************************/
