const static char sccsid[] = "@(#) MQMBID sn=p800-003-150615.2 su=_O7DtFhOPEeWRp7-5NNeHyQ pn=lib/exits/oltp/unix/linux_2/amqzscgx.c";
/*********************************************************************/
/*                                                                   */
/* Module Name: amqzscgx.c                                           */
/*                                                                   */
/* Description: WebSphere MQ sample CICS GLobal User Exit (GLUE)     */
/*              program for the CICS Task termination user exit      */
/*              (UE014015)                                           */
/*   <copyright                                                      */
/*   notice="lm-source-program"                                      */
/*   pids="5724-H72,"                                                */
/*   years="1996,2012"                                               */
/*   crc="1939517010" >                                              */
/*   Licensed Materials - Property of IBM                            */
/*                                                                   */
/*   5724-H72,                                                       */
/*                                                                   */
/*   (C) Copyright IBM Corp. 1996, 2012 All Rights Reserved.         */
/*                                                                   */
/*   US Government Users Restricted Rights - Use, duplication or     */
/*   disclosure restricted by GSA ADP Schedule Contract with         */
/*   IBM Corp.                                                       */
/*   </copyright>                                                    */
/*********************************************************************/
/*                                                                   */
/* Function:                                                         */
/*                                                                   */
/* This sample is the WebSphere MQ CICS Task termination user exit   */
/* (UE014015) program.                                               */
/*                                                                   */
/* It is based on the samples in the CICS documentation, and         */
/* contains the following function:                                  */
/*  cics_UE_entry  -  CICS UE entry                                  */
/*                                                                   */
/*********************************************************************/
/*                                                                   */
/* Compile:                                                          */
/*    gcc -c -KPIC -D_REENTRANT -D_POSIX_PTHREAD_SEMANTICS           */
/*    -I/opt/cics/include -I/opt/mqm/inc -o amqzscgx.o amqzscgx.c    */
/*                                                                   */
/* Link:                                                             */
/*    ld -o amqzscg amqzscgx.o -G -L/opt/mqm/lib -L/opt/ibm/cics/lib */
/*    -lmqzi_r -lmqmcs_r -lmqmzse_r -lmqmcics_r -lpthread            */
/*                                                                   */
/*********************************************************************/

/*********************************************************************/
/* Includes                                                          */
/*********************************************************************/

/*********************************************************************/
/* Select compiler specific header files                             */
/*********************************************************************/

#include <stdio.h>
#include <errno.h>

/*********************************************************************/
/* Select CICS include files                                         */
/*********************************************************************/

#include <cicstype.h>
#include <cicsue.h>

/*********************************************************************/
/* Select MQI header file                                            */
/*********************************************************************/

#include <cmqc.h>

/*********************************************************************/
/* Data defined in this module                                       */
/*********************************************************************/

/*********************************************************************/
/* Local function declarations                                       */
/*********************************************************************/
extern void AMQ2PHASETASKDETACH(void);
extern void AMQ2PHASETASKABEND(void);

/*********************************************************************/
/* Function Definitions                                              */
/*********************************************************************/

/*********************************************************************/
/*                                                                   */
/* Function Name:  cics_UE_entry                                     */
/*                                                                   */
/* Description: CICS Task termination user exit (UE014015)           */
/*                                                                   */
/*********************************************************************/
/*                                                                   */
/* Function:                                                         */
/*                                                                   */
/*  When the task termination exit number 15 is enabled on CICS,     */
/*  CICS calls cics_UE_entry whenever a task terminates.             */
/*                                                                   */
/* Input Parameters:  UE_Header(cics_UE_Header_t *)                  */
/*                    - Exit generic information                     */
/*                                                                   */
/*                    UE_Specific(cics_UE014015_t *)                 */
/*                    - Exit specific information                    */
/*                                                                   */
/* Output Parameters: None                                           */
/*                                                                   */
/* InOut Parameters:  None                                           */
/*                                                                   */
/* Returns:           UE_HeaderVersion                               */
/*                    UE_SpecificVersion                             */
/*                    UE_Normal                                      */
/*                                                                   */
/*********************************************************************/
cics_UE_Return_t cics_UE_entry(cics_UE_Header_t *UE_Header,
                               cics_UE014015_t  *UE_Specific)
{
 cics_UE_Return_t rc = UE_HeaderVersion;

 /********************************************************************/
 /* Check we understand the versions of the structures               */
 /********************************************************************/
 if (UE_Header->UE_Version == cics_UE_HEADER_VERSION)
 {
    rc = UE_SpecificVersion;
    if (UE_Specific->UE_Version == cics_UE014015_VERSION)
    {
     /****************************************************************/
     /* Determine the type of task termination                       */
     /****************************************************************/
     if (UE_Specific->UE_Terminationtype == UE_Normaltermination)
     {
       /**************************************************************/
       /* Normal termination - inform MQ.                            */
       /* MQ will take the appropriate action including performing   */
       /* an MQDISC.                                                 */
       /**************************************************************/
       AMQ2PHASETASKDETACH();
     }
     else
     {
       /**************************************************************/
       /* Abnormal termination - inform MQ.                          */
       /* MQ will take the appropriate action including performing   */
       /* an MQDISC.                                                 */
       /**************************************************************/
       AMQ2PHASETASKABEND();
     }

     rc = UE_Normal;
    }
 }

 return rc;
}
/*********************************************************************/
/*                                                                   */
/* End of amqzscgx.c                                                 */
/*                                                                   */
/*********************************************************************/
/* MQMBID Start */
#ifndef __MQMBID_H
  #define __MQMBID_H
  #if defined(_AIX)
    #pragma comment(user, "@(#) MQMBID sn=p800-003-150615.2 su=_O7DtFhOPEeWRp7-5NNeHyQ pn=lib/exits/oltp/unix/linux_2/amqzscgx.c")
  #elif defined(hpux)
    #pragma VERSIONID "@(#) MQMBID sn=p800-003-150615.2 su=_O7DtFhOPEeWRp7-5NNeHyQ pn=lib/exits/oltp/unix/linux_2/amqzscgx.c"
  #elif defined(_LINUX_2)
    static char * __attribute__((used)) MQMBID(void) { return "@(#) MQMBID sn=p800-003-150615.2 su=_O7DtFhOPEeWRp7-5NNeHyQ pn=lib/exits/oltp/unix/linux_2/amqzscgx.c"; }
  #elif defined(WIN32) || defined(_WIN32)
    #pragma optimize("", off)
    const static char MQMBID[]="@(#) MQMBID sn=p800-003-150615.2 su=_O7DtFhOPEeWRp7-5NNeHyQ pn=lib/exits/oltp/unix/linux_2/amqzscgx.c";
    #pragma optimize("", on)
  #else
    static char * MQMBID(void) { return "@(#) MQMBID sn=p800-003-150615.2 su=_O7DtFhOPEeWRp7-5NNeHyQ pn=lib/exits/oltp/unix/linux_2/amqzscgx.c"; }
  #endif
#endif
/* MQMBID End */
