const static char sccsid[] = "@(#) MQMBID sn=p800-003-150615.2 su=_O7DtFhOPEeWRp7-5NNeHyQ pn=lib/exits/oltp/unix/linux_2/amqzscix.c";
/*********************************************************************/
/*                                                                   */
/* Module Name: amqzscix.c                                           */
/*                                                                   */
/* Description: WebSphere MQ XA switch program for CICS              */
/*              XA Initialisation                                    */
/*   <copyright                                                      */
/*   notice="lm-source-program"                                      */
/*   pids="5724-H72,"                                                */
/*   years="1994,2012"                                               */
/*   crc="499748203" >                                               */
/*   Licensed Materials - Property of IBM                            */
/*                                                                   */
/*   5724-H72,                                                       */
/*                                                                   */
/*   (C) Copyright IBM Corp. 1994, 2012 All Rights Reserved.         */
/*                                                                   */
/*   US Government Users Restricted Rights - Use, duplication or     */
/*   disclosure restricted by GSA ADP Schedule Contract with         */
/*   IBM Corp.                                                       */
/*   </copyright>                                                    */
/*********************************************************************/
/*                                                                   */
/* Function:                                                         */
/*                                                                   */
/* amqzscix.c is the XA Initialisation routine for CICS.             */
/* It is based on the Oracle/Informix samples in the CICS/6000       */
/* documentation.                                                    */
/*                                                                   */
/* It should be linked with /opt/cics/lib/regxa_swxa.o, libmqmcics_r,*/
/* libmqmxa_r and libmqm_r in addition to the standard CICS/Encina/C */
/* libraries      						     */
/*                                                                   */
/* amqzscix.c contains the following functions:                      */
/*  CICS_XA_Init             CICS entry point for XA initialisation  */
/*                                                                   */
/*********************************************************************/

/*********************************************************************/
/* Includes                                                          */
/*********************************************************************/

/*********************************************************************/
/* Select compiler specific header files                             */
/*********************************************************************/

#include <string.h>
#include <stdio.h>

/*********************************************************************/
/* Select XA header file                                             */
/*********************************************************************/

#include <tmxa/xa.h>

/*********************************************************************/
/* External Data declarations                                        */
/*********************************************************************/

extern struct xa_switch_t MQRMIXASwitch;
extern struct xa_switch_t MQRMIXASwitchDynamic;
extern struct xa_switch_t RegXA_xa_switch;
extern struct xa_switch_t *cics_xa_switch;

/*********************************************************************/
/* Data defined in this module                                       */
/*********************************************************************/

/*********************************************************************/
/* Local function declarations                                       */
/*********************************************************************/

extern void AMQCICSINIT(void *);

/*********************************************************************/
/* Function Definitions                                              */
/*********************************************************************/

/*********************************************************************/
/*                                                                   */
/* Function Name:  CICS_XA_Init                                      */
/*                                                                   */
/* Description: CICS XA initialisation.                              */
/*                                                                   */
/*********************************************************************/
/* Following text will be included in the Service Reference Manual . */
/* Ensure that the content is correct and up-to-date.                */
/* All updates should be made in mixed case.                         */
/*                                                                   */
/* Function:                                                         */
/*                                                                   */
/*  amqzscix is called by CICS to initialise XA support for          */
/*  WebSphere MQ                                                     */
/*                                                                   */
/* Input Parameters:  None                                           */
/*                                                                   */
/* Output Parameters: None                                           */
/*                                                                   */
/* InOut Parameters:  None                                           */
/*                                                                   */
/* Returns:           * indicates FFST has been performed            */
/*     0                          - Success.                         */
/*                                                                   */
/* Exit Normal:       See Above                                      */
/*                                                                   */
/* Exit Error:        See Above                                      */
/*                                                                   */
/* End of text to be included in SRM                                 */
/*********************************************************************/
/*                                                                   */
/* Notes:                                                            */
/*   Restrictions: None                                              */
/*                                                                   */
/*********************************************************************/
struct xa_switch_t *CICS_XA_Init(void)
{
  /*******************************************************************/
  /* Set CICS pointer to our structure                               */
  /*******************************************************************/
  cics_xa_switch = &MQRMIXASwitchDynamic;

  /*******************************************************************/
  /* Initialise CICS support                                         */
  /*******************************************************************/
  cics_xa_init();

  /*******************************************************************/
  /* Tell MQ that CICS is available                                  */
  /* This call will cause MQ to callback to CICS on any MQCONN       */
  /* to determine the CICS UserId and transaction name, so that it   */
  /* can be used in authority checking and context.                  */
  /* For compatability with OS/2, a dummy parameter is given         */
  /*******************************************************************/
  AMQCICSINIT(NULL);

  /*******************************************************************/
  /* Return from function                                            */
  /*******************************************************************/
  return(&RegXA_xa_switch);

} /* End function amqzscix                                           */

/*********************************************************************/
/*                                                                   */
/* End of amqzscix.c                                                 */
/*                                                                   */
/*********************************************************************/
/* MQMBID Start */
#ifndef __MQMBID_H
  #define __MQMBID_H
  #if defined(_AIX)
    #pragma comment(user, "@(#) MQMBID sn=p800-003-150615.2 su=_O7DtFhOPEeWRp7-5NNeHyQ pn=lib/exits/oltp/unix/linux_2/amqzscix.c")
  #elif defined(hpux)
    #pragma VERSIONID "@(#) MQMBID sn=p800-003-150615.2 su=_O7DtFhOPEeWRp7-5NNeHyQ pn=lib/exits/oltp/unix/linux_2/amqzscix.c"
  #elif defined(_LINUX_2)
    static char * __attribute__((used)) MQMBID(void) { return "@(#) MQMBID sn=p800-003-150615.2 su=_O7DtFhOPEeWRp7-5NNeHyQ pn=lib/exits/oltp/unix/linux_2/amqzscix.c"; }
  #elif defined(WIN32) || defined(_WIN32)
    #pragma optimize("", off)
    const static char MQMBID[]="@(#) MQMBID sn=p800-003-150615.2 su=_O7DtFhOPEeWRp7-5NNeHyQ pn=lib/exits/oltp/unix/linux_2/amqzscix.c";
    #pragma optimize("", on)
  #else
    static char * MQMBID(void) { return "@(#) MQMBID sn=p800-003-150615.2 su=_O7DtFhOPEeWRp7-5NNeHyQ pn=lib/exits/oltp/unix/linux_2/amqzscix.c"; }
  #endif
#endif
/* MQMBID End */
