       IDENTIFICATION DIVISION.
      ****************************************************************
      *                                                              *
      * Program name: AMQ0PUB0                                       *
      *                                                              *
      * Description: Sample COBOL program that puts messages         *
      *              to a TOPIC (example using MQPUT)                *
      *   <copyright                                                 *
      *   notice="lm-source-program"                                 *
      *   pids="5724-H72,"                                           *
      *   years="2008,2012"                                          *
      *   crc="3130832482" >                                         *
      *   Licensed Materials - Property of IBM                       *
      *                                                              *
      *   5724-H72,                                                  *
      *                                                              *
      *   (C) Copyright IBM Corp. 2008, 2012 All Rights Reserved.    *
      *                                                              *
      *   US Government Users Restricted Rights - Use, duplication or  *
      *   disclosure restricted by GSA ADP Schedule Contract with    *
      *   IBM Corp.                                                  *
      *   </copyright>                                               *
      *                                                              *
      ****************************************************************
      *                                                              *
      * Function:                                                    *
      *                                                              *
      *                                                              *
      *   AMQ0PUB0 is a sample COBOL program to publish messages on  *
      *   to a topic, and is an example of the use of MQPUT          *
      *                                                              *
      *      -- sample message input is read using the ACCEPT        *
      *         verb, with a blank entry indicating the end of       *
      *         input; the target queue is obtained from the         *
      *         console                                              *
      *                                                              *
      *      -- puts each text line in the input to the topic        *
      *         taking each line of text as the content              *
      *         of a message                                         *
      *                                                              *
      *      -- writes a message for each MQI reason other than      *
      *         MQRC-NONE; stops if there is a MQI completion        *
      *         code of MQCC-FAILED                                  *
      *                                                              *
      *    Program logic:                                            *
      *         display prompt for queue name                        *
      *         ACCEPT the target topic name from the console        *
      *         MQCONNect to default queue manager                   *
      *         display name of target topic                         *
      *         MQOPEN target topic for OUTPUT/publishing            *
      *         display prompt for message(s)                        *
      *         while no MQI failures,                               *
      *         .  ACCEPT line of text                               *
      *         .  MQPUT message with text to target queue           *
      *         MQCLOSE target queue                                 *
      *         MQDISConnect from queue manager                      *
      *                                                              *
      *                                                              *
      ****************************************************************
      *                                                              *
      *                                                              *
      *                                                              *
      *   Exceptions signaled:  none                                 *
      *   Exceptions monitored: none                                 *
      *                                                              *
      *   AMQ0PUB0 has no parameters                                 *
      *                                                              *
      ****************************************************************
       PROGRAM-ID. 'AMQ0PUB0'.

      ****************************************************************
       DATA DIVISION.
       WORKING-STORAGE SECTION.
      *
      **  Declare MQI structures needed
      * MQI named constants
       01 MY-MQ-CONSTANTS.
          COPY CMQV.
      * Object Descriptor
       01 OBJECT-DESCRIPTOR.
          COPY CMQODV.
      * Message Descriptor
       01 MESSAGE-DESCRIPTOR.
          COPY CMQMDV.
      * Put message options
       01 PMOPTIONS.
          COPY CMQPMOV.
      ** note, sample uses defaults where it can
       01 QM-NAME                    PIC X(48) VALUE SPACES.
       01 HCONN                      PIC S9(9) BINARY.
       01 Q-HANDLE                   PIC S9(9) BINARY.
       01 OPTIONS                    PIC S9(9) BINARY.
       01 COMPLETION-CODE            PIC S9(9) BINARY.
       01 OPEN-CODE                  PIC S9(9) BINARY.
       01 CON-REASON                 PIC S9(9) BINARY.
       01 REASON                     PIC S9(9) BINARY.
       01 BUFFER                     PIC X(100).
       01 BUFFER-LENGTH              PIC S9(9) BINARY.
       01 TOPIC-LENGTH               PIC S9(9) BINARY VALUE 0.
       01 REAL-TOPIC-LENGTH          PIC S9(9) BINARY VALUE 0.
       01 WORK-FIELD                 PIC X(60).
       01 TARGET-TOPIC               PIC X(48).

      ****************************************************************
       PROCEDURE DIVISION.
       P0.
      ** indicate that sample program has started
           DISPLAY 'AMQ0PUB0 start'.

      ****************************************************************
      *                                                              *
      *    Display prompt for the topic string                       *
      *                                                              *
      ****************************************************************
           DISPLAY 'Please enter the topic string '

      ** get the target topic from StdIn.
           ACCEPT TARGET-TOPIC FROM CONSOLE.

      ****************************************************************
      *                                                              *
      *   Connect to default queue manager                           *
      *                                                              *
      ****************************************************************
           add MQPMO-FAIL-IF-QUIESCING MQPMO-NO-SYNCPOINT
               GIVING MQPMO-OPTIONS.
           CALL 'MQCONN'
            USING QM-NAME, HCONN,
            COMPLETION-CODE, CON-REASON.

      *      report reason and stop if it failed
           IF COMPLETION-CODE IS EQUAL TO MQCC-FAILED
             DISPLAY 'MQCONN ended with reason code ' CON-REASON
             MOVE CON-REASON TO RETURN-CODE
             GOBACK
             END-IF.

      ****************************************************************
      *                                                              *
      *    Display name of target topic read from StdIn              *
      *                                                              *
      ****************************************************************
           DISPLAY 'target topic is ' TARGET-TOPIC.

      ****************************************************************
      *                                                              *
      *   Open the target topic for output (and fail if              *
      *   MQM is quiescing)                                          *
      *                                                              *
      ****************************************************************
       OPENS.
           move MQOT-TOPIC to MQOD-OBJECTTYPE.
           move MQOD-VERSION-4 to MQOD-VERSION.

      *     Work out how many trailing spaces we have to determine
      *     real length of TOPIC STRING. Need to reverse the string
      *     as there is no TRAILING keyword in some COBOL
      *     implementations.
           MOVE FUNCTION REVERSE (TARGET-TOPIC) TO WORK-FIELD.
           inspect WORK-FIELD Tallying TOPIC-LENGTH
               For LEADING Spaces.
           subtract TOPIC-LENGTH from LENGTH OF TARGET-TOPIC
               giving REAL-TOPIC-LENGTH.
           move REAL-TOPIC-LENGTH to MQOD-OBJECTSTRING-VSLENGTH.
           set MQOD-OBJECTSTRING-VSPTR to ADDRESS OF TARGET-TOPIC.

           MOVE MQCO-NONE TO OPTIONS.
           ADD MQOO-OUTPUT MQOO-FAIL-IF-QUIESCING
                     GIVING OPTIONS.
           CALL 'MQOPEN'
            USING HCONN, OBJECT-DESCRIPTOR,
            OPTIONS, Q-HANDLE,
            OPEN-CODE, REASON.

      *      report reason, if any; stop if failed
           IF REASON IS NOT EQUAL TO MQRC-NONE
             DISPLAY 'MQOPEN ended with reason code ' REASON
             END-IF.

           IF OPEN-CODE IS EQUAL TO MQCC-FAILED
             DISPLAY 'unable to open target topic for output'
             MOVE REASON TO RETURN-CODE
             GOBACK
             END-IF.

      ****************************************************************
      *                                                              *
      *   Put request messages to the target topic                   *
      *                                                              *
      ****************************************************************
       PUTS.
      **   Display prompt for the message(s)                         *
           DISPLAY 'Please enter the message(s) '

           MOVE OPEN-CODE TO COMPLETION-CODE.
           PERFORM PUTR WITH TEST BEFORE
             UNTIL COMPLETION-CODE IS EQUAL TO MQCC-FAILED.

      ****************************************************************
      *                                                              *
      *   Close the target topic (if it was opened)                  *
      *                                                              *
      ****************************************************************
       CLOSES.
           MOVE MQCO-NONE TO OPTIONS.
           CALL 'MQCLOSE'
            USING HCONN, Q-HANDLE, OPTIONS,
            COMPLETION-CODE, REASON.

      *      report reason, if any
           IF REASON IS NOT EQUAL TO MQRC-NONE
             DISPLAY 'MQCLOSE ended with reason code ' REASON
             END-IF.

      ****************************************************************
      *                                                              *
      *  Disconnect from queue manager (if not previously connected) *
      *                                                              *
      ****************************************************************
       DISCS.
           IF CON-REASON IS NOT EQUAL TO MQRC-ALREADY-CONNECTED
             CALL 'MQDISC'
              USING HCONN, COMPLETION-CODE, REASON

      *      report reason, if any
             IF REASON IS NOT EQUAL TO MQRC-NONE
               DISPLAY 'MQDISC ended with reason code ' REASON
             END-IF
           END-IF.

       OVER.
      ** indicate that sample program has finished
           DISPLAY 'Sample AMQ0PUB0 end'.
           MOVE ZERO TO RETURN-CODE.
           GOBACK.

      ****************************************************************
      *                                                              *
      *   Put one request to the target topic                        *
      *                                                              *
      ****************************************************************
       PUTR.
           MOVE SPACES TO BUFFER.
           ACCEPT BUFFER.
           IF BUFFER IS NOT EQUAL TO SPACES
             PERFORM PUTIT
           ELSE
             MOVE MQCC-FAILED TO COMPLETION-CODE.

       PUTIT.
           MOVE 60 to BUFFER-LENGTH.
           CALL 'MQPUT'
            USING HCONN, Q-HANDLE,
            MESSAGE-DESCRIPTOR, PMOPTIONS,
            BUFFER-LENGTH, BUFFER,
            COMPLETION-CODE, REASON.

      *      report reason, if any
           IF REASON IS NOT EQUAL TO MQRC-NONE
             DISPLAY 'MQPUT ended with reason code ' REASON
             END-IF.

      ****************************************************************
      *                                                              *
      * END OF AMQ0PUB0                                              *
      *                                                              *
      ****************************************************************
