/*********************************************************************/
/*                                                                   */
/* Module Name: AMQODQMA.Y                                           */
/*                                                                   */
/* Description: RUNMQDLQ Parser: YACC                                */
/*   <copyright                                                      */
/*   notice="lm-source-program"                                      */
/*   pids="5724-H72"                                                 */
/*   years="1994,2014"                                               */
/*   crc="1988911399" >                                              */
/*   Licensed Materials - Property of IBM                            */
/*                                                                   */
/*   5724-H72                                                        */
/*                                                                   */
/*   (C) Copyright IBM Corp. 1994, 2014 All Rights Reserved.         */
/*                                                                   */
/*   US Government Users Restricted Rights - Use, duplication or     */
/*   disclosure restricted by GSA ADP Schedule Contract with         */
/*   IBM Corp.                                                       */
/*   </copyright>                                                    */
/*********************************************************************/
/* Function:                                                         */
/* This file contains the RUNMQDLQ command file grammar and the      */
/* functions used to build the internal representation of the        */
/* templates.                                                        */
/*                                                                   */
/*                                                                   */
/*********************************************************************/

%{
/*********************************************************************/
/*                                                                   */
/* Module Name: AMQODQMA.C                                           */
/*                                                                   */
/* Description: RUNMQDLQ Parser: YACC                                */
/*                                                                   */
/* Statement:     Licensed Materials - Property of IBM               */
/*                                                                   */
/*                5765-115 5621-390 (C) Copyright IBM Corp. 1994     */
/*                                                                   */
/*                U.S. Government Users Restricted Rights - use,     */
/*                duplication or disclosure restricted by GSA ADP    */
/*                Schedule Contract with IBM Corp.                   */
/*                                                                   */
/*********************************************************************/
/*                                                                   */
/* WARNING WARNING WARNING WARNING WARNING WARNING WARNING WARNING   */
/*   This file was generated by running YACC against the source file */
/*                                                                   */
/*   AMQODQMA.Y                                                      */
/*                                                                   */
/*   Updates should be made to the above source file and NOT to      */
/*   this file.                                                      */
/* WARNING WARNING WARNING WARNING WARNING WARNING WARNING WARNING   */
/*                                                                   */
/*********************************************************************/
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <cmqc.h>
#include <amqodqha.h>

#if defined(AMQ_NT)
   #include <malloc.h>
   #pragma warning(disable:4129)
   #pragma warning(disable:4102)
#endif

static odqPattern_t *pPat;

extern int odqLineNo;
extern MQCNO cno;

/*--------------------------------------------------------------------*/
/* F U N C T I O N     P R O T O T Y P E S                            */
/*--------------------------------------------------------------------*/
static odqResp odqAddLine(void);

static odqResp odqPrepareTemplate(void);

static odqResp odqAddParm(odqKeyword key, odqParm Value);

static odqResp odqUseDefault(odqKeyword key);

int            yyparse (void);
void           yyerror (char * msg);
int            yylex   (void);

#undef FUNCTION_ID
#define FUNCTION_ID odqtodqyyparse

%}
%union {
         odqParm o;
       }

%start file
%token     ACTION
%token     APPLIDAT
%token     APPLTYPE
%token     APPLNAME
%token     DESTQ
%token     DESTQM
%token     FEEDBACK
%token     FORMAT
%token     FWDQ
%token     FWDQM
%token     HEADER
%token     MSGTYPE
%token     PERSIST
%token     REASON
%token     REPLYQ
%token     REPLYQM
%token     RETRY
%token     USERID
%token     LBRACKET
%token     RBRACKET
%token     UNEXPECTED
%token <o> INTEGER
%token     NEWLINE
%token <o> WSTRING
%token <o> STRING
%token     INPUTQM
%token     INPUTQ
%token     WAIT
%token     RETRYINT
%token     PUTAUT
%token     DEFAULT
%type  <o> integer
%type  <o> string
%type  <o> wstring
%%
file
    : cmdlist
    | parmline cmdlist
    ;

errline
    : error NEWLINE
    ;

parmline
    : parms NEWLINE
    ;
parms
    : parm
    | parms parm
    ;

parm
    : INPUTQ  string   {odqAddParm(InputQ, $2); }
    | INPUTQM string   {
                         odqResp rc;
                         rc = odqAddParm(InputQM, $2);
                         if( odq_Ok == rc)
                         {
                           rc = odqConnectQmgr ( pPat->Parm[InputQM].s, &cno ) ;
                           if( odq_Error <= rc )
                           {
                              odqGlobal.odqInputErrorCount ++ ;
                           }
                         }
                       }
    | RETRYINT integer {odqAddParm(RetryInt, $2); }
    | WAIT     integer {
                          if( $2.i > -2 && $2.i <= 999999)
                          {
                            odqAddParm(Wait,$2);
                          }
                          else
                          {
                            odqFFDC( /*IN*/
                                       FUNCTION_ID,
                                       odq_ValueOutOfRange,
                                       odqLineNo,
                                       $2.i,
                                       odqParmAttrs[Wait].keyword,
                                       strlen(odqParmAttrs[Wait].keyword),
                                       "Keyword",
                                       NULL
                                     /*OUT*/
                                   ) ;
                            odqGlobal.odqInputErrorCount ++ ;
                          }
                        }
    ;
cmdlist
    : cmdline
    | cmdlist cmdline
    ;
cmdline
    : cmd NEWLINE                          {
                                             odqResp rc;
                                             rc=odqAddLine();
                                             if( odq_Error <= rc )
                                             {
                                               YYABORT;
                                             }
                                           }
    | errline
    | NEWLINE                  {
/*--------------------------------------------------------------------*/
/* If we detect a syntax error then a 'unexpected' token will be      */
/* returned. When we see an unexpected end of line we check to see    */
/* if we're part way through a rule. If so then we must create a      */
/* new template.                                                      */
/*                                                                    */
/* Note: we only check the 'normal' parameters and not the environment*/
/*       parms as we don't want to add a rule with only env parms.    */
/*--------------------------------------------------------------------*/
                                 odqResp rc;
                                 int i ;
                                 for( i = FirstKeyword;
                                      i < InputQ &&
                                      (*(pPat->ParmSpecified+i)
                                              == NotSpecified);
                                      i ++ );
                                  if (i < InputQ )
                                  {
                                    rc=odqAddLine();
                                    if( odq_Error <= rc )
                                    {
                                      YYABORT;
                                    }
                                  }
                               }
    ;
cmd
    : pattern
    | action
    | cmd pattern
    | cmd action
    ;
pattern
    : FORMAT wstring   {odqAddParm(Format,$2);}
    | DESTQ wstring    {odqAddParm(DestQName,$2);}
    | DESTQM wstring   {odqAddParm(DestQMgrName,$2);}
    | REPLYQ wstring   {odqAddParm(ReplyToQ,$2);}
    | REPLYQM wstring  {odqAddParm(ReplyToQMgr,$2);}
    | APPLIDAT wstring {odqAddParm(ApplIdentityData,$2);}
    | APPLNAME wstring {odqAddParm(PutApplName,$2);}
    | USERID wstring   {odqAddParm(UserIdentifier,$2);}
    | APPLTYPE integer {odqAddParm(PutApplType,$2);}
    | REASON integer   {odqAddParm(Reason,$2);}
    | MSGTYPE integer  {odqAddParm(MsgType,$2);}
    | FEEDBACK integer {odqAddParm(Feedback,$2);}
    | PERSIST integer  {odqAddParm(Persistence,$2);}
    | APPLTYPE integerdefault {odqUseDefault(PutApplType);}
    | REASON integerdefault   {odqUseDefault(Reason);}
    | MSGTYPE integerdefault  {odqUseDefault(MsgType);}
    | FEEDBACK integerdefault {odqUseDefault(Feedback);}
    | PERSIST integerdefault  {odqUseDefault(Persistence);}
    ;
action
    : ACTION  integer {
                        odqAddParm(Action,$2);
                      }

    | HEADER  integer {odqAddParm(Header,$2);}
    | RETRY integer   {
                        if( $2.i > 0 )
                        {
                          odqAddParm(Retry,$2);
                        }
                        else
                        {
                          odqFFDC( /*IN*/
                                     FUNCTION_ID,
                                     odq_ValueOutOfRange,
                                     odqLineNo,
                                     $2.i,
                                     odqParmAttrs[Retry].keyword,
                                     strlen(odqParmAttrs[Retry].keyword),
                                     "Keyword",
                                     NULL
                                   /*OUT*/
                                 ) ;
                          odqGlobal.odqInputErrorCount ++ ;
                        }
                      }
    | PUTAUT integer   {odqAddParm(PutAut,$2);}
    | FWDQ string      {odqAddParm(ForwardQ,$2);}
    | FWDQM string     {odqAddParm(ForwardQMgr,$2);}
    ;

integer
    : LBRACKET INTEGER RBRACKET       { $$ = $2;}
    ;
integerdefault
    : LBRACKET DEFAULT RBRACKET
    ;

wstring
    : LBRACKET WSTRING RBRACKET       { $$ = $2;}
    ;
string
    : LBRACKET STRING RBRACKET        { $$ = $2;}
    ;

%%

extern FILE *yyin ;

#undef FUNCTION_ID
#define FUNCTION_ID odqtodqProcessStdin

/*********************************************************************/
/*                                                                   */
/* Function: odqProcessStdin                                         */
/*                                                                   */
/* Description: Parse the input rule table                           */
/*                                                                   */
/* Intended Function: This parses the input rule table converting    */
/*                    the rules from a text based format to a        */
/*                    structure which is easier for the DLQ handler  */
/*                    to use.                                        */
/*                                                                   */
/* Input Parameters: none (stdin)                                    */
/*                                                                   */
/* Output Parameters: none ( list of rules anchored in odqGlobal)    */
/*                                                                   */
/* Returns:                                                          */
/*********************************************************************/
odqResp odqProcessStdin ( void )
{
 odqResp rc=odq_Ok ;

 odq_fnc_entry( FUNCTION_ID ) ;
/*--------------------------------------------------------------------*/
/* Build an empty template for the parser to fill in.                 */
/*--------------------------------------------------------------------*/
 rc = odqPrepareTemplate();
 if ( odq_Error > rc )
 {
#ifdef AMQ_AS400
   /*-----------------------------------------------------------------*/
   /* AS400 static storage is not re-initialized so need to call      */
   /* initialisation function prior to parsing input                  */
   /*-----------------------------------------------------------------*/
   yylex_initialise();
#endif

   /*-----------------------------------------------------------------*/
   /* Default the RetryInt in the first template.                     */
   /*-----------------------------------------------------------------*/
   pPat->Parm[RetryInt].i = 60 ;
   yyin = stdin ;
   while(!feof(yyin))
   {
     yyparse();
   }
 }
/*--------------------------------------------------------------------*/
/* We allow the parser to continue after the first error is detected  */
/* so that all of the errors are diagnosed on a single pass.          */
/* After the parser completes we terminate if any errors were         */
/* detected.                                                          */
/*--------------------------------------------------------------------*/
 if ( 0!= odqGlobal.odqInputErrorCount )
 {
   rc = odq_InvalidInput ;
   odqFFDC( /*IN*/
              FUNCTION_ID,
              rc,
              odqGlobal.odqInputErrorCount,
              0,
              NULL
            /*OUT*/
          ) ;
 }
 else
 {
   /*-----------------------------------------------------------------*/
   /* It's not meaningful for the DLQ handler to continue if there    */
   /* are no templates as the default action is to ignore messages.   */
   /*-----------------------------------------------------------------*/
   if ( NULL == odqGlobal.odqPatternHead)
   {
     rc = odq_NoValidInput ;
     odqFFDC( /*IN*/
                FUNCTION_ID,
                rc,
                0,
                0,
                NULL
              /*OUT*/
            ) ;
   }
 }
 odq_fnc_retcode( FUNCTION_ID, rc ) ;
 return rc ;
}





#undef  FUNCTION_ID
#define FUNCTION_ID odqtodqPrepareTemplate

/*********************************************************************/
/*                                                                   */
/* Function: odqPrepareTemplate                                      */
/*                                                                   */
/* Description: Build a blank rule template                          */
/*                                                                   */
/* Intended Function: This function builds a blank rule template     */
/*                    which can then be filled in by the parser.     */
/*                    The static global pPat is set to point to      */
/*                    the blank template obtained.                   */
/*                                                                   */
/* Input Parameters: none                                            */
/*                                                                   */
/* Output Parameters: none                                           */
/*                                                                   */
/* Returns:                                                          */
/*********************************************************************/
/*--------------------------------------------------------------------*/
/* odqPrepareTemplate: setup a blank template for the parser to fill  */
/*                     in.                                            */
/*--------------------------------------------------------------------*/
static odqResp odqPrepareTemplate(void)
{
 odqResp rc=odq_Ok ;
 odq_fnc_entry( FUNCTION_ID ) ;
 /*------------------------------------------------------------------*/
 /* Get some storage in which to keep our representation of the      */
 /* pattern line.                                                    */
 /*------------------------------------------------------------------*/
 rc = odqGetMem(sizeof(*pPat)+
                    LastKeyword*sizeof(odqParmSpec_t),
               "PatternLine",
               (void **)&pPat);
 if (odq_Error > rc )
 {
   pPat->ParmSpecified = (odqParmSpec_t*)&(pPat->Parm[LastKeyword].i);
   memset( pPat->ParmSpecified, 0, LastKeyword*sizeof(odqParmSpec_t) );
   pPat->next = NULL ;
 }
 else
 {
   odqGlobal.odqInputErrorCount ++ ;
 }
 odq_fnc_retcode( FUNCTION_ID, rc ) ;
 return rc ;
}

#undef  FUNCTION_ID
#define FUNCTION_ID odqtodqAddParm

/*********************************************************************/
/*                                                                   */
/* Function: odqAddParm                                              */
/*                                                                   */
/* Description: Add a parameter to the current rule template         */
/*                                                                   */
/* Intended Function: This function performs duplicate and size      */
/*                    checking on parameters, and if the parameters  */
/*                    meet the relevant contraints add the parameter */
/*                    to the current rule template.                  */
/*                                                                   */
/* Input Parameters: pECAnchor                                       */
/*                                                                   */
/* Output Parameters: none                                           */
/*                                                                   */
/* Returns:                                                          */
/*********************************************************************/
/*--------------------------------------------------------------------*/
/* odqAddParm: Add a parameter to the current template.               */
/*--------------------------------------------------------------------*/
static odqResp odqAddParm(odqKeyword key, odqParm Value)
{
 odqResp rc=odq_Ok ;
 int i,j ;
 odq_fnc_entry( FUNCTION_ID ) ;
 /*--------------------------------------------------------------*/
 /* Any environment specifications must be in the first input    */
 /* line to runmqdlq. As soon as we see a parameter that is not  */
 /* an environment specification we can be sure that no          */
 /* further environment specification will occur.                */
 /* If we've not already connected to the queue manager then     */
 /* perform the connect now. We want to connect as early as      */
 /* possible so that errors are associated with the correct      */
 /* queue manager.                                               */
 /*--------------------------------------------------------------*/
 if ( InputQ > key &&
      0 == odqGlobal.odqConnectAttempted )
 {
    rc = odqConnectQmgr ("", &cno ) ;
    /*-----------------------------------------------------------*/
    /* If the connect fails then we choose to soldier on and     */
    /* parse the rest of the input file. Once the input file     */
    /* has been processed we will terminate without any further  */
    /* action.                                                   */
    /*-----------------------------------------------------------*/
    if (odq_Error <= rc )
    {
      odqGlobal.odqInputErrorCount ++ ;
    }
 }
 /*-------------------------------------------------------------------*/
 /* if we've already seen this parameter then flag it as a duplicate. */
 /*-------------------------------------------------------------------*/
 if (*(pPat->ParmSpecified+key) != NotSpecified)
 {
    odqFFDC( /*IN*/
               FUNCTION_ID,
               odq_DuplicateKeyword,
               odqLineNo,
               0,
               odqParmAttrs[key].keyword,
               strlen(odqParmAttrs[key].keyword),
               "Keyword",
               NULL
             /*OUT*/
           ) ;
     rc = odq_DuplicateKeyword ;
     odqGlobal.odqInputErrorCount ++ ;
 }
 else
 {
   *(pPat->ParmSpecified+key) = Specified ;
   /*-----------------------------------------------------------*/
   /* Count the minimum number of characters required to match  */
   /* the pattern. If this number exceeds the maximum length of */
   /* the field then it's not possible for this pattern to be   */
   /* matched.                                                  */
   /*-----------------------------------------------------------*/
   switch(odqParmAttrs[key].format)
   {
     /*---------------------------------------------------------*/
     /* String including wildcards                              */
     /*---------------------------------------------------------*/
     case 'w':
       for( i = 0, j=0 ;
            Value.s[i] != 0 ;
            i++ )
       {
         if( odqANY_SUBSTRING !=  Value.s[i] )
         {
            j++ ;
         }
       }
       break;
     /*---------------------------------------------------------*/
     /* String excluding wildcards                              */
     /*---------------------------------------------------------*/
     case 's':
       for( j = 0;
            Value.s[j] != 0 ;
            j++ );
       break;
     /*---------------------------------------------------------*/
     /* integer                                                 */
     /*---------------------------------------------------------*/
     case 'd':
       j = sizeof( int ) ;
       break ;
   }
   if( odqParmAttrs[key].maxlen < j )
   {
     odqFFDC( /*IN*/
                  FUNCTION_ID,
                  odq_InvalidFieldLen,
                  odqLineNo,
                  0,
                  odqParmAttrs[key].keyword,
                  strlen(odqParmAttrs[key].keyword),
                  "Keyword",
                  NULL
                /*OUT*/
              ) ;
        rc = odq_InvalidFieldLen ;
        odqGlobal.odqInputErrorCount ++ ;
   }
   else
   {
     pPat->Parm[key] = Value;
   }
 }
 odq_fnc_retcode( FUNCTION_ID, rc ) ;
 return rc ;
}
#undef  FUNCTION_ID
#define FUNCTION_ID odqtodqUseDefault

/*********************************************************************/
/*                                                                   */
/* Function: odqAddParm                                              */
/*                                                                   */
/* Description: Add a parameter to the current rule template         */
/*                                                                   */
/* Intended Function: This function performs duplicate and size      */
/*                    checking on parameters, and if the parameters  */
/*                    meet the relevant contraints add the parameter */
/*                    to the current rule template.                  */
/*                                                                   */
/* Input Parameters: pECAnchor                                       */
/*                                                                   */
/* Output Parameters: none                                           */
/*                                                                   */
/* Returns:                                                          */
/*********************************************************************/
static odqResp odqUseDefault(odqKeyword key)
{
 odqResp rc=odq_Ok ;
 odq_fnc_entry( FUNCTION_ID ) ;
 /*-------------------------------------------------------------------*/
 /* if we've already seen this parameter then flag it as a duplicate. */
 /*-------------------------------------------------------------------*/
 if (*(pPat->ParmSpecified+key) != NotSpecified)
 {
    odqFFDC( /*IN*/
               FUNCTION_ID,
               odq_DuplicateKeyword,
               odqLineNo,
               0,
               odqParmAttrs[key].keyword,
               strlen(odqParmAttrs[key].keyword),
               "Keyword",
               NULL
             /*OUT*/
           ) ;
     rc = odq_DuplicateKeyword ;
     odqGlobal.odqInputErrorCount ++ ;
 }
 else
 {
   *(pPat->ParmSpecified+key) = ExplicitlyDefaulted ;
 }
 odq_fnc_retcode( FUNCTION_ID, rc ) ;
 return rc ;
}


#undef  FUNCTION_ID
#define FUNCTION_ID odqtodqAddLine
/*--------------------------------------------------------------------*/
/* odqAddLine: Add the current rule to the list of rules              */
/*--------------------------------------------------------------------*/
static odqResp odqAddLine(void)
{
 odqResp rc=odq_Ok ;

 odq_fnc_entry( FUNCTION_ID ) ;
 /*-------------------------------------------------------------------*/
 /* Set up some defaults for 'optional fields'                        */
 /*-------------------------------------------------------------------*/
 if ( NotSpecified == *(pPat->ParmSpecified+Retry) )
 {
   pPat->Parm[Retry].i = 1 ;
 }
 if ( NotSpecified == *(pPat->ParmSpecified+Header) )
 {
   pPat->Parm[Header].i = 1 ;
 }
 if ( NotSpecified == *(pPat->ParmSpecified+PutAut) )
 {
   pPat->Parm[PutAut].i = 0 ;
 }

 /*-------------------------------------------------------------------*/
 /* Save the line number of the pattern for use in debugging.         */
 /*-------------------------------------------------------------------*/
 pPat->LineNo = odqLineNo - 1;

 /*-------------------------------------------------------------------*/
 /* Detect invalid combinations of parameters.                        */
 /*-------------------------------------------------------------------*/
 if (
       (*(pPat->ParmSpecified+Action) != Specified)
       |
       (pPat->Parm[Action].i == odqFORWARD &&
        *(pPat->ParmSpecified+ForwardQ) != Specified)
       |
       (pPat->Parm[Action].i != odqFORWARD &&
        *(pPat->ParmSpecified+ForwardQMgr) != NotSpecified)
       |
       (pPat->Parm[Action].i != odqFORWARD &&
        *(pPat->ParmSpecified+Header) != NotSpecified)
    )
 {
    odqFFDC( /*IN*/
               FUNCTION_ID,
               odq_InvalidInputComb,
               odqLineNo - 1,
               0,
               NULL
             /*OUT*/
           ) ;
     rc = odq_InvalidInputComb ;
     odqGlobal.odqInputErrorCount ++ ;
 }

 /*-------------------------------------------------------------------*/
 /* Add the current pattern into the chain of patterns.               */
 /*-------------------------------------------------------------------*/
 if ( odq_Error > rc )
 {
   pPat->next = NULL ;
   if ( odqGlobal.odqPatternHead == NULL )
   {
      odqGlobal.odqPatternHead = pPat ;
   }
   else
   {
     odqPattern_t *lPattern ;
     for( lPattern = odqGlobal.odqPatternHead ;
          lPattern->next != NULL ;
          lPattern = lPattern->next );
     lPattern -> next = pPat ;
   }
 }

 /*-------------------------------------------------------------------*/
 /* Prepare the next template for the parser to complete.             */
 /*-------------------------------------------------------------------*/
 rc = odqPrepareTemplate();
 odq_fnc_retcode( FUNCTION_ID, rc ) ;
 return rc ;
}
#undef FUNCTION_ID
#define FUNCTION_ID odqtodqyyparse
