#!/bin/sh 

# -  Library:       WebSphere MQ
# -  Component:     WMQ SOAP Sample Programs
# -  Part:          SOAPCleanup.sh
# - 
# -     <copyright 
#  notice="lm-source-program" 
#  pids="5724-H72," 
#  years="1994,2012" 
#  crc="615307366" > 
#  Licensed Materials - Property of IBM  
#   
#  5724-H72, 
#   
#  (C) Copyright IBM Corp. 1994, 2012 All Rights Reserved.  
#   
#  US Government Users Restricted Rights - Use, duplication or  
#  disclosure restricted by GSA ADP Schedule Contract with  
#  IBM Corp.  
#  </copyright> 

echo WebSphere MQ Transport for SOAP environment clean up

echo ""
echo "Ending any MQ Listeners"
endmqlsr -m WMQSOAP.DEMO.QM

echo ""
echo "Ending the Queue Manager"
endmqm -i WMQSOAP.DEMO.QM

echo ""
echo "Removing the Queue Manager from the system"
dltmqm WMQSOAP.DEMO.QM

echo ""
echo "Removing any files/directories generated from precious sample runs"
rm -rf soap classes generated bin
rm -rf *log *wsdd
