#!/bin/sh 

# -  Library:       WebSphere MQ
# -  Component:     WMQ SOAP Sample Programs
# -  Part:          regenDemo.sh
# - 
# -     <copyright 
#  notice="lm-source-program" 
#  pids="5724-H72," 
#  years="1994,2012" 
#  crc="3185455336" > 
#  Licensed Materials - Property of IBM  
#   
#  5724-H72, 
#   
#  (C) Copyright IBM Corp. 1994, 2012 All Rights Reserved.  
#   
#  US Government Users Restricted Rights - Use, duplication or  
#  disclosure restricted by GSA ADP Schedule Contract with  
#  IBM Corp.  
#  </copyright> 
# - regenerate and redeploy the demo from the source

echo "setup environment"
. ${WMQSOAP_HOME}/bin/amqwsetcp.sh
if [ $? -ne 0 ]
then
   echo "ERROR - Environment failure, please check documentation for prerequisities."
   exit 1
fi

echo "clean up old directories and files"
rm -rf classes
rm -f server-config.wsdd

echo "check MQ bits ready"
${WMQSOAP_HOME}/samp/soap/setupWMQSOAP.sh
if [ $? -ne 0 ]
then
   echo "ERROR - WMQ Setup failed, please check error logs."
   exit 1
fi

echo "deploy the Axis server (generate proxies, etc)"
mkdir -p soap/server
cp ${WMQSOAP_HOME}/samp/soap/java/server/StockQuoteAxis.java soap/server/.
${WMQSOAP_HOME}/bin/amqwdeployWMQService.sh -u "jms:/queue?destination=SOAPJ.demos@WMQSOAP.DEMO.QM&connectionFactory=connectQueueManager(WMQSOAP.DEMO.QM)&initialContextFactory=com.ibm.mq.jms.Nojndi" -n 10 -f soap/server/StockQuoteAxis.java
if [ $? -ne 0 ]
then
   echo "ERROR - Java Deployment failed, please check errors from Deployment."
   exit 1
fi

# - compile the clients
# - make sure the proxies are high in the serach path
echo "Recompile the clients, using the proxies just generated"
mkdir classes
mkdir -p soap/clients
cp ${WMQSOAP_HOME}/samp/soap/java/clients/*.java soap/clients/.
# Delete any DotNet files, Java tran files
rm -f soap/clients/SQAxis2DotNet.java soap/clients/SQAxis2AxisAsync*.java

javac -d classes soap/clients/*.java 

echo "Configure the client to make sure that Axis clients know about jms:xxx"
${WMQSOAP_HOME}/bin/amqwclientConfig.sh
if [ $? -ne 0 ]
then
   echo "ERROR - amqwclientconfig failed, please check errors from amqwclientconfig."
   exit 1
fi

cp ${WMQSOAP_HOME}/samp/soap/*.txt .

echo "Demo regenerated"





